/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.scope;

import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.internal.scope.EnclosedScope;
import com.google.dart.engine.internal.scope.Scope;

public class FunctionScope
extends EnclosedScope {
    private final ExecutableElement functionElement;
    private boolean parametersDefined;

    public FunctionScope(Scope scope, ExecutableElement executableElement) {
        super(new EnclosedScope(scope));
        if (executableElement == null) {
            throw new IllegalArgumentException("function element cannot be null");
        }
        this.functionElement = executableElement;
    }

    public void defineParameters() {
        ParameterElement[] parameterElementArray;
        if (this.parametersDefined) {
            return;
        }
        this.parametersDefined = true;
        Scope scope = this.getEnclosingScope();
        if (this.functionElement.getEnclosingElement() instanceof ExecutableElement && (parameterElementArray = this.functionElement.getName()) != null && !parameterElementArray.isEmpty()) {
            scope.define(this.functionElement);
        }
        for (ParameterElement parameterElement : this.functionElement.getParameters()) {
            if (parameterElement.isInitializingFormal()) continue;
            scope.define(parameterElement);
        }
    }
}

