/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.scope;

import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.internal.scope.Scope;
import java.util.HashMap;

public class EnclosedScope
extends Scope {
    private Scope enclosingScope;
    private HashMap<String, Element> hiddenElements = new HashMap();
    private boolean hasHiddenName = false;

    public EnclosedScope(Scope scope) {
        this.enclosingScope = scope;
    }

    @Override
    public Scope getEnclosingScope() {
        return this.enclosingScope;
    }

    @Override
    public AnalysisErrorListener getErrorListener() {
        return this.enclosingScope.getErrorListener();
    }

    public void hide(Element element) {
        String string;
        if (element != null && (string = element.getName()) != null && !string.isEmpty()) {
            this.hiddenElements.put(string, element);
            this.hasHiddenName = true;
        }
    }

    @Override
    protected Element internalLookup(Identifier identifier, String string, LibraryElement libraryElement) {
        Element element;
        Element element2 = this.localLookup(string, libraryElement);
        if (element2 != null) {
            return element2;
        }
        if (this.hasHiddenName && (element = this.hiddenElements.get(string)) != null) {
            this.getErrorListener().onError(new AnalysisError(this.getSource(identifier), identifier.getOffset(), identifier.getLength(), CompileTimeErrorCode.REFERENCED_BEFORE_DECLARATION, new Object[0]));
            return element;
        }
        return this.enclosingScope.internalLookup(identifier, string, libraryElement);
    }
}

