/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.scope;

import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.internal.scope.EnclosedScope;
import com.google.dart.engine.internal.scope.Scope;

public class ClassScope
extends EnclosedScope {
    public ClassScope(Scope scope, ClassElement classElement) {
        super(new EnclosedScope(scope));
        if (classElement == null) {
            throw new IllegalArgumentException("class element cannot be null");
        }
        this.defineTypeParameters(classElement);
        this.defineMembers(classElement);
    }

    @Override
    protected AnalysisError getErrorForDuplicate(Element element, Element element2) {
        if (element instanceof PropertyAccessorElement && element2 instanceof MethodElement) {
            if (element.getNameOffset() < element2.getNameOffset()) {
                return new AnalysisError(element2.getSource(), element2.getNameOffset(), element2.getDisplayName().length(), CompileTimeErrorCode.METHOD_AND_GETTER_WITH_SAME_NAME, element.getDisplayName());
            }
            return new AnalysisError(element.getSource(), element.getNameOffset(), element.getDisplayName().length(), CompileTimeErrorCode.GETTER_AND_METHOD_WITH_SAME_NAME, element.getDisplayName());
        }
        return super.getErrorForDuplicate(element, element2);
    }

    private void defineMembers(ClassElement classElement) {
        for (PropertyAccessorElement executableElement : classElement.getAccessors()) {
            this.define(executableElement);
        }
        for (ExecutableElement executableElement : classElement.getMethods()) {
            this.define(executableElement);
        }
    }

    private void defineTypeParameters(ClassElement classElement) {
        Scope scope = this.getEnclosingScope();
        for (TypeParameterElement typeParameterElement : classElement.getTypeParameters()) {
            scope.define(typeParameterElement);
        }
    }
}

