/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.ConstructorName;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionExpression;
import com.google.dart.engine.ast.Label;
import com.google.dart.engine.ast.MethodInvocation;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.PropertyAccess;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.internal.element.LocalVariableElementImpl;
import com.google.dart.engine.internal.element.ParameterElementImpl;
import com.google.dart.engine.internal.resolver.Library;
import com.google.dart.engine.internal.resolver.ResolvableLibrary;
import com.google.dart.engine.internal.resolver.ScopedVisitor;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.internal.scope.Scope;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.general.ObjectUtilities;

public class VariableResolverVisitor
extends ScopedVisitor {
    private ExecutableElement enclosingFunction;

    public VariableResolverVisitor(Library library, Source source, TypeProvider typeProvider) {
        super(library, source, typeProvider);
    }

    public VariableResolverVisitor(LibraryElement libraryElement, Source source, TypeProvider typeProvider, Scope scope, AnalysisErrorListener analysisErrorListener) {
        super(libraryElement, source, typeProvider, scope, analysisErrorListener);
    }

    public VariableResolverVisitor(ResolvableLibrary resolvableLibrary, Source source, TypeProvider typeProvider) {
        super(resolvableLibrary, source, typeProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        ExecutableElement executableElement = this.enclosingFunction;
        try {
            this.enclosingFunction = functionDeclaration.getElement();
            Void void_ = super.visitFunctionDeclaration(functionDeclaration);
            return void_;
        }
        finally {
            this.enclosingFunction = executableElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionExpression(FunctionExpression functionExpression) {
        if (!(functionExpression.getParent() instanceof FunctionDeclaration)) {
            ExecutableElement executableElement = this.enclosingFunction;
            try {
                this.enclosingFunction = functionExpression.getElement();
                Void void_ = super.visitFunctionExpression(functionExpression);
                return void_;
            }
            finally {
                this.enclosingFunction = executableElement;
            }
        }
        return super.visitFunctionExpression(functionExpression);
    }

    @Override
    public Void visitSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
        if (simpleIdentifier.getStaticElement() != null) {
            return null;
        }
        AstNode astNode = simpleIdentifier.getParent();
        if (astNode instanceof PrefixedIdentifier && ((PrefixedIdentifier)astNode).getIdentifier() == simpleIdentifier) {
            return null;
        }
        if (astNode instanceof PropertyAccess && ((PropertyAccess)astNode).getPropertyName() == simpleIdentifier) {
            return null;
        }
        if (astNode instanceof MethodInvocation && ((MethodInvocation)astNode).getMethodName() == simpleIdentifier) {
            return null;
        }
        if (astNode instanceof ConstructorName) {
            return null;
        }
        if (astNode instanceof Label) {
            return null;
        }
        Element element = this.getNameScope().lookup(simpleIdentifier, this.getDefiningLibrary());
        if (!(element instanceof VariableElement)) {
            return null;
        }
        ElementKind elementKind = element.getKind();
        if (elementKind == ElementKind.LOCAL_VARIABLE) {
            simpleIdentifier.setStaticElement(element);
            if (simpleIdentifier.inSetterContext()) {
                LocalVariableElementImpl localVariableElementImpl = (LocalVariableElementImpl)element;
                localVariableElementImpl.markPotentiallyMutatedInScope();
                if (!ObjectUtilities.equals(element.getEnclosingElement(), this.enclosingFunction)) {
                    localVariableElementImpl.markPotentiallyMutatedInClosure();
                }
            }
        } else if (elementKind == ElementKind.PARAMETER) {
            simpleIdentifier.setStaticElement(element);
            if (simpleIdentifier.inSetterContext()) {
                ParameterElementImpl parameterElementImpl = (ParameterElementImpl)element;
                parameterElementImpl.markPotentiallyMutatedInScope();
                if (this.enclosingFunction != null && !ObjectUtilities.equals(element.getEnclosingElement(), this.enclosingFunction)) {
                    parameterElementImpl.markPotentiallyMutatedInClosure();
                }
            }
        }
        return null;
    }
}

