/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.ast.AsExpression;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.CatchClause;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.ClassMember;
import com.google.dart.engine.ast.ClassTypeAlias;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.ConstructorName;
import com.google.dart.engine.ast.DeclaredIdentifier;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.ExtendsClause;
import com.google.dart.engine.ast.FieldFormalParameter;
import com.google.dart.engine.ast.FormalParameter;
import com.google.dart.engine.ast.FormalParameterList;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionTypeAlias;
import com.google.dart.engine.ast.FunctionTypedFormalParameter;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.ImplementsClause;
import com.google.dart.engine.ast.InstanceCreationExpression;
import com.google.dart.engine.ast.IsExpression;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.SimpleFormalParameter;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.SuperExpression;
import com.google.dart.engine.ast.TypeArgumentList;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.ast.TypeParameter;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.VariableDeclarationList;
import com.google.dart.engine.ast.WithClause;
import com.google.dart.engine.ast.visitor.UnifyingAstVisitor;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.FieldElement;
import com.google.dart.engine.element.FieldFormalParameterElement;
import com.google.dart.engine.element.FunctionTypeAliasElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.MultiplyDefinedElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.PrefixElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.PropertyInducingElement;
import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.error.StaticTypeWarningCode;
import com.google.dart.engine.error.StaticWarningCode;
import com.google.dart.engine.internal.element.ClassElementImpl;
import com.google.dart.engine.internal.element.ConstructorElementImpl;
import com.google.dart.engine.internal.element.ExecutableElementImpl;
import com.google.dart.engine.internal.element.FunctionTypeAliasElementImpl;
import com.google.dart.engine.internal.element.LocalVariableElementImpl;
import com.google.dart.engine.internal.element.ParameterElementImpl;
import com.google.dart.engine.internal.element.PropertyAccessorElementImpl;
import com.google.dart.engine.internal.element.PropertyInducingElementImpl;
import com.google.dart.engine.internal.element.TypeParameterElementImpl;
import com.google.dart.engine.internal.element.VariableElementImpl;
import com.google.dart.engine.internal.resolver.Library;
import com.google.dart.engine.internal.resolver.ResolvableLibrary;
import com.google.dart.engine.internal.resolver.ScopedVisitor;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.internal.scope.Scope;
import com.google.dart.engine.internal.type.DynamicTypeImpl;
import com.google.dart.engine.internal.type.FunctionTypeImpl;
import com.google.dart.engine.internal.type.InterfaceTypeImpl;
import com.google.dart.engine.internal.type.TypeImpl;
import com.google.dart.engine.internal.type.TypeParameterTypeImpl;
import com.google.dart.engine.internal.type.VoidTypeImpl;
import com.google.dart.engine.scanner.Keyword;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.scanner.TokenType;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.type.FunctionType;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;
import java.util.ArrayList;

public class TypeResolverVisitor
extends ScopedVisitor {
    private Type dynamicType;
    private boolean hasReferenceToSuper;

    private static boolean isBuiltInIdentifier(TypeName typeName) {
        Token token = typeName.getName().getBeginToken();
        return token.getType() == TokenType.KEYWORD;
    }

    private static boolean isTypeAnnotation(TypeName typeName) {
        AstNode astNode = typeName.getParent();
        if (astNode instanceof VariableDeclarationList) {
            return ((VariableDeclarationList)astNode).getType() == typeName;
        }
        if (astNode instanceof FieldFormalParameter) {
            return ((FieldFormalParameter)astNode).getType() == typeName;
        }
        if (astNode instanceof SimpleFormalParameter) {
            return ((SimpleFormalParameter)astNode).getType() == typeName;
        }
        return false;
    }

    public TypeResolverVisitor(Library library, Source source, TypeProvider typeProvider) {
        super(library, source, typeProvider);
        this.dynamicType = typeProvider.getDynamicType();
    }

    public TypeResolverVisitor(LibraryElement libraryElement, Source source, TypeProvider typeProvider, AnalysisErrorListener analysisErrorListener) {
        super(libraryElement, source, typeProvider, analysisErrorListener);
        this.dynamicType = typeProvider.getDynamicType();
    }

    public TypeResolverVisitor(LibraryElement libraryElement, Source source, TypeProvider typeProvider, Scope scope, AnalysisErrorListener analysisErrorListener) {
        super(libraryElement, source, typeProvider, scope, analysisErrorListener);
        this.dynamicType = typeProvider.getDynamicType();
    }

    public TypeResolverVisitor(ResolvableLibrary resolvableLibrary, Source source, TypeProvider typeProvider) {
        super(resolvableLibrary, source, typeProvider);
        this.dynamicType = typeProvider.getDynamicType();
    }

    @Override
    public Void visitCatchClause(CatchClause catchClause) {
        AstNode astNode;
        super.visitCatchClause(catchClause);
        SimpleIdentifier simpleIdentifier = catchClause.getExceptionParameter();
        if (simpleIdentifier != null) {
            astNode = catchClause.getExceptionType();
            Type type = astNode == null ? this.getTypeProvider().getDynamicType() : this.getType((TypeName)astNode);
            this.recordType(simpleIdentifier, type);
            Element element = simpleIdentifier.getStaticElement();
            if (element instanceof VariableElementImpl) {
                ((VariableElementImpl)element).setType(type);
            }
        }
        if ((astNode = catchClause.getStackTraceParameter()) != null) {
            this.recordType((Expression)astNode, this.getTypeProvider().getStackTraceType());
        }
        return null;
    }

    @Override
    public Void visitClassDeclaration(ClassDeclaration classDeclaration) {
        Object object;
        this.hasReferenceToSuper = false;
        super.visitClassDeclaration(classDeclaration);
        ClassElementImpl classElementImpl = this.getClassElement(classDeclaration.getName());
        Object object2 = null;
        ExtendsClause extendsClause = classDeclaration.getExtendsClause();
        if (extendsClause != null) {
            object = classDeclaration.getWithClause() == null ? CompileTimeErrorCode.EXTENDS_NON_CLASS : CompileTimeErrorCode.MIXIN_WITH_NON_CLASS_SUPERCLASS;
            object2 = this.resolveType(extendsClause.getSuperclass(), (ErrorCode)object, (ErrorCode)object);
            if (object2 != this.getTypeProvider().getObjectType()) {
                classElementImpl.setValidMixin(false);
            }
        }
        if (classElementImpl != null) {
            if (object2 == null) {
                object = this.getTypeProvider().getObjectType();
                if (classElementImpl.getType() != object) {
                    object2 = object;
                }
            }
            classElementImpl.setSupertype((InterfaceType)object2);
            classElementImpl.setHasReferenceToSuper(this.hasReferenceToSuper);
        }
        this.resolve(classElementImpl, classDeclaration.getWithClause(), classDeclaration.getImplementsClause());
        return null;
    }

    @Override
    public Void visitClassTypeAlias(ClassTypeAlias classTypeAlias) {
        super.visitClassTypeAlias(classTypeAlias);
        ClassElementImpl classElementImpl = this.getClassElement(classTypeAlias.getName());
        CompileTimeErrorCode compileTimeErrorCode = CompileTimeErrorCode.MIXIN_WITH_NON_CLASS_SUPERCLASS;
        InterfaceType interfaceType = this.resolveType(classTypeAlias.getSuperclass(), compileTimeErrorCode, compileTimeErrorCode);
        if (interfaceType == null) {
            interfaceType = this.getTypeProvider().getObjectType();
        }
        if (classElementImpl != null && interfaceType != null) {
            ConstructorElement[] constructorElementArray;
            int n;
            classElementImpl.setSupertype(interfaceType);
            ClassElement classElement = interfaceType.getElement();
            if (classElement != null && (n = (constructorElementArray = classElement.getConstructors()).length) > 0) {
                Type[] typeArray = TypeParameterTypeImpl.getTypes(interfaceType.getTypeParameters());
                Type[] typeArray2 = this.getArgumentTypes(classTypeAlias.getSuperclass().getTypeArguments(), typeArray);
                InterfaceType interfaceType2 = classElementImpl.getType();
                ArrayList<ConstructorElement> arrayList = new ArrayList<ConstructorElement>(n);
                for (int i = 0; i < n; ++i) {
                    ConstructorElement constructorElement = constructorElementArray[i];
                    if (constructorElement.isFactory()) continue;
                    arrayList.add(this.createImplicitContructor(interfaceType2, constructorElement, typeArray, typeArray2));
                }
                classElementImpl.setConstructors(arrayList.toArray(new ConstructorElement[arrayList.size()]));
            }
        }
        this.resolve(classElementImpl, classTypeAlias.getWithClause(), classTypeAlias.getImplementsClause());
        return null;
    }

    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
        super.visitConstructorDeclaration(constructorDeclaration);
        ExecutableElementImpl executableElementImpl = (ExecutableElementImpl)((Object)constructorDeclaration.getElement());
        if (executableElementImpl != null) {
            ClassElement classElement = (ClassElement)executableElementImpl.getEnclosingElement();
            executableElementImpl.setReturnType(classElement.getType());
            FunctionTypeImpl functionTypeImpl = new FunctionTypeImpl(executableElementImpl);
            functionTypeImpl.setTypeArguments(classElement.getType().getTypeArguments());
            executableElementImpl.setType(functionTypeImpl);
        }
        return null;
    }

    @Override
    public Void visitDeclaredIdentifier(DeclaredIdentifier declaredIdentifier) {
        super.visitDeclaredIdentifier(declaredIdentifier);
        TypeName typeName = declaredIdentifier.getType();
        Type type = typeName == null ? this.dynamicType : this.getType(typeName);
        LocalVariableElementImpl localVariableElementImpl = (LocalVariableElementImpl)declaredIdentifier.getElement();
        localVariableElementImpl.setType(type);
        return null;
    }

    @Override
    public Void visitFieldFormalParameter(FieldFormalParameter fieldFormalParameter) {
        super.visitFieldFormalParameter(fieldFormalParameter);
        Element element = fieldFormalParameter.getIdentifier().getStaticElement();
        if (element instanceof ParameterElementImpl) {
            ParameterElementImpl parameterElementImpl = (ParameterElementImpl)element;
            FormalParameterList formalParameterList = fieldFormalParameter.getParameters();
            if (formalParameterList == null) {
                Type type;
                TypeName typeName = fieldFormalParameter.getType();
                if (typeName == null) {
                    FieldElement fieldElement;
                    type = this.dynamicType;
                    if (parameterElementImpl instanceof FieldFormalParameterElement && (fieldElement = ((FieldFormalParameterElement)((Object)parameterElementImpl)).getField()) != null) {
                        type = fieldElement.getType();
                    }
                } else {
                    type = this.getType(typeName);
                }
                parameterElementImpl.setType(type);
            } else {
                this.setFunctionTypedParameterType(parameterElementImpl, fieldFormalParameter.getType(), fieldFormalParameter.getParameters());
            }
        }
        return null;
    }

    @Override
    public Void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        super.visitFunctionDeclaration(functionDeclaration);
        ExecutableElementImpl executableElementImpl = (ExecutableElementImpl)functionDeclaration.getElement();
        executableElementImpl.setReturnType(this.computeReturnType(functionDeclaration.getReturnType()));
        FunctionTypeImpl functionTypeImpl = new FunctionTypeImpl(executableElementImpl);
        ClassElement classElement = executableElementImpl.getAncestor(ClassElement.class);
        if (classElement != null) {
            functionTypeImpl.setTypeArguments(classElement.getType().getTypeArguments());
        }
        executableElementImpl.setType(functionTypeImpl);
        return null;
    }

    @Override
    public Void visitFunctionTypeAlias(FunctionTypeAlias functionTypeAlias) {
        super.visitFunctionTypeAlias(functionTypeAlias);
        FunctionTypeAliasElementImpl functionTypeAliasElementImpl = (FunctionTypeAliasElementImpl)functionTypeAlias.getElement();
        functionTypeAliasElementImpl.setReturnType(this.computeReturnType(functionTypeAlias.getReturnType()));
        return null;
    }

    @Override
    public Void visitFunctionTypedFormalParameter(FunctionTypedFormalParameter functionTypedFormalParameter) {
        super.visitFunctionTypedFormalParameter(functionTypedFormalParameter);
        Element element = functionTypedFormalParameter.getIdentifier().getStaticElement();
        if (element instanceof ParameterElementImpl) {
            this.setFunctionTypedParameterType((ParameterElementImpl)element, functionTypedFormalParameter.getReturnType(), functionTypedFormalParameter.getParameters());
        }
        return null;
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        super.visitMethodDeclaration(methodDeclaration);
        ExecutableElementImpl executableElementImpl = (ExecutableElementImpl)methodDeclaration.getElement();
        executableElementImpl.setReturnType(this.computeReturnType(methodDeclaration.getReturnType()));
        FunctionTypeImpl functionTypeImpl = new FunctionTypeImpl(executableElementImpl);
        ClassElement classElement = executableElementImpl.getAncestor(ClassElement.class);
        if (classElement != null) {
            functionTypeImpl.setTypeArguments(classElement.getType().getTypeArguments());
        }
        executableElementImpl.setType(functionTypeImpl);
        if (executableElementImpl instanceof PropertyAccessorElement) {
            Type[] typeArray;
            PropertyAccessorElement propertyAccessorElement = (PropertyAccessorElement)((Object)executableElementImpl);
            PropertyInducingElementImpl propertyInducingElementImpl = (PropertyInducingElementImpl)propertyAccessorElement.getVariable();
            if (propertyAccessorElement.isGetter()) {
                propertyInducingElementImpl.setType(functionTypeImpl.getReturnType());
            } else if (propertyInducingElementImpl.getType() == null && (typeArray = functionTypeImpl.getNormalParameterTypes()) != null && typeArray.length > 0) {
                propertyInducingElementImpl.setType(typeArray[0]);
            }
        }
        return null;
    }

    @Override
    public Void visitSimpleFormalParameter(SimpleFormalParameter simpleFormalParameter) {
        super.visitSimpleFormalParameter(simpleFormalParameter);
        TypeName typeName = simpleFormalParameter.getType();
        Type type = typeName == null ? this.dynamicType : this.getType(typeName);
        Element element = simpleFormalParameter.getIdentifier().getStaticElement();
        if (element instanceof ParameterElement) {
            ((ParameterElementImpl)element).setType(type);
        }
        return null;
    }

    @Override
    public Void visitSuperExpression(SuperExpression superExpression) {
        this.hasReferenceToSuper = true;
        return (Void)super.visitSuperExpression(superExpression);
    }

    @Override
    public Void visitTypeName(TypeName typeName) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        super.visitTypeName(typeName);
        Object object5 = typeName.getName();
        TypeArgumentList typeArgumentList = typeName.getTypeArguments();
        Element element = this.getNameScope().lookup((Identifier)object5, this.getDefiningLibrary());
        if (element == null) {
            if (((Identifier)object5).getName().equals(this.dynamicType.getName())) {
                this.setElement((Identifier)object5, this.dynamicType.getElement());
                if (typeArgumentList != null) {
                    // empty if block
                }
                ((Expression)object5).setStaticType(this.dynamicType);
                typeName.setType(this.dynamicType);
                return null;
            }
            VoidTypeImpl voidTypeImpl = VoidTypeImpl.getInstance();
            if (((Identifier)object5).getName().equals(voidTypeImpl.getName())) {
                if (typeArgumentList != null) {
                    // empty if block
                }
                ((Expression)object5).setStaticType(voidTypeImpl);
                typeName.setType(voidTypeImpl);
                return null;
            }
            object4 = typeName.getParent();
            if (object5 instanceof PrefixedIdentifier && object4 instanceof ConstructorName && typeArgumentList == null && (object3 = (ConstructorName)object4).getName() == null) {
                object2 = (PrefixedIdentifier)object5;
                object = ((PrefixedIdentifier)object2).getPrefix();
                element = this.getNameScope().lookup((Identifier)object, this.getDefiningLibrary());
                if (element instanceof PrefixElement) {
                    if (((AstNode)object4).getParent() instanceof InstanceCreationExpression && ((InstanceCreationExpression)((AstNode)object4).getParent()).isConst()) {
                        this.reportErrorForNode(CompileTimeErrorCode.CONST_WITH_NON_TYPE, ((PrefixedIdentifier)object2).getIdentifier(), ((PrefixedIdentifier)object2).getIdentifier().getName());
                    } else {
                        this.reportErrorForNode(StaticWarningCode.NEW_WITH_NON_TYPE, ((PrefixedIdentifier)object2).getIdentifier(), ((PrefixedIdentifier)object2).getIdentifier().getName());
                    }
                    this.setElement((Identifier)object, element);
                    return null;
                }
                if (element != null) {
                    object3.setName(((PrefixedIdentifier)object2).getIdentifier());
                    object3.setPeriod(((PrefixedIdentifier)object2).getPeriod());
                    typeName.setName((Identifier)object);
                    object5 = object;
                }
            }
        }
        boolean bl2 = bl = !(element instanceof MultiplyDefinedElement);
        if (bl && !(element instanceof ClassElement) && this.isTypeNameInInstanceCreationExpression(typeName)) {
            object4 = this.getTypeSimpleIdentifier((Identifier)object5);
            object3 = (InstanceCreationExpression)typeName.getParent().getParent();
            if (object3.isConst()) {
                if (element == null) {
                    this.reportErrorForNode(CompileTimeErrorCode.UNDEFINED_CLASS, (AstNode)object4, object5);
                } else {
                    this.reportErrorForNode(CompileTimeErrorCode.CONST_WITH_NON_TYPE, (AstNode)object4, object5);
                }
                bl = false;
            } else if (element != null) {
                this.reportErrorForNode(StaticWarningCode.NEW_WITH_NON_TYPE, (AstNode)object4, object5);
                bl = false;
            }
        }
        if (bl && element == null) {
            object4 = this.getTypeSimpleIdentifier((Identifier)object5);
            if (TypeResolverVisitor.isBuiltInIdentifier(typeName) && TypeResolverVisitor.isTypeAnnotation(typeName)) {
                this.reportErrorForNode(CompileTimeErrorCode.BUILT_IN_IDENTIFIER_AS_TYPE, (AstNode)object5, ((Identifier)object5).getName());
            } else if (((SimpleIdentifier)object4).getName().equals("boolean")) {
                this.reportErrorForNode(StaticWarningCode.UNDEFINED_CLASS_BOOLEAN, (AstNode)object4, new Object[0]);
            } else if (this.isTypeNameInCatchClause(typeName)) {
                this.reportErrorForNode(StaticWarningCode.NON_TYPE_IN_CATCH_CLAUSE, (AstNode)object5, ((Identifier)object5).getName());
            } else if (this.isTypeNameInAsExpression(typeName)) {
                this.reportErrorForNode(StaticWarningCode.CAST_TO_NON_TYPE, (AstNode)object5, ((Identifier)object5).getName());
            } else if (this.isTypeNameInIsExpression(typeName)) {
                this.reportErrorForNode(StaticWarningCode.TYPE_TEST_NON_TYPE, (AstNode)object5, ((Identifier)object5).getName());
            } else {
                object3 = this.getRedirectingConstructorKind(typeName);
                if (object3 != null) {
                    object2 = object3 == RedirectingConstructorKind.CONST ? CompileTimeErrorCode.REDIRECT_TO_NON_CLASS : StaticWarningCode.REDIRECT_TO_NON_CLASS;
                    this.reportErrorForNode((ErrorCode)object2, (AstNode)object5, ((Identifier)object5).getName());
                } else if (this.isTypeNameInTypeArgumentList(typeName)) {
                    this.reportErrorForNode(StaticTypeWarningCode.NON_TYPE_AS_TYPE_ARGUMENT, (AstNode)object5, ((Identifier)object5).getName());
                } else {
                    this.reportErrorForNode(StaticWarningCode.UNDEFINED_CLASS, (AstNode)object5, ((Identifier)object5).getName());
                }
            }
            bl = false;
        }
        if (!bl) {
            if (element instanceof MultiplyDefinedElement) {
                this.setElement((Identifier)object5, element);
            } else {
                this.setElement((Identifier)object5, this.dynamicType.getElement());
            }
            ((Expression)object5).setStaticType(this.dynamicType);
            typeName.setType(this.dynamicType);
            return null;
        }
        object4 = null;
        if (element instanceof ClassElement) {
            this.setElement((Identifier)object5, element);
            object4 = ((ClassElement)element).getType();
        } else if (element instanceof FunctionTypeAliasElement) {
            this.setElement((Identifier)object5, element);
            object4 = ((FunctionTypeAliasElement)element).getType();
        } else if (element instanceof TypeParameterElement) {
            this.setElement((Identifier)object5, element);
            object4 = ((TypeParameterElement)element).getType();
            if (typeArgumentList != null) {
                // empty if block
            }
        } else if (element instanceof MultiplyDefinedElement) {
            object3 = ((MultiplyDefinedElement)element).getConflictingElements();
            object4 = this.getTypeWhenMultiplyDefined((Element[])object3);
            if (object4 != null) {
                typeName.setType((Type)object4);
            }
        } else {
            if (this.isTypeNameInCatchClause(typeName)) {
                this.reportErrorForNode(StaticWarningCode.NON_TYPE_IN_CATCH_CLAUSE, (AstNode)object5, ((Identifier)object5).getName());
            } else if (this.isTypeNameInAsExpression(typeName)) {
                this.reportErrorForNode(StaticWarningCode.CAST_TO_NON_TYPE, (AstNode)object5, ((Identifier)object5).getName());
            } else if (this.isTypeNameInIsExpression(typeName)) {
                this.reportErrorForNode(StaticWarningCode.TYPE_TEST_NON_TYPE, (AstNode)object5, ((Identifier)object5).getName());
            } else {
                object3 = this.getRedirectingConstructorKind(typeName);
                if (object3 != null) {
                    object2 = object3 == RedirectingConstructorKind.CONST ? CompileTimeErrorCode.REDIRECT_TO_NON_CLASS : StaticWarningCode.REDIRECT_TO_NON_CLASS;
                    this.reportErrorForNode((ErrorCode)object2, (AstNode)object5, ((Identifier)object5).getName());
                } else if (this.isTypeNameInTypeArgumentList(typeName)) {
                    this.reportErrorForNode(StaticTypeWarningCode.NON_TYPE_AS_TYPE_ARGUMENT, (AstNode)object5, ((Identifier)object5).getName());
                } else {
                    object2 = ((AstNode)object5).getParent();
                    while (object2 instanceof TypeName) {
                        object2 = ((AstNode)object2).getParent();
                    }
                    if (!(object2 instanceof ExtendsClause || object2 instanceof ImplementsClause || object2 instanceof WithClause || object2 instanceof ClassTypeAlias)) {
                        this.reportErrorForNode(StaticWarningCode.NOT_A_TYPE, (AstNode)object5, ((Identifier)object5).getName());
                    }
                }
            }
            this.setElement((Identifier)object5, this.dynamicType.getElement());
            ((Expression)object5).setStaticType(this.dynamicType);
            typeName.setType(this.dynamicType);
            return null;
        }
        if (typeArgumentList != null) {
            int n;
            object3 = typeArgumentList.getArguments();
            int n2 = object3.size();
            object = this.getTypeArguments((Type)object4);
            int n3 = ((Type[])object).length;
            Type[] typeArray = new Type[n3];
            if (n2 == n3) {
                for (n = 0; n < n3; ++n) {
                    TypeName typeName2 = (TypeName)object3.get(n);
                    Type type = this.getType(typeName2);
                    if (type == null) {
                        type = this.dynamicType;
                    }
                    typeArray[n] = type;
                }
            } else {
                this.reportErrorForNode(this.getInvalidTypeParametersErrorCode(typeName), typeName, ((Identifier)object5).getName(), n3, n2);
                for (n = 0; n < n3; ++n) {
                    typeArray[n] = this.dynamicType;
                }
            }
            if (object4 instanceof InterfaceTypeImpl) {
                InterfaceTypeImpl interfaceTypeImpl = (InterfaceTypeImpl)object4;
                object4 = interfaceTypeImpl.substitute(typeArray);
            } else if (object4 instanceof FunctionTypeImpl) {
                FunctionTypeImpl functionTypeImpl = (FunctionTypeImpl)object4;
                object4 = functionTypeImpl.substitute(typeArray);
            }
        } else {
            object3 = this.getTypeArguments((Type)object4);
            int n = ((Element[])object3).length;
            if (n > 0) {
                object = DynamicTypeImpl.getInstance();
                Type[] typeArray = new Type[n];
                for (int i = 0; i < n; ++i) {
                    typeArray[i] = object;
                }
                object4 = object4.substitute(typeArray, (Type[])object3);
            }
        }
        ((Expression)object5).setStaticType((Type)object4);
        typeName.setType((Type)object4);
        return null;
    }

    @Override
    public Void visitTypeParameter(TypeParameter typeParameter) {
        TypeParameterElementImpl typeParameterElementImpl;
        super.visitTypeParameter(typeParameter);
        TypeName typeName = typeParameter.getBound();
        if (typeName != null && (typeParameterElementImpl = (TypeParameterElementImpl)typeParameter.getName().getStaticElement()) != null) {
            typeParameterElementImpl.setBound(typeName.getType());
        }
        return null;
    }

    @Override
    public Void visitVariableDeclaration(VariableDeclaration variableDeclaration) {
        super.visitVariableDeclaration(variableDeclaration);
        TypeName typeName = ((VariableDeclarationList)variableDeclaration.getParent()).getType();
        Type type = typeName == null ? this.dynamicType : this.getType(typeName);
        Element element = variableDeclaration.getName().getStaticElement();
        if (element instanceof VariableElement) {
            ((VariableElementImpl)element).setType(type);
            if (element instanceof PropertyInducingElement) {
                PropertyInducingElement propertyInducingElement = (PropertyInducingElement)element;
                PropertyAccessorElementImpl propertyAccessorElementImpl = (PropertyAccessorElementImpl)propertyInducingElement.getGetter();
                propertyAccessorElementImpl.setReturnType(type);
                FunctionTypeImpl functionTypeImpl = new FunctionTypeImpl(propertyAccessorElementImpl);
                ClassElement classElement = element.getAncestor(ClassElement.class);
                if (classElement != null) {
                    functionTypeImpl.setTypeArguments(classElement.getType().getTypeArguments());
                }
                propertyAccessorElementImpl.setType(functionTypeImpl);
                PropertyAccessorElementImpl propertyAccessorElementImpl2 = (PropertyAccessorElementImpl)propertyInducingElement.getSetter();
                if (propertyAccessorElementImpl2 != null) {
                    ParameterElement[] parameterElementArray = propertyAccessorElementImpl2.getParameters();
                    if (parameterElementArray.length > 0) {
                        ((ParameterElementImpl)parameterElementArray[0]).setType(type);
                    }
                    propertyAccessorElementImpl2.setReturnType(VoidTypeImpl.getInstance());
                    FunctionTypeImpl functionTypeImpl2 = new FunctionTypeImpl(propertyAccessorElementImpl2);
                    if (classElement != null) {
                        functionTypeImpl2.setTypeArguments(classElement.getType().getTypeArguments());
                    }
                    propertyAccessorElementImpl2.setType(functionTypeImpl2);
                }
            }
        }
        return null;
    }

    @Override
    protected void visitClassDeclarationInScope(ClassDeclaration classDeclaration) {
        final ArrayList arrayList = new ArrayList();
        classDeclaration.visitChildren(new UnifyingAstVisitor<Void>(){

            @Override
            public Void visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
                arrayList.add(constructorDeclaration);
                return null;
            }

            @Override
            public Void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
                arrayList.add(methodDeclaration);
                return null;
            }

            @Override
            public Void visitNode(AstNode astNode) {
                return astNode.accept(TypeResolverVisitor.this);
            }
        });
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ((ClassMember)arrayList.get(i)).accept(this);
        }
    }

    private Type computeReturnType(TypeName typeName) {
        if (typeName == null) {
            return this.dynamicType;
        }
        return typeName.getType();
    }

    private ConstructorElement createImplicitContructor(InterfaceType interfaceType, ConstructorElement constructorElement, Type[] typeArray, Type[] typeArray2) {
        Object object;
        ConstructorElementImpl constructorElementImpl = new ConstructorElementImpl(constructorElement.getName(), -1);
        constructorElementImpl.setSynthetic(true);
        constructorElementImpl.setRedirectedConstructor(constructorElement);
        constructorElementImpl.setConst(constructorElement.isConst());
        constructorElementImpl.setReturnType(interfaceType);
        ParameterElement[] parameterElementArray = constructorElement.getParameters();
        int n = parameterElementArray.length;
        if (n > 0) {
            object = new ParameterElement[n];
            for (int i = 0; i < n; ++i) {
                ParameterElement parameterElement = parameterElementArray[i];
                ParameterElementImpl parameterElementImpl = new ParameterElementImpl(parameterElement.getName(), -1);
                parameterElementImpl.setConst(parameterElement.isConst());
                parameterElementImpl.setFinal(parameterElement.isFinal());
                parameterElementImpl.setParameterKind(parameterElement.getParameterKind());
                parameterElementImpl.setSynthetic(true);
                parameterElementImpl.setType(parameterElement.getType().substitute(typeArray2, typeArray));
                object[i] = parameterElementImpl;
            }
            constructorElementImpl.setParameters((ParameterElement[])object);
        }
        object = new FunctionTypeImpl(constructorElementImpl);
        ((FunctionTypeImpl)object).setTypeArguments(interfaceType.getTypeArguments());
        constructorElementImpl.setType((FunctionType)object);
        return constructorElementImpl;
    }

    private Type[] getArgumentTypes(TypeArgumentList typeArgumentList, Type[] typeArray) {
        DynamicTypeImpl dynamicTypeImpl = DynamicTypeImpl.getInstance();
        int n = typeArray.length;
        Type[] typeArray2 = new Type[n];
        if (typeArgumentList == null) {
            for (int i = 0; i < n; ++i) {
                typeArray2[i] = dynamicTypeImpl;
            }
        } else {
            int n2;
            NodeList<TypeName> nodeList = typeArgumentList.getArguments();
            int n3 = Math.min(nodeList.size(), n);
            for (n2 = 0; n2 < n3; ++n2) {
                typeArray2[n2] = ((TypeName)nodeList.get(n2)).getType();
            }
            for (n2 = n3; n2 < n; ++n2) {
                typeArray2[n2] = dynamicTypeImpl;
            }
        }
        return typeArray2;
    }

    private ClassElementImpl getClassElement(SimpleIdentifier simpleIdentifier) {
        if (simpleIdentifier == null) {
            return null;
        }
        Element element = simpleIdentifier.getStaticElement();
        if (!(element instanceof ClassElementImpl)) {
            return null;
        }
        return (ClassElementImpl)element;
    }

    private ParameterElement[] getElements(FormalParameterList formalParameterList) {
        ArrayList<ParameterElement> arrayList = new ArrayList<ParameterElement>();
        for (FormalParameter formalParameter : formalParameterList.getParameters()) {
            ParameterElement parameterElement = (ParameterElement)formalParameter.getIdentifier().getStaticElement();
            if (parameterElement == null) continue;
            arrayList.add(parameterElement);
        }
        return arrayList.toArray(new ParameterElement[arrayList.size()]);
    }

    private ErrorCode getInvalidTypeParametersErrorCode(TypeName typeName) {
        AstNode astNode = typeName.getParent();
        if (astNode instanceof ConstructorName && (astNode = astNode.getParent()) instanceof InstanceCreationExpression) {
            if (((InstanceCreationExpression)astNode).isConst()) {
                return CompileTimeErrorCode.CONST_WITH_INVALID_TYPE_PARAMETERS;
            }
            return StaticWarningCode.NEW_WITH_INVALID_TYPE_PARAMETERS;
        }
        return StaticTypeWarningCode.WRONG_NUMBER_OF_TYPE_ARGUMENTS;
    }

    private RedirectingConstructorKind getRedirectingConstructorKind(TypeName typeName) {
        ConstructorDeclaration constructorDeclaration;
        ConstructorName constructorName;
        AstNode astNode = typeName.getParent();
        if (astNode instanceof ConstructorName && (astNode = (constructorName = (ConstructorName)astNode).getParent()) instanceof ConstructorDeclaration && (constructorDeclaration = (ConstructorDeclaration)astNode).getRedirectedConstructor() == constructorName) {
            if (constructorDeclaration.getConstKeyword() != null) {
                return RedirectingConstructorKind.CONST;
            }
            return RedirectingConstructorKind.NORMAL;
        }
        return null;
    }

    private Type getType(TypeName typeName) {
        Type type = typeName.getType();
        if (type == null) {
            return this.dynamicType;
        }
        return type;
    }

    private Type[] getTypeArguments(Type type) {
        if (type instanceof InterfaceType) {
            return ((InterfaceType)type).getTypeArguments();
        }
        if (type instanceof FunctionType) {
            return ((FunctionType)type).getTypeArguments();
        }
        return TypeImpl.EMPTY_ARRAY;
    }

    private SimpleIdentifier getTypeSimpleIdentifier(Identifier identifier) {
        if (identifier instanceof SimpleIdentifier) {
            return (SimpleIdentifier)identifier;
        }
        return ((PrefixedIdentifier)identifier).getIdentifier();
    }

    private InterfaceType getTypeWhenMultiplyDefined(Element[] elementArray) {
        InterfaceType interfaceType = null;
        for (Element element : elementArray) {
            if (!(element instanceof ClassElement)) continue;
            if (interfaceType != null) {
                return null;
            }
            interfaceType = ((ClassElement)element).getType();
        }
        return interfaceType;
    }

    private boolean isTypeNameInAsExpression(TypeName typeName) {
        AstNode astNode = typeName.getParent();
        if (astNode instanceof AsExpression) {
            AsExpression asExpression = (AsExpression)astNode;
            return asExpression.getType() == typeName;
        }
        return false;
    }

    private boolean isTypeNameInCatchClause(TypeName typeName) {
        AstNode astNode = typeName.getParent();
        if (astNode instanceof CatchClause) {
            CatchClause catchClause = (CatchClause)astNode;
            return catchClause.getExceptionType() == typeName;
        }
        return false;
    }

    private boolean isTypeNameInInstanceCreationExpression(TypeName typeName) {
        AstNode astNode = typeName.getParent();
        if (astNode instanceof ConstructorName && astNode.getParent() instanceof InstanceCreationExpression) {
            ConstructorName constructorName = (ConstructorName)astNode;
            return constructorName != null && constructorName.getType() == typeName;
        }
        return false;
    }

    private boolean isTypeNameInIsExpression(TypeName typeName) {
        AstNode astNode = typeName.getParent();
        if (astNode instanceof IsExpression) {
            IsExpression isExpression = (IsExpression)astNode;
            return isExpression.getType() == typeName;
        }
        return false;
    }

    private boolean isTypeNameInTypeArgumentList(TypeName typeName) {
        return typeName.getParent() instanceof TypeArgumentList;
    }

    private Void recordType(Expression expression, Type type) {
        if (type == null) {
            expression.setStaticType(this.dynamicType);
        } else {
            expression.setStaticType(type);
        }
        return null;
    }

    private void resolve(ClassElementImpl classElementImpl, WithClause withClause, ImplementsClause implementsClause) {
        InterfaceType[] interfaceTypeArray;
        if (withClause != null) {
            interfaceTypeArray = this.resolveTypes(withClause.getMixinTypes(), CompileTimeErrorCode.MIXIN_OF_NON_CLASS, CompileTimeErrorCode.MIXIN_OF_NON_CLASS);
            if (classElementImpl != null) {
                classElementImpl.setMixins(interfaceTypeArray);
            }
        }
        if (implementsClause != null) {
            int n;
            interfaceTypeArray = implementsClause.getInterfaces();
            InterfaceType[] interfaceTypeArray2 = this.resolveTypes((NodeList<TypeName>)interfaceTypeArray, CompileTimeErrorCode.IMPLEMENTS_NON_CLASS, CompileTimeErrorCode.IMPLEMENTS_DYNAMIC);
            if (classElementImpl != null) {
                classElementImpl.setInterfaces(interfaceTypeArray2);
            }
            TypeName[] typeNameArray = interfaceTypeArray.toArray(new TypeName[interfaceTypeArray.size()]);
            boolean[] blArray = new boolean[typeNameArray.length];
            for (n = 0; n < blArray.length; ++n) {
                blArray[n] = false;
            }
            for (n = 0; n < typeNameArray.length; ++n) {
                TypeName typeName = typeNameArray[n];
                if (blArray[n]) continue;
                Element element = typeName.getName().getStaticElement();
                for (int i = n + 1; i < typeNameArray.length; ++i) {
                    TypeName typeName2 = typeNameArray[i];
                    Identifier identifier = typeName2.getName();
                    String string = identifier.getName();
                    Element element2 = identifier.getStaticElement();
                    if (element == null || !element.equals(element2)) continue;
                    blArray[i] = true;
                    this.reportErrorForNode(CompileTimeErrorCode.IMPLEMENTS_REPEATED, typeName2, string);
                }
            }
        }
    }

    private InterfaceType resolveType(TypeName typeName, ErrorCode errorCode, ErrorCode errorCode2) {
        Type type = typeName.getType();
        if (type instanceof InterfaceType) {
            return (InterfaceType)type;
        }
        Identifier identifier = typeName.getName();
        if (identifier.getName().equals(Keyword.DYNAMIC.getSyntax())) {
            this.reportErrorForNode(errorCode2, identifier, identifier.getName());
        } else {
            this.reportErrorForNode(errorCode, identifier, identifier.getName());
        }
        return null;
    }

    private InterfaceType[] resolveTypes(NodeList<TypeName> nodeList, ErrorCode errorCode, ErrorCode errorCode2) {
        ArrayList<InterfaceType> arrayList = new ArrayList<InterfaceType>();
        for (TypeName typeName : nodeList) {
            InterfaceType interfaceType = this.resolveType(typeName, errorCode, errorCode2);
            if (interfaceType == null) continue;
            arrayList.add(interfaceType);
        }
        return arrayList.toArray(new InterfaceType[arrayList.size()]);
    }

    private void setElement(Identifier identifier, Element element) {
        if (element != null) {
            if (identifier instanceof SimpleIdentifier) {
                ((SimpleIdentifier)identifier).setStaticElement(element);
            } else if (identifier instanceof PrefixedIdentifier) {
                PrefixedIdentifier prefixedIdentifier = (PrefixedIdentifier)identifier;
                prefixedIdentifier.getIdentifier().setStaticElement(element);
                SimpleIdentifier simpleIdentifier = prefixedIdentifier.getPrefix();
                Element element2 = this.getNameScope().lookup(simpleIdentifier, this.getDefiningLibrary());
                if (element2 != null) {
                    simpleIdentifier.setStaticElement(element2);
                }
            }
        }
    }

    private void setFunctionTypedParameterType(ParameterElementImpl parameterElementImpl, TypeName typeName, FormalParameterList formalParameterList) {
        ParameterElement[] parameterElementArray = this.getElements(formalParameterList);
        FunctionTypeAliasElementImpl functionTypeAliasElementImpl = new FunctionTypeAliasElementImpl(null);
        functionTypeAliasElementImpl.setSynthetic(true);
        functionTypeAliasElementImpl.shareParameters(parameterElementArray);
        functionTypeAliasElementImpl.setReturnType(this.computeReturnType(typeName));
        FunctionTypeImpl functionTypeImpl = new FunctionTypeImpl(functionTypeAliasElementImpl);
        ClassElement classElement = parameterElementImpl.getAncestor(ClassElement.class);
        if (classElement != null) {
            functionTypeAliasElementImpl.shareTypeParameters(classElement.getTypeParameters());
            functionTypeImpl.setTypeArguments(classElement.getType().getTypeArguments());
        } else {
            FunctionTypeAliasElement functionTypeAliasElement;
            for (functionTypeAliasElement = parameterElementImpl.getAncestor(FunctionTypeAliasElement.class); functionTypeAliasElement != null && functionTypeAliasElement.isSynthetic(); functionTypeAliasElement = functionTypeAliasElement.getAncestor(FunctionTypeAliasElement.class)) {
            }
            if (functionTypeAliasElement != null) {
                functionTypeAliasElementImpl.setTypeParameters(functionTypeAliasElement.getTypeParameters());
                functionTypeImpl.setTypeArguments(functionTypeAliasElement.getType().getTypeArguments());
            } else {
                functionTypeImpl.setTypeArguments(TypeImpl.EMPTY_ARRAY);
            }
        }
        parameterElementImpl.setType(functionTypeImpl);
    }

    private static enum RedirectingConstructorKind {
        CONST,
        NORMAL;

    }
}

