/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.internal.scope.Namespace;
import com.google.dart.engine.internal.scope.NamespaceBuilder;
import com.google.dart.engine.internal.type.BottomTypeImpl;
import com.google.dart.engine.internal.type.DynamicTypeImpl;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;

public class TypeProviderImpl
implements TypeProvider {
    private InterfaceType boolType;
    private Type bottomType;
    private InterfaceType doubleType;
    private InterfaceType deprecatedType;
    private Type dynamicType;
    private InterfaceType functionType;
    private InterfaceType intType;
    private InterfaceType listType;
    private InterfaceType mapType;
    private InterfaceType nullType;
    private InterfaceType numType;
    private InterfaceType objectType;
    private InterfaceType stackTraceType;
    private InterfaceType stringType;
    private InterfaceType symbolType;
    private InterfaceType typeType;

    public TypeProviderImpl(LibraryElement libraryElement) {
        this.initializeFrom(libraryElement);
    }

    @Override
    public InterfaceType getBoolType() {
        return this.boolType;
    }

    @Override
    public Type getBottomType() {
        return this.bottomType;
    }

    @Override
    public InterfaceType getDeprecatedType() {
        return this.deprecatedType;
    }

    @Override
    public InterfaceType getDoubleType() {
        return this.doubleType;
    }

    @Override
    public Type getDynamicType() {
        return this.dynamicType;
    }

    @Override
    public InterfaceType getFunctionType() {
        return this.functionType;
    }

    @Override
    public InterfaceType getIntType() {
        return this.intType;
    }

    @Override
    public InterfaceType getListType() {
        return this.listType;
    }

    @Override
    public InterfaceType getMapType() {
        return this.mapType;
    }

    @Override
    public InterfaceType getNullType() {
        return this.nullType;
    }

    @Override
    public InterfaceType getNumType() {
        return this.numType;
    }

    @Override
    public InterfaceType getObjectType() {
        return this.objectType;
    }

    @Override
    public InterfaceType getStackTraceType() {
        return this.stackTraceType;
    }

    @Override
    public InterfaceType getStringType() {
        return this.stringType;
    }

    @Override
    public InterfaceType getSymbolType() {
        return this.symbolType;
    }

    @Override
    public InterfaceType getTypeType() {
        return this.typeType;
    }

    private InterfaceType getType(Namespace namespace, String string) {
        Element element = namespace.get(string);
        if (element == null) {
            AnalysisEngine.getInstance().getLogger().logInformation("No definition of type " + string);
            return null;
        }
        return ((ClassElement)element).getType();
    }

    private void initializeFrom(LibraryElement libraryElement) {
        Namespace namespace = new NamespaceBuilder().createPublicNamespaceForLibrary(libraryElement);
        this.boolType = this.getType(namespace, "bool");
        this.bottomType = BottomTypeImpl.getInstance();
        this.deprecatedType = this.getType(namespace, "Deprecated");
        this.doubleType = this.getType(namespace, "double");
        this.dynamicType = DynamicTypeImpl.getInstance();
        this.functionType = this.getType(namespace, "Function");
        this.intType = this.getType(namespace, "int");
        this.listType = this.getType(namespace, "List");
        this.mapType = this.getType(namespace, "Map");
        this.nullType = this.getType(namespace, "Null");
        this.numType = this.getType(namespace, "num");
        this.objectType = this.getType(namespace, "Object");
        this.stackTraceType = this.getType(namespace, "StackTrace");
        this.stringType = this.getType(namespace, "String");
        this.symbolType = this.getType(namespace, "Symbol");
        this.typeType = this.getType(namespace, "Type");
    }
}

