/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.type.Type;
import java.util.Collection;
import java.util.HashMap;

public class TypePromotionManager {
    private TypePromoteScope currentScope;

    public void enterScope() {
        this.currentScope = new TypePromoteScope(this.currentScope);
    }

    public void exitScope() {
        if (this.currentScope == null) {
            throw new IllegalStateException("No scope to exit");
        }
        this.currentScope = this.currentScope.outerScope;
    }

    public Collection<Element> getPromotedElements() {
        return this.currentScope.getPromotedElements();
    }

    public Type getStaticType(VariableElement variableElement) {
        Type type = this.getType(variableElement);
        if (type == null) {
            type = variableElement.getType();
        }
        return type;
    }

    public Type getType(Element element) {
        if (this.currentScope == null) {
            return null;
        }
        return this.currentScope.getType(element);
    }

    public void setType(Element element, Type type) {
        if (this.currentScope == null) {
            throw new IllegalStateException("Cannot promote without a scope");
        }
        this.currentScope.setType(element, type);
    }

    private static class TypePromoteScope {
        private TypePromoteScope outerScope;
        private HashMap<Element, Type> promotedTypes = new HashMap();

        public TypePromoteScope(TypePromoteScope typePromoteScope) {
            this.outerScope = typePromoteScope;
        }

        public Collection<Element> getPromotedElements() {
            return this.promotedTypes.keySet();
        }

        public Type getType(Element element) {
            Type type = this.promotedTypes.get(element);
            if (type == null && element instanceof PropertyAccessorElement) {
                type = this.promotedTypes.get(((PropertyAccessorElement)element).getVariable());
            }
            if (type != null) {
                return type;
            }
            if (this.outerScope != null) {
                return this.outerScope.getType(element);
            }
            return null;
        }

        public void setType(Element element, Type type) {
            this.promotedTypes.put(element, type);
        }
    }
}

