/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.VariableDeclarationList;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.type.Type;
import java.util.HashMap;
import java.util.Map;

public class TypeOverrideManager {
    private TypeOverrideScope currentScope;

    public void applyOverrides(HashMap<Element, Type> hashMap) {
        if (this.currentScope == null) {
            throw new IllegalStateException("Cannot apply overrides without a scope");
        }
        this.currentScope.applyOverrides(hashMap);
    }

    public HashMap<Element, Type> captureLocalOverrides() {
        if (this.currentScope == null) {
            throw new IllegalStateException("Cannot capture local overrides without a scope");
        }
        return this.currentScope.captureLocalOverrides();
    }

    public HashMap<Element, Type> captureOverrides(VariableDeclarationList variableDeclarationList) {
        if (this.currentScope == null) {
            throw new IllegalStateException("Cannot capture overrides without a scope");
        }
        return this.currentScope.captureOverrides(variableDeclarationList);
    }

    public void enterScope() {
        this.currentScope = new TypeOverrideScope(this.currentScope);
    }

    public void exitScope() {
        if (this.currentScope == null) {
            throw new IllegalStateException("No scope to exit");
        }
        this.currentScope = this.currentScope.outerScope;
    }

    public Type getType(Element element) {
        if (this.currentScope == null) {
            return null;
        }
        return this.currentScope.getType(element);
    }

    public void setType(Element element, Type type) {
        if (this.currentScope == null) {
            throw new IllegalStateException("Cannot override without a scope");
        }
        this.currentScope.setType(element, type);
    }

    private static class TypeOverrideScope {
        private TypeOverrideScope outerScope;
        private HashMap<Element, Type> overridenTypes = new HashMap();

        public TypeOverrideScope(TypeOverrideScope typeOverrideScope) {
            this.outerScope = typeOverrideScope;
        }

        public void applyOverrides(HashMap<Element, Type> hashMap) {
            for (Map.Entry<Element, Type> entry : hashMap.entrySet()) {
                this.overridenTypes.put(entry.getKey(), entry.getValue());
            }
        }

        public HashMap<Element, Type> captureLocalOverrides() {
            return this.overridenTypes;
        }

        public HashMap<Element, Type> captureOverrides(VariableDeclarationList variableDeclarationList) {
            HashMap<Element, Type> hashMap = new HashMap<Element, Type>();
            if (variableDeclarationList.isConst() || variableDeclarationList.isFinal()) {
                for (VariableDeclaration variableDeclaration : variableDeclarationList.getVariables()) {
                    Type type;
                    VariableElement variableElement = variableDeclaration.getElement();
                    if (variableElement == null || (type = this.overridenTypes.get(variableElement)) == null) continue;
                    hashMap.put(variableElement, type);
                }
            }
            return hashMap;
        }

        public Type getType(Element element) {
            Type type = this.overridenTypes.get(element);
            if (type == null && element instanceof PropertyAccessorElement) {
                type = this.overridenTypes.get(((PropertyAccessorElement)element).getVariable());
            }
            if (type != null) {
                return type;
            }
            if (this.outerScope != null) {
                return this.outerScope.getType(element);
            }
            return null;
        }

        public void setType(Element element, Type type) {
            this.overridenTypes.put(element, type);
        }
    }
}

