/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.type.InterfaceType;
import java.util.HashMap;
import java.util.HashSet;

public class SubtypeManager {
    private HashMap<ClassElement, HashSet<ClassElement>> subtypeMap = new HashMap();
    private HashSet<LibraryElement> visitedLibraries = new HashSet();

    public HashSet<ClassElement> computeAllSubtypes(ClassElement classElement) {
        this.computeSubtypesInLibrary(classElement.getLibrary());
        HashSet<ClassElement> hashSet = new HashSet<ClassElement>();
        this.safelyComputeAllSubtypes(classElement, new HashSet<ClassElement>(), hashSet);
        return hashSet;
    }

    public void ensureLibraryVisited(LibraryElement libraryElement) {
        this.computeSubtypesInLibrary(libraryElement);
    }

    private void computeSubtypesInClass(ClassElement classElement) {
        InterfaceType[] interfaceTypeArray;
        InterfaceType interfaceType = classElement.getSupertype();
        if (interfaceType != null && (interfaceTypeArray = interfaceType.getElement()) != null) {
            this.putInSubtypeMap((ClassElement)interfaceTypeArray, classElement);
        }
        InterfaceType[] interfaceTypeArray2 = interfaceTypeArray = classElement.getInterfaces();
        int n = interfaceTypeArray2.length;
        for (int i = 0; i < n; ++i) {
            InterfaceType interfaceType2 = interfaceTypeArray2[i];
            ClassElement object = interfaceType2.getElement();
            if (object == null) continue;
            this.putInSubtypeMap(object, classElement);
        }
        for (InterfaceType interfaceType2 : interfaceTypeArray2 = classElement.getMixins()) {
            ClassElement classElement2 = interfaceType2.getElement();
            if (classElement2 == null) continue;
            this.putInSubtypeMap(classElement2, classElement);
        }
    }

    private void computeSubtypesInCompilationUnit(CompilationUnitElement compilationUnitElement) {
        ClassElement[] classElementArray;
        for (ClassElement classElement : classElementArray = compilationUnitElement.getTypes()) {
            this.computeSubtypesInClass(classElement);
        }
    }

    private void computeSubtypesInLibrary(LibraryElement libraryElement) {
        int n;
        if (libraryElement == null || this.visitedLibraries.contains(libraryElement)) {
            return;
        }
        this.visitedLibraries.add(libraryElement);
        this.computeSubtypesInCompilationUnit(libraryElement.getDefiningCompilationUnit());
        CompilationUnitElement[] compilationUnitElementArray = libraryElement.getParts();
        Element[] elementArray = compilationUnitElementArray;
        int n2 = elementArray.length;
        for (n = 0; n < n2; ++n) {
            CompilationUnitElement compilationUnitElement = elementArray[n];
            this.computeSubtypesInCompilationUnit(compilationUnitElement);
        }
        Element[] elementArray2 = elementArray = libraryElement.getImportedLibraries();
        n = elementArray2.length;
        for (int i = 0; i < n; ++i) {
            Element element = elementArray2[i];
            this.computeSubtypesInLibrary(element.getLibrary());
        }
        for (Element element : elementArray2 = libraryElement.getExportedLibraries()) {
            this.computeSubtypesInLibrary(element.getLibrary());
        }
    }

    private void putInSubtypeMap(ClassElement classElement, ClassElement classElement2) {
        HashSet<ClassElement> hashSet = this.subtypeMap.get(classElement);
        if (hashSet == null) {
            hashSet = new HashSet();
            this.subtypeMap.put(classElement, hashSet);
        }
        hashSet.add(classElement2);
    }

    private void safelyComputeAllSubtypes(ClassElement classElement, HashSet<ClassElement> hashSet, HashSet<ClassElement> hashSet2) {
        if (!hashSet.add(classElement)) {
            return;
        }
        HashSet<ClassElement> hashSet3 = this.subtypeMap.get(classElement);
        if (hashSet3 == null) {
            return;
        }
        for (ClassElement classElement2 : hashSet3) {
            this.safelyComputeAllSubtypes(classElement2, hashSet, hashSet2);
        }
        hashSet2.addAll(hashSet3);
    }
}

