/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.ast.AdjacentStrings;
import com.google.dart.engine.ast.ArgumentDefinitionTest;
import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AsExpression;
import com.google.dart.engine.ast.AssignmentExpression;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.BlockFunctionBody;
import com.google.dart.engine.ast.BooleanLiteral;
import com.google.dart.engine.ast.CascadeExpression;
import com.google.dart.engine.ast.ConditionalExpression;
import com.google.dart.engine.ast.DoubleLiteral;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.ExpressionFunctionBody;
import com.google.dart.engine.ast.FunctionBody;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionExpression;
import com.google.dart.engine.ast.FunctionExpressionInvocation;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.IndexExpression;
import com.google.dart.engine.ast.InstanceCreationExpression;
import com.google.dart.engine.ast.IntegerLiteral;
import com.google.dart.engine.ast.IsExpression;
import com.google.dart.engine.ast.ListLiteral;
import com.google.dart.engine.ast.MapLiteral;
import com.google.dart.engine.ast.MapLiteralEntry;
import com.google.dart.engine.ast.MethodInvocation;
import com.google.dart.engine.ast.NamedExpression;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.NullLiteral;
import com.google.dart.engine.ast.ParenthesizedExpression;
import com.google.dart.engine.ast.PostfixExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.PropertyAccess;
import com.google.dart.engine.ast.RethrowExpression;
import com.google.dart.engine.ast.ReturnStatement;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.SimpleStringLiteral;
import com.google.dart.engine.ast.StringInterpolation;
import com.google.dart.engine.ast.SuperExpression;
import com.google.dart.engine.ast.SymbolLiteral;
import com.google.dart.engine.ast.ThisExpression;
import com.google.dart.engine.ast.ThrowExpression;
import com.google.dart.engine.ast.TypeArgumentList;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.visitor.GeneralizingAstVisitor;
import com.google.dart.engine.ast.visitor.SimpleAstVisitor;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.FunctionTypeAliasElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.LocalVariableElement;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.PrefixElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.internal.element.ExecutableElementImpl;
import com.google.dart.engine.internal.resolver.ResolverVisitor;
import com.google.dart.engine.internal.resolver.TypeOverrideManager;
import com.google.dart.engine.internal.resolver.TypePromotionManager;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.internal.type.BottomTypeImpl;
import com.google.dart.engine.internal.type.InterfaceTypeImpl;
import com.google.dart.engine.scanner.TokenType;
import com.google.dart.engine.type.FunctionType;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;
import com.google.dart.engine.type.TypeParameterType;
import com.google.dart.engine.utilities.general.StringUtilities;
import java.util.HashMap;

public class StaticTypeAnalyzer
extends SimpleAstVisitor<Void> {
    private ResolverVisitor resolver;
    private TypeProvider typeProvider;
    private Type dynamicType;
    private InterfaceType thisType;
    private TypeOverrideManager overrideManager;
    private TypePromotionManager promoteManager;
    private HashMap<ExecutableElement, Type> propagatedReturnTypes = new HashMap();
    private static final HashMap<String, String> HTML_ELEMENT_TO_CLASS_MAP = StaticTypeAnalyzer.createHtmlTagToClassMap();

    private static HashMap<String, String> createHtmlTagToClassMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("a", "AnchorElement");
        hashMap.put("area", "AreaElement");
        hashMap.put("br", "BRElement");
        hashMap.put("base", "BaseElement");
        hashMap.put("body", "BodyElement");
        hashMap.put("button", "ButtonElement");
        hashMap.put("canvas", "CanvasElement");
        hashMap.put("content", "ContentElement");
        hashMap.put("dl", "DListElement");
        hashMap.put("datalist", "DataListElement");
        hashMap.put("details", "DetailsElement");
        hashMap.put("div", "DivElement");
        hashMap.put("embed", "EmbedElement");
        hashMap.put("fieldset", "FieldSetElement");
        hashMap.put("form", "FormElement");
        hashMap.put("hr", "HRElement");
        hashMap.put("head", "HeadElement");
        hashMap.put("h1", "HeadingElement");
        hashMap.put("h2", "HeadingElement");
        hashMap.put("h3", "HeadingElement");
        hashMap.put("h4", "HeadingElement");
        hashMap.put("h5", "HeadingElement");
        hashMap.put("h6", "HeadingElement");
        hashMap.put("html", "HtmlElement");
        hashMap.put("iframe", "IFrameElement");
        hashMap.put("img", "ImageElement");
        hashMap.put("input", "InputElement");
        hashMap.put("keygen", "KeygenElement");
        hashMap.put("li", "LIElement");
        hashMap.put("label", "LabelElement");
        hashMap.put("legend", "LegendElement");
        hashMap.put("link", "LinkElement");
        hashMap.put("map", "MapElement");
        hashMap.put("menu", "MenuElement");
        hashMap.put("meter", "MeterElement");
        hashMap.put("ol", "OListElement");
        hashMap.put("object", "ObjectElement");
        hashMap.put("optgroup", "OptGroupElement");
        hashMap.put("output", "OutputElement");
        hashMap.put("p", "ParagraphElement");
        hashMap.put("param", "ParamElement");
        hashMap.put("pre", "PreElement");
        hashMap.put("progress", "ProgressElement");
        hashMap.put("script", "ScriptElement");
        hashMap.put("select", "SelectElement");
        hashMap.put("source", "SourceElement");
        hashMap.put("span", "SpanElement");
        hashMap.put("style", "StyleElement");
        hashMap.put("caption", "TableCaptionElement");
        hashMap.put("td", "TableCellElement");
        hashMap.put("col", "TableColElement");
        hashMap.put("table", "TableElement");
        hashMap.put("tr", "TableRowElement");
        hashMap.put("textarea", "TextAreaElement");
        hashMap.put("title", "TitleElement");
        hashMap.put("track", "TrackElement");
        hashMap.put("ul", "UListElement");
        hashMap.put("video", "VideoElement");
        return hashMap;
    }

    public StaticTypeAnalyzer(ResolverVisitor resolverVisitor) {
        this.resolver = resolverVisitor;
        this.typeProvider = resolverVisitor.getTypeProvider();
        this.dynamicType = this.typeProvider.getDynamicType();
        this.overrideManager = resolverVisitor.getOverrideManager();
        this.promoteManager = resolverVisitor.getPromoteManager();
    }

    public void setThisType(InterfaceType interfaceType) {
        this.thisType = interfaceType;
    }

    @Override
    public Void visitAdjacentStrings(AdjacentStrings adjacentStrings) {
        this.recordStaticType(adjacentStrings, this.typeProvider.getStringType());
        return null;
    }

    @Override
    public Void visitArgumentDefinitionTest(ArgumentDefinitionTest argumentDefinitionTest) {
        this.recordStaticType(argumentDefinitionTest, this.typeProvider.getBoolType());
        return null;
    }

    @Override
    public Void visitAsExpression(AsExpression asExpression) {
        this.recordStaticType(asExpression, this.getType(asExpression.getType()));
        return null;
    }

    @Override
    public Void visitAssignmentExpression(AssignmentExpression assignmentExpression) {
        TokenType tokenType = assignmentExpression.getOperator().getType();
        if (tokenType == TokenType.EQ) {
            Expression expression = assignmentExpression.getRightHandSide();
            Type type = this.getStaticType(expression);
            this.recordStaticType(assignmentExpression, type);
            Type type2 = type;
            Type type3 = expression.getPropagatedType();
            if (type3 != null) {
                if (type3.isMoreSpecificThan(type)) {
                    this.recordPropagatedType(assignmentExpression, type3);
                }
                type2 = type3;
            }
            this.resolver.overrideExpression(assignmentExpression.getLeftHandSide(), type2);
        } else {
            Type type;
            MethodElement methodElement = assignmentExpression.getStaticElement();
            Type type4 = this.computeStaticReturnType(methodElement);
            this.recordStaticType(assignmentExpression, type4);
            MethodElement methodElement2 = assignmentExpression.getPropagatedElement();
            if (methodElement2 != methodElement && (type = this.computeStaticReturnType(methodElement2)) != null && type.isMoreSpecificThan(type4)) {
                this.recordPropagatedType(assignmentExpression, type);
            }
        }
        return null;
    }

    @Override
    public Void visitBinaryExpression(BinaryExpression binaryExpression) {
        Type type;
        MethodElement methodElement = binaryExpression.getStaticElement();
        Type type2 = this.computeStaticReturnType(methodElement);
        type2 = this.refineBinaryExpressionType(binaryExpression, type2);
        this.recordStaticType(binaryExpression, type2);
        MethodElement methodElement2 = binaryExpression.getPropagatedElement();
        if (methodElement2 != methodElement && (type = this.computeStaticReturnType(methodElement2)) != null && type.isMoreSpecificThan(type2)) {
            this.recordPropagatedType(binaryExpression, type);
        }
        return null;
    }

    @Override
    public Void visitBooleanLiteral(BooleanLiteral booleanLiteral) {
        this.recordStaticType(booleanLiteral, this.typeProvider.getBoolType());
        return null;
    }

    @Override
    public Void visitCascadeExpression(CascadeExpression cascadeExpression) {
        this.recordStaticType(cascadeExpression, this.getStaticType(cascadeExpression.getTarget()));
        this.recordPropagatedType(cascadeExpression, cascadeExpression.getTarget().getPropagatedType());
        return null;
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpression conditionalExpression) {
        Type type;
        Type type2 = this.getStaticType(conditionalExpression.getThenExpression());
        Type type3 = this.getStaticType(conditionalExpression.getElseExpression());
        if (type2 == null) {
            type2 = this.dynamicType;
        }
        if (type3 == null) {
            type3 = this.dynamicType;
        }
        if ((type = type2.getLeastUpperBound(type3)) == null) {
            type = this.dynamicType;
        }
        this.recordStaticType(conditionalExpression, type);
        Type type4 = conditionalExpression.getThenExpression().getPropagatedType();
        Type type5 = conditionalExpression.getElseExpression().getPropagatedType();
        if (type4 != null || type5 != null) {
            Type type6;
            if (type4 == null) {
                type4 = type2;
            }
            if (type5 == null) {
                type5 = type3;
            }
            if ((type6 = type4.getLeastUpperBound(type5)) != null && type6.isMoreSpecificThan(type)) {
                this.recordPropagatedType(conditionalExpression, type6);
            }
        }
        return null;
    }

    @Override
    public Void visitDoubleLiteral(DoubleLiteral doubleLiteral) {
        this.recordStaticType(doubleLiteral, this.typeProvider.getDoubleType());
        return null;
    }

    @Override
    public Void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        FunctionExpression functionExpression = functionDeclaration.getFunctionExpression();
        ExecutableElementImpl executableElementImpl = (ExecutableElementImpl)functionDeclaration.getElement();
        executableElementImpl.setReturnType(this.computeStaticReturnTypeOfFunctionDeclaration(functionDeclaration));
        this.recordPropagatedTypeOfFunction(executableElementImpl, functionExpression.getBody());
        this.recordStaticType(functionExpression, executableElementImpl.getType());
        return null;
    }

    @Override
    public Void visitFunctionExpression(FunctionExpression functionExpression) {
        if (functionExpression.getParent() instanceof FunctionDeclaration) {
            return null;
        }
        ExecutableElementImpl executableElementImpl = (ExecutableElementImpl)functionExpression.getElement();
        executableElementImpl.setReturnType(this.computeStaticReturnTypeOfFunctionExpression(functionExpression));
        this.recordPropagatedTypeOfFunction(executableElementImpl, functionExpression.getBody());
        this.recordStaticType(functionExpression, functionExpression.getElement().getType());
        return null;
    }

    @Override
    public Void visitFunctionExpressionInvocation(FunctionExpressionInvocation functionExpressionInvocation) {
        ExecutableElement executableElement;
        ExecutableElement executableElement2 = functionExpressionInvocation.getStaticElement();
        Type type = this.computeStaticReturnType(executableElement2);
        this.recordStaticType(functionExpressionInvocation, type);
        Type type2 = this.computePropagatedReturnType(executableElement2);
        if (type2 != null && (type == null || type2.isMoreSpecificThan(type))) {
            this.recordPropagatedType(functionExpressionInvocation, type2);
        }
        if ((executableElement = functionExpressionInvocation.getPropagatedElement()) != executableElement2) {
            Type type3;
            Type type4 = this.computeStaticReturnType(executableElement);
            if (type4 != null && (type == null || type4.isMoreSpecificThan(type)) && (type2 == null || type4.isMoreSpecificThan(type2))) {
                this.recordPropagatedType(functionExpressionInvocation, type4);
            }
            if (!((type3 = this.computePropagatedReturnType(executableElement)) == null || type != null && !type3.isMoreSpecificThan(type) || type2 != null && !type3.isMoreSpecificThan(type2) || type4 != null && !type3.isMoreSpecificThan(type4))) {
                this.recordPropagatedType(functionExpressionInvocation, type3);
            }
        }
        return null;
    }

    @Override
    public Void visitIndexExpression(IndexExpression indexExpression) {
        if (indexExpression.inSetterContext()) {
            Type type;
            MethodElement methodElement = indexExpression.getStaticElement();
            Type type2 = this.computeArgumentType(methodElement);
            this.recordStaticType(indexExpression, type2);
            MethodElement methodElement2 = indexExpression.getPropagatedElement();
            if (methodElement2 != methodElement && (type = this.computeArgumentType(methodElement2)) != null && type.isMoreSpecificThan(type2)) {
                this.recordPropagatedType(indexExpression, type);
            }
        } else {
            Type type;
            MethodElement methodElement = indexExpression.getStaticElement();
            Type type3 = this.computeStaticReturnType(methodElement);
            this.recordStaticType(indexExpression, type3);
            MethodElement methodElement3 = indexExpression.getPropagatedElement();
            if (methodElement3 != methodElement && (type = this.computeStaticReturnType(methodElement3)) != null && type.isMoreSpecificThan(type3)) {
                this.recordPropagatedType(indexExpression, type);
            }
        }
        return null;
    }

    @Override
    public Void visitInstanceCreationExpression(InstanceCreationExpression instanceCreationExpression) {
        LibraryElement libraryElement;
        this.recordStaticType(instanceCreationExpression, instanceCreationExpression.getConstructorName().getType().getType());
        ConstructorElement constructorElement = instanceCreationExpression.getStaticElement();
        if (constructorElement != null && "Element".equals(constructorElement.getEnclosingElement().getName()) && this.isHtmlLibrary(libraryElement = constructorElement.getLibrary())) {
            String string = constructorElement.getName();
            if ("tag".equals(string)) {
                Type type = this.getFirstArgumentAsTypeWithMap(libraryElement, instanceCreationExpression.getArgumentList(), HTML_ELEMENT_TO_CLASS_MAP);
                if (type != null) {
                    this.recordPropagatedType(instanceCreationExpression, type);
                }
            } else {
                Type type = this.getElementNameAsType(libraryElement, string, HTML_ELEMENT_TO_CLASS_MAP);
                if (type != null) {
                    this.recordPropagatedType(instanceCreationExpression, type);
                }
            }
        }
        return null;
    }

    @Override
    public Void visitIntegerLiteral(IntegerLiteral integerLiteral) {
        this.recordStaticType(integerLiteral, this.typeProvider.getIntType());
        return null;
    }

    @Override
    public Void visitIsExpression(IsExpression isExpression) {
        this.recordStaticType(isExpression, this.typeProvider.getBoolType());
        return null;
    }

    @Override
    public Void visitListLiteral(ListLiteral listLiteral) {
        TypeName typeName;
        Type type;
        NodeList<AstNode> nodeList;
        Type type2 = this.dynamicType;
        TypeArgumentList typeArgumentList = listLiteral.getTypeArguments();
        if (typeArgumentList != null && (nodeList = typeArgumentList.getArguments()) != null && nodeList.size() == 1 && (type = this.getType(typeName = (TypeName)nodeList.get(0))) != null) {
            type2 = type;
        }
        this.recordStaticType(listLiteral, this.typeProvider.getListType().substitute(new Type[]{type2}));
        nodeList = listLiteral.getElements();
        int n = nodeList.size();
        if (n > 0) {
            type = ((Expression)nodeList.get(0)).getBestType();
            for (int i = 1; i < n; ++i) {
                Type type3 = ((Expression)nodeList.get(i)).getBestType();
                if (!type.equals(type3)) {
                    type = this.dynamicType;
                    continue;
                }
                if ((type = type.getLeastUpperBound(type3)) != null) continue;
                type = this.dynamicType;
            }
            if (type.isMoreSpecificThan(type2)) {
                this.recordPropagatedType(listLiteral, this.typeProvider.getListType().substitute(new Type[]{type}));
            }
        }
        return null;
    }

    @Override
    public Void visitMapLiteral(MapLiteral mapLiteral) {
        Object object;
        Type type;
        Object object2;
        NodeList<AstNode> nodeList;
        Type type2 = this.dynamicType;
        Type type3 = this.dynamicType;
        TypeArgumentList typeArgumentList = mapLiteral.getTypeArguments();
        if (typeArgumentList != null && (nodeList = typeArgumentList.getArguments()) != null && nodeList.size() == 2) {
            TypeName typeName = (TypeName)nodeList.get(0);
            object2 = this.getType(typeName);
            if (object2 != null) {
                type2 = object2;
            }
            if ((type = this.getType((TypeName)(object = (TypeName)nodeList.get(1)))) != null) {
                type3 = type;
            }
        }
        this.recordStaticType(mapLiteral, this.typeProvider.getMapType().substitute(new Type[]{type2, type3}));
        nodeList = mapLiteral.getEntries();
        int n = nodeList.size();
        if (n > 0) {
            boolean bl;
            int n2;
            object2 = (MapLiteralEntry)nodeList.get(0);
            object = ((MapLiteralEntry)object2).getKey().getBestType();
            type = ((MapLiteralEntry)object2).getValue().getBestType();
            for (n2 = 1; n2 < n; ++n2) {
                object2 = (MapLiteralEntry)nodeList.get(n2);
                Type type4 = ((MapLiteralEntry)object2).getKey().getBestType();
                if (!object.equals(type4)) {
                    object = this.dynamicType;
                } else if ((object = object.getLeastUpperBound(type4)) == null) {
                    object = this.dynamicType;
                }
                Type type5 = ((MapLiteralEntry)object2).getValue().getBestType();
                if (!type.equals(type5)) {
                    type = this.dynamicType;
                    continue;
                }
                if ((type = type.getLeastUpperBound(type5)) != null) continue;
                type = this.dynamicType;
            }
            n2 = object != null && object.isMoreSpecificThan(type2) ? 1 : 0;
            boolean bl2 = bl = type != null && type.isMoreSpecificThan(type3);
            if (n2 != 0 || bl) {
                if (n2 == 0) {
                    object = type2;
                }
                if (!bl) {
                    type = type3;
                }
                this.recordPropagatedType(mapLiteral, this.typeProvider.getMapType().substitute(new Type[]{object, type}));
            }
        }
        return null;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocation methodInvocation) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Type type;
        Object object6;
        SimpleIdentifier simpleIdentifier = methodInvocation.getMethodName();
        Element element = simpleIdentifier.getStaticElement();
        if (element instanceof LocalVariableElement) {
            object6 = (LocalVariableElement)element;
            type = object6.getType();
            this.recordStaticType(simpleIdentifier, type);
            object5 = this.overrideManager.getType((Element)object6);
            if (object5 != null && object5.isMoreSpecificThan(type)) {
                this.recordPropagatedType(simpleIdentifier, (Type)object5);
            }
        }
        object6 = this.computeStaticReturnType(element);
        this.recordStaticType(methodInvocation, (Type)object6);
        type = this.computePropagatedReturnType(element);
        if (type != null && (object6 == null || type.isMoreSpecificThan((Type)object6))) {
            this.recordPropagatedType(methodInvocation, type);
        }
        if (((String)(object5 = simpleIdentifier.getName())).equals("then")) {
            FunctionExpression functionExpression;
            Type type2;
            object4 = methodInvocation.getRealTarget();
            Object object7 = object3 = object4 == null ? null : ((Expression)object4).getBestType();
            if (this.isAsyncFutureType((Type)object3) && ((NodeList)(object2 = methodInvocation.getArgumentList().getArguments())).size() == 1 && (object = (Expression)((NodeList)object2).get(0)) instanceof FunctionExpression && (type2 = this.computePropagatedReturnType((functionExpression = (FunctionExpression)object).getElement())) != null) {
                InterfaceTypeImpl interfaceTypeImpl;
                if (this.isAsyncFutureType(type2)) {
                    interfaceTypeImpl = (InterfaceTypeImpl)type2;
                } else {
                    InterfaceType interfaceType = (InterfaceType)object3;
                    interfaceTypeImpl = new InterfaceTypeImpl(interfaceType.getElement());
                    interfaceTypeImpl.setTypeArguments(new Type[]{type2});
                }
                this.recordPropagatedType(methodInvocation, interfaceTypeImpl);
                return null;
            }
        }
        if (((String)object5).equals("$dom_createEvent")) {
            object4 = methodInvocation.getRealTarget();
            if (object4 != null && (object3 = ((Expression)object4).getBestType()) instanceof InterfaceType && (object3.getName().equals("HtmlDocument") || object3.getName().equals("Document")) && this.isHtmlLibrary((LibraryElement)(object2 = object3.getElement().getLibrary())) && (object = this.getFirstArgumentAsType((LibraryElement)object2, methodInvocation.getArgumentList())) != null) {
                this.recordPropagatedType(methodInvocation, (Type)object);
            }
        } else if (((String)object5).equals("query")) {
            object4 = methodInvocation.getRealTarget();
            if (object4 == null) {
                object3 = simpleIdentifier.getBestElement();
                if (object3 != null && this.isHtmlLibrary((LibraryElement)(object2 = object3.getLibrary())) && (object = this.getFirstArgumentAsQuery((LibraryElement)object2, methodInvocation.getArgumentList())) != null) {
                    this.recordPropagatedType(methodInvocation, (Type)object);
                }
            } else {
                object3 = ((Expression)object4).getBestType();
                if (object3 instanceof InterfaceType && (object3.getName().equals("HtmlDocument") || object3.getName().equals("Document")) && this.isHtmlLibrary((LibraryElement)(object2 = object3.getElement().getLibrary())) && (object = this.getFirstArgumentAsQuery((LibraryElement)object2, methodInvocation.getArgumentList())) != null) {
                    this.recordPropagatedType(methodInvocation, (Type)object);
                }
            }
        } else if (((String)object5).equals("$dom_createElement")) {
            object4 = methodInvocation.getRealTarget();
            object3 = ((Expression)object4).getBestType();
            if (object3 instanceof InterfaceType && (object3.getName().equals("HtmlDocument") || object3.getName().equals("Document")) && this.isHtmlLibrary((LibraryElement)(object2 = object3.getElement().getLibrary())) && (object = this.getFirstArgumentAsQuery((LibraryElement)object2, methodInvocation.getArgumentList())) != null) {
                this.recordPropagatedType(methodInvocation, (Type)object);
            }
        } else if (((String)object5).equals("JS")) {
            object4 = this.getFirstArgumentAsType(this.typeProvider.getObjectType().getElement().getLibrary(), methodInvocation.getArgumentList());
            if (object4 != null) {
                this.recordPropagatedType(methodInvocation, (Type)object4);
            }
        } else {
            object4 = simpleIdentifier.getPropagatedElement();
            if (object4 != element) {
                object3 = this.computeStaticReturnType((Element)object4);
                if (object3 != null && (object6 == null || object3.isMoreSpecificThan((Type)object6)) && (type == null || object3.isMoreSpecificThan(type))) {
                    this.recordPropagatedType(methodInvocation, (Type)object3);
                }
                if (!((object2 = this.computePropagatedReturnType((Element)object4)) == null || object6 != null && !object2.isMoreSpecificThan((Type)object6) || type != null && !object2.isMoreSpecificThan(type) || object3 != null && !object2.isMoreSpecificThan((Type)object3))) {
                    this.recordPropagatedType(methodInvocation, (Type)object2);
                }
            }
        }
        return null;
    }

    @Override
    public Void visitNamedExpression(NamedExpression namedExpression) {
        Expression expression = namedExpression.getExpression();
        this.recordStaticType(namedExpression, this.getStaticType(expression));
        this.recordPropagatedType(namedExpression, expression.getPropagatedType());
        return null;
    }

    @Override
    public Void visitNullLiteral(NullLiteral nullLiteral) {
        this.recordStaticType(nullLiteral, this.typeProvider.getBottomType());
        return null;
    }

    @Override
    public Void visitParenthesizedExpression(ParenthesizedExpression parenthesizedExpression) {
        Expression expression = parenthesizedExpression.getExpression();
        this.recordStaticType(parenthesizedExpression, this.getStaticType(expression));
        this.recordPropagatedType(parenthesizedExpression, expression.getPropagatedType());
        return null;
    }

    @Override
    public Void visitPostfixExpression(PostfixExpression postfixExpression) {
        Expression expression = postfixExpression.getOperand();
        Type type = this.getStaticType(expression);
        TokenType tokenType = postfixExpression.getOperator().getType();
        if (tokenType == TokenType.MINUS_MINUS || tokenType == TokenType.PLUS_PLUS) {
            InterfaceType interfaceType = this.typeProvider.getIntType();
            if (this.getStaticType(postfixExpression.getOperand()) == interfaceType) {
                type = interfaceType;
            }
        }
        this.recordStaticType(postfixExpression, type);
        this.recordPropagatedType(postfixExpression, expression.getPropagatedType());
        return null;
    }

    @Override
    public Void visitPrefixedIdentifier(PrefixedIdentifier prefixedIdentifier) {
        SimpleIdentifier simpleIdentifier = prefixedIdentifier.getIdentifier();
        Element element = simpleIdentifier.getStaticElement();
        Type type = this.dynamicType;
        if (element instanceof ClassElement) {
            type = this.isNotTypeLiteral(prefixedIdentifier) ? ((ClassElement)element).getType() : this.typeProvider.getTypeType();
        } else if (element instanceof FunctionTypeAliasElement) {
            type = this.isNotTypeLiteral(prefixedIdentifier) ? ((FunctionTypeAliasElement)element).getType() : this.typeProvider.getTypeType();
        } else if (element instanceof MethodElement) {
            type = ((MethodElement)element).getType();
        } else if (element instanceof PropertyAccessorElement) {
            type = this.getTypeOfProperty((PropertyAccessorElement)element, prefixedIdentifier.getPrefix().getStaticType());
        } else if (element instanceof ExecutableElement) {
            type = ((ExecutableElement)element).getType();
        } else if (element instanceof TypeParameterElement) {
            type = ((TypeParameterElement)element).getType();
        } else if (element instanceof VariableElement) {
            type = ((VariableElement)element).getType();
        }
        this.recordStaticType(simpleIdentifier, type);
        this.recordStaticType(prefixedIdentifier, type);
        Element element2 = simpleIdentifier.getPropagatedElement();
        Type type2 = null;
        if (element2 instanceof ClassElement) {
            type2 = this.isNotTypeLiteral(prefixedIdentifier) ? ((ClassElement)element2).getType() : this.typeProvider.getTypeType();
        } else if (element2 instanceof FunctionTypeAliasElement) {
            type2 = ((FunctionTypeAliasElement)element2).getType();
        } else if (element2 instanceof MethodElement) {
            type2 = ((MethodElement)element2).getType();
        } else if (element2 instanceof PropertyAccessorElement) {
            type2 = this.getTypeOfProperty((PropertyAccessorElement)element2, prefixedIdentifier.getPrefix().getStaticType());
        } else if (element2 instanceof ExecutableElement) {
            type2 = ((ExecutableElement)element2).getType();
        } else if (element2 instanceof TypeParameterElement) {
            type2 = ((TypeParameterElement)element2).getType();
        } else if (element2 instanceof VariableElement) {
            type2 = ((VariableElement)element2).getType();
        }
        Type type3 = this.overrideManager.getType(element2);
        if (type2 == null || type3 != null && type3.isMoreSpecificThan(type2)) {
            type2 = type3;
        }
        if (type2 != null && type2.isMoreSpecificThan(type)) {
            this.recordPropagatedType(simpleIdentifier, type2);
            this.recordPropagatedType(prefixedIdentifier, type2);
        }
        return null;
    }

    @Override
    public Void visitPrefixExpression(PrefixExpression prefixExpression) {
        TokenType tokenType = prefixExpression.getOperator().getType();
        if (tokenType == TokenType.BANG) {
            this.recordStaticType(prefixExpression, this.typeProvider.getBoolType());
        } else {
            Type type;
            Object object;
            MethodElement methodElement = prefixExpression.getStaticElement();
            Object object2 = this.computeStaticReturnType(methodElement);
            if (tokenType == TokenType.MINUS_MINUS || tokenType == TokenType.PLUS_PLUS) {
                object = this.typeProvider.getIntType();
                if (this.getStaticType(prefixExpression.getOperand()) == object) {
                    object2 = object;
                }
            }
            this.recordStaticType(prefixExpression, (Type)object2);
            object = prefixExpression.getPropagatedElement();
            if (object != methodElement && (type = this.computeStaticReturnType((Element)object)) != null && type.isMoreSpecificThan((Type)object2)) {
                this.recordPropagatedType(prefixExpression, type);
            }
        }
        return null;
    }

    @Override
    public Void visitPropertyAccess(PropertyAccess propertyAccess) {
        Object object;
        SimpleIdentifier simpleIdentifier = propertyAccess.getPropertyName();
        Element element = simpleIdentifier.getStaticElement();
        Type type = this.dynamicType;
        if (element instanceof MethodElement) {
            type = ((MethodElement)element).getType();
        } else if (element instanceof PropertyAccessorElement) {
            object = propertyAccess.getRealTarget();
            type = this.getTypeOfProperty((PropertyAccessorElement)element, object != null ? this.getStaticType((Expression)object) : null);
        }
        this.recordStaticType(simpleIdentifier, type);
        this.recordStaticType(propertyAccess, type);
        object = simpleIdentifier.getPropagatedElement();
        Type type2 = this.overrideManager.getType((Element)object);
        if (object instanceof MethodElement) {
            type2 = ((MethodElement)object).getType();
        } else if (object instanceof PropertyAccessorElement) {
            Expression expression = propertyAccess.getRealTarget();
            type2 = this.getTypeOfProperty((PropertyAccessorElement)object, expression != null ? expression.getBestType() : null);
        }
        if (type2 != null && type2.isMoreSpecificThan(type)) {
            this.recordPropagatedType(simpleIdentifier, type2);
            this.recordPropagatedType(propertyAccess, type2);
        }
        return null;
    }

    @Override
    public Void visitRethrowExpression(RethrowExpression rethrowExpression) {
        this.recordStaticType(rethrowExpression, this.typeProvider.getBottomType());
        return null;
    }

    @Override
    public Void visitSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
        Object object;
        Element element = simpleIdentifier.getStaticElement();
        Type type = this.dynamicType;
        if (element instanceof ClassElement) {
            type = this.isNotTypeLiteral(simpleIdentifier) ? ((ClassElement)element).getType() : this.typeProvider.getTypeType();
        } else if (element instanceof FunctionTypeAliasElement) {
            type = this.isNotTypeLiteral(simpleIdentifier) ? ((FunctionTypeAliasElement)element).getType() : this.typeProvider.getTypeType();
        } else if (element instanceof MethodElement) {
            type = ((MethodElement)element).getType();
        } else if (element instanceof PropertyAccessorElement) {
            type = this.getTypeOfProperty((PropertyAccessorElement)element, null);
        } else if (element instanceof ExecutableElement) {
            type = ((ExecutableElement)element).getType();
        } else if (element instanceof TypeParameterElement) {
            type = ((TypeParameterElement)element).getType();
        } else if (element instanceof VariableElement) {
            object = (VariableElement)element;
            type = this.promoteManager.getStaticType((VariableElement)object);
        } else {
            if (element instanceof PrefixElement) {
                return null;
            }
            type = this.dynamicType;
        }
        this.recordStaticType(simpleIdentifier, type);
        object = this.overrideManager.getType(element);
        if (object != null && object.isMoreSpecificThan(type)) {
            this.recordPropagatedType(simpleIdentifier, (Type)object);
        }
        return null;
    }

    @Override
    public Void visitSimpleStringLiteral(SimpleStringLiteral simpleStringLiteral) {
        this.recordStaticType(simpleStringLiteral, this.typeProvider.getStringType());
        return null;
    }

    @Override
    public Void visitStringInterpolation(StringInterpolation stringInterpolation) {
        this.recordStaticType(stringInterpolation, this.typeProvider.getStringType());
        return null;
    }

    @Override
    public Void visitSuperExpression(SuperExpression superExpression) {
        if (this.thisType == null) {
            this.recordStaticType(superExpression, this.dynamicType);
        } else {
            this.recordStaticType(superExpression, this.thisType);
        }
        return null;
    }

    @Override
    public Void visitSymbolLiteral(SymbolLiteral symbolLiteral) {
        this.recordStaticType(symbolLiteral, this.typeProvider.getSymbolType());
        return null;
    }

    @Override
    public Void visitThisExpression(ThisExpression thisExpression) {
        if (this.thisType == null) {
            this.recordStaticType(thisExpression, this.dynamicType);
        } else {
            this.recordStaticType(thisExpression, this.thisType);
        }
        return null;
    }

    @Override
    public Void visitThrowExpression(ThrowExpression throwExpression) {
        this.recordStaticType(throwExpression, this.typeProvider.getBottomType());
        return null;
    }

    @Override
    public Void visitVariableDeclaration(VariableDeclaration variableDeclaration) {
        Expression expression = variableDeclaration.getInitializer();
        if (expression != null) {
            Type type = expression.getBestType();
            SimpleIdentifier simpleIdentifier = variableDeclaration.getName();
            this.recordPropagatedType(simpleIdentifier, type);
            VariableElement variableElement = (VariableElement)simpleIdentifier.getStaticElement();
            if (variableElement != null) {
                this.resolver.overrideVariable(variableElement, type);
            }
        }
        return null;
    }

    private Type computeArgumentType(ExecutableElement executableElement) {
        ParameterElement[] parameterElementArray;
        if (executableElement != null && (parameterElementArray = executableElement.getParameters()) != null && parameterElementArray.length == 2) {
            return parameterElementArray[1].getType();
        }
        return this.dynamicType;
    }

    private Type computePropagatedReturnType(Element element) {
        if (element instanceof ExecutableElement) {
            return this.propagatedReturnTypes.get(element);
        }
        return null;
    }

    private Type computePropagatedReturnTypeOfFunction(FunctionBody functionBody) {
        if (functionBody instanceof ExpressionFunctionBody) {
            ExpressionFunctionBody expressionFunctionBody = (ExpressionFunctionBody)functionBody;
            return expressionFunctionBody.getExpression().getBestType();
        }
        if (functionBody instanceof BlockFunctionBody) {
            final Type[] typeArray = new Type[]{null};
            functionBody.accept(new GeneralizingAstVisitor<Void>(){

                @Override
                public Void visitExpression(Expression expression) {
                    return null;
                }

                @Override
                public Void visitReturnStatement(ReturnStatement returnStatement) {
                    Expression expression = returnStatement.getExpression();
                    Type type = expression != null ? expression.getBestType() : BottomTypeImpl.getInstance();
                    typeArray[0] = typeArray[0] == null ? type : typeArray[0].getLeastUpperBound(type);
                    return null;
                }
            });
            return typeArray[0];
        }
        return null;
    }

    private Type computeStaticReturnType(Element element) {
        VariableElement variableElement;
        Type type;
        if (element instanceof PropertyAccessorElement) {
            FunctionType functionType = ((PropertyAccessorElement)element).getType();
            if (functionType != null) {
                Type type2;
                Type type3 = functionType.getReturnType();
                if (type3.isDartCoreFunction()) {
                    return this.dynamicType;
                }
                if (type3 instanceof InterfaceType) {
                    MethodElement methodElement = ((InterfaceType)type3).lookUpMethod("call", this.resolver.getDefiningLibrary());
                    if (methodElement != null) {
                        return methodElement.getType().getReturnType();
                    }
                } else if (type3 instanceof FunctionType && (type2 = ((FunctionType)type3).getReturnType()) != null) {
                    return type2;
                }
                if (type3 != null) {
                    return type3;
                }
            }
        } else if (element instanceof ExecutableElement) {
            FunctionType functionType = ((ExecutableElement)element).getType();
            if (functionType != null) {
                return functionType.getReturnType();
            }
        } else if (element instanceof VariableElement && (type = this.promoteManager.getStaticType(variableElement = (VariableElement)element)) instanceof FunctionType) {
            return ((FunctionType)type).getReturnType();
        }
        return this.dynamicType;
    }

    private Type computeStaticReturnTypeOfFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        TypeName typeName = functionDeclaration.getReturnType();
        if (typeName == null) {
            return this.dynamicType;
        }
        return typeName.getType();
    }

    private Type computeStaticReturnTypeOfFunctionExpression(FunctionExpression functionExpression) {
        FunctionBody functionBody = functionExpression.getBody();
        if (functionBody instanceof ExpressionFunctionBody) {
            return this.getStaticType(((ExpressionFunctionBody)functionBody).getExpression());
        }
        return this.dynamicType;
    }

    private Type getElementNameAsType(LibraryElement libraryElement, String string, HashMap<String, String> hashMap) {
        if (string != null) {
            ClassElement classElement;
            if (hashMap != null) {
                string = hashMap.get(string.toLowerCase());
            }
            if ((classElement = libraryElement.getType(string)) != null) {
                return classElement.getType();
            }
        }
        return null;
    }

    private Type getFirstArgumentAsQuery(LibraryElement libraryElement, ArgumentList argumentList) {
        String string = this.getFirstArgumentAsString(argumentList);
        if (string != null) {
            if (StringUtilities.indexOf1(string, 0, 32) >= 0) {
                return null;
            }
            String string2 = string;
            string2 = StringUtilities.substringBeforeChar(string2, 58);
            string2 = StringUtilities.substringBeforeChar(string2, 91);
            string2 = StringUtilities.substringBeforeChar(string2, 46);
            string2 = StringUtilities.substringBeforeChar(string2, 35);
            ClassElement classElement = libraryElement.getType(string2 = HTML_ELEMENT_TO_CLASS_MAP.get(string2.toLowerCase()));
            if (classElement != null) {
                return classElement.getType();
            }
        }
        return null;
    }

    private String getFirstArgumentAsString(ArgumentList argumentList) {
        Expression expression;
        NodeList<Expression> nodeList = argumentList.getArguments();
        if (nodeList.size() > 0 && (expression = (Expression)nodeList.get(0)) instanceof SimpleStringLiteral) {
            return ((SimpleStringLiteral)expression).getValue();
        }
        return null;
    }

    private Type getFirstArgumentAsType(LibraryElement libraryElement, ArgumentList argumentList) {
        return this.getFirstArgumentAsTypeWithMap(libraryElement, argumentList, null);
    }

    private Type getFirstArgumentAsTypeWithMap(LibraryElement libraryElement, ArgumentList argumentList, HashMap<String, String> hashMap) {
        return this.getElementNameAsType(libraryElement, this.getFirstArgumentAsString(argumentList), hashMap);
    }

    private Type getStaticType(Expression expression) {
        Type type = expression.getStaticType();
        if (type == null) {
            return this.dynamicType;
        }
        return type;
    }

    private Type getType(TypeName typeName) {
        Type type = typeName.getType();
        if (type == null) {
            return this.dynamicType;
        }
        return type;
    }

    private Type getTypeOfProperty(PropertyAccessorElement propertyAccessorElement, Type type) {
        FunctionType functionType = propertyAccessorElement.getType();
        if (functionType == null) {
            return this.dynamicType;
        }
        if (propertyAccessorElement.isSetter()) {
            Type[] typeArray = functionType.getNormalParameterTypes();
            if (typeArray != null && typeArray.length > 0) {
                return typeArray[0];
            }
            PropertyAccessorElement propertyAccessorElement2 = propertyAccessorElement.getVariable().getGetter();
            if (propertyAccessorElement2 != null && (functionType = propertyAccessorElement2.getType()) != null) {
                return functionType.getReturnType();
            }
            return this.dynamicType;
        }
        Type type2 = functionType.getReturnType();
        if (type2 instanceof TypeParameterType && type instanceof InterfaceType) {
            TypeParameterElement[] typeParameterElementArray;
            InterfaceType interfaceType = (InterfaceType)type;
            TypeParameterElement[] typeParameterElementArray2 = typeParameterElementArray = interfaceType.getElement() != null ? interfaceType.getElement().getTypeParameters() : null;
            if (typeParameterElementArray != null) {
                for (int i = 0; i < typeParameterElementArray.length; ++i) {
                    TypeParameterElement typeParameterElement = typeParameterElementArray[i];
                    if (!type2.getName().equals(typeParameterElement.getName())) continue;
                    return interfaceType.getTypeArguments()[i];
                }
            }
        }
        return type2;
    }

    private boolean isAsyncFutureType(Type type) {
        return type instanceof InterfaceType && type.getName().equals("Future") && this.isAsyncLibrary(type.getElement().getLibrary());
    }

    private boolean isAsyncLibrary(LibraryElement libraryElement) {
        return libraryElement.getName().equals("dart.async");
    }

    private boolean isHtmlLibrary(LibraryElement libraryElement) {
        return libraryElement != null && "dart.dom.html".equals(libraryElement.getName());
    }

    private boolean isNotTypeLiteral(Identifier identifier) {
        AstNode astNode = identifier.getParent();
        return astNode instanceof TypeName || astNode instanceof PrefixedIdentifier && (astNode.getParent() instanceof TypeName || ((PrefixedIdentifier)astNode).getPrefix() == identifier) || astNode instanceof PropertyAccess && ((PropertyAccess)astNode).getTarget() == identifier || astNode instanceof MethodInvocation && identifier == ((MethodInvocation)astNode).getTarget();
    }

    private void recordPropagatedType(Expression expression, Type type) {
        if (type != null && !type.isDynamic()) {
            expression.setPropagatedType(type);
        }
    }

    private void recordPropagatedTypeOfFunction(ExecutableElement executableElement, FunctionBody functionBody) {
        Type type = this.computePropagatedReturnTypeOfFunction(functionBody);
        if (type == null) {
            return;
        }
        if (type.isBottom()) {
            return;
        }
        Type type2 = executableElement.getReturnType();
        if (!type.isMoreSpecificThan(type2)) {
            return;
        }
        this.propagatedReturnTypes.put(executableElement, type);
    }

    private void recordStaticType(Expression expression, Type type) {
        if (type == null) {
            expression.setStaticType(this.dynamicType);
        } else {
            expression.setStaticType(type);
        }
    }

    private Type refineBinaryExpressionType(BinaryExpression binaryExpression, Type type) {
        TokenType tokenType = binaryExpression.getOperator().getType();
        if (tokenType == TokenType.AMPERSAND_AMPERSAND || tokenType == TokenType.BAR_BAR || tokenType == TokenType.EQ_EQ || tokenType == TokenType.BANG_EQ) {
            return this.typeProvider.getBoolType();
        }
        InterfaceType interfaceType = this.typeProvider.getIntType();
        if (this.getStaticType(binaryExpression.getLeftOperand()).equals(interfaceType)) {
            if (tokenType == TokenType.MINUS || tokenType == TokenType.PERCENT || tokenType == TokenType.PLUS || tokenType == TokenType.STAR) {
                InterfaceType interfaceType2 = this.typeProvider.getDoubleType();
                if (this.getStaticType(binaryExpression.getRightOperand()).equals(interfaceType2)) {
                    return interfaceType2;
                }
            }
            if ((tokenType == TokenType.MINUS || tokenType == TokenType.PERCENT || tokenType == TokenType.PLUS || tokenType == TokenType.STAR || tokenType == TokenType.TILDE_SLASH) && this.getStaticType(binaryExpression.getRightOperand()).equals(interfaceType)) {
                type = interfaceType;
            }
        }
        return type;
    }
}

