/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.Block;
import com.google.dart.engine.ast.CatchClause;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.ClassTypeAlias;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.Declaration;
import com.google.dart.engine.ast.DeclaredIdentifier;
import com.google.dart.engine.ast.DoStatement;
import com.google.dart.engine.ast.FieldDeclaration;
import com.google.dart.engine.ast.ForEachStatement;
import com.google.dart.engine.ast.ForStatement;
import com.google.dart.engine.ast.FormalParameterList;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionDeclarationStatement;
import com.google.dart.engine.ast.FunctionExpression;
import com.google.dart.engine.ast.FunctionTypeAlias;
import com.google.dart.engine.ast.IfStatement;
import com.google.dart.engine.ast.Label;
import com.google.dart.engine.ast.LabeledStatement;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.Statement;
import com.google.dart.engine.ast.SwitchCase;
import com.google.dart.engine.ast.SwitchDefault;
import com.google.dart.engine.ast.SwitchMember;
import com.google.dart.engine.ast.SwitchStatement;
import com.google.dart.engine.ast.TopLevelVariableDeclaration;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.VariableDeclarationStatement;
import com.google.dart.engine.ast.WhileStatement;
import com.google.dart.engine.ast.visitor.UnifyingAstVisitor;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.LabelElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.LocalVariableElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.internal.resolver.Library;
import com.google.dart.engine.internal.resolver.ResolvableLibrary;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.internal.scope.ClassScope;
import com.google.dart.engine.internal.scope.EnclosedScope;
import com.google.dart.engine.internal.scope.FunctionScope;
import com.google.dart.engine.internal.scope.FunctionTypeScope;
import com.google.dart.engine.internal.scope.LabelScope;
import com.google.dart.engine.internal.scope.LibraryScope;
import com.google.dart.engine.internal.scope.Scope;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.source.Source;

public abstract class ScopedVisitor
extends UnifyingAstVisitor<Void> {
    private LibraryElement definingLibrary;
    private Source source;
    private AnalysisErrorListener errorListener;
    private Scope nameScope;
    private TypeProvider typeProvider;
    private LabelScope labelScope;

    public ScopedVisitor(Library library, Source source, TypeProvider typeProvider) {
        this.definingLibrary = library.getLibraryElement();
        this.source = source;
        LibraryScope libraryScope = library.getLibraryScope();
        this.errorListener = libraryScope.getErrorListener();
        this.nameScope = libraryScope;
        this.typeProvider = typeProvider;
    }

    public ScopedVisitor(LibraryElement libraryElement, Source source, TypeProvider typeProvider, AnalysisErrorListener analysisErrorListener) {
        this.definingLibrary = libraryElement;
        this.source = source;
        this.errorListener = analysisErrorListener;
        this.nameScope = new LibraryScope(libraryElement, analysisErrorListener);
        this.typeProvider = typeProvider;
    }

    public ScopedVisitor(LibraryElement libraryElement, Source source, TypeProvider typeProvider, Scope scope, AnalysisErrorListener analysisErrorListener) {
        this.definingLibrary = libraryElement;
        this.source = source;
        this.errorListener = analysisErrorListener;
        this.nameScope = scope;
        this.typeProvider = typeProvider;
    }

    public ScopedVisitor(ResolvableLibrary resolvableLibrary, Source source, TypeProvider typeProvider) {
        this.definingLibrary = resolvableLibrary.getLibraryElement();
        this.source = source;
        LibraryScope libraryScope = resolvableLibrary.getLibraryScope();
        this.errorListener = libraryScope.getErrorListener();
        this.nameScope = libraryScope;
        this.typeProvider = typeProvider;
    }

    public LibraryElement getDefiningLibrary() {
        return this.definingLibrary;
    }

    public TypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    public Scope popNameScope() {
        this.nameScope = this.nameScope.getEnclosingScope();
        return this.nameScope;
    }

    public Scope pushNameScope() {
        EnclosedScope enclosedScope = new EnclosedScope(this.nameScope);
        this.nameScope = enclosedScope;
        return this.nameScope;
    }

    public void reportError(AnalysisError analysisError) {
        this.errorListener.onError(analysisError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitBlock(Block block) {
        Scope scope = this.nameScope;
        try {
            EnclosedScope enclosedScope = new EnclosedScope(this.nameScope);
            this.hideNamesDefinedInBlock(enclosedScope, block);
            this.nameScope = enclosedScope;
            super.visitBlock(block);
        }
        finally {
            this.nameScope = scope;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitCatchClause(CatchClause catchClause) {
        SimpleIdentifier simpleIdentifier = catchClause.getExceptionParameter();
        if (simpleIdentifier != null) {
            Scope scope = this.nameScope;
            try {
                this.nameScope = new EnclosedScope(this.nameScope);
                this.nameScope.define(simpleIdentifier.getStaticElement());
                SimpleIdentifier simpleIdentifier2 = catchClause.getStackTraceParameter();
                if (simpleIdentifier2 != null) {
                    this.nameScope.define(simpleIdentifier2.getStaticElement());
                }
                super.visitCatchClause(catchClause);
            }
            finally {
                this.nameScope = scope;
            }
        } else {
            super.visitCatchClause(catchClause);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitClassDeclaration(ClassDeclaration classDeclaration) {
        ClassElement classElement = classDeclaration.getElement();
        Scope scope = this.nameScope;
        try {
            if (classElement == null) {
                AnalysisEngine.getInstance().getLogger().logInformation("Missing element for constructor " + classDeclaration.getName().getName() + " in " + this.getDefiningLibrary().getSource().getFullName(), new Exception());
            } else {
                this.nameScope = new ClassScope(this.nameScope, classElement);
            }
            this.visitClassDeclarationInScope(classDeclaration);
        }
        finally {
            this.nameScope = scope;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitClassTypeAlias(ClassTypeAlias classTypeAlias) {
        Scope scope = this.nameScope;
        try {
            this.nameScope = new ClassScope(this.nameScope, classTypeAlias.getElement());
            super.visitClassTypeAlias(classTypeAlias);
        }
        finally {
            this.nameScope = scope;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
        ConstructorElement constructorElement = constructorDeclaration.getElement();
        Scope scope = this.nameScope;
        try {
            if (constructorElement == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Missing element for constructor ");
                stringBuilder.append(constructorDeclaration.getReturnType().getName());
                if (constructorDeclaration.getName() != null) {
                    stringBuilder.append(".");
                    stringBuilder.append(constructorDeclaration.getName().getName());
                }
                stringBuilder.append(" in ");
                stringBuilder.append(this.getDefiningLibrary().getSource().getFullName());
                AnalysisEngine.getInstance().getLogger().logInformation(stringBuilder.toString(), new Exception());
            } else {
                this.nameScope = new FunctionScope(this.nameScope, constructorElement);
            }
            super.visitConstructorDeclaration(constructorDeclaration);
        }
        finally {
            this.nameScope = scope;
        }
        return null;
    }

    @Override
    public Void visitDeclaredIdentifier(DeclaredIdentifier declaredIdentifier) {
        LocalVariableElement localVariableElement = declaredIdentifier.getElement();
        if (localVariableElement != null) {
            this.nameScope.define(localVariableElement);
        }
        super.visitDeclaredIdentifier(declaredIdentifier);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitDoStatement(DoStatement doStatement) {
        LabelScope labelScope = this.labelScope;
        try {
            this.labelScope = new LabelScope(this.labelScope, false, false);
            this.visitStatementInScope(doStatement.getBody());
            this.safelyVisit(doStatement.getCondition());
        }
        finally {
            this.labelScope = labelScope;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitForEachStatement(ForEachStatement forEachStatement) {
        Scope scope = this.nameScope;
        LabelScope labelScope = this.labelScope;
        try {
            this.nameScope = new EnclosedScope(this.nameScope);
            this.labelScope = new LabelScope(labelScope, false, false);
            this.visitForEachStatementInScope(forEachStatement);
        }
        finally {
            this.labelScope = labelScope;
            this.nameScope = scope;
        }
        return null;
    }

    @Override
    public Void visitFormalParameterList(FormalParameterList formalParameterList) {
        super.visitFormalParameterList(formalParameterList);
        if (this.nameScope instanceof FunctionScope) {
            ((FunctionScope)this.nameScope).defineParameters();
        }
        if (this.nameScope instanceof FunctionTypeScope) {
            ((FunctionTypeScope)this.nameScope).defineParameters();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitForStatement(ForStatement forStatement) {
        Scope scope = this.nameScope;
        LabelScope labelScope = this.labelScope;
        try {
            this.nameScope = new EnclosedScope(this.nameScope);
            this.labelScope = new LabelScope(labelScope, false, false);
            this.visitForStatementInScope(forStatement);
        }
        finally {
            this.labelScope = labelScope;
            this.nameScope = scope;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        ExecutableElement executableElement = functionDeclaration.getElement();
        Scope scope = this.nameScope;
        try {
            if (executableElement == null) {
                AnalysisEngine.getInstance().getLogger().logInformation("Missing element for top-level function " + functionDeclaration.getName().getName() + " in " + this.getDefiningLibrary().getSource().getFullName(), new Exception());
            } else {
                this.nameScope = new FunctionScope(this.nameScope, executableElement);
            }
            super.visitFunctionDeclaration(functionDeclaration);
        }
        finally {
            this.nameScope = scope;
        }
        if (!(executableElement.getEnclosingElement() instanceof CompilationUnitElement)) {
            this.nameScope.define(executableElement);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionExpression(FunctionExpression functionExpression) {
        if (functionExpression.getParent() instanceof FunctionDeclaration) {
            super.visitFunctionExpression(functionExpression);
        } else {
            Scope scope = this.nameScope;
            try {
                ExecutableElement executableElement = functionExpression.getElement();
                if (executableElement == null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Missing element for function ");
                    for (AstNode astNode = functionExpression.getParent(); astNode != null; astNode = astNode.getParent()) {
                        if (!(astNode instanceof Declaration)) continue;
                        Element element = ((Declaration)astNode).getElement();
                        stringBuilder.append(element == null ? "<unknown> " : element.getName() + " ");
                    }
                    stringBuilder.append("in ");
                    stringBuilder.append(this.getDefiningLibrary().getSource().getFullName());
                    AnalysisEngine.getInstance().getLogger().logInformation(stringBuilder.toString(), new Exception());
                } else {
                    this.nameScope = new FunctionScope(this.nameScope, executableElement);
                }
                super.visitFunctionExpression(functionExpression);
            }
            finally {
                this.nameScope = scope;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionTypeAlias(FunctionTypeAlias functionTypeAlias) {
        Scope scope = this.nameScope;
        try {
            this.nameScope = new FunctionTypeScope(this.nameScope, functionTypeAlias.getElement());
            super.visitFunctionTypeAlias(functionTypeAlias);
        }
        finally {
            this.nameScope = scope;
        }
        return null;
    }

    @Override
    public Void visitIfStatement(IfStatement ifStatement) {
        this.safelyVisit(ifStatement.getCondition());
        this.visitStatementInScope(ifStatement.getThenStatement());
        this.visitStatementInScope(ifStatement.getElseStatement());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitLabeledStatement(LabeledStatement labeledStatement) {
        LabelScope labelScope = this.addScopesFor(labeledStatement.getLabels());
        try {
            super.visitLabeledStatement(labeledStatement);
        }
        finally {
            this.labelScope = labelScope;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        Scope scope = this.nameScope;
        try {
            ExecutableElement executableElement = methodDeclaration.getElement();
            if (executableElement == null) {
                AnalysisEngine.getInstance().getLogger().logInformation("Missing element for method " + methodDeclaration.getName().getName() + " in " + this.getDefiningLibrary().getSource().getFullName(), new Exception());
            } else {
                this.nameScope = new FunctionScope(this.nameScope, executableElement);
            }
            super.visitMethodDeclaration(methodDeclaration);
        }
        finally {
            this.nameScope = scope;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitSwitchCase(SwitchCase switchCase) {
        switchCase.getExpression().accept(this);
        Scope scope = this.nameScope;
        try {
            this.nameScope = new EnclosedScope(this.nameScope);
            switchCase.getStatements().accept(this);
        }
        finally {
            this.nameScope = scope;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitSwitchDefault(SwitchDefault switchDefault) {
        Scope scope = this.nameScope;
        try {
            this.nameScope = new EnclosedScope(this.nameScope);
            switchDefault.getStatements().accept(this);
        }
        finally {
            this.nameScope = scope;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitSwitchStatement(SwitchStatement switchStatement) {
        LabelScope labelScope = this.labelScope;
        try {
            this.labelScope = new LabelScope(labelScope, true, false);
            for (SwitchMember switchMember : switchStatement.getMembers()) {
                for (Label label : switchMember.getLabels()) {
                    SimpleIdentifier simpleIdentifier = label.getLabel();
                    LabelElement labelElement = (LabelElement)simpleIdentifier.getStaticElement();
                    this.labelScope = new LabelScope(this.labelScope, simpleIdentifier.getName(), labelElement);
                }
            }
            super.visitSwitchStatement(switchStatement);
        }
        finally {
            this.labelScope = labelScope;
        }
        return null;
    }

    @Override
    public Void visitVariableDeclaration(VariableDeclaration variableDeclaration) {
        VariableElement variableElement;
        super.visitVariableDeclaration(variableDeclaration);
        if (!(variableDeclaration.getParent().getParent() instanceof TopLevelVariableDeclaration) && !(variableDeclaration.getParent().getParent() instanceof FieldDeclaration) && (variableElement = variableDeclaration.getElement()) != null) {
            this.nameScope.define(variableElement);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitWhileStatement(WhileStatement whileStatement) {
        LabelScope labelScope = this.labelScope;
        try {
            this.labelScope = new LabelScope(labelScope, false, false);
            this.safelyVisit(whileStatement.getCondition());
            this.visitStatementInScope(whileStatement.getBody());
        }
        finally {
            this.labelScope = labelScope;
        }
        return null;
    }

    protected LabelScope getLabelScope() {
        return this.labelScope;
    }

    protected Scope getNameScope() {
        return this.nameScope;
    }

    protected Source getSource() {
        return this.source;
    }

    protected void reportErrorForNode(ErrorCode errorCode, AstNode astNode, Object ... objectArray) {
        this.errorListener.onError(new AnalysisError(this.source, astNode.getOffset(), astNode.getLength(), errorCode, objectArray));
    }

    protected void reportErrorForOffset(ErrorCode errorCode, int n, int n2, Object ... objectArray) {
        this.errorListener.onError(new AnalysisError(this.source, n, n2, errorCode, objectArray));
    }

    protected void reportErrorForToken(ErrorCode errorCode, Token token, Object ... objectArray) {
        this.errorListener.onError(new AnalysisError(this.source, token.getOffset(), token.getLength(), errorCode, objectArray));
    }

    protected void safelyVisit(AstNode astNode) {
        if (astNode != null) {
            astNode.accept(this);
        }
    }

    protected void visitClassDeclarationInScope(ClassDeclaration classDeclaration) {
        super.visitClassDeclaration(classDeclaration);
    }

    protected void visitForEachStatementInScope(ForEachStatement forEachStatement) {
        this.safelyVisit(forEachStatement.getIdentifier());
        this.safelyVisit(forEachStatement.getIterator());
        this.safelyVisit(forEachStatement.getLoopVariable());
        this.visitStatementInScope(forEachStatement.getBody());
    }

    protected void visitForStatementInScope(ForStatement forStatement) {
        this.safelyVisit(forStatement.getVariables());
        this.safelyVisit(forStatement.getInitialization());
        this.safelyVisit(forStatement.getCondition());
        forStatement.getUpdaters().accept(this);
        this.visitStatementInScope(forStatement.getBody());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitStatementInScope(Statement statement) {
        if (statement instanceof Block) {
            this.visitBlock((Block)statement);
        } else if (statement != null) {
            Scope scope = this.nameScope;
            try {
                this.nameScope = new EnclosedScope(this.nameScope);
                statement.accept(this);
            }
            finally {
                this.nameScope = scope;
            }
        }
    }

    private LabelScope addScopesFor(NodeList<Label> nodeList) {
        LabelScope labelScope = this.labelScope;
        for (Label label : nodeList) {
            SimpleIdentifier simpleIdentifier = label.getLabel();
            String string = simpleIdentifier.getName();
            LabelElement labelElement = (LabelElement)simpleIdentifier.getStaticElement();
            this.labelScope = new LabelScope(this.labelScope, string, labelElement);
        }
        return labelScope;
    }

    private void hideNamesDefinedInBlock(EnclosedScope enclosedScope, Block block) {
        NodeList<Statement> nodeList = block.getStatements();
        int n = nodeList.size();
        for (int i = 0; i < n; ++i) {
            Statement statement;
            Statement statement2 = (Statement)nodeList.get(i);
            if (statement2 instanceof VariableDeclarationStatement) {
                statement = (VariableDeclarationStatement)statement2;
                NodeList<VariableDeclaration> nodeList2 = ((VariableDeclarationStatement)statement).getVariables().getVariables();
                int n2 = nodeList2.size();
                for (int j = 0; j < n2; ++j) {
                    enclosedScope.hide(((VariableDeclaration)nodeList2.get(j)).getElement());
                }
                continue;
            }
            if (!(statement2 instanceof FunctionDeclarationStatement)) continue;
            statement = (FunctionDeclarationStatement)statement2;
            enclosedScope.hide(((FunctionDeclarationStatement)statement).getFunctionDeclaration().getElement());
        }
    }
}

