/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AsExpression;
import com.google.dart.engine.ast.AssertStatement;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.Block;
import com.google.dart.engine.ast.BlockFunctionBody;
import com.google.dart.engine.ast.BreakStatement;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.CommentReference;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.CompilationUnitMember;
import com.google.dart.engine.ast.ConditionalExpression;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.ConstructorFieldInitializer;
import com.google.dart.engine.ast.ConstructorName;
import com.google.dart.engine.ast.ContinueStatement;
import com.google.dart.engine.ast.DeclaredIdentifier;
import com.google.dart.engine.ast.Directive;
import com.google.dart.engine.ast.DoStatement;
import com.google.dart.engine.ast.EmptyFunctionBody;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.ExpressionFunctionBody;
import com.google.dart.engine.ast.ExpressionStatement;
import com.google.dart.engine.ast.FieldDeclaration;
import com.google.dart.engine.ast.ForEachStatement;
import com.google.dart.engine.ast.ForStatement;
import com.google.dart.engine.ast.FormalParameter;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionExpression;
import com.google.dart.engine.ast.FunctionExpressionInvocation;
import com.google.dart.engine.ast.HideCombinator;
import com.google.dart.engine.ast.IfStatement;
import com.google.dart.engine.ast.IsExpression;
import com.google.dart.engine.ast.Label;
import com.google.dart.engine.ast.LibraryIdentifier;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.MethodInvocation;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.ParenthesizedExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.PropertyAccess;
import com.google.dart.engine.ast.RedirectingConstructorInvocation;
import com.google.dart.engine.ast.RethrowExpression;
import com.google.dart.engine.ast.ReturnStatement;
import com.google.dart.engine.ast.ShowCombinator;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.Statement;
import com.google.dart.engine.ast.SuperConstructorInvocation;
import com.google.dart.engine.ast.SwitchCase;
import com.google.dart.engine.ast.SwitchDefault;
import com.google.dart.engine.ast.ThrowExpression;
import com.google.dart.engine.ast.TopLevelVariableDeclaration;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.ast.WhileStatement;
import com.google.dart.engine.ast.visitor.RecursiveAstVisitor;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.LocalVariableElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.PropertyInducingElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.internal.element.VariableElementImpl;
import com.google.dart.engine.internal.resolver.ElementResolver;
import com.google.dart.engine.internal.resolver.InheritanceManager;
import com.google.dart.engine.internal.resolver.Library;
import com.google.dart.engine.internal.resolver.ProxyConditionalAnalysisError;
import com.google.dart.engine.internal.resolver.ResolvableLibrary;
import com.google.dart.engine.internal.resolver.ScopedVisitor;
import com.google.dart.engine.internal.resolver.StaticTypeAnalyzer;
import com.google.dart.engine.internal.resolver.TypeOverrideManager;
import com.google.dart.engine.internal.resolver.TypePromotionManager;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.internal.scope.Scope;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.scanner.TokenType;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.type.FunctionType;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ResolverVisitor
extends ScopedVisitor {
    private final InheritanceManager inheritanceManager;
    private ElementResolver elementResolver;
    private StaticTypeAnalyzer typeAnalyzer;
    private ClassElement enclosingClass = null;
    private ExecutableElement enclosingFunction = null;
    private Comment commentBeforeFunction = null;
    private TypeOverrideManager overrideManager = new TypeOverrideManager();
    private TypePromotionManager promoteManager = new TypePromotionManager();
    private ArrayList<ProxyConditionalAnalysisError> proxyConditionalAnalysisErrors = new ArrayList();

    public ResolverVisitor(Library library, Source source, TypeProvider typeProvider) {
        super(library, source, typeProvider);
        this.inheritanceManager = library.getInheritanceManager();
        this.elementResolver = new ElementResolver(this);
        this.typeAnalyzer = new StaticTypeAnalyzer(this);
    }

    public ResolverVisitor(LibraryElement libraryElement, Source source, TypeProvider typeProvider, InheritanceManager inheritanceManager, AnalysisErrorListener analysisErrorListener) {
        super(libraryElement, source, typeProvider, analysisErrorListener);
        this.inheritanceManager = inheritanceManager;
        this.elementResolver = new ElementResolver(this);
        this.typeAnalyzer = new StaticTypeAnalyzer(this);
    }

    public ResolverVisitor(LibraryElement libraryElement, Source source, TypeProvider typeProvider, Scope scope, AnalysisErrorListener analysisErrorListener) {
        super(libraryElement, source, typeProvider, scope, analysisErrorListener);
        this.inheritanceManager = new InheritanceManager(libraryElement);
        this.elementResolver = new ElementResolver(this);
        this.typeAnalyzer = new StaticTypeAnalyzer(this);
    }

    public ResolverVisitor(ResolvableLibrary resolvableLibrary, Source source, TypeProvider typeProvider) {
        super(resolvableLibrary, source, typeProvider);
        this.inheritanceManager = resolvableLibrary.getInheritanceManager();
        this.elementResolver = new ElementResolver(this);
        this.typeAnalyzer = new StaticTypeAnalyzer(this);
    }

    public TypeOverrideManager getOverrideManager() {
        return this.overrideManager;
    }

    public TypePromotionManager getPromoteManager() {
        return this.promoteManager;
    }

    public ArrayList<ProxyConditionalAnalysisError> getProxyConditionalAnalysisErrors() {
        return this.proxyConditionalAnalysisErrors;
    }

    @Override
    public Void visitAsExpression(AsExpression asExpression) {
        super.visitAsExpression(asExpression);
        this.overrideExpression(asExpression.getExpression(), asExpression.getType().getType());
        return null;
    }

    @Override
    public Void visitAssertStatement(AssertStatement assertStatement) {
        super.visitAssertStatement(assertStatement);
        this.propagateTrueState(assertStatement.getCondition());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitBinaryExpression(BinaryExpression binaryExpression) {
        TokenType tokenType = binaryExpression.getOperator().getType();
        Expression expression = binaryExpression.getLeftOperand();
        Expression expression2 = binaryExpression.getRightOperand();
        if (tokenType == TokenType.AMPERSAND_AMPERSAND) {
            this.safelyVisit(expression);
            if (expression2 != null) {
                try {
                    this.overrideManager.enterScope();
                    this.promoteManager.enterScope();
                    this.propagateTrueState(expression);
                    this.promoteTypes(expression);
                    this.clearTypePromotionsIfPotentiallyMutatedIn(expression);
                    this.clearTypePromotionsIfPotentiallyMutatedIn(expression2);
                    this.clearTypePromotionsIfAccessedInClosureAndProtentiallyMutated(expression2);
                    expression2.accept(this);
                }
                finally {
                    this.overrideManager.exitScope();
                    this.promoteManager.exitScope();
                }
            }
        } else if (tokenType == TokenType.BAR_BAR) {
            this.safelyVisit(expression);
            if (expression2 != null) {
                try {
                    this.overrideManager.enterScope();
                    this.propagateFalseState(expression);
                    expression2.accept(this);
                }
                finally {
                    this.overrideManager.exitScope();
                }
            }
        } else {
            this.safelyVisit(expression);
            this.safelyVisit(expression2);
        }
        binaryExpression.accept(this.elementResolver);
        binaryExpression.accept(this.typeAnalyzer);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitBlockFunctionBody(BlockFunctionBody blockFunctionBody) {
        this.safelyVisit(this.commentBeforeFunction);
        try {
            this.overrideManager.enterScope();
            super.visitBlockFunctionBody(blockFunctionBody);
        }
        finally {
            this.overrideManager.exitScope();
        }
        return null;
    }

    @Override
    public Void visitBreakStatement(BreakStatement breakStatement) {
        breakStatement.accept(this.elementResolver);
        breakStatement.accept(this.typeAnalyzer);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitClassDeclaration(ClassDeclaration classDeclaration) {
        ClassElement classElement = this.enclosingClass;
        try {
            this.enclosingClass = classDeclaration.getElement();
            this.typeAnalyzer.setThisType(this.enclosingClass == null ? null : this.enclosingClass.getType());
            super.visitClassDeclaration(classDeclaration);
            this.typeAnalyzer.setThisType(classElement == null ? null : classElement.getType());
            this.enclosingClass = classElement;
        }
        catch (Throwable throwable) {
            this.typeAnalyzer.setThisType(classElement == null ? null : classElement.getType());
            this.enclosingClass = classElement;
            throw throwable;
        }
        return null;
    }

    @Override
    public Void visitComment(Comment comment) {
        if ((comment.getParent() instanceof FunctionDeclaration || comment.getParent() instanceof ConstructorDeclaration || comment.getParent() instanceof MethodDeclaration) && comment != this.commentBeforeFunction) {
            this.commentBeforeFunction = comment;
            return null;
        }
        super.visitComment(comment);
        this.commentBeforeFunction = null;
        return null;
    }

    @Override
    public Void visitCommentReference(CommentReference commentReference) {
        commentReference.accept(this.elementResolver);
        commentReference.accept(this.typeAnalyzer);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitCompilationUnit(CompilationUnit compilationUnit) {
        try {
            CompilationUnitMember compilationUnitMember;
            int n;
            this.overrideManager.enterScope();
            NodeList<Directive> nodeList = compilationUnit.getDirectives();
            int n2 = nodeList.size();
            for (int i = 0; i < n2; ++i) {
                ((Directive)nodeList.get(i)).accept(this);
            }
            NodeList<CompilationUnitMember> nodeList2 = compilationUnit.getDeclarations();
            int n3 = nodeList2.size();
            for (n = 0; n < n3; ++n) {
                compilationUnitMember = (CompilationUnitMember)nodeList2.get(n);
                if (compilationUnitMember instanceof ClassDeclaration) continue;
                compilationUnitMember.accept(this);
            }
            for (n = 0; n < n3; ++n) {
                compilationUnitMember = (CompilationUnitMember)nodeList2.get(n);
                if (!(compilationUnitMember instanceof ClassDeclaration)) continue;
                compilationUnitMember.accept(this);
            }
        }
        finally {
            this.overrideManager.exitScope();
        }
        compilationUnit.accept(this.elementResolver);
        compilationUnit.accept(this.typeAnalyzer);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitConditionalExpression(ConditionalExpression conditionalExpression) {
        Expression expression;
        Expression expression2 = conditionalExpression.getCondition();
        this.safelyVisit(expression2);
        Expression expression3 = conditionalExpression.getThenExpression();
        if (expression3 != null) {
            try {
                this.overrideManager.enterScope();
                this.promoteManager.enterScope();
                this.propagateTrueState(expression2);
                this.promoteTypes(expression2);
                this.clearTypePromotionsIfPotentiallyMutatedIn(expression3);
                this.clearTypePromotionsIfAccessedInClosureAndProtentiallyMutated(expression3);
                expression3.accept(this);
            }
            finally {
                this.overrideManager.exitScope();
                this.promoteManager.exitScope();
            }
        }
        if ((expression = conditionalExpression.getElseExpression()) != null) {
            try {
                this.overrideManager.enterScope();
                this.propagateFalseState(expression2);
                expression.accept(this);
            }
            finally {
                this.overrideManager.exitScope();
            }
        }
        conditionalExpression.accept(this.elementResolver);
        conditionalExpression.accept(this.typeAnalyzer);
        boolean bl = this.isAbruptTerminationExpression(expression3);
        boolean bl2 = this.isAbruptTerminationExpression(expression);
        if (bl2 && !bl) {
            this.propagateTrueState(expression2);
            this.propagateState(expression3);
        } else if (bl && !bl2) {
            this.propagateFalseState(expression2);
            this.propagateState(expression);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
        ExecutableElement executableElement = this.enclosingFunction;
        try {
            this.enclosingFunction = constructorDeclaration.getElement();
            super.visitConstructorDeclaration(constructorDeclaration);
        }
        finally {
            this.enclosingFunction = executableElement;
        }
        return null;
    }

    @Override
    public Void visitConstructorFieldInitializer(ConstructorFieldInitializer constructorFieldInitializer) {
        this.safelyVisit(constructorFieldInitializer.getExpression());
        constructorFieldInitializer.accept(this.elementResolver);
        constructorFieldInitializer.accept(this.typeAnalyzer);
        return null;
    }

    @Override
    public Void visitConstructorName(ConstructorName constructorName) {
        constructorName.accept(this.elementResolver);
        constructorName.accept(this.typeAnalyzer);
        return null;
    }

    @Override
    public Void visitContinueStatement(ContinueStatement continueStatement) {
        continueStatement.accept(this.elementResolver);
        continueStatement.accept(this.typeAnalyzer);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitDoStatement(DoStatement doStatement) {
        try {
            this.overrideManager.enterScope();
            super.visitDoStatement(doStatement);
        }
        finally {
            this.overrideManager.exitScope();
        }
        return null;
    }

    @Override
    public Void visitEmptyFunctionBody(EmptyFunctionBody emptyFunctionBody) {
        this.safelyVisit(this.commentBeforeFunction);
        return (Void)super.visitEmptyFunctionBody(emptyFunctionBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitExpressionFunctionBody(ExpressionFunctionBody expressionFunctionBody) {
        this.safelyVisit(this.commentBeforeFunction);
        try {
            this.overrideManager.enterScope();
            super.visitExpressionFunctionBody(expressionFunctionBody);
        }
        finally {
            this.overrideManager.exitScope();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFieldDeclaration(FieldDeclaration fieldDeclaration) {
        try {
            this.overrideManager.enterScope();
            super.visitFieldDeclaration(fieldDeclaration);
        }
        finally {
            HashMap<Element, Type> hashMap = this.overrideManager.captureOverrides(fieldDeclaration.getFields());
            this.overrideManager.exitScope();
            this.overrideManager.applyOverrides(hashMap);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitForEachStatement(ForEachStatement forEachStatement) {
        try {
            this.overrideManager.enterScope();
            super.visitForEachStatement(forEachStatement);
        }
        finally {
            this.overrideManager.exitScope();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitForStatement(ForStatement forStatement) {
        try {
            this.overrideManager.enterScope();
            super.visitForStatement(forStatement);
        }
        finally {
            this.overrideManager.exitScope();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        ExecutableElement executableElement = this.enclosingFunction;
        try {
            SimpleIdentifier simpleIdentifier = functionDeclaration.getName();
            this.enclosingFunction = (ExecutableElement)simpleIdentifier.getStaticElement();
            super.visitFunctionDeclaration(functionDeclaration);
        }
        finally {
            this.enclosingFunction = executableElement;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionExpression(FunctionExpression functionExpression) {
        ExecutableElement executableElement = this.enclosingFunction;
        try {
            this.enclosingFunction = functionExpression.getElement();
            this.overrideManager.enterScope();
            super.visitFunctionExpression(functionExpression);
        }
        finally {
            this.overrideManager.exitScope();
            this.enclosingFunction = executableElement;
        }
        return null;
    }

    @Override
    public Void visitFunctionExpressionInvocation(FunctionExpressionInvocation functionExpressionInvocation) {
        this.safelyVisit(functionExpressionInvocation.getFunction());
        functionExpressionInvocation.accept(this.elementResolver);
        this.inferFunctionExpressionsParametersTypes(functionExpressionInvocation.getArgumentList());
        this.safelyVisit(functionExpressionInvocation.getArgumentList());
        functionExpressionInvocation.accept(this.typeAnalyzer);
        return null;
    }

    @Override
    public Void visitHideCombinator(HideCombinator hideCombinator) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitIfStatement(IfStatement ifStatement) {
        Expression expression = ifStatement.getCondition();
        this.safelyVisit(expression);
        HashMap<Element, Type> hashMap = null;
        Statement statement = ifStatement.getThenStatement();
        if (statement != null) {
            try {
                this.overrideManager.enterScope();
                this.promoteManager.enterScope();
                this.propagateTrueState(expression);
                this.promoteTypes(expression);
                this.clearTypePromotionsIfPotentiallyMutatedIn(statement);
                this.clearTypePromotionsIfAccessedInClosureAndProtentiallyMutated(statement);
                this.visitStatementInScope(statement);
            }
            finally {
                hashMap = this.overrideManager.captureLocalOverrides();
                this.overrideManager.exitScope();
                this.promoteManager.exitScope();
            }
        }
        HashMap<Element, Type> hashMap2 = null;
        Statement statement2 = ifStatement.getElseStatement();
        if (statement2 != null) {
            try {
                this.overrideManager.enterScope();
                this.propagateFalseState(expression);
                this.visitStatementInScope(statement2);
            }
            finally {
                hashMap2 = this.overrideManager.captureLocalOverrides();
                this.overrideManager.exitScope();
            }
        }
        ifStatement.accept(this.elementResolver);
        ifStatement.accept(this.typeAnalyzer);
        boolean bl = this.isAbruptTerminationStatement(statement);
        boolean bl2 = this.isAbruptTerminationStatement(statement2);
        if (bl2 && !bl) {
            this.propagateTrueState(expression);
            if (hashMap != null) {
                this.overrideManager.applyOverrides(hashMap);
            }
        } else if (bl && !bl2) {
            this.propagateFalseState(expression);
            if (hashMap2 != null) {
                this.overrideManager.applyOverrides(hashMap2);
            }
        }
        return null;
    }

    @Override
    public Void visitLabel(Label label) {
        return null;
    }

    @Override
    public Void visitLibraryIdentifier(LibraryIdentifier libraryIdentifier) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        ExecutableElement executableElement = this.enclosingFunction;
        try {
            this.enclosingFunction = methodDeclaration.getElement();
            super.visitMethodDeclaration(methodDeclaration);
        }
        finally {
            this.enclosingFunction = executableElement;
        }
        return null;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocation methodInvocation) {
        this.safelyVisit(methodInvocation.getTarget());
        methodInvocation.accept(this.elementResolver);
        this.inferFunctionExpressionsParametersTypes(methodInvocation.getArgumentList());
        this.safelyVisit(methodInvocation.getArgumentList());
        methodInvocation.accept(this.typeAnalyzer);
        return null;
    }

    @Override
    public Void visitNode(AstNode astNode) {
        astNode.visitChildren(this);
        astNode.accept(this.elementResolver);
        astNode.accept(this.typeAnalyzer);
        return null;
    }

    @Override
    public Void visitPrefixedIdentifier(PrefixedIdentifier prefixedIdentifier) {
        this.safelyVisit(prefixedIdentifier.getPrefix());
        prefixedIdentifier.accept(this.elementResolver);
        prefixedIdentifier.accept(this.typeAnalyzer);
        return null;
    }

    @Override
    public Void visitPropertyAccess(PropertyAccess propertyAccess) {
        this.safelyVisit(propertyAccess.getTarget());
        propertyAccess.accept(this.elementResolver);
        propertyAccess.accept(this.typeAnalyzer);
        return null;
    }

    @Override
    public Void visitRedirectingConstructorInvocation(RedirectingConstructorInvocation redirectingConstructorInvocation) {
        this.safelyVisit(redirectingConstructorInvocation.getArgumentList());
        redirectingConstructorInvocation.accept(this.elementResolver);
        redirectingConstructorInvocation.accept(this.typeAnalyzer);
        return null;
    }

    @Override
    public Void visitShowCombinator(ShowCombinator showCombinator) {
        return null;
    }

    @Override
    public Void visitSuperConstructorInvocation(SuperConstructorInvocation superConstructorInvocation) {
        this.safelyVisit(superConstructorInvocation.getArgumentList());
        superConstructorInvocation.accept(this.elementResolver);
        superConstructorInvocation.accept(this.typeAnalyzer);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitSwitchCase(SwitchCase switchCase) {
        try {
            this.overrideManager.enterScope();
            super.visitSwitchCase(switchCase);
        }
        finally {
            this.overrideManager.exitScope();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitSwitchDefault(SwitchDefault switchDefault) {
        try {
            this.overrideManager.enterScope();
            super.visitSwitchDefault(switchDefault);
        }
        finally {
            this.overrideManager.exitScope();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitTopLevelVariableDeclaration(TopLevelVariableDeclaration topLevelVariableDeclaration) {
        try {
            this.overrideManager.enterScope();
            super.visitTopLevelVariableDeclaration(topLevelVariableDeclaration);
        }
        finally {
            HashMap<Element, Type> hashMap = this.overrideManager.captureOverrides(topLevelVariableDeclaration.getVariables());
            this.overrideManager.exitScope();
            this.overrideManager.applyOverrides(hashMap);
        }
        return null;
    }

    @Override
    public Void visitTypeName(TypeName typeName) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitWhileStatement(WhileStatement whileStatement) {
        Expression expression = whileStatement.getCondition();
        this.safelyVisit(expression);
        Statement statement = whileStatement.getBody();
        if (statement != null) {
            try {
                this.overrideManager.enterScope();
                this.propagateTrueState(expression);
                this.visitStatementInScope(statement);
            }
            finally {
                this.overrideManager.exitScope();
            }
        }
        whileStatement.accept(this.elementResolver);
        whileStatement.accept(this.typeAnalyzer);
        return null;
    }

    protected ClassElement getEnclosingClass() {
        return this.enclosingClass;
    }

    protected ExecutableElement getEnclosingFunction() {
        return this.enclosingFunction;
    }

    protected VariableElement getOverridablePropagatedElement(Expression expression) {
        Element element = null;
        if (expression instanceof SimpleIdentifier) {
            element = ((SimpleIdentifier)expression).getPropagatedElement();
        } else if (expression instanceof PrefixedIdentifier) {
            element = ((PrefixedIdentifier)expression).getPropagatedElement();
        } else if (expression instanceof PropertyAccess) {
            element = ((PropertyAccess)expression).getPropertyName().getPropagatedElement();
        }
        if (element instanceof VariableElement) {
            return (VariableElement)element;
        }
        return null;
    }

    protected VariableElement getOverridableStaticElement(Expression expression) {
        Element element = null;
        if (expression instanceof SimpleIdentifier) {
            element = ((SimpleIdentifier)expression).getStaticElement();
        } else if (expression instanceof PrefixedIdentifier) {
            element = ((PrefixedIdentifier)expression).getStaticElement();
        } else if (expression instanceof PropertyAccess) {
            element = ((PropertyAccess)expression).getPropertyName().getStaticElement();
        }
        if (element instanceof VariableElement) {
            return (VariableElement)element;
        }
        return null;
    }

    protected VariableElement getPromotionStaticElement(Expression expression) {
        while (expression instanceof ParenthesizedExpression) {
            expression = ((ParenthesizedExpression)expression).getExpression();
        }
        if (!(expression instanceof SimpleIdentifier)) {
            return null;
        }
        SimpleIdentifier simpleIdentifier = (SimpleIdentifier)expression;
        Element element = simpleIdentifier.getStaticElement();
        if (!(element instanceof VariableElement)) {
            return null;
        }
        ElementKind elementKind = element.getKind();
        if (elementKind == ElementKind.LOCAL_VARIABLE) {
            return (VariableElement)element;
        }
        if (elementKind == ElementKind.PARAMETER) {
            return (VariableElement)element;
        }
        return null;
    }

    protected void overrideExpression(Expression expression, Type type) {
        VariableElement variableElement = this.getOverridableStaticElement(expression);
        if (variableElement != null) {
            this.overrideVariable(variableElement, type);
        }
        if ((variableElement = this.getOverridablePropagatedElement(expression)) != null) {
            this.overrideVariable(variableElement, type);
        }
    }

    protected void overrideVariable(VariableElement variableElement, Type type) {
        Object object;
        if (type == null || type.isBottom()) {
            return;
        }
        if (variableElement instanceof PropertyInducingElement && !(object = (PropertyInducingElement)variableElement).isConst() && !object.isFinal()) {
            return;
        }
        object = this.getBestType(variableElement);
        if (object == null || !object.isMoreSpecificThan(type)) {
            this.overrideManager.setType(variableElement, type);
        }
    }

    protected void reportProxyConditionalErrorForNode(Element element, ErrorCode errorCode, AstNode astNode, Object ... objectArray) {
        this.proxyConditionalAnalysisErrors.add(new ProxyConditionalAnalysisError(element, new AnalysisError(this.getSource(), astNode.getOffset(), astNode.getLength(), errorCode, objectArray)));
    }

    protected void reportProxyConditionalErrorForOffset(Element element, ErrorCode errorCode, int n, int n2, Object ... objectArray) {
        this.proxyConditionalAnalysisErrors.add(new ProxyConditionalAnalysisError(element, new AnalysisError(this.getSource(), n, n2, errorCode, objectArray)));
    }

    protected void reportProxyConditionalErrorForToken(Element element, ErrorCode errorCode, Token token, Object ... objectArray) {
        this.proxyConditionalAnalysisErrors.add(new ProxyConditionalAnalysisError(element, new AnalysisError(this.getSource(), token.getOffset(), token.getLength(), errorCode, objectArray)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void visitForEachStatementInScope(ForEachStatement forEachStatement) {
        Expression expression = forEachStatement.getIterator();
        this.safelyVisit(expression);
        DeclaredIdentifier declaredIdentifier = forEachStatement.getLoopVariable();
        SimpleIdentifier simpleIdentifier = forEachStatement.getIdentifier();
        this.safelyVisit(declaredIdentifier);
        this.safelyVisit(simpleIdentifier);
        Statement statement = forEachStatement.getBody();
        if (statement != null) {
            try {
                Element element;
                this.overrideManager.enterScope();
                if (declaredIdentifier != null && expression != null) {
                    LocalVariableElement localVariableElement = declaredIdentifier.getElement();
                    if (localVariableElement != null) {
                        Type type = this.getIteratorElementType(expression);
                        this.overrideVariable(localVariableElement, type);
                        this.recordPropagatedType(declaredIdentifier.getIdentifier(), type);
                    }
                } else if (simpleIdentifier != null && expression != null && (element = simpleIdentifier.getStaticElement()) instanceof VariableElement) {
                    Type type = this.getIteratorElementType(expression);
                    this.overrideVariable((VariableElement)element, type);
                    this.recordPropagatedType(simpleIdentifier, type);
                }
                this.visitStatementInScope(statement);
            }
            finally {
                this.overrideManager.exitScope();
            }
        }
        forEachStatement.accept(this.elementResolver);
        forEachStatement.accept(this.typeAnalyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void visitForStatementInScope(ForStatement forStatement) {
        this.safelyVisit(forStatement.getVariables());
        this.safelyVisit(forStatement.getInitialization());
        this.safelyVisit(forStatement.getCondition());
        this.overrideManager.enterScope();
        try {
            this.propagateTrueState(forStatement.getCondition());
            this.visitStatementInScope(forStatement.getBody());
            forStatement.getUpdaters().accept(this);
        }
        finally {
            this.overrideManager.exitScope();
        }
    }

    private void clearTypePromotionsIfAccessedInClosureAndProtentiallyMutated(AstNode astNode) {
        for (Element element : this.promoteManager.getPromotedElements()) {
            if (!((VariableElementImpl)element).isPotentiallyMutatedInScope() || !this.isVariableAccessedInClosure(element, astNode)) continue;
            this.promoteManager.setType(element, null);
        }
    }

    private void clearTypePromotionsIfPotentiallyMutatedIn(AstNode astNode) {
        for (Element element : this.promoteManager.getPromotedElements()) {
            if (!this.isVariablePotentiallyMutatedIn(element, astNode)) continue;
            this.promoteManager.setType(element, null);
        }
    }

    private Type getBestType(Element element) {
        Type type = this.overrideManager.getType(element);
        if (type == null) {
            if (element instanceof LocalVariableElement) {
                type = ((LocalVariableElement)element).getType();
            } else if (element instanceof ParameterElement) {
                type = ((ParameterElement)element).getType();
            }
        }
        return type;
    }

    private Type getIteratorElementType(Expression expression) {
        Type type = expression.getBestType();
        if (type instanceof InterfaceType) {
            InterfaceType interfaceType = (InterfaceType)type;
            FunctionType functionType = this.inheritanceManager.lookupMemberType(interfaceType, "iterator");
            if (functionType == null) {
                return null;
            }
            Type type2 = functionType.getReturnType();
            if (type2 instanceof InterfaceType) {
                InterfaceType interfaceType2 = (InterfaceType)type2;
                FunctionType functionType2 = this.inheritanceManager.lookupMemberType(interfaceType2, "current");
                if (functionType2 == null) {
                    return null;
                }
                return functionType2.getReturnType();
            }
        }
        return null;
    }

    private void inferFunctionExpressionParametersTypes(Expression expression, Type type) {
        FunctionType functionType;
        if (!(expression instanceof FunctionExpression)) {
            return;
        }
        FunctionExpression functionExpression = (FunctionExpression)expression;
        if (!(type instanceof FunctionType)) {
            return;
        }
        FunctionType functionType2 = (FunctionType)type;
        FunctionType functionType3 = functionType = functionExpression.getElement() != null ? functionExpression.getElement().getType() : null;
        if (functionType != null && !functionType2.isMoreSpecificThan(functionType)) {
            return;
        }
        functionExpression.setPropagatedType(functionType2);
        NodeList<FormalParameter> nodeList = functionExpression.getParameters().getParameters();
        ParameterElement[] parameterElementArray = functionType2.getParameters();
        for (int i = 0; i < nodeList.size() && i < parameterElementArray.length; ++i) {
            FormalParameter formalParameter = (FormalParameter)nodeList.get(i);
            ParameterElement parameterElement = formalParameter.getElement();
            Type type2 = this.getBestType(parameterElement);
            Type type3 = parameterElementArray[i].getType();
            if (type2 != null && !type3.isMoreSpecificThan(type2)) continue;
            this.overrideManager.setType(parameterElement, type3);
        }
    }

    private void inferFunctionExpressionsParametersTypes(ArgumentList argumentList) {
        for (Expression expression : argumentList.getArguments()) {
            ParameterElement parameterElement = expression.getPropagatedParameterElement();
            if (parameterElement == null) {
                parameterElement = expression.getStaticParameterElement();
            }
            if (parameterElement == null) continue;
            this.inferFunctionExpressionParametersTypes(expression, parameterElement.getType());
        }
    }

    private boolean isAbruptTerminationExpression(Expression expression) {
        while (expression instanceof ParenthesizedExpression) {
            expression = ((ParenthesizedExpression)expression).getExpression();
        }
        return expression instanceof ThrowExpression || expression instanceof RethrowExpression;
    }

    private boolean isAbruptTerminationStatement(Statement statement) {
        if (statement instanceof ReturnStatement || statement instanceof BreakStatement || statement instanceof ContinueStatement) {
            return true;
        }
        if (statement instanceof ExpressionStatement) {
            return this.isAbruptTerminationExpression(((ExpressionStatement)statement).getExpression());
        }
        if (statement instanceof Block) {
            NodeList<Statement> nodeList = ((Block)statement).getStatements();
            int n = nodeList.size();
            if (n == 0) {
                return false;
            }
            return this.isAbruptTerminationStatement((Statement)nodeList.get(n - 1));
        }
        return false;
    }

    private boolean isVariableAccessedInClosure(final Element element, AstNode astNode) {
        final boolean[] blArray = new boolean[]{false};
        astNode.accept(new RecursiveAstVisitor<Void>(){
            private boolean inClosure = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void visitFunctionExpression(FunctionExpression functionExpression) {
                boolean bl = this.inClosure;
                try {
                    this.inClosure = true;
                    Void void_ = (Void)super.visitFunctionExpression(functionExpression);
                    return void_;
                }
                finally {
                    this.inClosure = bl;
                }
            }

            @Override
            public Void visitSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
                if (blArray[0]) {
                    return null;
                }
                if (this.inClosure && simpleIdentifier.getStaticElement() == element) {
                    blArray[0] = blArray[0] | true;
                }
                return null;
            }
        });
        return blArray[0];
    }

    private boolean isVariablePotentiallyMutatedIn(final Element element, AstNode astNode) {
        final boolean[] blArray = new boolean[]{false};
        astNode.accept(new RecursiveAstVisitor<Void>(){

            @Override
            public Void visitSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
                if (blArray[0]) {
                    return null;
                }
                if (simpleIdentifier.getStaticElement() == element && simpleIdentifier.inSetterContext()) {
                    blArray[0] = blArray[0] | true;
                }
                return null;
            }
        });
        return blArray[0];
    }

    private void promote(Expression expression, Type type) {
        VariableElement variableElement = this.getPromotionStaticElement(expression);
        if (variableElement != null) {
            if (((VariableElementImpl)variableElement).isPotentiallyMutatedInClosure()) {
                return;
            }
            Type type2 = this.promoteManager.getType(variableElement);
            if (type2 == null) {
                type2 = expression.getStaticType();
            }
            if (type2 == null || type2.isDynamic()) {
                return;
            }
            if (type == null || type.isDynamic()) {
                return;
            }
            if (!type.isMoreSpecificThan(type2)) {
                return;
            }
            this.promoteManager.setType(variableElement, type);
        }
    }

    private void promoteTypes(Expression expression) {
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            if (binaryExpression.getOperator().getType() == TokenType.AMPERSAND_AMPERSAND) {
                Expression expression2 = binaryExpression.getLeftOperand();
                Expression expression3 = binaryExpression.getRightOperand();
                this.promoteTypes(expression2);
                this.promoteTypes(expression3);
                this.clearTypePromotionsIfPotentiallyMutatedIn(expression3);
            }
        } else if (expression instanceof IsExpression) {
            IsExpression isExpression = (IsExpression)expression;
            if (isExpression.getNotOperator() == null) {
                this.promote(isExpression.getExpression(), isExpression.getType().getType());
            }
        } else if (expression instanceof ParenthesizedExpression) {
            this.promoteTypes(((ParenthesizedExpression)expression).getExpression());
        }
    }

    private void propagateFalseState(Expression expression) {
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            if (binaryExpression.getOperator().getType() == TokenType.BAR_BAR) {
                this.propagateFalseState(binaryExpression.getLeftOperand());
                this.propagateFalseState(binaryExpression.getRightOperand());
            }
        } else if (expression instanceof IsExpression) {
            IsExpression isExpression = (IsExpression)expression;
            if (isExpression.getNotOperator() != null) {
                this.overrideExpression(isExpression.getExpression(), isExpression.getType().getType());
            }
        } else if (expression instanceof PrefixExpression) {
            PrefixExpression prefixExpression = (PrefixExpression)expression;
            if (prefixExpression.getOperator().getType() == TokenType.BANG) {
                this.propagateTrueState(prefixExpression.getOperand());
            }
        } else if (expression instanceof ParenthesizedExpression) {
            this.propagateFalseState(((ParenthesizedExpression)expression).getExpression());
        }
    }

    private void propagateState(Expression expression) {
    }

    private void propagateTrueState(Expression expression) {
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            if (binaryExpression.getOperator().getType() == TokenType.AMPERSAND_AMPERSAND) {
                this.propagateTrueState(binaryExpression.getLeftOperand());
                this.propagateTrueState(binaryExpression.getRightOperand());
            }
        } else if (expression instanceof IsExpression) {
            IsExpression isExpression = (IsExpression)expression;
            if (isExpression.getNotOperator() == null) {
                this.overrideExpression(isExpression.getExpression(), isExpression.getType().getType());
            }
        } else if (expression instanceof PrefixExpression) {
            PrefixExpression prefixExpression = (PrefixExpression)expression;
            if (prefixExpression.getOperator().getType() == TokenType.BANG) {
                this.propagateFalseState(prefixExpression.getOperand());
            }
        } else if (expression instanceof ParenthesizedExpression) {
            this.propagateTrueState(((ParenthesizedExpression)expression).getExpression());
        }
    }

    private void recordPropagatedType(Expression expression, Type type) {
        if (type != null && !type.isDynamic()) {
            expression.setPropagatedType(type);
        }
    }
}

