/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.internal.context.ResolvableCompilationUnit;
import com.google.dart.engine.internal.element.LibraryElementImpl;
import com.google.dart.engine.internal.resolver.InheritanceManager;
import com.google.dart.engine.internal.scope.LibraryScope;
import com.google.dart.engine.source.Source;
import java.util.HashSet;

public class ResolvableLibrary {
    private Source librarySource;
    private ResolvableLibrary[] importedLibraries = EMPTY_ARRAY;
    private boolean explicitlyImportsCore = false;
    private ResolvableLibrary[] exportedLibraries = EMPTY_ARRAY;
    private ResolvableCompilationUnit[] compilationUnits;
    private LibraryElementImpl libraryElement;
    private AnalysisErrorListener errorListener;
    private InheritanceManager inheritanceManager;
    private static final ResolvableLibrary[] EMPTY_ARRAY = new ResolvableLibrary[0];
    private LibraryScope libraryScope;

    public ResolvableLibrary(Source source) {
        this.librarySource = source;
    }

    public CompilationUnit getAST(Source source) {
        int n = this.compilationUnits.length;
        for (int i = 0; i < n; ++i) {
            if (!((Object)this.compilationUnits[i].getSource()).equals(source)) continue;
            return this.compilationUnits[i].getCompilationUnit();
        }
        return null;
    }

    public CompilationUnit[] getCompilationUnits() throws AnalysisException {
        int n = this.compilationUnits.length;
        CompilationUnit[] compilationUnitArray = new CompilationUnit[n];
        for (int i = 0; i < n; ++i) {
            compilationUnitArray[i] = this.compilationUnits[i].getCompilationUnit();
        }
        return compilationUnitArray;
    }

    public Source[] getCompilationUnitSources() {
        int n = this.compilationUnits.length;
        Source[] sourceArray = new Source[n];
        for (int i = 0; i < n; ++i) {
            sourceArray[i] = this.compilationUnits[i].getSource();
        }
        return sourceArray;
    }

    public CompilationUnit getDefiningCompilationUnit() throws AnalysisException {
        return this.compilationUnits[0].getCompilationUnit();
    }

    public boolean getExplicitlyImportsCore() {
        return this.explicitlyImportsCore;
    }

    public ResolvableLibrary[] getExports() {
        return this.exportedLibraries;
    }

    public ResolvableLibrary[] getImports() {
        return this.importedLibraries;
    }

    public ResolvableLibrary[] getImportsAndExports() {
        HashSet<ResolvableLibrary> hashSet = new HashSet<ResolvableLibrary>(this.importedLibraries.length + this.exportedLibraries.length);
        for (ResolvableLibrary resolvableLibrary : this.importedLibraries) {
            hashSet.add(resolvableLibrary);
        }
        for (ResolvableLibrary resolvableLibrary : this.exportedLibraries) {
            hashSet.add(resolvableLibrary);
        }
        return hashSet.toArray(new ResolvableLibrary[hashSet.size()]);
    }

    public InheritanceManager getInheritanceManager() {
        if (this.inheritanceManager == null) {
            this.inheritanceManager = new InheritanceManager(this.libraryElement);
            return this.inheritanceManager;
        }
        return this.inheritanceManager;
    }

    public LibraryElementImpl getLibraryElement() {
        return this.libraryElement;
    }

    public LibraryScope getLibraryScope() {
        if (this.libraryScope == null) {
            this.libraryScope = new LibraryScope(this.libraryElement, this.errorListener);
        }
        return this.libraryScope;
    }

    public Source getLibrarySource() {
        return this.librarySource;
    }

    public long getModificationTime(Source source) throws AnalysisException {
        int n = this.compilationUnits.length;
        for (int i = 0; i < n; ++i) {
            if (!((Object)source).equals(this.compilationUnits[i].getSource())) continue;
            return this.compilationUnits[i].getModificationTime();
        }
        return -1L;
    }

    public ResolvableCompilationUnit[] getResolvableCompilationUnits() {
        return this.compilationUnits;
    }

    public void setResolvableCompilationUnits(ResolvableCompilationUnit[] resolvableCompilationUnitArray) {
        this.compilationUnits = resolvableCompilationUnitArray;
    }

    public void setErrorListener(AnalysisErrorListener analysisErrorListener) {
        this.errorListener = analysisErrorListener;
    }

    public void setExplicitlyImportsCore(boolean bl) {
        this.explicitlyImportsCore = bl;
    }

    public void setExportedLibraries(ResolvableLibrary[] resolvableLibraryArray) {
        this.exportedLibraries = resolvableLibraryArray;
    }

    public void setImportedLibraries(ResolvableLibrary[] resolvableLibraryArray) {
        this.importedLibraries = resolvableLibraryArray;
    }

    public void setLibraryElement(LibraryElementImpl libraryElementImpl) {
        this.libraryElement = libraryElementImpl;
        if (this.inheritanceManager != null) {
            this.inheritanceManager.setLibraryElement(libraryElementImpl);
        }
    }

    public String toString() {
        return this.librarySource.getShortName();
    }
}

