/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.element.ExecutableElement;

public class MemberMap {
    private int size = 0;
    private String[] keys;
    private ExecutableElement[] values;

    public MemberMap() {
        this(10);
    }

    public MemberMap(int n) {
        this.initArrays(n);
    }

    public MemberMap(MemberMap memberMap) {
        this.initArrays(memberMap.size + 5);
        for (int i = 0; i < memberMap.size; ++i) {
            this.keys[i] = memberMap.keys[i];
            this.values[i] = memberMap.values[i];
        }
        this.size = memberMap.size;
    }

    public ExecutableElement get(String string) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] == null || !this.keys[i].equals(string)) continue;
            return this.values[i];
        }
        return null;
    }

    public String getKey(int n) {
        return this.keys[n];
    }

    public int getSize() {
        return this.size;
    }

    public ExecutableElement getValue(int n) {
        return this.values[n];
    }

    public void put(String string, ExecutableElement executableElement) {
        int n;
        for (n = 0; n < this.size; ++n) {
            if (this.keys[n] == null || !this.keys[n].equals(string)) continue;
            this.values[n] = executableElement;
            return;
        }
        if (this.size == this.keys.length) {
            int n2;
            n = this.size * 2;
            String[] stringArray = new String[n];
            ExecutableElement[] executableElementArray = new ExecutableElement[n];
            for (n2 = 0; n2 < this.size; ++n2) {
                stringArray[n2] = this.keys[n2];
            }
            for (n2 = 0; n2 < this.size; ++n2) {
                executableElementArray[n2] = this.values[n2];
            }
            this.keys = stringArray;
            this.values = executableElementArray;
        }
        this.keys[this.size] = string;
        this.values[this.size] = executableElement;
        ++this.size;
    }

    public void remove(String string) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.keys[i].equals(string)) continue;
            this.keys[i] = null;
            this.values[i] = null;
            return;
        }
    }

    public void setValue(int n, ExecutableElement executableElement) {
        this.values[n] = executableElement;
    }

    private void initArrays(int n) {
        this.keys = new String[n];
        this.values = new ExecutableElement[n];
    }
}

