/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.Combinator;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.Directive;
import com.google.dart.engine.ast.ExportDirective;
import com.google.dart.engine.ast.HideCombinator;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.NamespaceDirective;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.ShowCombinator;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.UriBasedDirective;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExportElement;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.element.ImportElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.NamespaceCombinator;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.internal.builder.AngularCompilationUnitBuilder;
import com.google.dart.engine.internal.constant.ConstantValueComputer;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.PerformanceStatistics;
import com.google.dart.engine.internal.context.RecordingErrorListener;
import com.google.dart.engine.internal.context.ResolvableCompilationUnit;
import com.google.dart.engine.internal.element.ExportElementImpl;
import com.google.dart.engine.internal.element.HideElementCombinatorImpl;
import com.google.dart.engine.internal.element.ImportElementImpl;
import com.google.dart.engine.internal.element.LibraryElementImpl;
import com.google.dart.engine.internal.element.PrefixElementImpl;
import com.google.dart.engine.internal.element.ShowElementCombinatorImpl;
import com.google.dart.engine.internal.element.UriReferencedElementImpl;
import com.google.dart.engine.internal.resolver.LibraryElementBuilder;
import com.google.dart.engine.internal.resolver.ProxyConditionalAnalysisError;
import com.google.dart.engine.internal.resolver.ResolvableLibrary;
import com.google.dart.engine.internal.resolver.ResolverVisitor;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.internal.resolver.TypeProviderImpl;
import com.google.dart.engine.internal.resolver.TypeResolverVisitor;
import com.google.dart.engine.internal.resolver.VariableResolverVisitor;
import com.google.dart.engine.internal.scope.Namespace;
import com.google.dart.engine.internal.scope.NamespaceBuilder;
import com.google.dart.engine.source.DartUriResolver;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.SourceKind;
import com.google.dart.engine.utilities.general.TimeCounter;
import com.google.dart.engine.utilities.instrumentation.Instrumentation;
import com.google.dart.engine.utilities.instrumentation.InstrumentationBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LibraryResolver2 {
    private InternalAnalysisContext analysisContext;
    private RecordingErrorListener errorListener;
    private Source coreLibrarySource;
    private ResolvableLibrary coreLibrary;
    private TypeProvider typeProvider;
    private HashMap<Source, ResolvableLibrary> libraryMap = new HashMap();
    private List<ResolvableLibrary> librariesInCycle;

    public LibraryResolver2(InternalAnalysisContext internalAnalysisContext) {
        this.analysisContext = internalAnalysisContext;
        this.errorListener = new RecordingErrorListener();
        this.coreLibrarySource = internalAnalysisContext.getSourceFactory().forUri("dart:core");
    }

    public InternalAnalysisContext getAnalysisContext() {
        return this.analysisContext;
    }

    public RecordingErrorListener getErrorListener() {
        return this.errorListener;
    }

    public List<ResolvableLibrary> getResolvedLibraries() {
        return this.librariesInCycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryElement resolveLibrary(Source source, List<ResolvableLibrary> list) throws AnalysisException {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("dart.engine.LibraryResolver.resolveLibrary");
        try {
            instrumentationBuilder.data("fullName", source.getFullName());
            this.librariesInCycle = list;
            this.libraryMap = this.buildLibraryMap();
            ResolvableLibrary resolvableLibrary = this.libraryMap.get(source);
            this.coreLibrary = this.libraryMap.get(this.coreLibrarySource);
            instrumentationBuilder.metric("buildLibraryMap", "complete");
            this.buildElementModels();
            instrumentationBuilder.metric("buildElementModels", "complete");
            LibraryElementImpl libraryElementImpl = this.coreLibrary.getLibraryElement();
            if (libraryElementImpl == null) {
                throw new AnalysisException("Could not resolve dart:core");
            }
            this.buildDirectiveModels();
            instrumentationBuilder.metric("buildDirectiveModels", "complete");
            this.typeProvider = new TypeProviderImpl(libraryElementImpl);
            this.buildTypeHierarchies();
            instrumentationBuilder.metric("buildTypeHierarchies", "complete");
            this.resolveReferencesAndTypes();
            instrumentationBuilder.metric("resolveReferencesAndTypes", "complete");
            this.performConstantEvaluation();
            instrumentationBuilder.metric("performConstantEvaluation", "complete");
            instrumentationBuilder.metric("librariesInCycles", list.size());
            for (ResolvableLibrary resolvableLibrary2 : list) {
                instrumentationBuilder.metric("librariesInCycles-CompilationUnitSources-Size", resolvableLibrary2.getCompilationUnitSources().length);
            }
            LibraryElementImpl libraryElementImpl2 = resolvableLibrary.getLibraryElement();
            return libraryElementImpl2;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    private NamespaceCombinator[] buildCombinators(NamespaceDirective namespaceDirective) {
        ArrayList<NamespaceCombinator> arrayList = new ArrayList<NamespaceCombinator>();
        for (Combinator combinator : namespaceDirective.getCombinators()) {
            NamespaceCombinator namespaceCombinator;
            if (combinator instanceof HideCombinator) {
                namespaceCombinator = new HideElementCombinatorImpl();
                ((HideElementCombinatorImpl)namespaceCombinator).setHiddenNames(this.getIdentifiers(((HideCombinator)combinator).getHiddenNames()));
                arrayList.add(namespaceCombinator);
                continue;
            }
            namespaceCombinator = new ShowElementCombinatorImpl();
            ((ShowElementCombinatorImpl)namespaceCombinator).setOffset(combinator.getOffset());
            ((ShowElementCombinatorImpl)namespaceCombinator).setEnd(combinator.getEnd());
            ((ShowElementCombinatorImpl)namespaceCombinator).setShownNames(this.getIdentifiers(((ShowCombinator)combinator).getShownNames()));
            arrayList.add(namespaceCombinator);
        }
        return arrayList.toArray(new NamespaceCombinator[arrayList.size()]);
    }

    private void buildDirectiveModels() throws AnalysisException {
        for (ResolvableLibrary resolvableLibrary : this.librariesInCycle) {
            Object object;
            Object object2;
            HashMap<String, PrefixElementImpl> hashMap = new HashMap<String, PrefixElementImpl>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (Directive directive : resolvableLibrary.getDefiningCompilationUnit().getDirectives()) {
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                if (directive instanceof ImportDirective) {
                    SimpleIdentifier simpleIdentifier;
                    object2 = (ImportDirective)directive;
                    object = ((UriBasedDirective)object2).getUriContent();
                    if (DartUriResolver.isDartExtUri((String)object)) {
                        resolvableLibrary.getLibraryElement().setHasExtUri(true);
                    }
                    if ((object6 = ((UriBasedDirective)object2).getSource()) == null || !this.analysisContext.exists((Source)object6) || (object5 = this.libraryMap.get(object6)) == null) continue;
                    object4 = new ImportElementImpl(directive.getOffset());
                    object3 = ((UriBasedDirective)object2).getUri();
                    if (object3 != null) {
                        ((UriReferencedElementImpl)object4).setUriOffset(((AstNode)object3).getOffset());
                        ((UriReferencedElementImpl)object4).setUriEnd(((AstNode)object3).getEnd());
                    }
                    ((UriReferencedElementImpl)object4).setUri((String)object);
                    ((ImportElementImpl)object4).setCombinators(this.buildCombinators((NamespaceDirective)object2));
                    LibraryElementImpl libraryElementImpl = ((ResolvableLibrary)object5).getLibraryElement();
                    if (libraryElementImpl != null) {
                        ((ImportElementImpl)object4).setImportedLibrary(libraryElementImpl);
                    }
                    if ((simpleIdentifier = ((ImportDirective)directive).getPrefix()) != null) {
                        ((ImportElementImpl)object4).setPrefixOffset(simpleIdentifier.getOffset());
                        String string = simpleIdentifier.getName();
                        PrefixElementImpl prefixElementImpl = (PrefixElementImpl)hashMap.get(string);
                        if (prefixElementImpl == null) {
                            prefixElementImpl = new PrefixElementImpl(simpleIdentifier);
                            hashMap.put(string, prefixElementImpl);
                        }
                        ((ImportElementImpl)object4).setPrefix(prefixElementImpl);
                        simpleIdentifier.setStaticElement(prefixElementImpl);
                    }
                    directive.setElement((Element)object4);
                    arrayList.add(object4);
                    if (this.analysisContext.computeKindOf((Source)object6) == SourceKind.LIBRARY) continue;
                    this.errorListener.onError(new AnalysisError(resolvableLibrary.getLibrarySource(), ((AstNode)object3).getOffset(), ((AstNode)object3).getLength(), CompileTimeErrorCode.IMPORT_OF_NON_LIBRARY, ((AstNode)object3).toSource()));
                    continue;
                }
                if (!(directive instanceof ExportDirective) || (object = ((UriBasedDirective)(object2 = (ExportDirective)directive)).getSource()) == null || !this.analysisContext.exists((Source)object) || (object6 = this.libraryMap.get(object)) == null) continue;
                object5 = new ExportElementImpl();
                object4 = ((UriBasedDirective)object2).getUri();
                if (object4 != null) {
                    ((UriReferencedElementImpl)object5).setUriOffset(((AstNode)object4).getOffset());
                    ((UriReferencedElementImpl)object5).setUriEnd(((AstNode)object4).getEnd());
                }
                ((UriReferencedElementImpl)object5).setUri(((UriBasedDirective)object2).getUriContent());
                ((ExportElementImpl)object5).setCombinators(this.buildCombinators((NamespaceDirective)object2));
                object3 = ((ResolvableLibrary)object6).getLibraryElement();
                if (object3 != null) {
                    ((ExportElementImpl)object5).setExportedLibrary((LibraryElement)object3);
                }
                directive.setElement((Element)object5);
                arrayList2.add(object5);
                if (this.analysisContext.computeKindOf((Source)object) == SourceKind.LIBRARY) continue;
                this.errorListener.onError(new AnalysisError(resolvableLibrary.getLibrarySource(), ((AstNode)object4).getOffset(), ((AstNode)object4).getLength(), CompileTimeErrorCode.EXPORT_OF_NON_LIBRARY, ((AstNode)object4).toSource()));
            }
            Source source = resolvableLibrary.getLibrarySource();
            if (!resolvableLibrary.getExplicitlyImportsCore() && !((Object)this.coreLibrarySource).equals(source)) {
                ImportElementImpl importElementImpl = new ImportElementImpl(-1);
                importElementImpl.setImportedLibrary(this.coreLibrary.getLibraryElement());
                importElementImpl.setSynthetic(true);
                arrayList.add(importElementImpl);
            }
            LibraryElementImpl object32 = resolvableLibrary.getLibraryElement();
            object32.setImports(arrayList.toArray(new ImportElement[arrayList.size()]));
            object32.setExports(arrayList2.toArray(new ExportElement[arrayList2.size()]));
            if (object32.getEntryPoint() != null || !((object = ((Namespace)(object2 = new NamespaceBuilder().createExportNamespaceForLibrary(object32))).get("main")) instanceof FunctionElement)) continue;
            object32.setEntryPoint((FunctionElement)object);
        }
    }

    private void buildElementModels() throws AnalysisException {
        for (ResolvableLibrary resolvableLibrary : this.librariesInCycle) {
            LibraryElementBuilder libraryElementBuilder = new LibraryElementBuilder(this.getAnalysisContext(), this.getErrorListener());
            LibraryElementImpl libraryElementImpl = libraryElementBuilder.buildLibrary(resolvableLibrary);
            resolvableLibrary.setLibraryElement(libraryElementImpl);
        }
    }

    private HashMap<Source, ResolvableLibrary> buildLibraryMap() {
        HashMap<Source, ResolvableLibrary> hashMap = new HashMap<Source, ResolvableLibrary>();
        int n = this.librariesInCycle.size();
        for (int i = 0; i < n; ++i) {
            ResolvableLibrary resolvableLibrary = this.librariesInCycle.get(i);
            resolvableLibrary.setErrorListener(this.errorListener);
            hashMap.put(resolvableLibrary.getLibrarySource(), resolvableLibrary);
            for (ResolvableLibrary resolvableLibrary2 : resolvableLibrary.getImportsAndExports()) {
                hashMap.put(resolvableLibrary2.getLibrarySource(), resolvableLibrary2);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTypeHierarchies() throws AnalysisException {
        TimeCounter.TimeCounterHandle timeCounterHandle = PerformanceStatistics.resolve.start();
        try {
            for (ResolvableLibrary resolvableLibrary : this.librariesInCycle) {
                for (ResolvableCompilationUnit resolvableCompilationUnit : resolvableLibrary.getResolvableCompilationUnits()) {
                    Source source = resolvableCompilationUnit.getSource();
                    CompilationUnit compilationUnit = resolvableCompilationUnit.getCompilationUnit();
                    TypeResolverVisitor typeResolverVisitor = new TypeResolverVisitor(resolvableLibrary, source, this.typeProvider);
                    compilationUnit.accept(typeResolverVisitor);
                }
            }
        }
        finally {
            timeCounterHandle.stop();
        }
    }

    private String[] getIdentifiers(NodeList<SimpleIdentifier> nodeList) {
        int n = nodeList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SimpleIdentifier)nodeList.get(i)).getName();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performConstantEvaluation() {
        TimeCounter.TimeCounterHandle timeCounterHandle = PerformanceStatistics.resolve.start();
        try {
            ConstantValueComputer constantValueComputer = new ConstantValueComputer(this.typeProvider);
            for (ResolvableLibrary resolvableLibrary : this.librariesInCycle) {
                for (ResolvableCompilationUnit resolvableCompilationUnit : resolvableLibrary.getResolvableCompilationUnits()) {
                    CompilationUnit compilationUnit = resolvableCompilationUnit.getCompilationUnit();
                    if (compilationUnit == null) continue;
                    constantValueComputer.add(compilationUnit);
                }
            }
            constantValueComputer.computeValues();
        }
        finally {
            timeCounterHandle.stop();
        }
    }

    private void resolveReferencesAndTypes() throws AnalysisException {
        for (ResolvableLibrary resolvableLibrary : this.librariesInCycle) {
            this.resolveReferencesAndTypesInLibrary(resolvableLibrary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveReferencesAndTypesInLibrary(ResolvableLibrary resolvableLibrary) throws AnalysisException {
        CompilationUnit compilationUnit;
        Source source;
        TimeCounter.TimeCounterHandle timeCounterHandle = PerformanceStatistics.resolve.start();
        try {
            for (ResolvableCompilationUnit resolvableCompilationUnit : resolvableLibrary.getResolvableCompilationUnits()) {
                source = resolvableCompilationUnit.getSource();
                compilationUnit = resolvableCompilationUnit.getCompilationUnit();
                compilationUnit.accept(new VariableResolverVisitor(resolvableLibrary, source, this.typeProvider));
                ResolverVisitor resolverVisitor = new ResolverVisitor(resolvableLibrary, source, this.typeProvider);
                compilationUnit.accept(resolverVisitor);
                for (ProxyConditionalAnalysisError proxyConditionalAnalysisError : resolverVisitor.getProxyConditionalAnalysisErrors()) {
                    if (!proxyConditionalAnalysisError.shouldIncludeErrorCode()) continue;
                    resolverVisitor.reportError(proxyConditionalAnalysisError.getAnalysisError());
                }
            }
        }
        finally {
            timeCounterHandle.stop();
        }
        timeCounterHandle = PerformanceStatistics.angular.start();
        try {
            for (ResolvableCompilationUnit resolvableCompilationUnit : resolvableLibrary.getResolvableCompilationUnits()) {
                source = resolvableCompilationUnit.getSource();
                compilationUnit = resolvableCompilationUnit.getCompilationUnit();
                new AngularCompilationUnitBuilder(this.errorListener, source, compilationUnit).build();
            }
        }
        finally {
            timeCounterHandle.stop();
        }
    }
}

