/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.Combinator;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.Directive;
import com.google.dart.engine.ast.ExportDirective;
import com.google.dart.engine.ast.HideCombinator;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.NamespaceDirective;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.ShowCombinator;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.StringInterpolation;
import com.google.dart.engine.ast.StringLiteral;
import com.google.dart.engine.ast.UriBasedDirective;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExportElement;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.element.ImportElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.NamespaceCombinator;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.internal.builder.AngularCompilationUnitBuilder;
import com.google.dart.engine.internal.constant.ConstantValueComputer;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.PerformanceStatistics;
import com.google.dart.engine.internal.context.RecordingErrorListener;
import com.google.dart.engine.internal.element.ExportElementImpl;
import com.google.dart.engine.internal.element.HideElementCombinatorImpl;
import com.google.dart.engine.internal.element.ImportElementImpl;
import com.google.dart.engine.internal.element.LibraryElementImpl;
import com.google.dart.engine.internal.element.PrefixElementImpl;
import com.google.dart.engine.internal.element.ShowElementCombinatorImpl;
import com.google.dart.engine.internal.element.UriReferencedElementImpl;
import com.google.dart.engine.internal.resolver.Library;
import com.google.dart.engine.internal.resolver.LibraryElementBuilder;
import com.google.dart.engine.internal.resolver.ProxyConditionalAnalysisError;
import com.google.dart.engine.internal.resolver.ResolverVisitor;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.internal.resolver.TypeProviderImpl;
import com.google.dart.engine.internal.resolver.TypeResolverVisitor;
import com.google.dart.engine.internal.resolver.VariableResolverVisitor;
import com.google.dart.engine.internal.scope.Namespace;
import com.google.dart.engine.internal.scope.NamespaceBuilder;
import com.google.dart.engine.source.DartUriResolver;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.SourceKind;
import com.google.dart.engine.utilities.general.TimeCounter;
import com.google.dart.engine.utilities.instrumentation.Instrumentation;
import com.google.dart.engine.utilities.instrumentation.InstrumentationBuilder;
import com.google.dart.engine.utilities.io.UriUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class LibraryResolver {
    private InternalAnalysisContext analysisContext;
    private RecordingErrorListener errorListener;
    private Source coreLibrarySource;
    private Library coreLibrary;
    private TypeProvider typeProvider;
    private HashMap<Source, Library> libraryMap = new HashMap();
    private Set<Library> librariesInCycles;

    public LibraryResolver(InternalAnalysisContext internalAnalysisContext) {
        this.analysisContext = internalAnalysisContext;
        this.errorListener = new RecordingErrorListener();
        this.coreLibrarySource = internalAnalysisContext.getSourceFactory().forUri("dart:core");
    }

    public InternalAnalysisContext getAnalysisContext() {
        return this.analysisContext;
    }

    public RecordingErrorListener getErrorListener() {
        return this.errorListener;
    }

    public Set<Library> getResolvedLibraries() {
        return this.librariesInCycles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryElement resolveEmbeddedLibrary(Source source, long l, CompilationUnit compilationUnit, boolean bl) throws AnalysisException {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("dart.engine.LibraryResolver.resolveEmbeddedLibrary");
        try {
            instrumentationBuilder.metric("fullAnalysis", bl);
            instrumentationBuilder.data("fullName", source.getFullName());
            Library library = this.createLibraryWithUnit(source, l, compilationUnit);
            this.coreLibrary = this.libraryMap.get(this.coreLibrarySource);
            if (this.coreLibrary == null) {
                this.coreLibrary = this.createLibrary(this.coreLibrarySource);
            }
            instrumentationBuilder.metric("createLibrary", "complete");
            this.computeEmbeddedLibraryDependencies(library, compilationUnit);
            this.librariesInCycles = this.computeLibrariesInCycles(library);
            this.buildElementModels();
            instrumentationBuilder.metric("buildElementModels", "complete");
            LibraryElementImpl libraryElementImpl = this.coreLibrary.getLibraryElement();
            if (libraryElementImpl == null) {
                throw new AnalysisException("Could not resolve dart:core");
            }
            this.buildDirectiveModels();
            instrumentationBuilder.metric("buildDirectiveModels", "complete");
            this.typeProvider = new TypeProviderImpl(libraryElementImpl);
            this.buildTypeHierarchies();
            instrumentationBuilder.metric("buildTypeHierarchies", "complete");
            this.resolveReferencesAndTypes();
            instrumentationBuilder.metric("resolveReferencesAndTypes", "complete");
            this.performConstantEvaluation();
            instrumentationBuilder.metric("performConstantEvaluation", "complete");
            LibraryElementImpl libraryElementImpl2 = library.getLibraryElement();
            return libraryElementImpl2;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryElement resolveLibrary(Source source, boolean bl) throws AnalysisException {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("dart.engine.LibraryResolver.resolveLibrary");
        try {
            instrumentationBuilder.metric("fullAnalysis", bl);
            instrumentationBuilder.data("fullName", source.getFullName());
            Library library = this.createLibrary(source);
            this.coreLibrary = this.libraryMap.get(this.coreLibrarySource);
            if (this.coreLibrary == null) {
                this.coreLibrary = this.createLibraryOrNull(this.coreLibrarySource);
                if (this.coreLibrary == null) {
                    throw new AnalysisException("Core library does not exist");
                }
            }
            instrumentationBuilder.metric("createLibrary", "complete");
            this.computeLibraryDependencies(library);
            this.librariesInCycles = this.computeLibrariesInCycles(library);
            this.buildElementModels();
            instrumentationBuilder.metric("buildElementModels", "complete");
            LibraryElementImpl libraryElementImpl = this.coreLibrary.getLibraryElement();
            if (libraryElementImpl == null) {
                throw new AnalysisException("Could not resolve dart:core");
            }
            this.buildDirectiveModels();
            instrumentationBuilder.metric("buildDirectiveModels", "complete");
            this.typeProvider = new TypeProviderImpl(libraryElementImpl);
            this.buildTypeHierarchies();
            instrumentationBuilder.metric("buildTypeHierarchies", "complete");
            this.resolveReferencesAndTypes();
            instrumentationBuilder.metric("resolveReferencesAndTypes", "complete");
            this.performConstantEvaluation();
            instrumentationBuilder.metric("performConstantEvaluation", "complete");
            instrumentationBuilder.metric("librariesInCycles", this.librariesInCycles.size());
            for (Library library2 : this.librariesInCycles) {
                instrumentationBuilder.metric("librariesInCycles-CompilationUnitSources-Size", library2.getCompilationUnitSources().size());
            }
            LibraryElementImpl libraryElementImpl2 = library.getLibraryElement();
            return libraryElementImpl2;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    protected Library createLibrary(Source source) throws AnalysisException {
        Library library = new Library(this.analysisContext, this.errorListener, source);
        this.libraryMap.put(source, library);
        return library;
    }

    private void addDependencyToMap(HashMap<Library, ArrayList<Library>> hashMap, Library library, Library library2) {
        ArrayList<Library> arrayList = hashMap.get(library2);
        if (arrayList == null) {
            arrayList = new ArrayList();
            hashMap.put(library2, arrayList);
        }
        arrayList.add(library);
    }

    private void addLibrariesInCycle(Library library, Set<Library> set, HashMap<Library, ArrayList<Library>> hashMap) {
        ArrayList<Library> arrayList;
        if (set.add(library) && (arrayList = hashMap.get(library)) != null) {
            for (Library library2 : arrayList) {
                this.addLibrariesInCycle(library2, set, hashMap);
            }
        }
    }

    private void addToDependencyMap(Library library, HashMap<Library, ArrayList<Library>> hashMap, Set<Library> set) {
        if (set.add(library)) {
            for (Library library2 : library.getImportsAndExports()) {
                this.addDependencyToMap(hashMap, library, library2);
                this.addToDependencyMap(library2, hashMap, set);
            }
            if (!library.getExplicitlyImportsCore() && library != this.coreLibrary) {
                this.addDependencyToMap(hashMap, library, this.coreLibrary);
            }
        }
    }

    private NamespaceCombinator[] buildCombinators(NamespaceDirective namespaceDirective) {
        ArrayList<NamespaceCombinator> arrayList = new ArrayList<NamespaceCombinator>();
        for (Combinator combinator : namespaceDirective.getCombinators()) {
            NamespaceCombinator namespaceCombinator;
            if (combinator instanceof HideCombinator) {
                namespaceCombinator = new HideElementCombinatorImpl();
                ((HideElementCombinatorImpl)namespaceCombinator).setHiddenNames(this.getIdentifiers(((HideCombinator)combinator).getHiddenNames()));
                arrayList.add(namespaceCombinator);
                continue;
            }
            namespaceCombinator = new ShowElementCombinatorImpl();
            ((ShowElementCombinatorImpl)namespaceCombinator).setOffset(combinator.getOffset());
            ((ShowElementCombinatorImpl)namespaceCombinator).setEnd(combinator.getEnd());
            ((ShowElementCombinatorImpl)namespaceCombinator).setShownNames(this.getIdentifiers(((ShowCombinator)combinator).getShownNames()));
            arrayList.add(namespaceCombinator);
        }
        return arrayList.toArray(new NamespaceCombinator[arrayList.size()]);
    }

    private void buildDirectiveModels() throws AnalysisException {
        for (Library library : this.librariesInCycles) {
            Object object;
            Object object2;
            HashMap<String, PrefixElementImpl> hashMap = new HashMap<String, PrefixElementImpl>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (Directive directive : library.getDefiningCompilationUnit().getDirectives()) {
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                if (directive instanceof ImportDirective) {
                    SimpleIdentifier simpleIdentifier;
                    object2 = (ImportDirective)directive;
                    object = ((UriBasedDirective)object2).getUriContent();
                    if (DartUriResolver.isDartExtUri((String)object)) {
                        library.getLibraryElement().setHasExtUri(true);
                    }
                    if ((object6 = ((UriBasedDirective)object2).getSource()) == null || (object5 = this.libraryMap.get(object6)) == null) continue;
                    object4 = new ImportElementImpl(directive.getOffset());
                    object3 = ((UriBasedDirective)object2).getUri();
                    ((UriReferencedElementImpl)object4).setUriOffset(((AstNode)object3).getOffset());
                    ((UriReferencedElementImpl)object4).setUriEnd(((AstNode)object3).getEnd());
                    ((UriReferencedElementImpl)object4).setUri((String)object);
                    ((ImportElementImpl)object4).setCombinators(this.buildCombinators((NamespaceDirective)object2));
                    LibraryElementImpl libraryElementImpl = ((Library)object5).getLibraryElement();
                    if (libraryElementImpl != null) {
                        ((ImportElementImpl)object4).setImportedLibrary(libraryElementImpl);
                    }
                    if ((simpleIdentifier = ((ImportDirective)directive).getPrefix()) != null) {
                        ((ImportElementImpl)object4).setPrefixOffset(simpleIdentifier.getOffset());
                        String string = simpleIdentifier.getName();
                        PrefixElementImpl prefixElementImpl = (PrefixElementImpl)hashMap.get(string);
                        if (prefixElementImpl == null) {
                            prefixElementImpl = new PrefixElementImpl(simpleIdentifier);
                            hashMap.put(string, prefixElementImpl);
                        }
                        ((ImportElementImpl)object4).setPrefix(prefixElementImpl);
                        simpleIdentifier.setStaticElement(prefixElementImpl);
                    }
                    directive.setElement((Element)object4);
                    arrayList.add(object4);
                    if (this.analysisContext.computeKindOf((Source)object6) == SourceKind.LIBRARY) continue;
                    this.errorListener.onError(new AnalysisError(library.getLibrarySource(), ((AstNode)object3).getOffset(), ((AstNode)object3).getLength(), CompileTimeErrorCode.IMPORT_OF_NON_LIBRARY, ((AstNode)object3).toSource()));
                    continue;
                }
                if (!(directive instanceof ExportDirective) || (object = ((UriBasedDirective)(object2 = (ExportDirective)directive)).getSource()) == null || (object6 = this.libraryMap.get(object)) == null) continue;
                object5 = new ExportElementImpl();
                object4 = ((UriBasedDirective)object2).getUri();
                ((UriReferencedElementImpl)object5).setUriOffset(((AstNode)object4).getOffset());
                ((UriReferencedElementImpl)object5).setUriEnd(((AstNode)object4).getEnd());
                ((UriReferencedElementImpl)object5).setUri(((UriBasedDirective)object2).getUriContent());
                ((ExportElementImpl)object5).setCombinators(this.buildCombinators((NamespaceDirective)object2));
                object3 = ((Library)object6).getLibraryElement();
                if (object3 != null) {
                    ((ExportElementImpl)object5).setExportedLibrary((LibraryElement)object3);
                }
                directive.setElement((Element)object5);
                arrayList2.add(object5);
                if (this.analysisContext.computeKindOf((Source)object) == SourceKind.LIBRARY) continue;
                this.errorListener.onError(new AnalysisError(library.getLibrarySource(), ((AstNode)object4).getOffset(), ((AstNode)object4).getLength(), CompileTimeErrorCode.EXPORT_OF_NON_LIBRARY, ((AstNode)object4).toSource()));
            }
            Source source = library.getLibrarySource();
            if (!library.getExplicitlyImportsCore() && !((Object)this.coreLibrarySource).equals(source)) {
                ImportElementImpl importElementImpl = new ImportElementImpl(-1);
                importElementImpl.setImportedLibrary(this.coreLibrary.getLibraryElement());
                importElementImpl.setSynthetic(true);
                arrayList.add(importElementImpl);
            }
            LibraryElementImpl object32 = library.getLibraryElement();
            object32.setImports(arrayList.toArray(new ImportElement[arrayList.size()]));
            object32.setExports(arrayList2.toArray(new ExportElement[arrayList2.size()]));
            if (object32.getEntryPoint() != null || !((object = ((Namespace)(object2 = new NamespaceBuilder().createExportNamespaceForLibrary(object32))).get("main")) instanceof FunctionElement)) continue;
            object32.setEntryPoint((FunctionElement)object);
        }
    }

    private void buildElementModels() throws AnalysisException {
        for (Library library : this.librariesInCycles) {
            LibraryElementBuilder libraryElementBuilder = new LibraryElementBuilder(this.getAnalysisContext(), this.getErrorListener());
            LibraryElementImpl libraryElementImpl = libraryElementBuilder.buildLibrary(library);
            library.setLibraryElement(libraryElementImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTypeHierarchies() throws AnalysisException {
        TimeCounter.TimeCounterHandle timeCounterHandle = PerformanceStatistics.resolve.start();
        try {
            for (Library library : this.librariesInCycles) {
                for (Source source : library.getCompilationUnitSources()) {
                    TypeResolverVisitor typeResolverVisitor = new TypeResolverVisitor(library, source, this.typeProvider);
                    library.getAST(source).accept(typeResolverVisitor);
                }
            }
        }
        finally {
            timeCounterHandle.stop();
        }
    }

    private HashMap<Library, ArrayList<Library>> computeDependencyMap(Library library) {
        HashMap<Library, ArrayList<Library>> hashMap = new HashMap<Library, ArrayList<Library>>();
        this.addToDependencyMap(library, hashMap, new HashSet<Library>());
        return hashMap;
    }

    private void computeEmbeddedLibraryDependencies(Library library, CompilationUnit compilationUnit) throws AnalysisException {
        Source source = library.getLibrarySource();
        HashSet<Source> hashSet = new HashSet<Source>();
        HashSet<Source> hashSet2 = new HashSet<Source>();
        for (Directive directive : compilationUnit.getDirectives()) {
            Source source2;
            if (directive instanceof ExportDirective) {
                source2 = this.resolveSource(source, (ExportDirective)directive);
                if (source2 == null) continue;
                hashSet.add(source2);
                continue;
            }
            if (!(directive instanceof ImportDirective) || (source2 = this.resolveSource(source, (ImportDirective)directive)) == null) continue;
            hashSet2.add(source2);
        }
        this.computeLibraryDependenciesFromDirectives(library, hashSet2.toArray(new Source[hashSet2.size()]), hashSet.toArray(new Source[hashSet.size()]));
    }

    private Set<Library> computeLibrariesInCycles(Library library) {
        HashMap<Library, ArrayList<Library>> hashMap = this.computeDependencyMap(library);
        HashSet<Library> hashSet = new HashSet<Library>();
        this.addLibrariesInCycle(library, hashSet, hashMap);
        return hashSet;
    }

    private void computeLibraryDependencies(Library library) throws AnalysisException {
        Source source = library.getLibrarySource();
        this.computeLibraryDependenciesFromDirectives(library, this.analysisContext.computeImportedLibraries(source), this.analysisContext.computeExportedLibraries(source));
    }

    private void computeLibraryDependenciesFromDirectives(Library library, Source[] sourceArray, Source[] sourceArray2) throws AnalysisException {
        Object object;
        ArrayList<Library> arrayList = new ArrayList<Library>();
        boolean bl = false;
        for (Source source : sourceArray) {
            if (((Object)source).equals(this.coreLibrarySource)) {
                bl = true;
            }
            if ((object = this.libraryMap.get(source)) == null && (object = this.createLibraryOrNull(source)) != null) {
                this.computeLibraryDependencies((Library)object);
            }
            if (object == null) continue;
            arrayList.add((Library)object);
        }
        library.setImportedLibraries(arrayList.toArray(new Library[arrayList.size()]));
        ArrayList arrayList2 = new ArrayList();
        Object object2 = sourceArray2;
        int n = ((Source[])object2).length;
        for (int i = 0; i < n; ++i) {
            object = object2[i];
            Library library2 = this.libraryMap.get(object);
            if (library2 == null && (library2 = this.createLibraryOrNull((Source)object)) != null) {
                this.computeLibraryDependencies(library2);
            }
            if (library2 == null) continue;
            arrayList2.add(library2);
        }
        library.setExportedLibraries(arrayList2.toArray(new Library[arrayList2.size()]));
        library.setExplicitlyImportsCore(bl);
        if (!bl && !((Object)this.coreLibrarySource).equals(library.getLibrarySource()) && (object2 = this.libraryMap.get(this.coreLibrarySource)) == null && (object2 = this.createLibraryOrNull(this.coreLibrarySource)) != null) {
            this.computeLibraryDependencies((Library)object2);
        }
    }

    private Library createLibraryOrNull(Source source) {
        if (!this.analysisContext.exists(source)) {
            return null;
        }
        Library library = new Library(this.analysisContext, this.errorListener, source);
        this.libraryMap.put(source, library);
        return library;
    }

    private Library createLibraryWithUnit(Source source, long l, CompilationUnit compilationUnit) throws AnalysisException {
        Library library = new Library(this.analysisContext, this.errorListener, source);
        library.setDefiningCompilationUnit(l, compilationUnit);
        this.libraryMap.put(source, library);
        return library;
    }

    private String[] getIdentifiers(NodeList<SimpleIdentifier> nodeList) {
        int n = nodeList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SimpleIdentifier)nodeList.get(i)).getName();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performConstantEvaluation() {
        TimeCounter.TimeCounterHandle timeCounterHandle = PerformanceStatistics.resolve.start();
        try {
            ConstantValueComputer constantValueComputer = new ConstantValueComputer(this.typeProvider);
            for (Library library : this.librariesInCycles) {
                for (Source source : library.getCompilationUnitSources()) {
                    try {
                        CompilationUnit compilationUnit = library.getAST(source);
                        if (compilationUnit == null) continue;
                        constantValueComputer.add(compilationUnit);
                    }
                    catch (AnalysisException analysisException) {
                        AnalysisEngine.getInstance().getLogger().logError("Internal Error: Could not access AST for " + source.getFullName() + " during constant evaluation", analysisException);
                    }
                }
            }
            constantValueComputer.computeValues();
        }
        finally {
            timeCounterHandle.stop();
        }
    }

    private void resolveReferencesAndTypes() throws AnalysisException {
        for (Library library : this.librariesInCycles) {
            this.resolveReferencesAndTypesInLibrary(library);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveReferencesAndTypesInLibrary(Library library) throws AnalysisException {
        CompilationUnit compilationUnit;
        TimeCounter.TimeCounterHandle timeCounterHandle = PerformanceStatistics.resolve.start();
        try {
            for (Source source : library.getCompilationUnitSources()) {
                compilationUnit = library.getAST(source);
                compilationUnit.accept(new VariableResolverVisitor(library, source, this.typeProvider));
                ResolverVisitor resolverVisitor = new ResolverVisitor(library, source, this.typeProvider);
                compilationUnit.accept(resolverVisitor);
                for (ProxyConditionalAnalysisError proxyConditionalAnalysisError : resolverVisitor.getProxyConditionalAnalysisErrors()) {
                    if (!proxyConditionalAnalysisError.shouldIncludeErrorCode()) continue;
                    resolverVisitor.reportError(proxyConditionalAnalysisError.getAnalysisError());
                }
            }
        }
        finally {
            timeCounterHandle.stop();
        }
        timeCounterHandle = PerformanceStatistics.angular.start();
        try {
            for (Source source : library.getCompilationUnitSources()) {
                compilationUnit = library.getAST(source);
                new AngularCompilationUnitBuilder(this.errorListener, source, compilationUnit).build();
            }
        }
        finally {
            timeCounterHandle.stop();
        }
    }

    private Source resolveSource(Source source, UriBasedDirective uriBasedDirective) {
        StringLiteral stringLiteral = uriBasedDirective.getUri();
        if (stringLiteral instanceof StringInterpolation) {
            return null;
        }
        String string = stringLiteral.getStringValue().trim();
        if (string == null || string.isEmpty()) {
            return null;
        }
        string = UriUtilities.encode(string);
        return this.analysisContext.getSourceFactory().resolveUri(source, string);
    }
}

