/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.Directive;
import com.google.dart.engine.ast.LibraryDirective;
import com.google.dart.engine.ast.LibraryIdentifier;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.PartDirective;
import com.google.dart.engine.ast.PartOfDirective;
import com.google.dart.engine.ast.StringLiteral;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.error.StaticWarningCode;
import com.google.dart.engine.internal.builder.CompilationUnitBuilder;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.element.CompilationUnitElementImpl;
import com.google.dart.engine.internal.element.LibraryElementImpl;
import com.google.dart.engine.internal.element.PropertyAccessorElementImpl;
import com.google.dart.engine.internal.element.PropertyInducingElementImpl;
import com.google.dart.engine.internal.resolver.Library;
import com.google.dart.engine.internal.resolver.ResolvableLibrary;
import com.google.dart.engine.resolver.ResolverErrorCode;
import com.google.dart.engine.source.Source;
import java.util.ArrayList;
import java.util.HashMap;

public class LibraryElementBuilder {
    private InternalAnalysisContext analysisContext;
    private AnalysisErrorListener errorListener;
    public static final String ENTRY_POINT_NAME = "main";

    public LibraryElementBuilder(InternalAnalysisContext internalAnalysisContext, AnalysisErrorListener analysisErrorListener) {
        this.analysisContext = internalAnalysisContext;
        this.errorListener = analysisErrorListener;
    }

    public LibraryElementImpl buildLibrary(Library library) throws AnalysisException {
        CompilationUnitBuilder compilationUnitBuilder = new CompilationUnitBuilder();
        Source source = library.getLibrarySource();
        CompilationUnit compilationUnit = library.getDefiningCompilationUnit();
        CompilationUnitElementImpl compilationUnitElementImpl = compilationUnitBuilder.buildCompilationUnit(source, compilationUnit);
        NodeList<Directive> nodeList = compilationUnit.getDirectives();
        LibraryIdentifier libraryIdentifier = null;
        boolean bl = false;
        FunctionElement functionElement = this.findEntryPoint(compilationUnitElementImpl);
        ArrayList<Directive> arrayList = new ArrayList<Directive>();
        ArrayList<CompilationUnitElementImpl> arrayList2 = new ArrayList<CompilationUnitElementImpl>();
        for (Directive directive : nodeList) {
            if (directive instanceof LibraryDirective) {
                if (libraryIdentifier != null) continue;
                libraryIdentifier = ((LibraryDirective)directive).getName();
                arrayList.add(directive);
                continue;
            }
            if (!(directive instanceof PartDirective)) continue;
            PartDirective partDirective = (PartDirective)directive;
            StringLiteral astNode = partDirective.getUri();
            Source source2 = partDirective.getSource();
            if (!this.analysisContext.exists(source2)) continue;
            bl = true;
            CompilationUnit compilationUnit2 = library.getAST(source2);
            CompilationUnitElementImpl compilationUnitElementImpl2 = compilationUnitBuilder.buildCompilationUnit(source2, compilationUnit2);
            compilationUnitElementImpl2.setUriOffset(astNode.getOffset());
            compilationUnitElementImpl2.setUriEnd(astNode.getEnd());
            compilationUnitElementImpl2.setUri(library.getUri(partDirective));
            String string = this.getPartLibraryName(source2, compilationUnit2, arrayList);
            if (string == null) {
                this.errorListener.onError(new AnalysisError(source, astNode.getOffset(), astNode.getLength(), CompileTimeErrorCode.PART_OF_NON_PART, astNode.toSource()));
            } else if (libraryIdentifier != null && !libraryIdentifier.getName().equals(string)) {
                this.errorListener.onError(new AnalysisError(source, astNode.getOffset(), astNode.getLength(), StaticWarningCode.PART_OF_DIFFERENT_LIBRARY, libraryIdentifier.getName(), string));
            }
            if (functionElement == null) {
                functionElement = this.findEntryPoint(compilationUnitElementImpl2);
            }
            directive.setElement(compilationUnitElementImpl2);
            arrayList2.add(compilationUnitElementImpl2);
        }
        if (bl && libraryIdentifier == null) {
            this.errorListener.onError(new AnalysisError(source, ResolverErrorCode.MISSING_LIBRARY_DIRECTIVE_WITH_PART, new Object[0]));
        }
        LibraryElementImpl libraryElementImpl = new LibraryElementImpl(this.analysisContext, libraryIdentifier);
        libraryElementImpl.setDefiningCompilationUnit(compilationUnitElementImpl);
        if (functionElement != null) {
            libraryElementImpl.setEntryPoint(functionElement);
        }
        int n = arrayList2.size();
        libraryElementImpl.setParts(arrayList2.toArray(new CompilationUnitElementImpl[n]));
        for (Directive directive : arrayList) {
            directive.setElement(libraryElementImpl);
        }
        library.setLibraryElement(libraryElementImpl);
        if (n > 0) {
            this.patchTopLevelAccessors(libraryElementImpl);
        }
        return libraryElementImpl;
    }

    public LibraryElementImpl buildLibrary(ResolvableLibrary resolvableLibrary) throws AnalysisException {
        CompilationUnitBuilder compilationUnitBuilder = new CompilationUnitBuilder();
        Source source = resolvableLibrary.getLibrarySource();
        CompilationUnit compilationUnit = resolvableLibrary.getDefiningCompilationUnit();
        CompilationUnitElementImpl compilationUnitElementImpl = compilationUnitBuilder.buildCompilationUnit(source, compilationUnit);
        NodeList<Directive> nodeList = compilationUnit.getDirectives();
        LibraryIdentifier libraryIdentifier = null;
        boolean bl = false;
        FunctionElement functionElement = this.findEntryPoint(compilationUnitElementImpl);
        ArrayList<Directive> arrayList = new ArrayList<Directive>();
        ArrayList<CompilationUnitElementImpl> arrayList2 = new ArrayList<CompilationUnitElementImpl>();
        for (Directive directive : nodeList) {
            if (directive instanceof LibraryDirective) {
                if (libraryIdentifier != null) continue;
                libraryIdentifier = ((LibraryDirective)directive).getName();
                arrayList.add(directive);
                continue;
            }
            if (!(directive instanceof PartDirective)) continue;
            PartDirective partDirective = (PartDirective)directive;
            StringLiteral astNode = partDirective.getUri();
            Source source2 = partDirective.getSource();
            if (!this.analysisContext.exists(source2)) continue;
            bl = true;
            CompilationUnit compilationUnit2 = resolvableLibrary.getAST(source2);
            CompilationUnitElementImpl compilationUnitElementImpl2 = compilationUnitBuilder.buildCompilationUnit(source2, compilationUnit2);
            compilationUnitElementImpl2.setUriOffset(astNode.getOffset());
            compilationUnitElementImpl2.setUriEnd(astNode.getEnd());
            compilationUnitElementImpl2.setUri(partDirective.getUriContent());
            String string = this.getPartLibraryName(source2, compilationUnit2, arrayList);
            if (string == null) {
                this.errorListener.onError(new AnalysisError(source, astNode.getOffset(), astNode.getLength(), CompileTimeErrorCode.PART_OF_NON_PART, astNode.toSource()));
            } else if (libraryIdentifier != null && !libraryIdentifier.getName().equals(string)) {
                this.errorListener.onError(new AnalysisError(source, astNode.getOffset(), astNode.getLength(), StaticWarningCode.PART_OF_DIFFERENT_LIBRARY, libraryIdentifier.getName(), string));
            }
            if (functionElement == null) {
                functionElement = this.findEntryPoint(compilationUnitElementImpl2);
            }
            directive.setElement(compilationUnitElementImpl2);
            arrayList2.add(compilationUnitElementImpl2);
        }
        if (bl && libraryIdentifier == null) {
            this.errorListener.onError(new AnalysisError(source, ResolverErrorCode.MISSING_LIBRARY_DIRECTIVE_WITH_PART, new Object[0]));
        }
        LibraryElementImpl libraryElementImpl = new LibraryElementImpl(this.analysisContext, libraryIdentifier);
        libraryElementImpl.setDefiningCompilationUnit(compilationUnitElementImpl);
        if (functionElement != null) {
            libraryElementImpl.setEntryPoint(functionElement);
        }
        int n = arrayList2.size();
        libraryElementImpl.setParts(arrayList2.toArray(new CompilationUnitElementImpl[n]));
        for (Directive directive : arrayList) {
            directive.setElement(libraryElementImpl);
        }
        resolvableLibrary.setLibraryElement(libraryElementImpl);
        if (n > 0) {
            this.patchTopLevelAccessors(libraryElementImpl);
        }
        return libraryElementImpl;
    }

    private void collectAccessors(HashMap<String, PropertyAccessorElement> hashMap, ArrayList<PropertyAccessorElement> arrayList, CompilationUnitElement compilationUnitElement) {
        for (PropertyAccessorElement propertyAccessorElement : compilationUnitElement.getAccessors()) {
            if (propertyAccessorElement.isGetter()) {
                if (propertyAccessorElement.isSynthetic() || propertyAccessorElement.getCorrespondingSetter() != null) continue;
                hashMap.put(propertyAccessorElement.getDisplayName(), propertyAccessorElement);
                continue;
            }
            if (propertyAccessorElement.isSynthetic() || propertyAccessorElement.getCorrespondingGetter() != null) continue;
            arrayList.add(propertyAccessorElement);
        }
    }

    private FunctionElement findEntryPoint(CompilationUnitElementImpl compilationUnitElementImpl) {
        for (FunctionElement functionElement : compilationUnitElementImpl.getFunctions()) {
            if (!functionElement.getName().equals(ENTRY_POINT_NAME)) continue;
            return functionElement;
        }
        return null;
    }

    private String getPartLibraryName(Source source, CompilationUnit compilationUnit, ArrayList<Directive> arrayList) {
        for (Directive directive : compilationUnit.getDirectives()) {
            if (!(directive instanceof PartOfDirective)) continue;
            arrayList.add(directive);
            LibraryIdentifier libraryIdentifier = ((PartOfDirective)directive).getLibraryName();
            if (libraryIdentifier == null) continue;
            return libraryIdentifier.getName();
        }
        return null;
    }

    private void patchTopLevelAccessors(LibraryElementImpl libraryElementImpl) {
        HashMap<String, PropertyAccessorElement> hashMap = new HashMap<String, PropertyAccessorElement>();
        ArrayList<PropertyAccessorElement> arrayList = new ArrayList<PropertyAccessorElement>();
        this.collectAccessors(hashMap, arrayList, libraryElementImpl.getDefiningCompilationUnit());
        for (CompilationUnitElement element : libraryElementImpl.getParts()) {
            this.collectAccessors(hashMap, arrayList, element);
        }
        for (PropertyAccessorElement propertyAccessorElement : arrayList) {
            PropertyAccessorElement propertyAccessorElement2 = hashMap.get(propertyAccessorElement.getDisplayName());
            if (propertyAccessorElement2 == null) continue;
            PropertyInducingElementImpl propertyInducingElementImpl = (PropertyInducingElementImpl)propertyAccessorElement2.getVariable();
            propertyInducingElementImpl.setSetter(propertyAccessorElement);
            ((PropertyAccessorElementImpl)propertyAccessorElement).setVariable(propertyInducingElementImpl);
        }
    }
}

