/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.StringInterpolation;
import com.google.dart.engine.ast.StringLiteral;
import com.google.dart.engine.ast.UriBasedDirective;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.ResolvableCompilationUnit;
import com.google.dart.engine.internal.element.LibraryElementImpl;
import com.google.dart.engine.internal.resolver.InheritanceManager;
import com.google.dart.engine.internal.scope.LibraryScope;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.io.UriUtilities;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Library {
    private InternalAnalysisContext analysisContext;
    private InheritanceManager inheritanceManager;
    private AnalysisErrorListener errorListener;
    private Source librarySource;
    private LibraryElementImpl libraryElement;
    private Library[] importedLibraries = EMPTY_ARRAY;
    private HashMap<UriBasedDirective, String> directiveUris = new HashMap();
    private boolean explicitlyImportsCore = false;
    private Library[] exportedLibraries = EMPTY_ARRAY;
    private HashMap<Source, ResolvableCompilationUnit> astMap = new HashMap();
    private LibraryScope libraryScope;
    private static final Library[] EMPTY_ARRAY = new Library[0];
    private static final String DART_EXT_SCHEME = "dart-ext:";

    public Library(InternalAnalysisContext internalAnalysisContext, AnalysisErrorListener analysisErrorListener, Source source) {
        this.analysisContext = internalAnalysisContext;
        this.errorListener = analysisErrorListener;
        this.librarySource = source;
        this.libraryElement = (LibraryElementImpl)internalAnalysisContext.getLibraryElement(source);
    }

    public CompilationUnit getAST(Source source) throws AnalysisException {
        ResolvableCompilationUnit resolvableCompilationUnit = this.astMap.get(source);
        if (resolvableCompilationUnit == null) {
            resolvableCompilationUnit = this.analysisContext.computeResolvableCompilationUnit(source);
            this.astMap.put(source, resolvableCompilationUnit);
        }
        return resolvableCompilationUnit.getCompilationUnit();
    }

    public CompilationUnit[] getCompilationUnits() throws AnalysisException {
        ArrayList<CompilationUnit> arrayList = new ArrayList<CompilationUnit>(this.astMap.size());
        arrayList.add(this.getDefiningCompilationUnit());
        for (Source source : this.astMap.keySet()) {
            if (((Object)this.librarySource).equals(source)) continue;
            arrayList.add(this.getAST(source));
        }
        return arrayList.toArray(new CompilationUnit[arrayList.size()]);
    }

    public Set<Source> getCompilationUnitSources() {
        return this.astMap.keySet();
    }

    public CompilationUnit getDefiningCompilationUnit() throws AnalysisException {
        return this.getAST(this.librarySource);
    }

    public boolean getExplicitlyImportsCore() {
        return this.explicitlyImportsCore;
    }

    public Library[] getExports() {
        return this.exportedLibraries;
    }

    public Library[] getImports() {
        return this.importedLibraries;
    }

    public Library[] getImportsAndExports() {
        HashSet<Library> hashSet = new HashSet<Library>(this.importedLibraries.length + this.exportedLibraries.length);
        for (Library library : this.importedLibraries) {
            hashSet.add(library);
        }
        for (Library library : this.exportedLibraries) {
            hashSet.add(library);
        }
        return hashSet.toArray(new Library[hashSet.size()]);
    }

    public InheritanceManager getInheritanceManager() {
        if (this.inheritanceManager == null) {
            this.inheritanceManager = new InheritanceManager(this.libraryElement);
            return this.inheritanceManager;
        }
        return this.inheritanceManager;
    }

    public LibraryElementImpl getLibraryElement() {
        if (this.libraryElement == null) {
            try {
                this.libraryElement = (LibraryElementImpl)this.analysisContext.computeLibraryElement(this.librarySource);
            }
            catch (AnalysisException analysisException) {
                AnalysisEngine.getInstance().getLogger().logError("Could not compute library element for " + this.librarySource.getFullName(), analysisException);
            }
        }
        return this.libraryElement;
    }

    public LibraryScope getLibraryScope() {
        if (this.libraryScope == null) {
            this.libraryScope = new LibraryScope(this.libraryElement, this.errorListener);
        }
        return this.libraryScope;
    }

    public Source getLibrarySource() {
        return this.librarySource;
    }

    public long getModificationTime(Source source) throws AnalysisException {
        ResolvableCompilationUnit resolvableCompilationUnit = this.astMap.get(source);
        if (resolvableCompilationUnit == null) {
            resolvableCompilationUnit = this.analysisContext.computeResolvableCompilationUnit(source);
            this.astMap.put(source, resolvableCompilationUnit);
        }
        return resolvableCompilationUnit.getModificationTime();
    }

    public Source getSource(UriBasedDirective uriBasedDirective) {
        StringLiteral stringLiteral = uriBasedDirective.getUri();
        if (stringLiteral instanceof StringInterpolation) {
            this.errorListener.onError(new AnalysisError(this.librarySource, stringLiteral.getOffset(), stringLiteral.getLength(), CompileTimeErrorCode.URI_WITH_INTERPOLATION, new Object[0]));
            return null;
        }
        String string = stringLiteral.getStringValue().trim();
        this.directiveUris.put(uriBasedDirective, string);
        string = UriUtilities.encode(string);
        if (uriBasedDirective instanceof ImportDirective && string.startsWith(DART_EXT_SCHEME)) {
            this.libraryElement.setHasExtUri(true);
            return null;
        }
        try {
            new URI(string);
            Source source = this.analysisContext.getSourceFactory().resolveUri(this.librarySource, string);
            if (!this.analysisContext.exists(source)) {
                this.errorListener.onError(new AnalysisError(this.librarySource, stringLiteral.getOffset(), stringLiteral.getLength(), CompileTimeErrorCode.URI_DOES_NOT_EXIST, string));
            }
            return source;
        }
        catch (URISyntaxException uRISyntaxException) {
            this.errorListener.onError(new AnalysisError(this.librarySource, stringLiteral.getOffset(), stringLiteral.getLength(), CompileTimeErrorCode.INVALID_URI, string));
            return null;
        }
    }

    public String getUri(UriBasedDirective uriBasedDirective) {
        return this.directiveUris.get(uriBasedDirective);
    }

    public void setDefiningCompilationUnit(long l, CompilationUnit compilationUnit) {
        this.astMap.put(this.librarySource, new ResolvableCompilationUnit(l, compilationUnit));
    }

    public void setExplicitlyImportsCore(boolean bl) {
        this.explicitlyImportsCore = bl;
    }

    public void setExportedLibraries(Library[] libraryArray) {
        this.exportedLibraries = libraryArray;
    }

    public void setImportedLibraries(Library[] libraryArray) {
        this.importedLibraries = libraryArray;
    }

    public void setLibraryElement(LibraryElementImpl libraryElementImpl) {
        this.libraryElement = libraryElementImpl;
        if (this.inheritanceManager != null) {
            this.inheritanceManager.setLibraryElement(libraryElementImpl);
        }
    }

    public String toString() {
        return this.librarySource.getShortName();
    }
}

