/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.error.StaticTypeWarningCode;
import com.google.dart.engine.error.StaticWarningCode;
import com.google.dart.engine.internal.element.ExecutableElementImpl;
import com.google.dart.engine.internal.element.MultiplyInheritedMethodElementImpl;
import com.google.dart.engine.internal.element.MultiplyInheritedPropertyAccessorElementImpl;
import com.google.dart.engine.internal.element.ParameterElementImpl;
import com.google.dart.engine.internal.element.PropertyAccessorElementImpl;
import com.google.dart.engine.internal.element.member.MethodMember;
import com.google.dart.engine.internal.element.member.PropertyAccessorMember;
import com.google.dart.engine.internal.resolver.MemberMap;
import com.google.dart.engine.internal.type.DynamicTypeImpl;
import com.google.dart.engine.internal.type.FunctionTypeImpl;
import com.google.dart.engine.scanner.StringToken;
import com.google.dart.engine.scanner.TokenType;
import com.google.dart.engine.type.FunctionType;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;
import com.google.dart.engine.utilities.dart.ParameterKind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class InheritanceManager {
    private LibraryElement library;
    private HashMap<ClassElement, MemberMap> classLookup;
    private HashMap<ClassElement, MemberMap> interfaceLookup;
    private HashMap<ClassElement, HashSet<AnalysisError>> errorsInClassElement = new HashMap();

    private static ExecutableElement computeMergedExecutableElement(ExecutableElement[] executableElementArray) {
        int n = InheritanceManager.getNumOfPositionalParameters(executableElementArray[0]);
        int n2 = InheritanceManager.getNumOfRequiredParameters(executableElementArray[0]);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 1; i < executableElementArray.length; ++i) {
            int n3;
            ExecutableElement executableElement = executableElementArray[i];
            int n4 = InheritanceManager.getNumOfPositionalParameters(executableElement);
            if (n < n4) {
                n = n4;
            }
            if (n2 > (n3 = InheritanceManager.getNumOfRequiredParameters(executableElement))) {
                n2 = n3;
            }
            hashSet.addAll(InheritanceManager.getNamedParameterNames(executableElement));
        }
        if (n2 > n) {
            return null;
        }
        return InheritanceManager.createSyntheticExecutableElement(executableElementArray, executableElementArray[0].getDisplayName(), n2, n - n2, hashSet.toArray(new String[hashSet.size()]));
    }

    private static ExecutableElement createSyntheticExecutableElement(ExecutableElement[] executableElementArray, String string, int n, int n2, String ... stringArray) {
        ParameterElementImpl parameterElementImpl;
        ExecutableElementImpl executableElementImpl;
        ExecutableElementImpl executableElementImpl2;
        DynamicTypeImpl dynamicTypeImpl = DynamicTypeImpl.getInstance();
        SimpleIdentifier simpleIdentifier = new SimpleIdentifier(new StringToken(TokenType.IDENTIFIER, string, 0));
        if (executableElementArray[0] instanceof MethodElement) {
            executableElementImpl2 = new MultiplyInheritedMethodElementImpl(simpleIdentifier);
            ((MultiplyInheritedMethodElementImpl)executableElementImpl2).setInheritedElements(executableElementArray);
            executableElementImpl = executableElementImpl2;
        } else {
            executableElementImpl2 = new MultiplyInheritedPropertyAccessorElementImpl(simpleIdentifier);
            ((PropertyAccessorElementImpl)executableElementImpl2).setGetter(((PropertyAccessorElement)executableElementArray[0]).isGetter());
            ((PropertyAccessorElementImpl)executableElementImpl2).setSetter(((PropertyAccessorElement)executableElementArray[0]).isSetter());
            ((MultiplyInheritedPropertyAccessorElementImpl)executableElementImpl2).setInheritedElements(executableElementArray);
            executableElementImpl = executableElementImpl2;
        }
        int n3 = n + n2 + stringArray.length;
        ParameterElement[] parameterElementArray = new ParameterElement[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            parameterElementImpl = new ParameterElementImpl("", 0);
            parameterElementImpl.setType(dynamicTypeImpl);
            parameterElementImpl.setParameterKind(ParameterKind.REQUIRED);
            parameterElementArray[n4] = parameterElementImpl;
            ++n5;
            ++n4;
        }
        n5 = 0;
        while (n5 < n2) {
            parameterElementImpl = new ParameterElementImpl("", 0);
            parameterElementImpl.setType(dynamicTypeImpl);
            parameterElementImpl.setParameterKind(ParameterKind.POSITIONAL);
            parameterElementArray[n4] = parameterElementImpl;
            ++n5;
            ++n4;
        }
        n5 = 0;
        while (n5 < stringArray.length) {
            parameterElementImpl = new ParameterElementImpl(stringArray[n5], 0);
            parameterElementImpl.setType(dynamicTypeImpl);
            parameterElementImpl.setParameterKind(ParameterKind.NAMED);
            parameterElementArray[n4] = parameterElementImpl;
            ++n5;
            ++n4;
        }
        executableElementImpl.setReturnType(dynamicTypeImpl);
        executableElementImpl.setParameters(parameterElementArray);
        FunctionTypeImpl functionTypeImpl = new FunctionTypeImpl(executableElementImpl);
        executableElementImpl.setType(functionTypeImpl);
        return executableElementImpl;
    }

    private static List<String> getNamedParameterNames(ExecutableElement executableElement) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ParameterElement[] parameterElementArray = executableElement.getParameters();
        for (int i = 0; i < parameterElementArray.length; ++i) {
            ParameterElement parameterElement = parameterElementArray[i];
            if (parameterElement.getParameterKind() != ParameterKind.NAMED) continue;
            arrayList.add(parameterElement.getName());
        }
        return arrayList;
    }

    private static int getNumOfParameters(ExecutableElement executableElement, ParameterKind parameterKind) {
        int n = 0;
        ParameterElement[] parameterElementArray = executableElement.getParameters();
        for (int i = 0; i < parameterElementArray.length; ++i) {
            ParameterElement parameterElement = parameterElementArray[i];
            if (parameterElement.getParameterKind() != parameterKind) continue;
            ++n;
        }
        return n;
    }

    private static int getNumOfPositionalParameters(ExecutableElement executableElement) {
        return InheritanceManager.getNumOfParameters(executableElement, ParameterKind.REQUIRED) + InheritanceManager.getNumOfParameters(executableElement, ParameterKind.POSITIONAL);
    }

    private static int getNumOfRequiredParameters(ExecutableElement executableElement) {
        return InheritanceManager.getNumOfParameters(executableElement, ParameterKind.REQUIRED);
    }

    private static boolean isAbstract(ExecutableElement executableElement) {
        if (executableElement instanceof MethodElement) {
            return ((MethodElement)executableElement).isAbstract();
        }
        if (executableElement instanceof PropertyAccessorElement) {
            return ((PropertyAccessorElement)executableElement).isAbstract();
        }
        return false;
    }

    public InheritanceManager(LibraryElement libraryElement) {
        this.library = libraryElement;
        this.classLookup = new HashMap();
        this.interfaceLookup = new HashMap();
    }

    public HashSet<AnalysisError> getErrors(ClassElement classElement) {
        return this.errorsInClassElement.get(classElement);
    }

    public MemberMap getMapOfMembersInheritedFromClasses(ClassElement classElement) {
        return this.computeClassChainLookupMap(classElement, new HashSet<ClassElement>());
    }

    public MemberMap getMapOfMembersInheritedFromInterfaces(ClassElement classElement) {
        return this.computeInterfaceLookupMap(classElement, new HashSet<ClassElement>());
    }

    public ExecutableElement lookupInheritance(ClassElement classElement, String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        ExecutableElement executableElement = this.computeClassChainLookupMap(classElement, new HashSet<ClassElement>()).get(string);
        if (executableElement == null) {
            return this.computeInterfaceLookupMap(classElement, new HashSet<ClassElement>()).get(string);
        }
        return executableElement;
    }

    public ExecutableElement lookupMember(ClassElement classElement, String string) {
        ExecutableElement executableElement = this.lookupMemberInClass(classElement, string);
        if (executableElement != null) {
            return executableElement;
        }
        return this.lookupInheritance(classElement, string);
    }

    public FunctionType lookupMemberType(InterfaceType interfaceType, String string) {
        ExecutableElement executableElement = this.lookupMember(interfaceType.getElement(), string);
        if (executableElement == null) {
            return null;
        }
        return this.substituteTypeArgumentsInMemberFromInheritance(executableElement.getType(), string, interfaceType);
    }

    public void setLibraryElement(LibraryElement libraryElement) {
        this.library = libraryElement;
    }

    public FunctionType substituteTypeArgumentsInMemberFromInheritance(FunctionType functionType, String string, InterfaceType interfaceType) {
        if (functionType == null || functionType.getTypeArguments().length == 0) {
            return functionType;
        }
        LinkedList<InterfaceType> linkedList = new LinkedList<InterfaceType>();
        this.computeInheritancePath(linkedList, interfaceType, string);
        if (linkedList == null || linkedList.isEmpty()) {
            return functionType;
        }
        FunctionType functionType2 = functionType;
        while (!linkedList.isEmpty()) {
            InterfaceType interfaceType2 = linkedList.removeLast();
            Type[] typeArray = interfaceType2.getElement().getType().getTypeArguments();
            Type[] typeArray2 = interfaceType2.getTypeArguments();
            functionType2 = functionType2.substitute(typeArray2, typeArray);
        }
        return functionType2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemberMap computeClassChainLookupMap(ClassElement classElement, HashSet<ClassElement> hashSet) {
        MemberMap memberMap = this.classLookup.get(classElement);
        if (memberMap != null) {
            return memberMap;
        }
        memberMap = new MemberMap();
        ClassElement classElement2 = null;
        InterfaceType interfaceType = classElement.getSupertype();
        if (interfaceType == null) {
            this.classLookup.put(classElement, memberMap);
            return memberMap;
        }
        classElement2 = interfaceType.getElement();
        if (classElement2 != null) {
            if (!hashSet.contains(classElement2)) {
                hashSet.add(classElement2);
                try {
                    memberMap = new MemberMap(this.computeClassChainLookupMap(classElement2, hashSet));
                    this.substituteTypeParametersDownHierarchy(interfaceType, memberMap);
                    this.recordMapWithClassMembers(memberMap, interfaceType, false);
                }
                finally {
                    hashSet.remove(classElement2);
                }
            } else {
                this.classLookup.put(classElement2, memberMap);
                return memberMap;
            }
        }
        InterfaceType[] interfaceTypeArray = classElement.getMixins();
        for (int i = interfaceTypeArray.length - 1; i >= 0; --i) {
            ClassElement classElement3 = interfaceTypeArray[i].getElement();
            if (classElement3 == null) continue;
            if (!hashSet.contains(classElement3)) {
                hashSet.add(classElement3);
                try {
                    MemberMap memberMap2 = new MemberMap(this.computeClassChainLookupMap(classElement3, hashSet));
                    this.substituteTypeParametersDownHierarchy(interfaceTypeArray[i], memberMap2);
                    this.recordMapWithClassMembers(memberMap2, interfaceTypeArray[i], false);
                    for (int j = 0; j < memberMap2.getSize(); ++j) {
                        String string = memberMap2.getKey(j);
                        ExecutableElement executableElement = memberMap2.getValue(j);
                        if (string == null || memberMap.get(string) != null && (memberMap.get(string) == null || InheritanceManager.isAbstract(executableElement))) continue;
                        memberMap.put(string, executableElement);
                    }
                    continue;
                }
                finally {
                    hashSet.remove(classElement3);
                }
            }
            this.classLookup.put(classElement3, memberMap);
            return memberMap;
        }
        this.classLookup.put(classElement, memberMap);
        return memberMap;
    }

    private void computeInheritancePath(LinkedList<InterfaceType> linkedList, InterfaceType interfaceType, String string) {
        InterfaceType[] interfaceTypeArray;
        linkedList.add(interfaceType);
        ClassElement classElement = interfaceType.getElement();
        InterfaceType interfaceType2 = classElement.getSupertype();
        if (interfaceType2 == null) {
            return;
        }
        if (linkedList.size() != 1 && this.lookupMemberInClass(classElement, string) != null) {
            return;
        }
        InterfaceType[] interfaceTypeArray2 = classElement.getMixins();
        for (int i = interfaceTypeArray2.length - 1; i >= 0; --i) {
            InterfaceType[] interfaceTypeArray3;
            interfaceTypeArray = interfaceTypeArray2[i].getElement();
            if (interfaceTypeArray == null || (interfaceTypeArray3 = this.lookupMemberInClass((ClassElement)interfaceTypeArray, string)) == null) continue;
            linkedList.add(interfaceTypeArray2[i]);
            return;
        }
        ClassElement classElement2 = interfaceType2.getElement();
        if (this.lookupMember(classElement2, string) != null) {
            this.computeInheritancePath(linkedList, interfaceType2, string);
            return;
        }
        for (InterfaceType interfaceType3 : interfaceTypeArray = classElement.getInterfaces()) {
            ClassElement classElement3 = interfaceType3.getElement();
            if (classElement3 == null || this.lookupMember(classElement3, string) == null) continue;
            this.computeInheritancePath(linkedList, interfaceType3, string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private MemberMap computeInterfaceLookupMap(ClassElement classElement, HashSet<ClassElement> hashSet) {
        boolean bl;
        Object object;
        void memberMap3;
        MemberMap memberMap = this.interfaceLookup.get(classElement);
        if (memberMap != null) {
            return memberMap;
        }
        memberMap = new MemberMap();
        InterfaceType interfaceType = classElement.getSupertype();
        ClassElement classElement2 = interfaceType != null ? interfaceType.getElement() : null;
        InterfaceType[] interfaceTypeArray = classElement.getMixins();
        InterfaceType[] interfaceTypeArray2 = classElement.getInterfaces();
        ArrayList<Object> arrayList = new ArrayList<Object>(interfaceTypeArray2.length + interfaceTypeArray.length + 1);
        if (classElement2 != null) {
            MemberMap memberMap2;
            if (!hashSet.contains(classElement2)) {
                try {
                    hashSet.add(classElement2);
                    memberMap2 = this.computeInterfaceLookupMap(classElement2, hashSet);
                    memberMap2 = new MemberMap(memberMap2);
                    this.substituteTypeParametersDownHierarchy(interfaceType, memberMap2);
                    this.recordMapWithClassMembers(memberMap2, interfaceType, true);
                    arrayList.add(memberMap2);
                }
                finally {
                    hashSet.remove(classElement2);
                }
            } else {
                memberMap2 = this.interfaceLookup.get(classElement);
                if (memberMap2 != null) {
                    arrayList.add(memberMap2);
                } else {
                    this.interfaceLookup.put(classElement2, memberMap);
                    return memberMap;
                }
            }
        }
        for (int i = interfaceTypeArray.length - 1; i >= 0; --i) {
            InterfaceType interfaceType2 = interfaceTypeArray[i];
            ClassElement classElement3 = interfaceType2.getElement();
            if (classElement3 == null) continue;
            if (!hashSet.contains(classElement3)) {
                try {
                    hashSet.add(classElement3);
                    MemberMap string = this.computeInterfaceLookupMap(classElement3, hashSet);
                    string = new MemberMap(string);
                    this.substituteTypeParametersDownHierarchy(interfaceType2, string);
                    this.recordMapWithClassMembers(string, interfaceType2, true);
                    arrayList.add(string);
                    continue;
                }
                finally {
                    hashSet.remove(classElement3);
                }
            }
            MemberMap memberMap2 = this.interfaceLookup.get(classElement);
            if (memberMap2 != null) {
                arrayList.add(memberMap2);
                continue;
            }
            this.interfaceLookup.put(classElement3, memberMap);
            return memberMap;
        }
        Object hashMap = interfaceTypeArray2;
        int n = ((InterfaceType[])hashMap).length;
        boolean bl2 = false;
        while (memberMap3 < n) {
            InterfaceType interfaceType2 = hashMap[memberMap3];
            ClassElement classElement3 = interfaceType2.getElement();
            if (classElement3 != null) {
                if (!hashSet.contains(classElement3)) {
                    try {
                        hashSet.add(classElement3);
                        object = this.computeInterfaceLookupMap(classElement3, hashSet);
                        object = new MemberMap((MemberMap)object);
                        this.substituteTypeParametersDownHierarchy(interfaceType2, (MemberMap)object);
                        this.recordMapWithClassMembers((MemberMap)object, interfaceType2, true);
                        arrayList.add(object);
                    }
                    finally {
                        hashSet.remove(classElement3);
                    }
                } else {
                    object = this.interfaceLookup.get(classElement);
                    if (object != null) {
                        arrayList.add(object);
                    } else {
                        this.interfaceLookup.put(classElement3, memberMap);
                        return memberMap;
                    }
                }
            }
            ++memberMap3;
        }
        if (arrayList.size() == 0) {
            this.interfaceLookup.put(classElement, memberMap);
            return memberMap;
        }
        hashMap = new HashMap();
        for (MemberMap entry : arrayList) {
            int n2 = entry.getSize();
            for (int i = 0; i < n2 && (object = entry.getKey(i)) != null; ++i) {
                ArrayList<ExecutableElement> arrayList2 = (ArrayList<ExecutableElement>)((HashMap)hashMap).get(object);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<ExecutableElement>(4);
                    ((HashMap)hashMap).put(object, arrayList2);
                }
                ExecutableElement executableElement = entry.getValue(i);
                if (arrayList2.isEmpty()) {
                    arrayList2.add(executableElement);
                    continue;
                }
                bl = false;
                boolean bl3 = executableElement instanceof MethodElement;
                for (ExecutableElement executableElement2 : arrayList2) {
                    boolean bl4 = executableElement2 instanceof MethodElement;
                    if (bl3 != bl4 || !executableElement2.getType().equals(executableElement.getType())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList2.add(executableElement);
            }
        }
        for (Map.Entry entry : ((HashMap)hashMap).entrySet()) {
            String string = (String)entry.getKey();
            ArrayList arrayList3 = (ArrayList)entry.getValue();
            int n3 = arrayList3.size();
            if (n3 == 1) {
                memberMap.put(string, (ExecutableElement)arrayList3.get(0));
                continue;
            }
            boolean bl5 = true;
            boolean bl6 = true;
            bl = true;
            for (Object object2 : arrayList3) {
                if (object2 instanceof PropertyAccessorElement) {
                    bl5 = false;
                    if (((PropertyAccessorElement)object2).isSetter()) {
                        bl = false;
                        continue;
                    }
                    bl6 = false;
                    continue;
                }
                bl = false;
                bl6 = false;
            }
            if (bl5 || bl || bl6) {
                Object object3;
                void var20_48;
                Object object2;
                ExecutableElement[] executableElementArray = arrayList3.toArray(new ExecutableElement[n3]);
                object2 = new FunctionType[n3];
                boolean bl7 = false;
                while (var20_48 < n3) {
                    object2[var20_48] = executableElementArray[var20_48].getType();
                    ++var20_48;
                }
                ArrayList<Integer> arrayList4 = new ArrayList<Integer>(1);
                for (int i = 0; i < n3; ++i) {
                    object3 = object2[i];
                    if (object3 == null) continue;
                    boolean bl8 = true;
                    for (int j = 0; j < n3 && bl8; ++j) {
                        if (i == j || object3.isSubtypeOf(object2[j])) continue;
                        bl8 = false;
                        break;
                    }
                    if (!bl8) continue;
                    arrayList4.add(i);
                }
                if (arrayList4.size() == 1) {
                    memberMap.put(string, executableElementArray[(Integer)arrayList4.get(0)]);
                    continue;
                }
                if (arrayList4.isEmpty()) {
                    String string2 = object2[0].toString() + ", " + object2[1].toString();
                    this.reportError(classElement, classElement.getNameOffset(), classElement.getDisplayName().length(), StaticTypeWarningCode.INCONSISTENT_METHOD_INHERITANCE, string, string2);
                    continue;
                }
                ExecutableElement[] executableElementArray2 = new ExecutableElement[arrayList4.size()];
                for (int i = 0; i < executableElementArray2.length; ++i) {
                    executableElementArray2[i] = executableElementArray[(Integer)arrayList4.get(i)];
                }
                object3 = InheritanceManager.computeMergedExecutableElement(executableElementArray2);
                if (object3 == null) continue;
                memberMap.put(string, (ExecutableElement)object3);
                continue;
            }
            this.reportError(classElement, classElement.getNameOffset(), classElement.getDisplayName().length(), StaticWarningCode.INCONSISTENT_METHOD_INHERITANCE_GETTER_AND_METHOD, string);
        }
        this.interfaceLookup.put(classElement, memberMap);
        return memberMap;
    }

    private ExecutableElement lookupMemberInClass(ClassElement classElement, String string) {
        MethodElement[] methodElementArray = classElement.getMethods();
        ExecutableElement[] executableElementArray = methodElementArray;
        int n = executableElementArray.length;
        for (int i = 0; i < n; ++i) {
            MethodElement methodElement = executableElementArray[i];
            if (!string.equals(methodElement.getName()) || !methodElement.isAccessibleIn(this.library) || methodElement.isStatic()) continue;
            return methodElement;
        }
        for (ExecutableElement executableElement : executableElementArray = classElement.getAccessors()) {
            if (!string.equals(executableElement.getName()) || !executableElement.isAccessibleIn(this.library) || executableElement.isStatic()) continue;
            return executableElement;
        }
        return null;
    }

    private void recordMapWithClassMembers(MemberMap memberMap, InterfaceType interfaceType, boolean bl) {
        MethodElement[] methodElementArray = interfaceType.getMethods();
        ExecutableElement[] executableElementArray = methodElementArray;
        int n = executableElementArray.length;
        for (int i = 0; i < n; ++i) {
            MethodElement methodElement = executableElementArray[i];
            if (!methodElement.isAccessibleIn(this.library) || methodElement.isStatic() || !bl && methodElement.isAbstract()) continue;
            memberMap.put(methodElement.getName(), methodElement);
        }
        for (ExecutableElement executableElement : executableElementArray = interfaceType.getAccessors()) {
            if (!executableElement.isAccessibleIn(this.library) || executableElement.isStatic() || !bl && executableElement.isAbstract()) continue;
            memberMap.put(executableElement.getName(), executableElement);
        }
    }

    private void reportError(ClassElement classElement, int n, int n2, ErrorCode errorCode, Object ... objectArray) {
        HashSet<AnalysisError> hashSet = this.errorsInClassElement.get(classElement);
        if (hashSet == null) {
            hashSet = new HashSet();
            this.errorsInClassElement.put(classElement, hashSet);
        }
        hashSet.add(new AnalysisError(classElement.getSource(), n, n2, errorCode, objectArray));
    }

    private void substituteTypeParametersDownHierarchy(InterfaceType interfaceType, MemberMap memberMap) {
        for (int i = 0; i < memberMap.getSize(); ++i) {
            ExecutableElement executableElement = memberMap.getValue(i);
            if (executableElement instanceof MethodMember) {
                executableElement = MethodMember.from((MethodMember)executableElement, interfaceType);
                memberMap.setValue(i, executableElement);
                continue;
            }
            if (!(executableElement instanceof PropertyAccessorMember)) continue;
            executableElement = PropertyAccessorMember.from((PropertyAccessorMember)executableElement, interfaceType);
            memberMap.setValue(i, executableElement);
        }
    }
}

