/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.ClassTypeAlias;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.Declaration;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionTypeAlias;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.internal.resolver.DeclarationMatcher;
import com.google.dart.engine.internal.resolver.ProxyConditionalAnalysisError;
import com.google.dart.engine.internal.resolver.ResolverVisitor;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.internal.resolver.TypeResolverVisitor;
import com.google.dart.engine.internal.resolver.VariableResolverVisitor;
import com.google.dart.engine.internal.scope.Scope;
import com.google.dart.engine.internal.scope.ScopeBuilder;
import com.google.dart.engine.source.Source;

public class IncrementalResolver {
    private LibraryElement definingLibrary;
    private Source source;
    private TypeProvider typeProvider;
    private AnalysisErrorListener errorListener;

    public IncrementalResolver(LibraryElement libraryElement, Source source, TypeProvider typeProvider, AnalysisErrorListener analysisErrorListener) {
        this.definingLibrary = libraryElement;
        this.source = source;
        this.typeProvider = typeProvider;
        this.errorListener = analysisErrorListener;
    }

    public void resolve(AstNode astNode) throws AnalysisException {
        AstNode astNode2 = this.findResolutionRoot(astNode);
        Scope scope = ScopeBuilder.scopeFor(astNode2, this.errorListener);
        if (this.elementModelChanged(astNode2.getParent())) {
            throw new AnalysisException("Cannot resolve node: element model changed");
        }
        this.resolveTypes(astNode, scope);
        this.resolveVariables(astNode, scope);
        this.resolveReferences(astNode, scope);
    }

    private boolean canBeResolved(AstNode astNode) {
        return astNode instanceof ClassDeclaration || astNode instanceof ClassTypeAlias || astNode instanceof CompilationUnit || astNode instanceof ConstructorDeclaration || astNode instanceof FunctionDeclaration || astNode instanceof FunctionTypeAlias || astNode instanceof MethodDeclaration;
    }

    private boolean elementModelChanged(AstNode astNode) throws AnalysisException {
        Element element = this.getElement(astNode);
        if (element == null) {
            throw new AnalysisException("Cannot resolve node: a " + astNode.getClass().getSimpleName() + " does not define an element");
        }
        DeclarationMatcher declarationMatcher = new DeclarationMatcher();
        return !declarationMatcher.matches(astNode, element);
    }

    private AstNode findResolutionRoot(AstNode astNode) throws AnalysisException {
        AstNode astNode2 = astNode;
        AstNode astNode3 = astNode2.getParent();
        while (astNode3 != null && !this.canBeResolved(astNode3)) {
            astNode2 = astNode3;
            astNode3 = astNode2.getParent();
        }
        if (astNode3 == null) {
            throw new AnalysisException("Cannot resolve node: no resolvable node");
        }
        return astNode2;
    }

    private Element getElement(AstNode astNode) {
        if (astNode instanceof Declaration) {
            return ((Declaration)astNode).getElement();
        }
        if (astNode instanceof CompilationUnit) {
            return ((CompilationUnit)astNode).getElement();
        }
        return null;
    }

    private void resolveReferences(AstNode astNode, Scope scope) {
        ResolverVisitor resolverVisitor = new ResolverVisitor(this.definingLibrary, this.source, this.typeProvider, scope, this.errorListener);
        astNode.accept(resolverVisitor);
        for (ProxyConditionalAnalysisError proxyConditionalAnalysisError : resolverVisitor.getProxyConditionalAnalysisErrors()) {
            if (!proxyConditionalAnalysisError.shouldIncludeErrorCode()) continue;
            resolverVisitor.reportError(proxyConditionalAnalysisError.getAnalysisError());
        }
    }

    private void resolveTypes(AstNode astNode, Scope scope) {
        TypeResolverVisitor typeResolverVisitor = new TypeResolverVisitor(this.definingLibrary, this.source, this.typeProvider, scope, this.errorListener);
        astNode.accept(typeResolverVisitor);
    }

    private void resolveVariables(AstNode astNode, Scope scope) {
        VariableResolverVisitor variableResolverVisitor = new VariableResolverVisitor(this.definingLibrary, this.source, this.typeProvider, scope, this.errorListener);
        astNode.accept(variableResolverVisitor);
    }
}

