/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.ast.AnnotatedNode;
import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AssignmentExpression;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.BreakStatement;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.ClassTypeAlias;
import com.google.dart.engine.ast.Combinator;
import com.google.dart.engine.ast.CommentReference;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.ConstructorFieldInitializer;
import com.google.dart.engine.ast.ConstructorInitializer;
import com.google.dart.engine.ast.ConstructorName;
import com.google.dart.engine.ast.ContinueStatement;
import com.google.dart.engine.ast.DeclaredIdentifier;
import com.google.dart.engine.ast.ExportDirective;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.FieldDeclaration;
import com.google.dart.engine.ast.FieldFormalParameter;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionExpression;
import com.google.dart.engine.ast.FunctionExpressionInvocation;
import com.google.dart.engine.ast.FunctionTypeAlias;
import com.google.dart.engine.ast.FunctionTypedFormalParameter;
import com.google.dart.engine.ast.HideCombinator;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.IndexExpression;
import com.google.dart.engine.ast.InstanceCreationExpression;
import com.google.dart.engine.ast.LibraryDirective;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.MethodInvocation;
import com.google.dart.engine.ast.NamedExpression;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.NormalFormalParameter;
import com.google.dart.engine.ast.NullLiteral;
import com.google.dart.engine.ast.PartDirective;
import com.google.dart.engine.ast.PartOfDirective;
import com.google.dart.engine.ast.PostfixExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.PropertyAccess;
import com.google.dart.engine.ast.RedirectingConstructorInvocation;
import com.google.dart.engine.ast.ShowCombinator;
import com.google.dart.engine.ast.SimpleFormalParameter;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.SuperConstructorInvocation;
import com.google.dart.engine.ast.SuperExpression;
import com.google.dart.engine.ast.TopLevelVariableDeclaration;
import com.google.dart.engine.ast.TypeParameter;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.VariableDeclarationList;
import com.google.dart.engine.ast.visitor.SimpleAstVisitor;
import com.google.dart.engine.context.AnalysisOptions;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.ExportElement;
import com.google.dart.engine.element.FieldElement;
import com.google.dart.engine.element.ImportElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.MultiplyDefinedElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.PrefixElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.PropertyInducingElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.error.HintCode;
import com.google.dart.engine.error.StaticTypeWarningCode;
import com.google.dart.engine.error.StaticWarningCode;
import com.google.dart.engine.internal.element.AuxiliaryElements;
import com.google.dart.engine.internal.element.ClassElementImpl;
import com.google.dart.engine.internal.element.ConstructorElementImpl;
import com.google.dart.engine.internal.element.ElementAnnotationImpl;
import com.google.dart.engine.internal.element.ElementImpl;
import com.google.dart.engine.internal.element.LabelElementImpl;
import com.google.dart.engine.internal.element.MultiplyDefinedElementImpl;
import com.google.dart.engine.internal.resolver.ResolverVisitor;
import com.google.dart.engine.internal.resolver.SubtypeManager;
import com.google.dart.engine.internal.resolver.TypePromotionManager;
import com.google.dart.engine.internal.scope.LabelScope;
import com.google.dart.engine.internal.scope.Namespace;
import com.google.dart.engine.internal.scope.NamespaceBuilder;
import com.google.dart.engine.internal.scope.Scope;
import com.google.dart.engine.internal.type.InterfaceTypeImpl;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.scanner.TokenType;
import com.google.dart.engine.type.FunctionType;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;
import com.google.dart.engine.type.TypeParameterType;
import com.google.dart.engine.utilities.dart.ParameterKind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ElementResolver
extends SimpleAstVisitor<Void> {
    private ResolverVisitor resolver;
    private LibraryElement definingLibrary;
    private boolean enableHints;
    private Type dynamicType;
    private Type typeType;
    private SubtypeManager subtypeManager;
    private TypePromotionManager promoteManager;
    public static final String CALL_METHOD_NAME = "call";
    public static final String NO_SUCH_METHOD_METHOD_NAME = "noSuchMethod";

    public static ClassElementImpl getTypeReference(Expression expression) {
        Element element;
        if (expression instanceof Identifier && (element = ((Identifier)expression).getStaticElement()) instanceof ClassElementImpl) {
            return (ClassElementImpl)element;
        }
        return null;
    }

    private static boolean isConstructorReturnType(SimpleIdentifier simpleIdentifier) {
        AstNode astNode = simpleIdentifier.getParent();
        if (astNode instanceof ConstructorDeclaration) {
            return ((ConstructorDeclaration)astNode).getReturnType() == simpleIdentifier;
        }
        return false;
    }

    private static boolean isFactoryConstructorReturnType(SimpleIdentifier simpleIdentifier) {
        AstNode astNode = simpleIdentifier.getParent();
        if (astNode instanceof ConstructorDeclaration) {
            ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)astNode;
            return constructorDeclaration.getReturnType() == simpleIdentifier && constructorDeclaration.getFactoryKeyword() != null;
        }
        return false;
    }

    private static boolean isSuperInValidContext(SuperExpression superExpression) {
        for (AstNode astNode = superExpression; astNode != null; astNode = astNode.getParent()) {
            if (astNode instanceof CompilationUnit) {
                return false;
            }
            if (astNode instanceof ConstructorDeclaration) {
                ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)astNode;
                return constructorDeclaration.getFactoryKeyword() == null;
            }
            if (astNode instanceof ConstructorFieldInitializer) {
                return false;
            }
            if (!(astNode instanceof MethodDeclaration)) continue;
            MethodDeclaration methodDeclaration = (MethodDeclaration)astNode;
            return !methodDeclaration.isStatic();
        }
        return false;
    }

    public ElementResolver(ResolverVisitor resolverVisitor) {
        this.resolver = resolverVisitor;
        this.definingLibrary = resolverVisitor.getDefiningLibrary();
        AnalysisOptions analysisOptions = this.definingLibrary.getContext().getAnalysisOptions();
        this.enableHints = analysisOptions.getHint();
        this.dynamicType = resolverVisitor.getTypeProvider().getDynamicType();
        this.typeType = resolverVisitor.getTypeProvider().getTypeType();
        this.subtypeManager = new SubtypeManager();
        this.promoteManager = resolverVisitor.getPromoteManager();
    }

    @Override
    public Void visitAssignmentExpression(AssignmentExpression assignmentExpression) {
        Token token = assignmentExpression.getOperator();
        TokenType tokenType = token.getType();
        if (tokenType != TokenType.EQ) {
            tokenType = this.operatorFromCompoundAssignment(tokenType);
            Expression expression = assignmentExpression.getLeftHandSide();
            if (expression != null) {
                String string = tokenType.getLexeme();
                Type type = this.getStaticType(expression);
                MethodElement methodElement = this.lookUpMethod(expression, type, string);
                assignmentExpression.setStaticElement(methodElement);
                Type type2 = this.getPropagatedType(expression);
                MethodElement methodElement2 = this.lookUpMethod(expression, type2, string);
                assignmentExpression.setPropagatedElement(methodElement2);
                if (this.shouldReportMissingMember(type, methodElement)) {
                    this.resolver.reportProxyConditionalErrorForToken(type.getElement(), StaticTypeWarningCode.UNDEFINED_METHOD, token, string, type.getDisplayName());
                } else if (this.enableHints && this.shouldReportMissingMember(type2, methodElement2) && !this.memberFoundInSubclass(type2.getElement(), string, true, false)) {
                    this.resolver.reportProxyConditionalErrorForToken(type2.getElement(), HintCode.UNDEFINED_METHOD, token, string, type2.getDisplayName());
                }
            }
        }
        return null;
    }

    @Override
    public Void visitBinaryExpression(BinaryExpression binaryExpression) {
        Expression expression;
        Token token = binaryExpression.getOperator();
        if (token.isUserDefinableOperator() && (expression = binaryExpression.getLeftOperand()) != null) {
            String string = token.getLexeme();
            Type type = this.getStaticType(expression);
            MethodElement methodElement = this.lookUpMethod(expression, type, string);
            binaryExpression.setStaticElement(methodElement);
            Type type2 = this.getPropagatedType(expression);
            MethodElement methodElement2 = this.lookUpMethod(expression, type2, string);
            binaryExpression.setPropagatedElement(methodElement2);
            if (this.shouldReportMissingMember(type, methodElement)) {
                this.resolver.reportProxyConditionalErrorForToken(type.getElement(), StaticTypeWarningCode.UNDEFINED_OPERATOR, token, string, type.getDisplayName());
            } else if (this.enableHints && this.shouldReportMissingMember(type2, methodElement2) && !this.memberFoundInSubclass(type2.getElement(), string, true, false)) {
                this.resolver.reportProxyConditionalErrorForToken(type2.getElement(), HintCode.UNDEFINED_OPERATOR, token, string, type2.getDisplayName());
            }
        }
        return null;
    }

    @Override
    public Void visitBreakStatement(BreakStatement breakStatement) {
        this.lookupLabel(breakStatement, breakStatement.getLabel());
        return null;
    }

    @Override
    public Void visitClassDeclaration(ClassDeclaration classDeclaration) {
        this.setMetadata(classDeclaration.getElement(), classDeclaration);
        return null;
    }

    @Override
    public Void visitClassTypeAlias(ClassTypeAlias classTypeAlias) {
        this.setMetadata(classTypeAlias.getElement(), classTypeAlias);
        return null;
    }

    @Override
    public Void visitCommentReference(CommentReference commentReference) {
        Identifier identifier = commentReference.getIdentifier();
        if (identifier instanceof SimpleIdentifier) {
            SimpleIdentifier simpleIdentifier = (SimpleIdentifier)identifier;
            Element element = this.resolveSimpleIdentifier(simpleIdentifier);
            if (element == null && (element = this.findImportWithoutPrefix(simpleIdentifier)) instanceof MultiplyDefinedElement) {
                element = null;
            }
            if (element != null) {
                ConstructorElement constructorElement;
                if (element.getLibrary() == null || !element.getLibrary().equals(this.definingLibrary)) {
                    // empty if block
                }
                simpleIdentifier.setStaticElement(element);
                if (commentReference.getNewKeyword() != null && element instanceof ClassElement && (constructorElement = ((ClassElement)element).getUnnamedConstructor()) != null) {
                    simpleIdentifier.setStaticElement(constructorElement);
                }
            }
        } else if (identifier instanceof PrefixedIdentifier) {
            PrefixedIdentifier prefixedIdentifier = (PrefixedIdentifier)identifier;
            SimpleIdentifier simpleIdentifier = prefixedIdentifier.getPrefix();
            SimpleIdentifier simpleIdentifier2 = prefixedIdentifier.getIdentifier();
            Element element = this.resolveSimpleIdentifier(simpleIdentifier);
            if (element != null) {
                ConstructorElement constructorElement;
                if (element instanceof PrefixElement) {
                    simpleIdentifier.setStaticElement(element);
                    element = this.resolver.getNameScope().lookup(identifier, this.definingLibrary);
                    simpleIdentifier2.setStaticElement(element);
                    return null;
                }
                LibraryElement libraryElement = element.getLibrary();
                if (libraryElement == null) {
                    AnalysisEngine.getInstance().getLogger().logError("Found element with null library: " + element.getName());
                } else if (!libraryElement.equals(this.definingLibrary)) {
                    // empty if block
                }
                simpleIdentifier2.setStaticElement(element);
                if (commentReference.getNewKeyword() == null) {
                    if (element instanceof ClassElement) {
                        ExecutableElement executableElement = this.lookupGetterOrMethod(((ClassElement)element).getType(), simpleIdentifier2.getName());
                        if (executableElement == null && (executableElement = ((ClassElement)element).getNamedConstructor(simpleIdentifier2.getName())) == null) {
                            executableElement = this.lookUpSetter(simpleIdentifier, ((ClassElement)element).getType(), simpleIdentifier2.getName());
                        }
                        if (executableElement != null) {
                            simpleIdentifier2.setStaticElement(executableElement);
                        }
                    }
                } else if (element instanceof ClassElement && (constructorElement = ((ClassElement)element).getNamedConstructor(simpleIdentifier2.getName())) != null) {
                    simpleIdentifier2.setStaticElement(constructorElement);
                }
            }
        }
        return null;
    }

    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
        super.visitConstructorDeclaration(constructorDeclaration);
        ConstructorElement constructorElement = constructorDeclaration.getElement();
        if (constructorElement instanceof ConstructorElementImpl) {
            ConstructorElementImpl constructorElementImpl = (ConstructorElementImpl)constructorElement;
            ConstructorName constructorName = constructorDeclaration.getRedirectedConstructor();
            if (constructorName != null) {
                ConstructorElement constructorElement2 = constructorName.getStaticElement();
                constructorElementImpl.setRedirectedConstructor(constructorElement2);
            } else {
                for (ConstructorInitializer constructorInitializer : constructorDeclaration.getInitializers()) {
                    if (!(constructorInitializer instanceof RedirectingConstructorInvocation)) continue;
                    ConstructorElement constructorElement3 = ((RedirectingConstructorInvocation)constructorInitializer).getStaticElement();
                    constructorElementImpl.setRedirectedConstructor(constructorElement3);
                }
            }
            this.setMetadata(constructorElementImpl, constructorDeclaration);
        }
        return null;
    }

    @Override
    public Void visitConstructorFieldInitializer(ConstructorFieldInitializer constructorFieldInitializer) {
        SimpleIdentifier simpleIdentifier = constructorFieldInitializer.getFieldName();
        ClassElement classElement = this.resolver.getEnclosingClass();
        FieldElement fieldElement = classElement.getField(simpleIdentifier.getName());
        simpleIdentifier.setStaticElement(fieldElement);
        return null;
    }

    @Override
    public Void visitConstructorName(ConstructorName constructorName) {
        ConstructorElement constructorElement;
        Type type = constructorName.getType().getType();
        if (type != null && type.isDynamic()) {
            return null;
        }
        if (!(type instanceof InterfaceType)) {
            return null;
        }
        SimpleIdentifier simpleIdentifier = constructorName.getName();
        InterfaceType interfaceType = (InterfaceType)type;
        if (simpleIdentifier == null) {
            constructorElement = interfaceType.lookUpConstructor(null, this.definingLibrary);
        } else {
            constructorElement = interfaceType.lookUpConstructor(simpleIdentifier.getName(), this.definingLibrary);
            simpleIdentifier.setStaticElement(constructorElement);
        }
        constructorName.setStaticElement(constructorElement);
        return null;
    }

    @Override
    public Void visitContinueStatement(ContinueStatement continueStatement) {
        this.lookupLabel(continueStatement, continueStatement.getLabel());
        return null;
    }

    @Override
    public Void visitDeclaredIdentifier(DeclaredIdentifier declaredIdentifier) {
        this.setMetadata(declaredIdentifier.getElement(), declaredIdentifier);
        return null;
    }

    @Override
    public Void visitExportDirective(ExportDirective exportDirective) {
        ExportElement exportElement = exportDirective.getElement();
        if (exportElement != null) {
            this.resolveCombinators(exportElement.getExportedLibrary(), exportDirective.getCombinators());
            this.setMetadata(exportElement, exportDirective);
        }
        return null;
    }

    @Override
    public Void visitFieldFormalParameter(FieldFormalParameter fieldFormalParameter) {
        this.setMetadataForParameter(fieldFormalParameter.getElement(), fieldFormalParameter);
        return (Void)super.visitFieldFormalParameter(fieldFormalParameter);
    }

    @Override
    public Void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        this.setMetadata(functionDeclaration.getElement(), functionDeclaration);
        return null;
    }

    @Override
    public Void visitFunctionExpressionInvocation(FunctionExpressionInvocation functionExpressionInvocation) {
        Expression expression = functionExpressionInvocation.getFunction();
        if (expression instanceof FunctionExpression) {
            FunctionExpression functionExpression = (FunctionExpression)expression;
            ExecutableElement executableElement = functionExpression.getElement();
            ArgumentList argumentList = functionExpressionInvocation.getArgumentList();
            ParameterElement[] parameterElementArray = this.resolveArgumentsToFunction(false, argumentList, executableElement);
            if (parameterElementArray != null) {
                argumentList.setCorrespondingStaticParameters(parameterElementArray);
            }
        }
        return null;
    }

    @Override
    public Void visitFunctionTypeAlias(FunctionTypeAlias functionTypeAlias) {
        this.setMetadata(functionTypeAlias.getElement(), functionTypeAlias);
        return null;
    }

    @Override
    public Void visitFunctionTypedFormalParameter(FunctionTypedFormalParameter functionTypedFormalParameter) {
        this.setMetadataForParameter(functionTypedFormalParameter.getElement(), functionTypedFormalParameter);
        return null;
    }

    @Override
    public Void visitImportDirective(ImportDirective importDirective) {
        Object object;
        SimpleIdentifier simpleIdentifier = importDirective.getPrefix();
        if (simpleIdentifier != null) {
            object = simpleIdentifier.getName();
            for (PrefixElement prefixElement : this.definingLibrary.getPrefixes()) {
                if (!prefixElement.getDisplayName().equals(object)) continue;
                simpleIdentifier.setStaticElement(prefixElement);
                break;
            }
        }
        if ((object = importDirective.getElement()) != null) {
            LibraryElement libraryElement = object.getImportedLibrary();
            if (libraryElement != null) {
                this.resolveCombinators(libraryElement, importDirective.getCombinators());
            }
            this.setMetadata((Element)object, importDirective);
        }
        return null;
    }

    @Override
    public Void visitIndexExpression(IndexExpression indexExpression) {
        Expression expression = indexExpression.getRealTarget();
        Type type = this.getStaticType(expression);
        Type type2 = this.getPropagatedType(expression);
        String string = TokenType.INDEX.getLexeme();
        String string2 = TokenType.INDEX_EQ.getLexeme();
        boolean bl = indexExpression.inGetterContext();
        boolean bl2 = indexExpression.inSetterContext();
        if (bl && bl2) {
            MethodElement methodElement = this.lookUpMethod(expression, type, string2);
            MethodElement methodElement2 = this.lookUpMethod(expression, type2, string2);
            indexExpression.setStaticElement(methodElement);
            indexExpression.setPropagatedElement(methodElement2);
            this.checkForUndefinedIndexOperator(indexExpression, expression, string, methodElement, methodElement2, type, type2);
            MethodElement methodElement3 = this.lookUpMethod(expression, type, string);
            MethodElement methodElement4 = this.lookUpMethod(expression, type2, string);
            AuxiliaryElements auxiliaryElements = new AuxiliaryElements(methodElement3, methodElement4);
            indexExpression.setAuxiliaryElements(auxiliaryElements);
            this.checkForUndefinedIndexOperator(indexExpression, expression, string, methodElement3, methodElement4, type, type2);
        } else if (bl) {
            MethodElement methodElement = this.lookUpMethod(expression, type, string);
            MethodElement methodElement5 = this.lookUpMethod(expression, type2, string);
            indexExpression.setStaticElement(methodElement);
            indexExpression.setPropagatedElement(methodElement5);
            this.checkForUndefinedIndexOperator(indexExpression, expression, string, methodElement, methodElement5, type, type2);
        } else if (bl2) {
            MethodElement methodElement = this.lookUpMethod(expression, type, string2);
            MethodElement methodElement6 = this.lookUpMethod(expression, type2, string2);
            indexExpression.setStaticElement(methodElement);
            indexExpression.setPropagatedElement(methodElement6);
            this.checkForUndefinedIndexOperator(indexExpression, expression, string2, methodElement, methodElement6, type, type2);
        }
        return null;
    }

    @Override
    public Void visitInstanceCreationExpression(InstanceCreationExpression instanceCreationExpression) {
        ConstructorElement constructorElement = instanceCreationExpression.getConstructorName().getStaticElement();
        instanceCreationExpression.setStaticElement(constructorElement);
        ArgumentList argumentList = instanceCreationExpression.getArgumentList();
        ParameterElement[] parameterElementArray = this.resolveArgumentsToFunction(instanceCreationExpression.isConst(), argumentList, constructorElement);
        if (parameterElementArray != null) {
            argumentList.setCorrespondingStaticParameters(parameterElementArray);
        }
        return null;
    }

    @Override
    public Void visitLibraryDirective(LibraryDirective libraryDirective) {
        this.setMetadata(libraryDirective.getElement(), libraryDirective);
        return null;
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        this.setMetadata(methodDeclaration.getElement(), methodDeclaration);
        return null;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocation methodInvocation) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Element element;
        Element element2;
        SimpleIdentifier simpleIdentifier = methodInvocation.getMethodName();
        if (simpleIdentifier.isSynthetic()) {
            return null;
        }
        Expression expression = methodInvocation.getRealTarget();
        if (expression instanceof SuperExpression && !ElementResolver.isSuperInValidContext((SuperExpression)expression)) {
            return null;
        }
        if (expression == null) {
            element2 = this.resolveInvokedElement(simpleIdentifier);
            element = null;
        } else {
            object5 = this.getStaticType(expression);
            object4 = ElementResolver.getTypeReference(expression);
            if (object4 != null) {
                element2 = element = this.resolveElement((ClassElementImpl)object4, simpleIdentifier);
            } else {
                element2 = this.resolveInvokedElementWithTarget(expression, (Type)object5, simpleIdentifier);
                element = this.resolveInvokedElementWithTarget(expression, this.getPropagatedType(expression), simpleIdentifier);
            }
        }
        element2 = this.convertSetterToGetter(element2);
        element = this.convertSetterToGetter(element);
        simpleIdentifier.setStaticElement(element2);
        simpleIdentifier.setPropagatedElement(element);
        object5 = methodInvocation.getArgumentList();
        if (element2 != null && (object4 = this.computeCorrespondingParameters((ArgumentList)object5, element2)) != null) {
            ((ArgumentList)object5).setCorrespondingStaticParameters((ParameterElement[])object4);
        }
        if (element != null && (object4 = this.computeCorrespondingParameters((ArgumentList)object5, element)) != null) {
            ((ArgumentList)object5).setCorrespondingPropagatedParameters((ParameterElement[])object4);
        }
        object4 = this.checkForInvocationError(expression, true, element2);
        boolean bl = false;
        if (this.enableHints && object4 == null && element2 == null) {
            object4 = this.checkForInvocationError(expression, false, element);
            if (object4 == StaticTypeWarningCode.UNDEFINED_METHOD) {
                object3 = null;
                if (expression == null) {
                    object3 = this.resolver.getEnclosingClass();
                } else {
                    object2 = expression.getBestType();
                    if (object2 != null && object2.getElement() instanceof ClassElement) {
                        object3 = (ClassElement)object2.getElement();
                    }
                }
                if (object3 != null) {
                    this.subtypeManager.ensureLibraryVisited(this.definingLibrary);
                    object2 = this.subtypeManager.computeAllSubtypes((ClassElement)object3);
                    object = ((HashSet)object2).iterator();
                    while (object.hasNext()) {
                        ClassElement classElement = (ClassElement)object.next();
                        if (classElement.getMethod(simpleIdentifier.getName()) == null) continue;
                        object4 = null;
                    }
                }
            }
            bl = true;
        }
        if (object4 == null) {
            return null;
        }
        if (object4 == StaticTypeWarningCode.INVOCATION_OF_NON_FUNCTION) {
            this.resolver.reportErrorForNode(StaticTypeWarningCode.INVOCATION_OF_NON_FUNCTION, simpleIdentifier, simpleIdentifier.getName());
        } else if (object4 == CompileTimeErrorCode.UNDEFINED_FUNCTION) {
            this.resolver.reportErrorForNode(CompileTimeErrorCode.UNDEFINED_FUNCTION, simpleIdentifier, simpleIdentifier.getName());
        } else if (object4 == StaticTypeWarningCode.UNDEFINED_METHOD) {
            if (expression == null) {
                object2 = this.resolver.getEnclosingClass();
                object3 = object2.getDisplayName();
                object = bl ? HintCode.UNDEFINED_METHOD : StaticTypeWarningCode.UNDEFINED_METHOD;
                this.resolver.reportProxyConditionalErrorForNode(this.resolver.getEnclosingClass(), (ErrorCode)object, simpleIdentifier, simpleIdentifier.getName(), object3);
            } else {
                object2 = null;
                if (!bl) {
                    object2 = this.getStaticType(expression);
                } else {
                    object2 = this.getPropagatedType(expression);
                    if (object2 == null) {
                        object2 = this.getStaticType(expression);
                    }
                }
                if (object2 != null && object2.isDartCoreFunction() && simpleIdentifier.getName().equals(CALL_METHOD_NAME)) {
                    return null;
                }
                object3 = object2 == null ? null : object2.getDisplayName();
                object = bl ? HintCode.UNDEFINED_METHOD : StaticTypeWarningCode.UNDEFINED_METHOD;
                this.resolver.reportProxyConditionalErrorForNode(object2.getElement(), (ErrorCode)object, simpleIdentifier, simpleIdentifier.getName(), object3);
            }
        } else if (object4 == StaticTypeWarningCode.UNDEFINED_SUPER_METHOD) {
            object3 = this.getStaticType(expression);
            object2 = object3 == null ? null : object3.getName();
            this.resolver.reportErrorForNode(StaticTypeWarningCode.UNDEFINED_SUPER_METHOD, simpleIdentifier, simpleIdentifier.getName(), object2);
        }
        return null;
    }

    @Override
    public Void visitPartDirective(PartDirective partDirective) {
        this.setMetadata(partDirective.getElement(), partDirective);
        return null;
    }

    @Override
    public Void visitPartOfDirective(PartOfDirective partOfDirective) {
        this.setMetadata(partOfDirective.getElement(), partOfDirective);
        return null;
    }

    @Override
    public Void visitPostfixExpression(PostfixExpression postfixExpression) {
        Expression expression = postfixExpression.getOperand();
        String string = this.getPostfixOperator(postfixExpression);
        Type type = this.getStaticType(expression);
        MethodElement methodElement = this.lookUpMethod(expression, type, string);
        postfixExpression.setStaticElement(methodElement);
        Type type2 = this.getPropagatedType(expression);
        MethodElement methodElement2 = this.lookUpMethod(expression, type2, string);
        postfixExpression.setPropagatedElement(methodElement2);
        if (this.shouldReportMissingMember(type, methodElement)) {
            this.resolver.reportProxyConditionalErrorForToken(type.getElement(), StaticTypeWarningCode.UNDEFINED_OPERATOR, postfixExpression.getOperator(), string, type.getDisplayName());
        } else if (this.enableHints && this.shouldReportMissingMember(type2, methodElement2) && !this.memberFoundInSubclass(type2.getElement(), string, true, false)) {
            this.resolver.reportProxyConditionalErrorForToken(type2.getElement(), HintCode.UNDEFINED_OPERATOR, postfixExpression.getOperator(), string, type2.getDisplayName());
        }
        return null;
    }

    @Override
    public Void visitPrefixedIdentifier(PrefixedIdentifier prefixedIdentifier) {
        SimpleIdentifier simpleIdentifier = prefixedIdentifier.getPrefix();
        SimpleIdentifier simpleIdentifier2 = prefixedIdentifier.getIdentifier();
        Element element = simpleIdentifier.getStaticElement();
        if (element instanceof PrefixElement) {
            PropertyAccessorElement propertyAccessorElement;
            Object object;
            Element element2 = this.resolver.getNameScope().lookup(prefixedIdentifier, this.definingLibrary);
            if (element2 == null && simpleIdentifier2.inSetterContext()) {
                element2 = this.resolver.getNameScope().lookup(new SyntheticIdentifier(prefixedIdentifier.getName() + "="), this.definingLibrary);
            }
            if (element2 == null) {
                if (simpleIdentifier2.inSetterContext()) {
                    this.resolver.reportErrorForNode(StaticWarningCode.UNDEFINED_SETTER, simpleIdentifier2, simpleIdentifier2.getName(), element.getName());
                } else {
                    if (prefixedIdentifier.getParent() instanceof Annotation) {
                        Annotation annotation = (Annotation)prefixedIdentifier.getParent();
                        this.resolver.reportErrorForNode(CompileTimeErrorCode.INVALID_ANNOTATION, annotation, new Object[0]);
                        return null;
                    }
                    this.resolver.reportErrorForNode(StaticWarningCode.UNDEFINED_GETTER, simpleIdentifier2, simpleIdentifier2.getName(), element.getName());
                }
                return null;
            }
            if (element2 instanceof PropertyAccessorElement && simpleIdentifier2.inSetterContext() && (object = ((PropertyAccessorElement)element2).getVariable()) != null && (propertyAccessorElement = object.getSetter()) != null) {
                element2 = propertyAccessorElement;
            }
            simpleIdentifier2.setStaticElement(element2);
            if (prefixedIdentifier.getParent() instanceof Annotation) {
                object = (Annotation)prefixedIdentifier.getParent();
                this.resolveAnnotationElement((Annotation)object);
                return null;
            }
            return null;
        }
        if (prefixedIdentifier.getParent() instanceof Annotation) {
            Annotation annotation = (Annotation)prefixedIdentifier.getParent();
            this.resolveAnnotationElement(annotation);
        }
        this.resolvePropertyAccess(simpleIdentifier, simpleIdentifier2);
        return null;
    }

    @Override
    public Void visitPrefixExpression(PrefixExpression prefixExpression) {
        Token token = prefixExpression.getOperator();
        TokenType tokenType = token.getType();
        if (tokenType.isUserDefinableOperator() || tokenType == TokenType.PLUS_PLUS || tokenType == TokenType.MINUS_MINUS) {
            Expression expression = prefixExpression.getOperand();
            String string = this.getPrefixOperator(prefixExpression);
            Type type = this.getStaticType(expression);
            MethodElement methodElement = this.lookUpMethod(expression, type, string);
            prefixExpression.setStaticElement(methodElement);
            Type type2 = this.getPropagatedType(expression);
            MethodElement methodElement2 = this.lookUpMethod(expression, type2, string);
            prefixExpression.setPropagatedElement(methodElement2);
            if (this.shouldReportMissingMember(type, methodElement)) {
                this.resolver.reportProxyConditionalErrorForToken(type.getElement(), StaticTypeWarningCode.UNDEFINED_OPERATOR, token, string, type.getDisplayName());
            } else if (this.enableHints && this.shouldReportMissingMember(type2, methodElement2) && !this.memberFoundInSubclass(type2.getElement(), string, true, false)) {
                this.resolver.reportProxyConditionalErrorForToken(type2.getElement(), HintCode.UNDEFINED_OPERATOR, token, string, type2.getDisplayName());
            }
        }
        return null;
    }

    @Override
    public Void visitPropertyAccess(PropertyAccess propertyAccess) {
        Expression expression = propertyAccess.getRealTarget();
        if (expression instanceof SuperExpression && !ElementResolver.isSuperInValidContext((SuperExpression)expression)) {
            return null;
        }
        SimpleIdentifier simpleIdentifier = propertyAccess.getPropertyName();
        this.resolvePropertyAccess(expression, simpleIdentifier);
        return null;
    }

    @Override
    public Void visitRedirectingConstructorInvocation(RedirectingConstructorInvocation redirectingConstructorInvocation) {
        ClassElement classElement = this.resolver.getEnclosingClass();
        if (classElement == null) {
            return null;
        }
        SimpleIdentifier simpleIdentifier = redirectingConstructorInvocation.getConstructorName();
        ConstructorElement constructorElement = simpleIdentifier == null ? classElement.getUnnamedConstructor() : classElement.getNamedConstructor(simpleIdentifier.getName());
        if (constructorElement == null) {
            return null;
        }
        if (simpleIdentifier != null) {
            simpleIdentifier.setStaticElement(constructorElement);
        }
        redirectingConstructorInvocation.setStaticElement(constructorElement);
        ArgumentList argumentList = redirectingConstructorInvocation.getArgumentList();
        ParameterElement[] parameterElementArray = this.resolveArgumentsToFunction(false, argumentList, constructorElement);
        if (parameterElementArray != null) {
            argumentList.setCorrespondingStaticParameters(parameterElementArray);
        }
        return null;
    }

    @Override
    public Void visitSimpleFormalParameter(SimpleFormalParameter simpleFormalParameter) {
        this.setMetadataForParameter(simpleFormalParameter.getElement(), simpleFormalParameter);
        return null;
    }

    @Override
    public Void visitSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
        Object object;
        if (simpleIdentifier.isSynthetic()) {
            return null;
        }
        if (simpleIdentifier.getStaticElement() != null) {
            return null;
        }
        if (simpleIdentifier.getName().equals(this.dynamicType.getName())) {
            simpleIdentifier.setStaticElement(this.dynamicType.getElement());
            simpleIdentifier.setStaticType(this.typeType);
            return null;
        }
        Element element = this.resolveSimpleIdentifier(simpleIdentifier);
        ClassElement classElement = this.resolver.getEnclosingClass();
        if (ElementResolver.isFactoryConstructorReturnType(simpleIdentifier) && element != classElement) {
            this.resolver.reportErrorForNode(CompileTimeErrorCode.INVALID_FACTORY_NAME_NOT_A_CLASS, simpleIdentifier, new Object[0]);
        } else if (ElementResolver.isConstructorReturnType(simpleIdentifier) && element != classElement) {
            this.resolver.reportErrorForNode(CompileTimeErrorCode.INVALID_CONSTRUCTOR_NAME, simpleIdentifier, new Object[0]);
            element = null;
        } else if (element == null || element instanceof PrefixElement && !this.isValidAsPrefix(simpleIdentifier)) {
            if (ElementResolver.isConstructorReturnType(simpleIdentifier)) {
                this.resolver.reportErrorForNode(CompileTimeErrorCode.INVALID_CONSTRUCTOR_NAME, simpleIdentifier, new Object[0]);
            } else if (simpleIdentifier.getParent() instanceof Annotation) {
                object = (Annotation)simpleIdentifier.getParent();
                this.resolver.reportErrorForNode(CompileTimeErrorCode.INVALID_ANNOTATION, (AstNode)object, new Object[0]);
            } else {
                this.resolver.reportProxyConditionalErrorForNode(this.resolver.getEnclosingClass(), StaticWarningCode.UNDEFINED_IDENTIFIER, simpleIdentifier, simpleIdentifier.getName());
            }
        }
        simpleIdentifier.setStaticElement(element);
        if (simpleIdentifier.inSetterContext() && simpleIdentifier.inGetterContext() && classElement != null) {
            object = classElement.getType();
            AuxiliaryElements auxiliaryElements = new AuxiliaryElements(this.lookUpGetter(null, (Type)object, simpleIdentifier.getName()), null);
            simpleIdentifier.setAuxiliaryElements(auxiliaryElements);
        }
        if (simpleIdentifier.getParent() instanceof Annotation) {
            object = (Annotation)simpleIdentifier.getParent();
            this.resolveAnnotationElement((Annotation)object);
        }
        return null;
    }

    @Override
    public Void visitSuperConstructorInvocation(SuperConstructorInvocation superConstructorInvocation) {
        ClassElement classElement = this.resolver.getEnclosingClass();
        if (classElement == null) {
            return null;
        }
        InterfaceType interfaceType = classElement.getSupertype();
        if (interfaceType == null) {
            return null;
        }
        SimpleIdentifier simpleIdentifier = superConstructorInvocation.getConstructorName();
        String string = simpleIdentifier != null ? simpleIdentifier.getName() : null;
        ConstructorElement constructorElement = interfaceType.lookUpConstructor(string, this.definingLibrary);
        if (constructorElement == null) {
            if (simpleIdentifier != null) {
                this.resolver.reportErrorForNode(CompileTimeErrorCode.UNDEFINED_CONSTRUCTOR_IN_INITIALIZER, superConstructorInvocation, interfaceType.getDisplayName(), simpleIdentifier);
            } else {
                this.resolver.reportErrorForNode(CompileTimeErrorCode.UNDEFINED_CONSTRUCTOR_IN_INITIALIZER_DEFAULT, superConstructorInvocation, interfaceType.getDisplayName());
            }
            return null;
        }
        if (constructorElement.isFactory()) {
            this.resolver.reportErrorForNode(CompileTimeErrorCode.NON_GENERATIVE_CONSTRUCTOR, superConstructorInvocation, constructorElement);
        }
        if (simpleIdentifier != null) {
            simpleIdentifier.setStaticElement(constructorElement);
        }
        superConstructorInvocation.setStaticElement(constructorElement);
        ArgumentList argumentList = superConstructorInvocation.getArgumentList();
        ParameterElement[] parameterElementArray = this.resolveArgumentsToFunction(this.isInConstConstructor(), argumentList, constructorElement);
        if (parameterElementArray != null) {
            argumentList.setCorrespondingStaticParameters(parameterElementArray);
        }
        return null;
    }

    @Override
    public Void visitSuperExpression(SuperExpression superExpression) {
        if (!ElementResolver.isSuperInValidContext(superExpression)) {
            this.resolver.reportErrorForNode(CompileTimeErrorCode.SUPER_IN_INVALID_CONTEXT, superExpression, new Object[0]);
        }
        return (Void)super.visitSuperExpression(superExpression);
    }

    @Override
    public Void visitTypeParameter(TypeParameter typeParameter) {
        this.setMetadata(typeParameter.getElement(), typeParameter);
        return null;
    }

    @Override
    public Void visitVariableDeclaration(VariableDeclaration variableDeclaration) {
        this.setMetadata(variableDeclaration.getElement(), variableDeclaration);
        return null;
    }

    private void addAnnotations(ArrayList<ElementAnnotationImpl> arrayList, NodeList<Annotation> nodeList) {
        int n = nodeList.size();
        for (int i = 0; i < n; ++i) {
            Annotation annotation = (Annotation)nodeList.get(i);
            Element element = annotation.getElement();
            if (element == null) continue;
            ElementAnnotationImpl elementAnnotationImpl = new ElementAnnotationImpl(element);
            annotation.setElementAnnotation(elementAnnotationImpl);
            arrayList.add(elementAnnotationImpl);
        }
    }

    private ErrorCode checkForInvocationError(Expression expression, boolean bl, Element element) {
        if (element instanceof PrefixElement) {
            element = null;
        }
        if (element instanceof PropertyAccessorElement) {
            Type type;
            FunctionType functionType = ((PropertyAccessorElement)element).getType();
            if (functionType != null && !this.isExecutableType(type = functionType.getReturnType())) {
                return StaticTypeWarningCode.INVOCATION_OF_NON_FUNCTION;
            }
        } else {
            if (element instanceof ExecutableElement) {
                return null;
            }
            if (element == null && expression instanceof SuperExpression) {
                return StaticTypeWarningCode.UNDEFINED_SUPER_METHOD;
            }
            if (element instanceof PropertyInducingElement) {
                Type type;
                PropertyAccessorElement propertyAccessorElement = ((PropertyInducingElement)element).getGetter();
                FunctionType functionType = propertyAccessorElement.getType();
                if (functionType != null && !this.isExecutableType(type = functionType.getReturnType())) {
                    return StaticTypeWarningCode.INVOCATION_OF_NON_FUNCTION;
                }
            } else if (element instanceof VariableElement) {
                Type type = ((VariableElement)element).getType();
                if (!this.isExecutableType(type)) {
                    return StaticTypeWarningCode.INVOCATION_OF_NON_FUNCTION;
                }
            } else {
                if (expression == null) {
                    ClassElement classElement = this.resolver.getEnclosingClass();
                    if (classElement == null) {
                        return CompileTimeErrorCode.UNDEFINED_FUNCTION;
                    }
                    if (element == null) {
                        return StaticTypeWarningCode.UNDEFINED_METHOD;
                    }
                    return StaticTypeWarningCode.INVOCATION_OF_NON_FUNCTION;
                }
                Type type = bl ? this.getStaticType(expression) : expression.getBestType();
                if (type == null) {
                    return CompileTimeErrorCode.UNDEFINED_FUNCTION;
                }
                if (!type.isDynamic() && !type.isBottom()) {
                    return StaticTypeWarningCode.UNDEFINED_METHOD;
                }
            }
        }
        return null;
    }

    private boolean checkForUndefinedIndexOperator(IndexExpression indexExpression, Expression expression, String string, MethodElement methodElement, MethodElement methodElement2, Type type, Type type2) {
        boolean bl;
        boolean bl2 = this.shouldReportMissingMember(type, methodElement);
        boolean bl3 = bl = !bl2 && this.enableHints && this.shouldReportMissingMember(type2, methodElement2) && !this.memberFoundInSubclass(type2.getElement(), string, true, false);
        if (bl2 || bl) {
            Enum enum_;
            Token token = indexExpression.getLeftBracket();
            Token token2 = indexExpression.getRightBracket();
            Enum enum_2 = enum_ = bl2 ? StaticTypeWarningCode.UNDEFINED_OPERATOR : HintCode.UNDEFINED_OPERATOR;
            if (token == null || token2 == null) {
                this.resolver.reportProxyConditionalErrorForNode(bl2 ? type.getElement() : type2.getElement(), (ErrorCode)((Object)enum_), indexExpression, new Object[]{string, bl2 ? type.getDisplayName() : type2.getDisplayName()});
            } else {
                int n = token.getOffset();
                int n2 = token2.getOffset() - n + 1;
                this.resolver.reportProxyConditionalErrorForOffset(bl2 ? type.getElement() : type2.getElement(), (ErrorCode)((Object)enum_), n, n2, new Object[]{string, bl2 ? type.getDisplayName() : type2.getDisplayName()});
            }
            return true;
        }
        return false;
    }

    private ParameterElement[] computeCorrespondingParameters(ArgumentList argumentList, Element element) {
        if (element instanceof PropertyAccessorElement) {
            FunctionType functionType = ((PropertyAccessorElement)element).getType();
            if (functionType != null) {
                Element element2;
                Type type = functionType.getReturnType();
                if (type instanceof InterfaceType) {
                    MethodElement methodElement = ((InterfaceType)type).lookUpMethod(CALL_METHOD_NAME, this.definingLibrary);
                    if (methodElement != null) {
                        return this.resolveArgumentsToFunction(false, argumentList, methodElement);
                    }
                } else if (type instanceof FunctionType && (element2 = ((FunctionType)type).getElement()) instanceof ExecutableElement) {
                    return this.resolveArgumentsToFunction(false, argumentList, (ExecutableElement)element2);
                }
            }
        } else {
            if (element instanceof ExecutableElement) {
                return this.resolveArgumentsToFunction(false, argumentList, (ExecutableElement)element);
            }
            if (element instanceof VariableElement) {
                MethodElement methodElement;
                VariableElement variableElement = (VariableElement)element;
                Type type = this.promoteManager.getStaticType(variableElement);
                if (type instanceof FunctionType) {
                    FunctionType functionType = (FunctionType)type;
                    ParameterElement[] parameterElementArray = functionType.getParameters();
                    return this.resolveArgumentsToParameters(false, argumentList, parameterElementArray);
                }
                if (type instanceof InterfaceType && (methodElement = ((InterfaceType)type).lookUpMethod(CALL_METHOD_NAME, this.definingLibrary)) != null) {
                    ParameterElement[] parameterElementArray = methodElement.getParameters();
                    return this.resolveArgumentsToParameters(false, argumentList, parameterElementArray);
                }
            }
        }
        return null;
    }

    private Element convertSetterToGetter(Element element) {
        if (element instanceof PropertyAccessorElement) {
            return ((PropertyAccessorElement)element).getVariable().getGetter();
        }
        return element;
    }

    private Element findImportWithoutPrefix(SimpleIdentifier simpleIdentifier) {
        Element element = null;
        Scope scope = this.resolver.getNameScope();
        for (ImportElement importElement : this.definingLibrary.getImports()) {
            SyntheticIdentifier syntheticIdentifier;
            Element element2;
            PrefixElement prefixElement = importElement.getPrefix();
            if (prefixElement == null || (element2 = scope.lookup(syntheticIdentifier = new SyntheticIdentifier(prefixElement.getName() + "." + simpleIdentifier.getName()), this.definingLibrary)) == null) continue;
            element = element == null ? element2 : MultiplyDefinedElementImpl.fromElements(this.definingLibrary.getContext(), element, element2);
        }
        return element;
    }

    private String getPostfixOperator(PostfixExpression postfixExpression) {
        return postfixExpression.getOperator().getType() == TokenType.PLUS_PLUS ? TokenType.PLUS.getLexeme() : TokenType.MINUS.getLexeme();
    }

    private String getPrefixOperator(PrefixExpression prefixExpression) {
        Token token = prefixExpression.getOperator();
        TokenType tokenType = token.getType();
        if (tokenType == TokenType.PLUS_PLUS) {
            return TokenType.PLUS.getLexeme();
        }
        if (tokenType == TokenType.MINUS_MINUS) {
            return TokenType.MINUS.getLexeme();
        }
        if (tokenType == TokenType.MINUS) {
            return "unary-";
        }
        return token.getLexeme();
    }

    private Type getPropagatedType(Expression expression) {
        Type type = this.resolveTypeParameter(expression.getPropagatedType());
        if (type instanceof FunctionType) {
            type = this.resolver.getTypeProvider().getFunctionType();
        }
        return type;
    }

    private Type getStaticType(Expression expression) {
        if (expression instanceof NullLiteral) {
            return this.resolver.getTypeProvider().getBottomType();
        }
        Type type = this.resolveTypeParameter(expression.getStaticType());
        if (type instanceof FunctionType) {
            type = this.resolver.getTypeProvider().getFunctionType();
        }
        return type;
    }

    private boolean isExecutableType(Type type) {
        if (type.isDynamic() || type instanceof FunctionType || type.isDartCoreFunction() || type.isObject()) {
            return true;
        }
        if (type instanceof InterfaceType) {
            ClassElement classElement = ((InterfaceType)type).getElement();
            MethodElement methodElement = classElement.lookUpMethod(CALL_METHOD_NAME, this.definingLibrary);
            return methodElement != null;
        }
        return false;
    }

    private boolean isInConstConstructor() {
        ExecutableElement executableElement = this.resolver.getEnclosingFunction();
        if (executableElement instanceof ConstructorElement) {
            return ((ConstructorElement)executableElement).isConst();
        }
        return false;
    }

    private boolean isStatic(Element element) {
        if (element instanceof ExecutableElement) {
            return ((ExecutableElement)element).isStatic();
        }
        if (element instanceof PropertyInducingElement) {
            return ((PropertyInducingElement)element).isStatic();
        }
        return false;
    }

    private boolean isValidAsPrefix(SimpleIdentifier simpleIdentifier) {
        AstNode astNode = simpleIdentifier.getParent();
        if (astNode instanceof ImportDirective) {
            return ((ImportDirective)astNode).getPrefix() == simpleIdentifier;
        }
        if (astNode instanceof PrefixedIdentifier) {
            return true;
        }
        if (astNode instanceof MethodInvocation) {
            return ((MethodInvocation)astNode).getTarget() == simpleIdentifier;
        }
        return false;
    }

    private PropertyAccessorElement lookUpGetter(Expression expression, Type type, String string) {
        if ((type = this.resolveTypeParameter(type)) instanceof InterfaceType) {
            InterfaceType interfaceType = (InterfaceType)type;
            PropertyAccessorElement propertyAccessorElement = expression instanceof SuperExpression ? interfaceType.lookUpGetterInSuperclass(string, this.definingLibrary) : interfaceType.lookUpGetter(string, this.definingLibrary);
            if (propertyAccessorElement != null) {
                return propertyAccessorElement;
            }
            return this.lookUpGetterInInterfaces(interfaceType, false, string, new HashSet<ClassElement>());
        }
        return null;
    }

    private PropertyAccessorElement lookUpGetterInInterfaces(InterfaceType interfaceType, boolean bl, String string, HashSet<ClassElement> hashSet) {
        PropertyAccessorElement propertyAccessorElement;
        Object object;
        ClassElement classElement = interfaceType.getElement();
        if (hashSet.contains(classElement)) {
            return null;
        }
        hashSet.add(classElement);
        if (bl && (object = interfaceType.getGetter(string)) != null && object.isAccessibleIn(this.definingLibrary)) {
            return object;
        }
        for (InterfaceType object2 : interfaceType.getInterfaces()) {
            propertyAccessorElement = this.lookUpGetterInInterfaces(object2, true, string, hashSet);
            if (propertyAccessorElement == null) continue;
            return propertyAccessorElement;
        }
        for (InterfaceType interfaceType2 : interfaceType.getMixins()) {
            propertyAccessorElement = this.lookUpGetterInInterfaces(interfaceType2, true, string, hashSet);
            if (propertyAccessorElement == null) continue;
            return propertyAccessorElement;
        }
        object = interfaceType.getSuperclass();
        if (object == null) {
            return null;
        }
        return this.lookUpGetterInInterfaces((InterfaceType)object, true, string, hashSet);
    }

    private ExecutableElement lookupGetterOrMethod(Type type, String string) {
        if ((type = this.resolveTypeParameter(type)) instanceof InterfaceType) {
            InterfaceType interfaceType = (InterfaceType)type;
            ExecutableElement executableElement = interfaceType.lookUpMethod(string, this.definingLibrary);
            if (executableElement != null) {
                return executableElement;
            }
            executableElement = interfaceType.lookUpGetter(string, this.definingLibrary);
            if (executableElement != null) {
                return executableElement;
            }
            return this.lookUpGetterOrMethodInInterfaces(interfaceType, false, string, new HashSet<ClassElement>());
        }
        return null;
    }

    private ExecutableElement lookUpGetterOrMethodInInterfaces(InterfaceType interfaceType, boolean bl, String string, HashSet<ClassElement> hashSet) {
        ExecutableElement executableElement;
        ClassElement classElement = interfaceType.getElement();
        if (hashSet.contains(classElement)) {
            return null;
        }
        hashSet.add(classElement);
        if (bl) {
            MethodElement object = interfaceType.getMethod(string);
            if (object != null) {
                return object;
            }
            PropertyAccessorElement propertyAccessorElement = interfaceType.getGetter(string);
            if (propertyAccessorElement != null) {
                return propertyAccessorElement;
            }
        }
        for (InterfaceType interfaceType2 : interfaceType.getInterfaces()) {
            executableElement = this.lookUpGetterOrMethodInInterfaces(interfaceType2, true, string, hashSet);
            if (executableElement == null) continue;
            return executableElement;
        }
        for (InterfaceType interfaceType2 : interfaceType.getMixins()) {
            executableElement = this.lookUpGetterOrMethodInInterfaces(interfaceType2, true, string, hashSet);
            if (executableElement == null) continue;
            return executableElement;
        }
        InterfaceType interfaceType3 = interfaceType.getSuperclass();
        if (interfaceType3 == null) {
            return null;
        }
        return this.lookUpGetterOrMethodInInterfaces(interfaceType3, true, string, hashSet);
    }

    private LabelElementImpl lookupLabel(AstNode astNode, SimpleIdentifier simpleIdentifier) {
        ExecutableElement executableElement;
        LabelScope labelScope = this.resolver.getLabelScope();
        LabelElementImpl labelElementImpl = null;
        if (simpleIdentifier == null) {
            if (labelScope != null) {
                labelElementImpl = (LabelElementImpl)labelScope.lookup("");
                if (labelElementImpl == null) {
                    // empty if block
                }
                labelElementImpl = null;
            }
        } else if (labelScope == null) {
            this.resolver.reportErrorForNode(CompileTimeErrorCode.LABEL_UNDEFINED, simpleIdentifier, simpleIdentifier.getName());
        } else {
            labelElementImpl = (LabelElementImpl)labelScope.lookup(simpleIdentifier.getName());
            if (labelElementImpl == null) {
                this.resolver.reportErrorForNode(CompileTimeErrorCode.LABEL_UNDEFINED, simpleIdentifier, simpleIdentifier.getName());
            } else {
                simpleIdentifier.setStaticElement(labelElementImpl);
            }
        }
        if (labelElementImpl != null && (executableElement = labelElementImpl.getAncestor(ExecutableElement.class)) != this.resolver.getEnclosingFunction()) {
            this.resolver.reportErrorForNode(CompileTimeErrorCode.LABEL_IN_OUTER_SCOPE, simpleIdentifier, simpleIdentifier.getName());
            labelElementImpl = null;
        }
        return labelElementImpl;
    }

    private MethodElement lookUpMethod(Expression expression, Type type, String string) {
        if ((type = this.resolveTypeParameter(type)) instanceof InterfaceType) {
            InterfaceType interfaceType = (InterfaceType)type;
            MethodElement methodElement = expression instanceof SuperExpression ? interfaceType.lookUpMethodInSuperclass(string, this.definingLibrary) : interfaceType.lookUpMethod(string, this.definingLibrary);
            if (methodElement != null) {
                return methodElement;
            }
            return this.lookUpMethodInInterfaces(interfaceType, false, string, new HashSet<ClassElement>());
        }
        return null;
    }

    private MethodElement lookUpMethodInInterfaces(InterfaceType interfaceType, boolean bl, String string, HashSet<ClassElement> hashSet) {
        MethodElement methodElement;
        Object object;
        ClassElement classElement = interfaceType.getElement();
        if (hashSet.contains(classElement)) {
            return null;
        }
        hashSet.add(classElement);
        if (bl && (object = interfaceType.getMethod(string)) != null && object.isAccessibleIn(this.definingLibrary)) {
            return object;
        }
        for (InterfaceType object2 : interfaceType.getInterfaces()) {
            methodElement = this.lookUpMethodInInterfaces(object2, true, string, hashSet);
            if (methodElement == null) continue;
            return methodElement;
        }
        for (InterfaceType interfaceType2 : interfaceType.getMixins()) {
            methodElement = this.lookUpMethodInInterfaces(interfaceType2, true, string, hashSet);
            if (methodElement == null) continue;
            return methodElement;
        }
        object = interfaceType.getSuperclass();
        if (object == null) {
            return null;
        }
        return this.lookUpMethodInInterfaces((InterfaceType)object, true, string, hashSet);
    }

    private PropertyAccessorElement lookUpSetter(Expression expression, Type type, String string) {
        if ((type = this.resolveTypeParameter(type)) instanceof InterfaceType) {
            InterfaceType interfaceType = (InterfaceType)type;
            PropertyAccessorElement propertyAccessorElement = expression instanceof SuperExpression ? interfaceType.lookUpSetterInSuperclass(string, this.definingLibrary) : interfaceType.lookUpSetter(string, this.definingLibrary);
            if (propertyAccessorElement != null) {
                return propertyAccessorElement;
            }
            return this.lookUpSetterInInterfaces(interfaceType, false, string, new HashSet<ClassElement>());
        }
        return null;
    }

    private PropertyAccessorElement lookUpSetterInInterfaces(InterfaceType interfaceType, boolean bl, String string, HashSet<ClassElement> hashSet) {
        PropertyAccessorElement propertyAccessorElement;
        Object object;
        ClassElement classElement = interfaceType.getElement();
        if (hashSet.contains(classElement)) {
            return null;
        }
        hashSet.add(classElement);
        if (bl && (object = interfaceType.getSetter(string)) != null && object.isAccessibleIn(this.definingLibrary)) {
            return object;
        }
        for (InterfaceType object2 : interfaceType.getInterfaces()) {
            propertyAccessorElement = this.lookUpSetterInInterfaces(object2, true, string, hashSet);
            if (propertyAccessorElement == null) continue;
            return propertyAccessorElement;
        }
        for (InterfaceType interfaceType2 : interfaceType.getMixins()) {
            propertyAccessorElement = this.lookUpSetterInInterfaces(interfaceType2, true, string, hashSet);
            if (propertyAccessorElement == null) continue;
            return propertyAccessorElement;
        }
        object = interfaceType.getSuperclass();
        if (object == null) {
            return null;
        }
        return this.lookUpSetterInInterfaces((InterfaceType)object, true, string, hashSet);
    }

    private boolean memberFoundInSubclass(Element element, String string, boolean bl, boolean bl2) {
        if (element instanceof ClassElement) {
            this.subtypeManager.ensureLibraryVisited(this.definingLibrary);
            HashSet<ClassElement> hashSet = this.subtypeManager.computeAllSubtypes((ClassElement)element);
            for (ClassElement classElement : hashSet) {
                if (bl && classElement.getMethod(string) != null) {
                    return true;
                }
                if (!bl2 || classElement.getGetter(string) == null && classElement.getSetter(string) == null) continue;
                return true;
            }
        }
        return false;
    }

    private TokenType operatorFromCompoundAssignment(TokenType tokenType) {
        switch (tokenType) {
            case AMPERSAND_EQ: {
                return TokenType.AMPERSAND;
            }
            case BAR_EQ: {
                return TokenType.BAR;
            }
            case CARET_EQ: {
                return TokenType.CARET;
            }
            case GT_GT_EQ: {
                return TokenType.GT_GT;
            }
            case LT_LT_EQ: {
                return TokenType.LT_LT;
            }
            case MINUS_EQ: {
                return TokenType.MINUS;
            }
            case PERCENT_EQ: {
                return TokenType.PERCENT;
            }
            case PLUS_EQ: {
                return TokenType.PLUS;
            }
            case SLASH_EQ: {
                return TokenType.SLASH;
            }
            case STAR_EQ: {
                return TokenType.STAR;
            }
            case TILDE_SLASH_EQ: {
                return TokenType.TILDE_SLASH;
            }
        }
        AnalysisEngine.getInstance().getLogger().logError("Failed to map " + tokenType.getLexeme() + " to it's corresponding operator");
        return tokenType;
    }

    private void resolveAnnotationConstructorInvocationArguments(Annotation annotation, ConstructorElement constructorElement) {
        ArgumentList argumentList = annotation.getArguments();
        if (argumentList == null) {
            return;
        }
        ParameterElement[] parameterElementArray = this.resolveArgumentsToFunction(true, argumentList, constructorElement);
        if (parameterElementArray != null) {
            argumentList.setCorrespondingStaticParameters(parameterElementArray);
        }
    }

    private void resolveAnnotationElement(Annotation annotation) {
        Object object;
        Element element;
        Element element2;
        SimpleIdentifier simpleIdentifier;
        SimpleIdentifier simpleIdentifier2;
        Object object2;
        Identifier identifier = annotation.getName();
        if (identifier instanceof PrefixedIdentifier) {
            object2 = (PrefixedIdentifier)identifier;
            simpleIdentifier2 = ((PrefixedIdentifier)object2).getPrefix();
            simpleIdentifier = ((PrefixedIdentifier)object2).getIdentifier();
        } else {
            simpleIdentifier2 = (SimpleIdentifier)identifier;
            simpleIdentifier = null;
        }
        identifier = annotation.getConstructorName();
        object2 = null;
        if (simpleIdentifier2 != null && simpleIdentifier == null && identifier == null) {
            element2 = simpleIdentifier2.getStaticElement();
            if (element2 instanceof PropertyAccessorElement) {
                this.resolveAnnotationElementGetter(annotation, (PropertyAccessorElement)element2);
                return;
            }
            if (element2 instanceof ClassElement) {
                element = (ClassElement)element2;
                object2 = new InterfaceTypeImpl((ClassElement)element).lookUpConstructor(null, this.definingLibrary);
            }
        }
        if (simpleIdentifier2 != null && simpleIdentifier != null && identifier == null) {
            element2 = simpleIdentifier2.getStaticElement();
            element = simpleIdentifier.getStaticElement();
            if (element2 instanceof ClassElement) {
                object = (ClassElement)element2;
                element = object.lookUpGetter(simpleIdentifier.getName(), this.definingLibrary);
            }
            if (element instanceof PropertyAccessorElement) {
                simpleIdentifier.setStaticElement(element);
                annotation.setElement(element);
                this.resolveAnnotationElementGetter(annotation, (PropertyAccessorElement)element);
                return;
            }
            if (element instanceof ClassElement) {
                object = (ClassElement)element;
                object2 = object.getUnnamedConstructor();
            }
            if (element2 instanceof ClassElement) {
                object = (ClassElement)element2;
                object2 = new InterfaceTypeImpl((ClassElement)object).lookUpConstructor(simpleIdentifier.getName(), this.definingLibrary);
                simpleIdentifier.setStaticElement((Element)object2);
            }
        }
        if (simpleIdentifier2 != null && simpleIdentifier != null && identifier != null && (element2 = simpleIdentifier.getStaticElement()) instanceof ClassElement) {
            element = (ClassElement)element2;
            object = ((SimpleIdentifier)identifier).getName();
            PropertyAccessorElement propertyAccessorElement = element.lookUpGetter((String)object, this.definingLibrary);
            if (propertyAccessorElement != null) {
                ((SimpleIdentifier)identifier).setStaticElement(propertyAccessorElement);
                annotation.setElement(element2);
                this.resolveAnnotationElementGetter(annotation, propertyAccessorElement);
                return;
            }
            object2 = new InterfaceTypeImpl((ClassElement)element).lookUpConstructor((String)object, this.definingLibrary);
            ((SimpleIdentifier)identifier).setStaticElement((Element)object2);
        }
        if (object2 == null) {
            this.resolver.reportErrorForNode(CompileTimeErrorCode.INVALID_ANNOTATION, annotation, new Object[0]);
            return;
        }
        annotation.setElement((Element)object2);
        this.resolveAnnotationConstructorInvocationArguments(annotation, (ConstructorElement)object2);
    }

    private void resolveAnnotationElementGetter(Annotation annotation, PropertyAccessorElement propertyAccessorElement) {
        if (!propertyAccessorElement.isSynthetic()) {
            this.resolver.reportErrorForNode(CompileTimeErrorCode.INVALID_ANNOTATION, annotation, new Object[0]);
            return;
        }
        PropertyInducingElement propertyInducingElement = propertyAccessorElement.getVariable();
        if (!propertyInducingElement.isConst()) {
            this.resolver.reportErrorForNode(CompileTimeErrorCode.INVALID_ANNOTATION, annotation, new Object[0]);
        }
    }

    private ParameterElement[] resolveArgumentsToFunction(boolean bl, ArgumentList argumentList, ExecutableElement executableElement) {
        if (executableElement == null) {
            return null;
        }
        ParameterElement[] parameterElementArray = executableElement.getParameters();
        return this.resolveArgumentsToParameters(bl, argumentList, parameterElementArray);
    }

    private ParameterElement[] resolveArgumentsToParameters(boolean bl, ArgumentList argumentList, ParameterElement[] parameterElementArray) {
        ArrayList<ParameterElement> arrayList = new ArrayList<ParameterElement>();
        ArrayList<ParameterElement> arrayList2 = new ArrayList<ParameterElement>();
        HashMap<String, ParameterElement> hashMap = new HashMap<String, ParameterElement>();
        for (ParameterElement object2 : parameterElementArray) {
            ParameterKind n3 = object2.getParameterKind();
            if (n3 == ParameterKind.REQUIRED) {
                arrayList.add(object2);
                continue;
            }
            if (n3 == ParameterKind.POSITIONAL) {
                arrayList2.add(object2);
                continue;
            }
            hashMap.put(object2.getName(), object2);
        }
        ArrayList arrayList3 = new ArrayList(arrayList);
        arrayList3.addAll(arrayList2);
        int n = arrayList3.size();
        int n2 = 0;
        NodeList<Expression> nodeList = argumentList.getArguments();
        int n3 = nodeList.size();
        ParameterElement[] parameterElementArray2 = new ParameterElement[n3];
        int n4 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        for (int enum_ = 0; enum_ < n3; ++enum_) {
            Expression expression = (Expression)nodeList.get(enum_);
            if (expression instanceof NamedExpression) {
                SimpleIdentifier simpleIdentifier = ((NamedExpression)expression).getName().getLabel();
                String string = simpleIdentifier.getName();
                ParameterElement parameterElement = (ParameterElement)hashMap.get(string);
                if (parameterElement == null) {
                    Enum enum_2 = bl ? CompileTimeErrorCode.UNDEFINED_NAMED_PARAMETER : StaticWarningCode.UNDEFINED_NAMED_PARAMETER;
                    this.resolver.reportErrorForNode((ErrorCode)((Object)enum_2), simpleIdentifier, new Object[]{string});
                } else {
                    parameterElementArray2[enum_] = parameterElement;
                    simpleIdentifier.setStaticElement(parameterElement);
                }
                if (hashSet.add(string)) continue;
                this.resolver.reportErrorForNode(CompileTimeErrorCode.DUPLICATE_NAMED_ARGUMENT, simpleIdentifier, string);
                continue;
            }
            ++n4;
            if (n2 >= n) continue;
            parameterElementArray2[enum_] = (ParameterElement)arrayList3.get(n2++);
        }
        if (n4 < arrayList.size()) {
            Enum enum_ = bl ? CompileTimeErrorCode.NOT_ENOUGH_REQUIRED_ARGUMENTS : StaticWarningCode.NOT_ENOUGH_REQUIRED_ARGUMENTS;
            this.resolver.reportErrorForNode((ErrorCode)((Object)enum_), argumentList, new Object[]{arrayList.size(), n4});
        } else if (n4 > n) {
            Enum enum_ = bl ? CompileTimeErrorCode.EXTRA_POSITIONAL_ARGUMENTS : StaticWarningCode.EXTRA_POSITIONAL_ARGUMENTS;
            this.resolver.reportErrorForNode((ErrorCode)((Object)enum_), argumentList, new Object[]{n, n4});
        }
        return parameterElementArray2;
    }

    private void resolveCombinators(LibraryElement libraryElement, NodeList<Combinator> nodeList) {
        if (libraryElement == null) {
            return;
        }
        Namespace namespace = new NamespaceBuilder().createExportNamespaceForLibrary(libraryElement);
        for (Combinator combinator : nodeList) {
            NodeList<SimpleIdentifier> nodeList2 = combinator instanceof HideCombinator ? ((HideCombinator)combinator).getHiddenNames() : ((ShowCombinator)combinator).getShownNames();
            for (SimpleIdentifier simpleIdentifier : nodeList2) {
                Element element = namespace.get(simpleIdentifier.getName());
                if (element == null) continue;
                simpleIdentifier.setStaticElement(element);
            }
        }
    }

    private Element resolveElement(ClassElementImpl classElementImpl, SimpleIdentifier simpleIdentifier) {
        String string = simpleIdentifier.getName();
        ExecutableElement executableElement = null;
        executableElement = classElementImpl.getMethod(string);
        if (executableElement == null && simpleIdentifier.inSetterContext()) {
            executableElement = classElementImpl.getSetter(string);
        }
        if (executableElement == null && simpleIdentifier.inGetterContext()) {
            executableElement = classElementImpl.getGetter(string);
        }
        if (executableElement != null && executableElement.isAccessibleIn(this.definingLibrary)) {
            return executableElement;
        }
        return null;
    }

    private Element resolveInvokedElement(SimpleIdentifier simpleIdentifier) {
        InterfaceType interfaceType;
        ClassElement classElement;
        Element element = this.resolver.getNameScope().lookup(simpleIdentifier, this.definingLibrary);
        if (element == null && (classElement = this.resolver.getEnclosingClass()) != null && (element = this.lookUpMethod(null, interfaceType = classElement.getType(), simpleIdentifier.getName())) == null) {
            element = this.lookUpGetter(null, interfaceType, simpleIdentifier.getName());
        }
        return element;
    }

    private Element resolveInvokedElementWithTarget(Expression expression, Type type, SimpleIdentifier simpleIdentifier) {
        Element element;
        if (type instanceof InterfaceType) {
            InterfaceType interfaceType = (InterfaceType)type;
            ExecutableElement executableElement = this.lookUpMethod(expression, interfaceType, simpleIdentifier.getName());
            if (executableElement == null) {
                executableElement = this.lookUpGetter(expression, interfaceType, simpleIdentifier.getName());
            }
            return executableElement;
        }
        if (expression instanceof SimpleIdentifier && (element = ((SimpleIdentifier)expression).getStaticElement()) instanceof PrefixElement) {
            String string = ((SimpleIdentifier)expression).getName() + "." + simpleIdentifier;
            SyntheticIdentifier syntheticIdentifier = new SyntheticIdentifier(string);
            Element element2 = this.resolver.getNameScope().lookup(syntheticIdentifier, this.definingLibrary);
            if (element2 != null) {
                return element2;
            }
        }
        return null;
    }

    private ExecutableElement resolveProperty(Expression expression, Type type, SimpleIdentifier simpleIdentifier) {
        ExecutableElement executableElement = null;
        if (simpleIdentifier.inSetterContext()) {
            executableElement = this.lookUpSetter(expression, type, simpleIdentifier.getName());
        }
        if (executableElement == null) {
            executableElement = this.lookUpGetter(expression, type, simpleIdentifier.getName());
        }
        if (executableElement == null) {
            executableElement = this.lookUpMethod(expression, type, simpleIdentifier.getName());
        }
        return executableElement;
    }

    private void resolvePropertyAccess(Expression expression, SimpleIdentifier simpleIdentifier) {
        boolean bl;
        Type type = this.getStaticType(expression);
        Type type2 = this.getPropagatedType(expression);
        Element element = null;
        Element element2 = null;
        ClassElementImpl classElementImpl = ElementResolver.getTypeReference(expression);
        if (classElementImpl != null) {
            element2 = this.resolveElement(classElementImpl, simpleIdentifier);
            element = element2;
        } else {
            element = this.resolveProperty(expression, type, simpleIdentifier);
            element2 = this.resolveProperty(expression, type2, simpleIdentifier);
        }
        if (expression.getParent().getParent() instanceof Annotation) {
            if (element != null) {
                simpleIdentifier.setStaticElement(element);
            }
            return;
        }
        simpleIdentifier.setStaticElement(element);
        simpleIdentifier.setPropagatedElement(element2);
        boolean bl2 = this.shouldReportMissingMember(type, element);
        boolean bl3 = bl = !bl2 && this.enableHints ? this.shouldReportMissingMember(type2, element2) : false;
        if (bl && this.memberFoundInSubclass(type2.getElement(), simpleIdentifier.getName(), false, true)) {
            bl = false;
        }
        if (bl2 || bl) {
            Object object;
            if (type.isVoid()) {
                if (simpleIdentifier.inSetterContext()) {
                    object = bl2 ? StaticTypeWarningCode.UNDEFINED_SETTER : HintCode.UNDEFINED_SETTER;
                    this.resolver.reportErrorForNode((ErrorCode)object, simpleIdentifier, simpleIdentifier.getName(), type.getDisplayName());
                } else if (simpleIdentifier.inGetterContext()) {
                    object = bl2 ? StaticTypeWarningCode.UNDEFINED_GETTER : HintCode.UNDEFINED_GETTER;
                    this.resolver.reportErrorForNode((ErrorCode)object, simpleIdentifier, simpleIdentifier.getName(), type.getDisplayName());
                } else {
                    this.resolver.reportErrorForNode(StaticWarningCode.UNDEFINED_IDENTIFIER, simpleIdentifier, simpleIdentifier.getName());
                }
            }
            Object object2 = object = bl2 ? type.getElement() : type2.getElement();
            if (object != null) {
                boolean bl4 = this.isStatic((Element)object);
                if (simpleIdentifier.inSetterContext()) {
                    if (bl4) {
                        Enum enum_ = bl2 ? StaticWarningCode.UNDEFINED_SETTER : HintCode.UNDEFINED_SETTER;
                        this.resolver.reportProxyConditionalErrorForNode((Element)object, (ErrorCode)((Object)enum_), simpleIdentifier, new Object[]{simpleIdentifier.getName(), object.getDisplayName()});
                    } else {
                        Enum enum_ = bl2 ? StaticTypeWarningCode.UNDEFINED_SETTER : HintCode.UNDEFINED_SETTER;
                        this.resolver.reportProxyConditionalErrorForNode((Element)object, (ErrorCode)((Object)enum_), simpleIdentifier, new Object[]{simpleIdentifier.getName(), object.getDisplayName()});
                    }
                } else if (simpleIdentifier.inGetterContext()) {
                    if (bl4) {
                        Enum enum_ = bl2 ? StaticWarningCode.UNDEFINED_GETTER : HintCode.UNDEFINED_GETTER;
                        this.resolver.reportProxyConditionalErrorForNode((Element)object, (ErrorCode)((Object)enum_), simpleIdentifier, new Object[]{simpleIdentifier.getName(), object.getDisplayName()});
                    } else {
                        Enum enum_ = bl2 ? StaticTypeWarningCode.UNDEFINED_GETTER : HintCode.UNDEFINED_GETTER;
                        this.resolver.reportProxyConditionalErrorForNode((Element)object, (ErrorCode)((Object)enum_), simpleIdentifier, new Object[]{simpleIdentifier.getName(), object.getDisplayName()});
                    }
                } else {
                    this.resolver.reportProxyConditionalErrorForNode((Element)object, StaticWarningCode.UNDEFINED_IDENTIFIER, simpleIdentifier, simpleIdentifier.getName());
                }
            }
        }
    }

    private Element resolveSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
        Object object;
        Element element;
        Object object2 = this.resolver.getNameScope().lookup(simpleIdentifier, this.definingLibrary);
        if (object2 instanceof PropertyAccessorElement && simpleIdentifier.inSetterContext()) {
            element = ((PropertyAccessorElement)object2).getVariable();
            if (element != null) {
                ClassElement classElement;
                object = element.getSetter();
                if (object == null && (classElement = this.resolver.getEnclosingClass()) != null) {
                    object = this.lookUpSetter(null, classElement.getType(), simpleIdentifier.getName());
                }
                if (object != null) {
                    object2 = object;
                }
            }
        } else if (object2 == null && simpleIdentifier.inSetterContext()) {
            object2 = this.resolver.getNameScope().lookup(new SyntheticIdentifier(simpleIdentifier.getName() + "="), this.definingLibrary);
        }
        element = this.resolver.getEnclosingClass();
        if (object2 == null && element != null) {
            object = element.getType();
            if (object2 == null && simpleIdentifier.inSetterContext()) {
                object2 = this.lookUpSetter(null, (Type)object, simpleIdentifier.getName());
            }
            if (object2 == null && simpleIdentifier.inGetterContext()) {
                object2 = this.lookUpGetter(null, (Type)object, simpleIdentifier.getName());
            }
            if (object2 == null) {
                object2 = this.lookUpMethod(null, (Type)object, simpleIdentifier.getName());
            }
        }
        return object2;
    }

    private Type resolveTypeParameter(Type type) {
        if (type instanceof TypeParameterType) {
            Type type2 = ((TypeParameterType)type).getElement().getBound();
            if (type2 == null) {
                return this.resolver.getTypeProvider().getObjectType();
            }
            return type2;
        }
        return type;
    }

    private void setMetadata(Element element, AnnotatedNode annotatedNode) {
        if (!(element instanceof ElementImpl)) {
            return;
        }
        ArrayList<ElementAnnotationImpl> arrayList = new ArrayList<ElementAnnotationImpl>();
        this.addAnnotations(arrayList, annotatedNode.getMetadata());
        if (annotatedNode instanceof VariableDeclaration && annotatedNode.getParent() instanceof VariableDeclarationList) {
            VariableDeclarationList variableDeclarationList = (VariableDeclarationList)annotatedNode.getParent();
            this.addAnnotations(arrayList, variableDeclarationList.getMetadata());
            if (variableDeclarationList.getParent() instanceof FieldDeclaration) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)variableDeclarationList.getParent();
                this.addAnnotations(arrayList, fieldDeclaration.getMetadata());
            } else if (variableDeclarationList.getParent() instanceof TopLevelVariableDeclaration) {
                TopLevelVariableDeclaration topLevelVariableDeclaration = (TopLevelVariableDeclaration)variableDeclarationList.getParent();
                this.addAnnotations(arrayList, topLevelVariableDeclaration.getMetadata());
            }
        }
        if (!arrayList.isEmpty()) {
            ((ElementImpl)element).setMetadata(arrayList.toArray(new ElementAnnotationImpl[arrayList.size()]));
        }
    }

    private void setMetadataForParameter(Element element, NormalFormalParameter normalFormalParameter) {
        if (!(element instanceof ElementImpl)) {
            return;
        }
        ArrayList<ElementAnnotationImpl> arrayList = new ArrayList<ElementAnnotationImpl>();
        this.addAnnotations(arrayList, normalFormalParameter.getMetadata());
        if (!arrayList.isEmpty()) {
            ((ElementImpl)element).setMetadata(arrayList.toArray(new ElementAnnotationImpl[arrayList.size()]));
        }
    }

    private boolean shouldReportMissingMember(Type type, Element element) {
        return element == null && type != null && !type.isDynamic() && !type.isBottom();
    }

    private static class SyntheticIdentifier
    extends Identifier {
        private final String name;

        private SyntheticIdentifier(String string) {
            this.name = string;
        }

        @Override
        public <R> R accept(AstVisitor<R> astVisitor) {
            return null;
        }

        @Override
        public Token getBeginToken() {
            return null;
        }

        @Override
        public Element getBestElement() {
            return null;
        }

        @Override
        public Token getEndToken() {
            return null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPrecedence() {
            return 16;
        }

        @Override
        public Element getPropagatedElement() {
            return null;
        }

        @Override
        public Element getStaticElement() {
            return null;
        }

        @Override
        public void visitChildren(AstVisitor<?> astVisitor) {
        }
    }
}

