/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.resolver;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.CatchClause;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.ClassMember;
import com.google.dart.engine.ast.ClassTypeAlias;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.DeclaredIdentifier;
import com.google.dart.engine.ast.DefaultFormalParameter;
import com.google.dart.engine.ast.ExportDirective;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.FieldFormalParameter;
import com.google.dart.engine.ast.FormalParameter;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionExpression;
import com.google.dart.engine.ast.FunctionTypeAlias;
import com.google.dart.engine.ast.FunctionTypedFormalParameter;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.Label;
import com.google.dart.engine.ast.LabeledStatement;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.PartDirective;
import com.google.dart.engine.ast.SimpleFormalParameter;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.StringInterpolation;
import com.google.dart.engine.ast.StringLiteral;
import com.google.dart.engine.ast.SwitchCase;
import com.google.dart.engine.ast.SwitchDefault;
import com.google.dart.engine.ast.TypeParameter;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.visitor.RecursiveAstVisitor;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.ExportElement;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.element.FunctionTypeAliasElement;
import com.google.dart.engine.element.ImportElement;
import com.google.dart.engine.element.LabelElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.LocalVariableElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.PrefixElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.element.visitor.GeneralizingElementVisitor;
import com.google.dart.engine.scanner.Keyword;
import com.google.dart.engine.scanner.KeywordToken;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.scanner.TokenType;
import com.google.dart.engine.source.Source;
import java.util.HashSet;

public class DeclarationMatcher
extends RecursiveAstVisitor<Void> {
    private CompilationUnitElement enclosingUnit;
    private FunctionTypeAliasElement enclosingAlias;
    private ClassElement enclosingClass;
    private ExecutableElement enclosingExecutable;
    private ParameterElement enclosingParameter;
    private HashSet<Element> allElements = new HashSet();
    private HashSet<Element> unmatchedElements = new HashSet();

    public boolean matches(AstNode astNode, Element element) {
        this.captureEnclosingElements(element);
        this.gatherElements(element);
        try {
            astNode.accept(this);
        }
        catch (DeclarationMismatchException declarationMismatchException) {
            return false;
        }
        return this.unmatchedElements.isEmpty();
    }

    @Override
    public Void visitCatchClause(CatchClause catchClause) {
        SimpleIdentifier simpleIdentifier = catchClause.getExceptionParameter();
        if (simpleIdentifier != null) {
            Element[] elementArray = this.enclosingExecutable.getLocalVariables();
            LocalVariableElement localVariableElement = (LocalVariableElement)this.findIdentifier(elementArray, simpleIdentifier);
            this.processElement(localVariableElement);
            SimpleIdentifier simpleIdentifier2 = catchClause.getStackTraceParameter();
            if (simpleIdentifier2 != null) {
                LocalVariableElement localVariableElement2 = (LocalVariableElement)this.findIdentifier(elementArray, simpleIdentifier2);
                this.processElement(localVariableElement2);
            }
        }
        return (Void)super.visitCatchClause(catchClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitClassDeclaration(ClassDeclaration classDeclaration) {
        ClassElement classElement = this.enclosingClass;
        try {
            Object object;
            SimpleIdentifier simpleIdentifier = classDeclaration.getName();
            this.enclosingClass = (ClassElement)this.findIdentifier(this.enclosingUnit.getTypes(), simpleIdentifier);
            this.processElement(this.enclosingClass);
            if (!this.hasConstructor(classDeclaration) && (object = this.enclosingClass.getUnnamedConstructor()).isSynthetic()) {
                this.processElement((Element)object);
            }
            object = (Void)super.visitClassDeclaration(classDeclaration);
            return object;
        }
        finally {
            this.enclosingClass = classElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitClassTypeAlias(ClassTypeAlias classTypeAlias) {
        ClassElement classElement = this.enclosingClass;
        try {
            SimpleIdentifier simpleIdentifier = classTypeAlias.getName();
            this.enclosingClass = (ClassElement)this.findIdentifier(this.enclosingUnit.getTypes(), simpleIdentifier);
            this.processElement(this.enclosingClass);
            Void void_ = (Void)super.visitClassTypeAlias(classTypeAlias);
            return void_;
        }
        finally {
            this.enclosingClass = classElement;
        }
    }

    @Override
    public Void visitCompilationUnit(CompilationUnit compilationUnit) {
        this.processElement(this.enclosingUnit);
        return (Void)super.visitCompilationUnit(compilationUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
        ExecutableElement executableElement = this.enclosingExecutable;
        try {
            SimpleIdentifier simpleIdentifier = constructorDeclaration.getName();
            this.enclosingExecutable = simpleIdentifier == null ? this.enclosingClass.getUnnamedConstructor() : this.enclosingClass.getNamedConstructor(simpleIdentifier.getName());
            this.processElement(this.enclosingExecutable);
            Void void_ = (Void)super.visitConstructorDeclaration(constructorDeclaration);
            return void_;
        }
        finally {
            this.enclosingExecutable = executableElement;
        }
    }

    @Override
    public Void visitDeclaredIdentifier(DeclaredIdentifier declaredIdentifier) {
        SimpleIdentifier simpleIdentifier = declaredIdentifier.getIdentifier();
        LocalVariableElement localVariableElement = (LocalVariableElement)this.findIdentifier(this.enclosingExecutable.getLocalVariables(), simpleIdentifier);
        this.processElement(localVariableElement);
        return (Void)super.visitDeclaredIdentifier(declaredIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitDefaultFormalParameter(DefaultFormalParameter defaultFormalParameter) {
        Element element;
        SimpleIdentifier simpleIdentifier = defaultFormalParameter.getParameter().getIdentifier();
        ParameterElement parameterElement = this.getElementForParameter(defaultFormalParameter, simpleIdentifier);
        Expression expression = defaultFormalParameter.getDefaultValue();
        if (expression != null) {
            element = this.enclosingExecutable;
            try {
                if (parameterElement != null) {
                    this.enclosingExecutable = parameterElement.getInitializer();
                }
                expression.accept(this);
            }
            finally {
                this.enclosingExecutable = element;
            }
            this.processElement(this.enclosingExecutable);
        }
        element = this.enclosingParameter;
        try {
            this.enclosingParameter = parameterElement;
            this.processElement(this.enclosingParameter);
            Void void_ = (Void)super.visitDefaultFormalParameter(defaultFormalParameter);
            return void_;
        }
        finally {
            this.enclosingParameter = element;
        }
    }

    @Override
    public Void visitExportDirective(ExportDirective exportDirective) {
        String string = this.getStringValue(exportDirective.getUri());
        if (string != null) {
            LibraryElement libraryElement = this.enclosingUnit.getLibrary();
            ExportElement exportElement = this.findExport(libraryElement.getExports(), this.enclosingUnit.getContext().getSourceFactory().resolveUri(this.enclosingUnit.getSource(), string));
            this.processElement(exportElement);
        }
        return (Void)super.visitExportDirective(exportDirective);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFieldFormalParameter(FieldFormalParameter fieldFormalParameter) {
        if (!(fieldFormalParameter.getParent() instanceof DefaultFormalParameter)) {
            SimpleIdentifier simpleIdentifier = fieldFormalParameter.getIdentifier();
            ParameterElement parameterElement = this.getElementForParameter(fieldFormalParameter, simpleIdentifier);
            ParameterElement parameterElement2 = this.enclosingParameter;
            try {
                this.enclosingParameter = parameterElement;
                this.processElement(this.enclosingParameter);
                Void void_ = (Void)super.visitFieldFormalParameter(fieldFormalParameter);
                return void_;
            }
            finally {
                this.enclosingParameter = parameterElement2;
            }
        }
        return (Void)super.visitFieldFormalParameter(fieldFormalParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        ExecutableElement executableElement = this.enclosingExecutable;
        try {
            Object object;
            SimpleIdentifier simpleIdentifier = functionDeclaration.getName();
            Token token = functionDeclaration.getPropertyKeyword();
            if (token == null) {
                this.enclosingExecutable = this.enclosingExecutable != null ? (ExecutableElement)this.findIdentifier(this.enclosingExecutable.getFunctions(), simpleIdentifier) : (ExecutableElement)this.findIdentifier(this.enclosingUnit.getFunctions(), simpleIdentifier);
            } else {
                object = (PropertyAccessorElement)this.findIdentifier(this.enclosingUnit.getAccessors(), simpleIdentifier);
                if (((KeywordToken)token).getKeyword() == Keyword.SET) {
                    object = object.getVariable().getSetter();
                }
                this.enclosingExecutable = object;
            }
            this.processElement(this.enclosingExecutable);
            object = (Void)super.visitFunctionDeclaration(functionDeclaration);
            return object;
        }
        finally {
            this.enclosingExecutable = executableElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionExpression(FunctionExpression functionExpression) {
        ExecutableElement executableElement;
        if (!(functionExpression.getParent() instanceof FunctionDeclaration)) {
            executableElement = (FunctionElement)this.findAtOffset(this.enclosingExecutable.getFunctions(), functionExpression.getBeginToken().getOffset());
            this.processElement(executableElement);
        }
        executableElement = this.enclosingExecutable;
        try {
            this.enclosingExecutable = functionExpression.getElement();
            this.processElement(this.enclosingExecutable);
            Void void_ = (Void)super.visitFunctionExpression(functionExpression);
            return void_;
        }
        finally {
            this.enclosingExecutable = executableElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionTypeAlias(FunctionTypeAlias functionTypeAlias) {
        FunctionTypeAliasElement functionTypeAliasElement = this.enclosingAlias;
        try {
            SimpleIdentifier simpleIdentifier = functionTypeAlias.getName();
            this.enclosingAlias = (FunctionTypeAliasElement)this.findIdentifier(this.enclosingUnit.getFunctionTypeAliases(), simpleIdentifier);
            this.processElement(this.enclosingAlias);
            Void void_ = (Void)super.visitFunctionTypeAlias(functionTypeAlias);
            return void_;
        }
        finally {
            this.enclosingAlias = functionTypeAliasElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionTypedFormalParameter(FunctionTypedFormalParameter functionTypedFormalParameter) {
        if (!(functionTypedFormalParameter.getParent() instanceof DefaultFormalParameter)) {
            SimpleIdentifier simpleIdentifier = functionTypedFormalParameter.getIdentifier();
            ParameterElement parameterElement = this.getElementForParameter(functionTypedFormalParameter, simpleIdentifier);
            ParameterElement parameterElement2 = this.enclosingParameter;
            try {
                this.enclosingParameter = parameterElement;
                this.processElement(this.enclosingParameter);
                Void void_ = (Void)super.visitFunctionTypedFormalParameter(functionTypedFormalParameter);
                return void_;
            }
            finally {
                this.enclosingParameter = parameterElement2;
            }
        }
        return (Void)super.visitFunctionTypedFormalParameter(functionTypedFormalParameter);
    }

    @Override
    public Void visitImportDirective(ImportDirective importDirective) {
        String string = this.getStringValue(importDirective.getUri());
        if (string != null) {
            LibraryElement libraryElement = this.enclosingUnit.getLibrary();
            ImportElement importElement = this.findImport(libraryElement.getImports(), this.enclosingUnit.getContext().getSourceFactory().resolveUri(this.enclosingUnit.getSource(), string), importDirective.getPrefix());
            this.processElement(importElement);
        }
        return (Void)super.visitImportDirective(importDirective);
    }

    @Override
    public Void visitLabeledStatement(LabeledStatement labeledStatement) {
        for (Label label : labeledStatement.getLabels()) {
            SimpleIdentifier simpleIdentifier = label.getLabel();
            LabelElement labelElement = (LabelElement)this.findIdentifier(this.enclosingExecutable.getLabels(), simpleIdentifier);
            this.processElement(labelElement);
        }
        return (Void)super.visitLabeledStatement(labeledStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        ExecutableElement executableElement = this.enclosingExecutable;
        try {
            Object object;
            Token token = methodDeclaration.getPropertyKeyword();
            SimpleIdentifier simpleIdentifier = methodDeclaration.getName();
            String string = simpleIdentifier.getName();
            if (string.equals(TokenType.MINUS.getLexeme()) && methodDeclaration.getParameters().getParameters().size() == 0) {
                string = "unary-";
            }
            if (token == null) {
                this.enclosingExecutable = (ExecutableElement)this.findWithNameAndOffset(this.enclosingClass.getMethods(), string, simpleIdentifier.getOffset());
                simpleIdentifier.setStaticElement(this.enclosingExecutable);
            } else {
                object = (PropertyAccessorElement)this.findIdentifier(this.enclosingClass.getAccessors(), simpleIdentifier);
                if (((KeywordToken)token).getKeyword() == Keyword.SET) {
                    object = object.getVariable().getSetter();
                    simpleIdentifier.setStaticElement((Element)object);
                }
                this.enclosingExecutable = object;
            }
            this.processElement(this.enclosingExecutable);
            object = (Void)super.visitMethodDeclaration(methodDeclaration);
            return object;
        }
        finally {
            this.enclosingExecutable = executableElement;
        }
    }

    @Override
    public Void visitPartDirective(PartDirective partDirective) {
        String string = this.getStringValue(partDirective.getUri());
        if (string != null) {
            Source source = this.enclosingUnit.getContext().getSourceFactory().resolveUri(this.enclosingUnit.getSource(), string);
            CompilationUnitElement compilationUnitElement = this.findPart(this.enclosingUnit.getLibrary().getParts(), source);
            this.processElement(compilationUnitElement);
        }
        return (Void)super.visitPartDirective(partDirective);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitSimpleFormalParameter(SimpleFormalParameter simpleFormalParameter) {
        if (!(simpleFormalParameter.getParent() instanceof DefaultFormalParameter)) {
            SimpleIdentifier simpleIdentifier = simpleFormalParameter.getIdentifier();
            ParameterElement parameterElement = this.getElementForParameter(simpleFormalParameter, simpleIdentifier);
            ParameterElement parameterElement2 = this.enclosingParameter;
            try {
                this.enclosingParameter = parameterElement;
                this.processElement(this.enclosingParameter);
                Void void_ = (Void)super.visitSimpleFormalParameter(simpleFormalParameter);
                return void_;
            }
            finally {
                this.enclosingParameter = parameterElement2;
            }
        }
        return (Void)super.visitSimpleFormalParameter(simpleFormalParameter);
    }

    @Override
    public Void visitSwitchCase(SwitchCase switchCase) {
        for (Label label : switchCase.getLabels()) {
            SimpleIdentifier simpleIdentifier = label.getLabel();
            LabelElement labelElement = (LabelElement)this.findIdentifier(this.enclosingExecutable.getLabels(), simpleIdentifier);
            this.processElement(labelElement);
        }
        return (Void)super.visitSwitchCase(switchCase);
    }

    @Override
    public Void visitSwitchDefault(SwitchDefault switchDefault) {
        for (Label label : switchDefault.getLabels()) {
            SimpleIdentifier simpleIdentifier = label.getLabel();
            LabelElement labelElement = (LabelElement)this.findIdentifier(this.enclosingExecutable.getLabels(), simpleIdentifier);
            this.processElement(labelElement);
        }
        return (Void)super.visitSwitchDefault(switchDefault);
    }

    @Override
    public Void visitTypeParameter(TypeParameter typeParameter) {
        SimpleIdentifier simpleIdentifier = typeParameter.getName();
        TypeParameterElement typeParameterElement = null;
        if (this.enclosingClass != null) {
            typeParameterElement = (TypeParameterElement)this.findIdentifier(this.enclosingClass.getTypeParameters(), simpleIdentifier);
        } else if (this.enclosingAlias != null) {
            typeParameterElement = (TypeParameterElement)this.findIdentifier(this.enclosingAlias.getTypeParameters(), simpleIdentifier);
        }
        this.processElement(typeParameterElement);
        return (Void)super.visitTypeParameter(typeParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitVariableDeclaration(VariableDeclaration variableDeclaration) {
        Expression expression;
        VariableElement variableElement = null;
        SimpleIdentifier simpleIdentifier = variableDeclaration.getName();
        if (this.enclosingExecutable != null) {
            variableElement = (VariableElement)this.findIdentifier(this.enclosingExecutable.getLocalVariables(), simpleIdentifier);
        }
        if (variableElement == null && this.enclosingClass != null) {
            variableElement = (VariableElement)this.findIdentifier(this.enclosingClass.getFields(), simpleIdentifier);
        }
        if (variableElement == null && this.enclosingUnit != null) {
            variableElement = (VariableElement)this.findIdentifier(this.enclosingUnit.getTopLevelVariables(), simpleIdentifier);
        }
        if ((expression = variableDeclaration.getInitializer()) != null) {
            ExecutableElement executableElement = this.enclosingExecutable;
            try {
                if (variableElement != null) {
                    this.enclosingExecutable = variableElement.getInitializer();
                }
                this.processElement(variableElement);
                this.processElement(this.enclosingExecutable);
                Void void_ = (Void)super.visitVariableDeclaration(variableDeclaration);
                return void_;
            }
            finally {
                this.enclosingExecutable = executableElement;
            }
        }
        return (Void)super.visitVariableDeclaration(variableDeclaration);
    }

    protected void processElement(Element element) {
        if (element == null) {
            throw new DeclarationMismatchException();
        }
        if (!this.allElements.contains(element)) {
            throw new DeclarationMismatchException();
        }
        this.unmatchedElements.remove(element);
    }

    private void captureEnclosingElements(Element element) {
        Element element2;
        Element element3 = element2 = element instanceof CompilationUnitElement ? element : element.getEnclosingElement();
        while (element2 != null) {
            if (element2 instanceof CompilationUnitElement) {
                this.enclosingUnit = (CompilationUnitElement)element2;
            } else if (element2 instanceof ClassElement) {
                if (this.enclosingClass == null) {
                    this.enclosingClass = (ClassElement)element2;
                }
            } else if (element2 instanceof FunctionTypeAliasElement) {
                if (this.enclosingAlias == null) {
                    this.enclosingAlias = (FunctionTypeAliasElement)element2;
                }
            } else if (element2 instanceof ExecutableElement) {
                if (this.enclosingExecutable == null) {
                    this.enclosingExecutable = (ExecutableElement)element2;
                }
            } else if (element2 instanceof ParameterElement && this.enclosingParameter == null) {
                this.enclosingParameter = (ParameterElement)element2;
            }
            element2 = element2.getEnclosingElement();
        }
    }

    private <E extends Element> E findAtOffset(E[] EArray, int n) {
        return (E)this.findWithNameAndOffset((Element[])EArray, "", n);
    }

    private ExportElement findExport(ExportElement[] exportElementArray, Source source) {
        for (ExportElement exportElement : exportElementArray) {
            if (!((Object)exportElement.getExportedLibrary().getSource()).equals(source)) continue;
            return exportElement;
        }
        return null;
    }

    private <E extends Element> E findIdentifier(E[] EArray, SimpleIdentifier simpleIdentifier) {
        return (E)this.findWithNameAndOffset((Element[])EArray, simpleIdentifier.getName(), simpleIdentifier.getOffset());
    }

    private ImportElement findImport(ImportElement[] importElementArray, Source source, SimpleIdentifier simpleIdentifier) {
        for (ImportElement importElement : importElementArray) {
            if (!((Object)importElement.getImportedLibrary().getSource()).equals(source)) continue;
            PrefixElement prefixElement = importElement.getPrefix();
            if (!(simpleIdentifier == null ? prefixElement == null : prefixElement != null && simpleIdentifier.getName().equals(prefixElement.getDisplayName()))) continue;
            return importElement;
        }
        return null;
    }

    private CompilationUnitElement findPart(CompilationUnitElement[] compilationUnitElementArray, Source source) {
        for (CompilationUnitElement compilationUnitElement : compilationUnitElementArray) {
            if (!((Object)compilationUnitElement.getSource()).equals(source)) continue;
            return compilationUnitElement;
        }
        return null;
    }

    private <E extends Element> E findWithNameAndOffset(E[] EArray, String string, int n) {
        for (E e : EArray) {
            if (!e.getDisplayName().equals(string) || e.getNameOffset() != n) continue;
            return e;
        }
        return null;
    }

    private void gatherElements(Element element) {
        element.accept(new GeneralizingElementVisitor<Void>(){

            @Override
            public Void visitElement(Element element) {
                DeclarationMatcher.this.allElements.add(element);
                DeclarationMatcher.this.unmatchedElements.add(element);
                return (Void)super.visitElement(element);
            }
        });
    }

    private ParameterElement getElementForParameter(FormalParameter formalParameter, SimpleIdentifier simpleIdentifier) {
        Element[] elementArray = null;
        if (this.enclosingParameter != null) {
            elementArray = this.enclosingParameter.getParameters();
        }
        if (elementArray == null && this.enclosingExecutable != null) {
            elementArray = this.enclosingExecutable.getParameters();
        }
        if (elementArray == null && this.enclosingAlias != null) {
            elementArray = this.enclosingAlias.getParameters();
        }
        return elementArray == null ? null : (ParameterElement)this.findIdentifier(elementArray, simpleIdentifier);
    }

    private String getStringValue(StringLiteral stringLiteral) {
        if (stringLiteral instanceof StringInterpolation) {
            return null;
        }
        return stringLiteral.getStringValue();
    }

    private boolean hasConstructor(ClassDeclaration classDeclaration) {
        for (ClassMember classMember : classDeclaration.getMembers()) {
            if (!(classMember instanceof ConstructorDeclaration)) continue;
            return true;
        }
        return false;
    }

    private static class DeclarationMismatchException
    extends RuntimeException {
    }
}

