/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.object;

import com.google.dart.engine.element.Element;
import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DynamicState;
import com.google.dart.engine.internal.object.EvaluationException;
import com.google.dart.engine.internal.object.InstanceState;
import com.google.dart.engine.internal.object.StringState;
import com.google.dart.engine.utilities.general.ObjectUtilities;

public class TypeState
extends InstanceState {
    private Element element;

    public TypeState(Element element) {
        this.element = element;
    }

    @Override
    public StringState convertToString() throws EvaluationException {
        if (this.element == null) {
            return StringState.UNKNOWN_VALUE;
        }
        return new StringState(this.element.getName());
    }

    public boolean equals(Object object) {
        return object instanceof TypeState && ObjectUtilities.equals(this.element, ((TypeState)object).element);
    }

    @Override
    public BoolState equalEqual(InstanceState instanceState) throws EvaluationException {
        this.assertBoolNumStringOrNull(instanceState);
        if (this.element == null) {
            return BoolState.UNKNOWN_VALUE;
        }
        if (instanceState instanceof TypeState) {
            Element element = ((TypeState)instanceState).element;
            if (element == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.element.equals(element));
        }
        if (instanceState instanceof DynamicState) {
            return BoolState.UNKNOWN_VALUE;
        }
        return BoolState.FALSE_STATE;
    }

    @Override
    public String getTypeName() {
        return "Type";
    }

    public int hashCode() {
        return this.element == null ? 0 : this.element.hashCode();
    }

    public String toString() {
        return this.element == null ? "-unknown-" : this.element.getName();
    }
}

