/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.object;

import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DynamicState;
import com.google.dart.engine.internal.object.EvaluationException;
import com.google.dart.engine.internal.object.InstanceState;
import com.google.dart.engine.internal.object.StringState;
import com.google.dart.engine.utilities.general.ObjectUtilities;

public class SymbolState
extends InstanceState {
    private String value;

    public SymbolState(String string) {
        this.value = string;
    }

    @Override
    public StringState convertToString() {
        if (this.value == null) {
            return StringState.UNKNOWN_VALUE;
        }
        return new StringState(this.value);
    }

    @Override
    public BoolState equalEqual(InstanceState instanceState) throws EvaluationException {
        this.assertBoolNumStringOrNull(instanceState);
        if (this.value == null) {
            return BoolState.UNKNOWN_VALUE;
        }
        if (instanceState instanceof SymbolState) {
            String string = ((SymbolState)instanceState).getValue();
            if (string == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value.equals(string));
        }
        if (instanceState instanceof DynamicState) {
            return BoolState.UNKNOWN_VALUE;
        }
        return BoolState.FALSE_STATE;
    }

    public boolean equals(Object object) {
        return object instanceof SymbolState && ObjectUtilities.equals(this.value, ((SymbolState)object).value);
    }

    @Override
    public String getTypeName() {
        return "Symbol";
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean hasExactValue() {
        return true;
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public String toString() {
        return this.value == null ? "-unknown-" : "#" + this.value;
    }
}

