/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.object;

import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DynamicState;
import com.google.dart.engine.internal.object.EvaluationException;
import com.google.dart.engine.internal.object.InstanceState;
import com.google.dart.engine.utilities.general.ObjectUtilities;

public class StringState
extends InstanceState {
    private String value;
    public static final StringState UNKNOWN_VALUE = new StringState(null);

    public StringState(String string) {
        this.value = string;
    }

    @Override
    public StringState concatenate(InstanceState instanceState) throws EvaluationException {
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof StringState) {
            String string = ((StringState)instanceState).getValue();
            if (string == null) {
                return UNKNOWN_VALUE;
            }
            return new StringState(this.value + string);
        }
        if (instanceState instanceof DynamicState) {
            return UNKNOWN_VALUE;
        }
        return super.concatenate(instanceState);
    }

    @Override
    public StringState convertToString() {
        return this;
    }

    @Override
    public BoolState equalEqual(InstanceState instanceState) throws EvaluationException {
        this.assertBoolNumStringOrNull(instanceState);
        if (this.value == null) {
            return BoolState.UNKNOWN_VALUE;
        }
        if (instanceState instanceof StringState) {
            String string = ((StringState)instanceState).getValue();
            if (string == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value.equals(string));
        }
        if (instanceState instanceof DynamicState) {
            return BoolState.UNKNOWN_VALUE;
        }
        return BoolState.FALSE_STATE;
    }

    public boolean equals(Object object) {
        return object instanceof StringState && ObjectUtilities.equals(this.value, ((StringState)object).value);
    }

    @Override
    public String getTypeName() {
        return "String";
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean hasExactValue() {
        return true;
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    @Override
    public boolean isBoolNumStringOrNull() {
        return true;
    }

    public String toString() {
        return this.value == null ? "-unknown-" : "'" + this.value + "'";
    }
}

