/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.object;

import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DynamicState;
import com.google.dart.engine.internal.object.EvaluationException;
import com.google.dart.engine.internal.object.InstanceState;
import com.google.dart.engine.internal.object.IntState;
import com.google.dart.engine.internal.object.StringState;
import java.math.BigInteger;

public class NumState
extends InstanceState {
    public static final NumState UNKNOWN_VALUE = new NumState();

    @Override
    public NumState add(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return UNKNOWN_VALUE;
    }

    @Override
    public StringState convertToString() {
        return StringState.UNKNOWN_VALUE;
    }

    @Override
    public NumState divide(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return UNKNOWN_VALUE;
    }

    public boolean equals(Object object) {
        return object instanceof NumState;
    }

    @Override
    public BoolState equalEqual(InstanceState instanceState) throws EvaluationException {
        this.assertBoolNumStringOrNull(instanceState);
        return BoolState.UNKNOWN_VALUE;
    }

    @Override
    public String getTypeName() {
        return "num";
    }

    @Override
    public BoolState greaterThan(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return BoolState.UNKNOWN_VALUE;
    }

    @Override
    public BoolState greaterThanOrEqual(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return BoolState.UNKNOWN_VALUE;
    }

    public int hashCode() {
        return 7;
    }

    @Override
    public IntState integerDivide(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return IntState.UNKNOWN_VALUE;
            }
            if (bigInteger.equals(BigInteger.ZERO)) {
                throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_IDBZE);
            }
        } else if (instanceState instanceof DynamicState) {
            return IntState.UNKNOWN_VALUE;
        }
        return IntState.UNKNOWN_VALUE;
    }

    @Override
    public boolean isBoolNumStringOrNull() {
        return true;
    }

    @Override
    public BoolState lessThan(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return BoolState.UNKNOWN_VALUE;
    }

    @Override
    public BoolState lessThanOrEqual(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return BoolState.UNKNOWN_VALUE;
    }

    @Override
    public NumState minus(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return UNKNOWN_VALUE;
    }

    @Override
    public NumState negated() throws EvaluationException {
        return UNKNOWN_VALUE;
    }

    @Override
    public NumState remainder(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return UNKNOWN_VALUE;
    }

    @Override
    public NumState times(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return UNKNOWN_VALUE;
    }

    public String toString() {
        return "-unknown-";
    }
}

