/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.object;

import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DynamicState;
import com.google.dart.engine.internal.object.EvaluationException;
import com.google.dart.engine.internal.object.InstanceState;
import com.google.dart.engine.internal.object.StringState;

public class NullState
extends InstanceState {
    public static final NullState NULL_STATE = new NullState();

    private NullState() {
    }

    @Override
    public BoolState convertToBool() throws EvaluationException {
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public StringState convertToString() {
        return new StringState("null");
    }

    @Override
    public BoolState equalEqual(InstanceState instanceState) throws EvaluationException {
        this.assertBoolNumStringOrNull(instanceState);
        if (instanceState instanceof DynamicState) {
            return BoolState.UNKNOWN_VALUE;
        }
        return BoolState.from(instanceState instanceof NullState);
    }

    public boolean equals(Object object) {
        return object instanceof NullState;
    }

    @Override
    public String getTypeName() {
        return "Null";
    }

    @Override
    public boolean hasExactValue() {
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public boolean isBoolNumStringOrNull() {
        return true;
    }

    @Override
    public BoolState logicalNot() throws EvaluationException {
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    public String toString() {
        return "null";
    }
}

