/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.object;

import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DartObjectImpl;
import com.google.dart.engine.internal.object.DynamicState;
import com.google.dart.engine.internal.object.EvaluationException;
import com.google.dart.engine.internal.object.InstanceState;
import com.google.dart.engine.internal.object.StringState;
import java.util.HashMap;
import java.util.Map;

public class MapState
extends InstanceState {
    private HashMap<DartObjectImpl, DartObjectImpl> entries;

    public MapState(HashMap<DartObjectImpl, DartObjectImpl> hashMap) {
        this.entries = hashMap;
    }

    @Override
    public StringState convertToString() {
        return StringState.UNKNOWN_VALUE;
    }

    @Override
    public BoolState equalEqual(InstanceState instanceState) throws EvaluationException {
        this.assertBoolNumStringOrNull(instanceState);
        if (instanceState instanceof DynamicState) {
            return BoolState.UNKNOWN_VALUE;
        }
        return BoolState.from(this.equals(instanceState));
    }

    public boolean equals(Object object) {
        if (!(object instanceof MapState)) {
            return false;
        }
        HashMap<DartObjectImpl, DartObjectImpl> hashMap = ((MapState)object).entries;
        int n = this.entries.size();
        if (hashMap.size() != n) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        for (Map.Entry<DartObjectImpl, DartObjectImpl> entry : this.entries.entrySet()) {
            DartObjectImpl dartObjectImpl;
            DartObjectImpl dartObjectImpl2 = entry.getKey();
            DartObjectImpl dartObjectImpl3 = entry.getValue();
            if (dartObjectImpl3.equals(dartObjectImpl = hashMap.get(dartObjectImpl2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getTypeName() {
        return "Map";
    }

    @Override
    public Map<Object, Object> getValue() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (Map.Entry<DartObjectImpl, DartObjectImpl> entry : this.entries.entrySet()) {
            DartObjectImpl dartObjectImpl = entry.getKey();
            DartObjectImpl dartObjectImpl2 = entry.getValue();
            if (!dartObjectImpl.hasExactValue() || !dartObjectImpl2.hasExactValue()) {
                return null;
            }
            hashMap.put(dartObjectImpl.getValue(), dartObjectImpl2.getValue());
        }
        return hashMap;
    }

    @Override
    public boolean hasExactValue() {
        for (Map.Entry<DartObjectImpl, DartObjectImpl> entry : this.entries.entrySet()) {
            if (entry.getKey().hasExactValue() && entry.getValue().hasExactValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (DartObjectImpl dartObjectImpl : this.entries.keySet()) {
            n = n << 3 ^ dartObjectImpl.hashCode();
        }
        return n;
    }
}

