/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.object;

import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DartObjectImpl;
import com.google.dart.engine.internal.object.DynamicState;
import com.google.dart.engine.internal.object.EvaluationException;
import com.google.dart.engine.internal.object.InstanceState;
import com.google.dart.engine.internal.object.StringState;

public class ListState
extends InstanceState {
    private DartObjectImpl[] elements;

    public ListState(DartObjectImpl[] dartObjectImplArray) {
        this.elements = dartObjectImplArray;
    }

    @Override
    public StringState convertToString() {
        return StringState.UNKNOWN_VALUE;
    }

    @Override
    public BoolState equalEqual(InstanceState instanceState) throws EvaluationException {
        this.assertBoolNumStringOrNull(instanceState);
        if (instanceState instanceof DynamicState) {
            return BoolState.UNKNOWN_VALUE;
        }
        return BoolState.from(this.equals(instanceState));
    }

    public boolean equals(Object object) {
        if (!(object instanceof ListState)) {
            return false;
        }
        DartObjectImpl[] dartObjectImplArray = ((ListState)object).elements;
        int n = this.elements.length;
        if (dartObjectImplArray.length != n) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (this.elements[i].equals(dartObjectImplArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getTypeName() {
        return "List";
    }

    public Object[] getValue() {
        int n = this.elements.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            DartObjectImpl dartObjectImpl = this.elements[i];
            if (!dartObjectImpl.hasExactValue()) {
                return null;
            }
            objectArray[i] = dartObjectImpl.getValue();
        }
        return objectArray;
    }

    @Override
    public boolean hasExactValue() {
        int n = this.elements.length;
        for (int i = 0; i < n; ++i) {
            if (this.elements[i].hasExactValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.elements.length;
        for (int i = 0; i < n2; ++i) {
            n = n << 3 ^ this.elements[i].hashCode();
        }
        return n;
    }
}

