/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.object;

import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DoubleState;
import com.google.dart.engine.internal.object.DynamicState;
import com.google.dart.engine.internal.object.EvaluationException;
import com.google.dart.engine.internal.object.InstanceState;
import com.google.dart.engine.internal.object.NumState;
import com.google.dart.engine.internal.object.StringState;
import com.google.dart.engine.utilities.general.ObjectUtilities;
import java.math.BigInteger;

public class IntState
extends NumState {
    private BigInteger value;
    public static final IntState UNKNOWN_VALUE = new IntState(null);

    public IntState(BigInteger bigInteger) {
        this.value = bigInteger;
    }

    @Override
    public NumState add(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            if (instanceState instanceof DoubleState) {
                return DoubleState.UNKNOWN_VALUE;
            }
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return UNKNOWN_VALUE;
            }
            return new IntState(this.value.add(bigInteger));
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return DoubleState.UNKNOWN_VALUE;
            }
            return new DoubleState(this.value.doubleValue() + d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public IntState bitAnd(InstanceState instanceState) throws EvaluationException {
        this.assertIntOrNull(instanceState);
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return UNKNOWN_VALUE;
            }
            return new IntState(this.value.and(bigInteger));
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public IntState bitNot() throws EvaluationException {
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        return new IntState(this.value.not());
    }

    @Override
    public IntState bitOr(InstanceState instanceState) throws EvaluationException {
        this.assertIntOrNull(instanceState);
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return UNKNOWN_VALUE;
            }
            return new IntState(this.value.or(bigInteger));
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public IntState bitXor(InstanceState instanceState) throws EvaluationException {
        this.assertIntOrNull(instanceState);
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return UNKNOWN_VALUE;
            }
            return new IntState(this.value.xor(bigInteger));
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public StringState convertToString() {
        if (this.value == null) {
            return StringState.UNKNOWN_VALUE;
        }
        return new StringState(this.value.toString());
    }

    @Override
    public NumState divide(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            if (instanceState instanceof DoubleState) {
                return DoubleState.UNKNOWN_VALUE;
            }
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return UNKNOWN_VALUE;
            }
            if (bigInteger.equals(BigInteger.ZERO)) {
                return new DoubleState(this.value.doubleValue() / bigInteger.doubleValue());
            }
            return new IntState(this.value.divide(bigInteger));
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return DoubleState.UNKNOWN_VALUE;
            }
            return new DoubleState(this.value.doubleValue() / d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public BoolState equalEqual(InstanceState instanceState) throws EvaluationException {
        this.assertBoolNumStringOrNull(instanceState);
        if (this.value == null) {
            return BoolState.UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value.equals(bigInteger));
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(d.equals(this.value.doubleValue()));
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return BoolState.UNKNOWN_VALUE;
        }
        return BoolState.FALSE_STATE;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof IntState && ObjectUtilities.equals(this.value, ((IntState)object).value);
    }

    @Override
    public String getTypeName() {
        return "int";
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public BoolState greaterThan(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            return BoolState.UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value.compareTo(bigInteger) > 0);
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value.doubleValue() > d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return BoolState.UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public BoolState greaterThanOrEqual(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            return BoolState.UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value.compareTo(bigInteger) >= 0);
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value.doubleValue() >= d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return BoolState.UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public boolean hasExactValue() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    @Override
    public IntState integerDivide(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return UNKNOWN_VALUE;
            }
            if (bigInteger.equals(BigInteger.ZERO)) {
                throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_IDBZE);
            }
            return new IntState(this.value.divide(bigInteger));
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return UNKNOWN_VALUE;
            }
            double d2 = this.value.doubleValue() / d;
            return new IntState(BigInteger.valueOf((long)d2));
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public boolean isBoolNumStringOrNull() {
        return true;
    }

    @Override
    public BoolState lessThan(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            return BoolState.UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value.compareTo(bigInteger) < 0);
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value.doubleValue() < d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return BoolState.UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public BoolState lessThanOrEqual(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            return BoolState.UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value.compareTo(bigInteger) <= 0);
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value.doubleValue() <= d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return BoolState.UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public NumState minus(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            if (instanceState instanceof DoubleState) {
                return DoubleState.UNKNOWN_VALUE;
            }
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return UNKNOWN_VALUE;
            }
            return new IntState(this.value.subtract(bigInteger));
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return DoubleState.UNKNOWN_VALUE;
            }
            return new DoubleState(this.value.doubleValue() - d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public NumState negated() throws EvaluationException {
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        return new IntState(this.value.negate());
    }

    @Override
    public NumState remainder(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            if (instanceState instanceof DoubleState) {
                return DoubleState.UNKNOWN_VALUE;
            }
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return UNKNOWN_VALUE;
            }
            if (bigInteger.equals(BigInteger.ZERO)) {
                return new DoubleState(this.value.doubleValue() % bigInteger.doubleValue());
            }
            return new IntState(this.value.remainder(bigInteger));
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return DoubleState.UNKNOWN_VALUE;
            }
            return new DoubleState(this.value.doubleValue() % d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public IntState shiftLeft(InstanceState instanceState) throws EvaluationException {
        this.assertIntOrNull(instanceState);
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return UNKNOWN_VALUE;
            }
            if (bigInteger.bitLength() > 31) {
                return UNKNOWN_VALUE;
            }
            return new IntState(this.value.shiftLeft(bigInteger.intValue()));
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public IntState shiftRight(InstanceState instanceState) throws EvaluationException {
        this.assertIntOrNull(instanceState);
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return UNKNOWN_VALUE;
            }
            if (bigInteger.bitLength() > 31) {
                return UNKNOWN_VALUE;
            }
            return new IntState(this.value.shiftRight(bigInteger.intValue()));
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public NumState times(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            if (instanceState instanceof DoubleState) {
                return DoubleState.UNKNOWN_VALUE;
            }
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return UNKNOWN_VALUE;
            }
            return new IntState(this.value.multiply(bigInteger));
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return DoubleState.UNKNOWN_VALUE;
            }
            return new DoubleState(this.value.doubleValue() * d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public String toString() {
        return this.value == null ? "-unknown-" : this.value.toString();
    }
}

