/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.object;

import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DoubleState;
import com.google.dart.engine.internal.object.DynamicState;
import com.google.dart.engine.internal.object.EvaluationException;
import com.google.dart.engine.internal.object.IntState;
import com.google.dart.engine.internal.object.NullState;
import com.google.dart.engine.internal.object.NumState;
import com.google.dart.engine.internal.object.StringState;

public abstract class InstanceState {
    public NumState add(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(this);
        this.assertNumOrNull(instanceState);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public IntState bitAnd(InstanceState instanceState) throws EvaluationException {
        this.assertIntOrNull(this);
        this.assertIntOrNull(instanceState);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public IntState bitNot() throws EvaluationException {
        this.assertIntOrNull(this);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public IntState bitOr(InstanceState instanceState) throws EvaluationException {
        this.assertIntOrNull(this);
        this.assertIntOrNull(instanceState);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public IntState bitXor(InstanceState instanceState) throws EvaluationException {
        this.assertIntOrNull(this);
        this.assertIntOrNull(instanceState);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public StringState concatenate(InstanceState instanceState) throws EvaluationException {
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public BoolState convertToBool() throws EvaluationException {
        return BoolState.FALSE_STATE;
    }

    public abstract StringState convertToString() throws EvaluationException;

    public NumState divide(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(this);
        this.assertNumOrNull(instanceState);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public abstract BoolState equalEqual(InstanceState var1) throws EvaluationException;

    public abstract String getTypeName();

    public Object getValue() {
        return null;
    }

    public BoolState greaterThan(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(this);
        this.assertNumOrNull(instanceState);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public BoolState greaterThanOrEqual(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(this);
        this.assertNumOrNull(instanceState);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public boolean hasExactValue() {
        return false;
    }

    public IntState integerDivide(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(this);
        this.assertNumOrNull(instanceState);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public boolean isBool() {
        return false;
    }

    public boolean isBoolNumStringOrNull() {
        return false;
    }

    public BoolState lessThan(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(this);
        this.assertNumOrNull(instanceState);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public BoolState lessThanOrEqual(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(this);
        this.assertNumOrNull(instanceState);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public BoolState logicalAnd(InstanceState instanceState) throws EvaluationException {
        this.assertBool(this);
        this.assertBool(instanceState);
        return BoolState.FALSE_STATE;
    }

    public BoolState logicalNot() throws EvaluationException {
        this.assertBool(this);
        return BoolState.TRUE_STATE;
    }

    public BoolState logicalOr(InstanceState instanceState) throws EvaluationException {
        this.assertBool(this);
        this.assertBool(instanceState);
        return instanceState.convertToBool();
    }

    public NumState minus(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(this);
        this.assertNumOrNull(instanceState);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public NumState negated() throws EvaluationException {
        this.assertNumOrNull(this);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public NumState remainder(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(this);
        this.assertNumOrNull(instanceState);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public IntState shiftLeft(InstanceState instanceState) throws EvaluationException {
        this.assertIntOrNull(this);
        this.assertIntOrNull(instanceState);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public IntState shiftRight(InstanceState instanceState) throws EvaluationException {
        this.assertIntOrNull(this);
        this.assertIntOrNull(instanceState);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    public NumState times(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(this);
        this.assertNumOrNull(instanceState);
        throw new EvaluationException(CompileTimeErrorCode.INVALID_CONSTANT);
    }

    protected void assertBool(InstanceState instanceState) throws EvaluationException {
        if (!(instanceState instanceof BoolState) && !(instanceState instanceof DynamicState)) {
            throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_TYPE_BOOL);
        }
    }

    protected void assertBoolNumStringOrNull(InstanceState instanceState) throws EvaluationException {
        if (!(instanceState instanceof BoolState || instanceState instanceof DoubleState || instanceState instanceof IntState || instanceState instanceof NumState || instanceState instanceof StringState || instanceState instanceof NullState || instanceState instanceof DynamicState)) {
            throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_TYPE_BOOL_NUM_STRING);
        }
    }

    protected void assertIntOrNull(InstanceState instanceState) throws EvaluationException {
        if (!(instanceState instanceof IntState || instanceState instanceof NumState || instanceState instanceof NullState || instanceState instanceof DynamicState)) {
            throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_TYPE_INT);
        }
    }

    protected void assertNumOrNull(InstanceState instanceState) throws EvaluationException {
        if (!(instanceState instanceof DoubleState || instanceState instanceof IntState || instanceState instanceof NumState || instanceState instanceof NullState || instanceState instanceof DynamicState)) {
            throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_TYPE_NUM);
        }
    }

    protected void assertString(InstanceState instanceState) throws EvaluationException {
        if (!(instanceState instanceof StringState) && !(instanceState instanceof DynamicState)) {
            throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_TYPE_BOOL);
        }
    }
}

