/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.object;

import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DartObjectImpl;
import com.google.dart.engine.internal.object.DynamicState;
import com.google.dart.engine.internal.object.EvaluationException;
import com.google.dart.engine.internal.object.InstanceState;
import com.google.dart.engine.internal.object.StringState;
import java.util.HashMap;
import java.util.HashSet;

public class GenericState
extends InstanceState {
    private HashMap<String, DartObjectImpl> fieldMap = new HashMap();
    public static final GenericState UNKNOWN_VALUE = new GenericState(new HashMap<String, DartObjectImpl>());

    public GenericState(HashMap<String, DartObjectImpl> hashMap) {
        this.fieldMap = hashMap;
    }

    @Override
    public StringState convertToString() {
        return StringState.UNKNOWN_VALUE;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GenericState)) {
            return false;
        }
        GenericState genericState = (GenericState)object;
        HashSet<String> hashSet = new HashSet<String>(genericState.fieldMap.keySet());
        for (String string : this.fieldMap.keySet()) {
            if (!this.fieldMap.get(string).equals(genericState.fieldMap.get(string))) {
                return false;
            }
            hashSet.remove(string);
        }
        for (String string : hashSet) {
            if (genericState.fieldMap.get(string).equals(this.fieldMap.get(string))) continue;
            return false;
        }
        return true;
    }

    @Override
    public BoolState equalEqual(InstanceState instanceState) throws EvaluationException {
        this.assertBoolNumStringOrNull(instanceState);
        if (instanceState instanceof DynamicState) {
            return BoolState.UNKNOWN_VALUE;
        }
        return BoolState.from(this.equals(instanceState));
    }

    @Override
    public String getTypeName() {
        return "user defined type";
    }

    public int hashCode() {
        int n = 0;
        for (DartObjectImpl dartObjectImpl : this.fieldMap.values()) {
            n += dartObjectImpl.hashCode();
        }
        return n;
    }
}

