/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.object;

import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DynamicState;
import com.google.dart.engine.internal.object.EvaluationException;
import com.google.dart.engine.internal.object.InstanceState;
import com.google.dart.engine.internal.object.StringState;
import com.google.dart.engine.utilities.general.ObjectUtilities;

public class FunctionState
extends InstanceState {
    private ExecutableElement element;

    public FunctionState(ExecutableElement executableElement) {
        this.element = executableElement;
    }

    @Override
    public StringState convertToString() throws EvaluationException {
        if (this.element == null) {
            return StringState.UNKNOWN_VALUE;
        }
        return new StringState(this.element.getName());
    }

    public boolean equals(Object object) {
        return object instanceof FunctionState && ObjectUtilities.equals(this.element, ((FunctionState)object).element);
    }

    @Override
    public BoolState equalEqual(InstanceState instanceState) throws EvaluationException {
        if (this.element == null) {
            return BoolState.UNKNOWN_VALUE;
        }
        if (instanceState instanceof FunctionState) {
            ExecutableElement executableElement = ((FunctionState)instanceState).element;
            if (executableElement == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.element.equals(executableElement));
        }
        if (instanceState instanceof DynamicState) {
            return BoolState.UNKNOWN_VALUE;
        }
        return BoolState.FALSE_STATE;
    }

    @Override
    public String getTypeName() {
        return "Function";
    }

    public int hashCode() {
        return this.element == null ? 0 : this.element.hashCode();
    }

    public String toString() {
        return this.element == null ? "-unknown-" : this.element.getName();
    }
}

