/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.object;

import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DoubleState;
import com.google.dart.engine.internal.object.EvaluationException;
import com.google.dart.engine.internal.object.InstanceState;
import com.google.dart.engine.internal.object.IntState;
import com.google.dart.engine.internal.object.NumState;
import com.google.dart.engine.internal.object.StringState;

public class DynamicState
extends InstanceState {
    public static final DynamicState DYNAMIC_STATE = new DynamicState();

    private DynamicState() {
    }

    @Override
    public NumState add(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return this.unknownNum(instanceState);
    }

    @Override
    public IntState bitAnd(InstanceState instanceState) throws EvaluationException {
        this.assertIntOrNull(instanceState);
        return IntState.UNKNOWN_VALUE;
    }

    @Override
    public IntState bitNot() throws EvaluationException {
        return IntState.UNKNOWN_VALUE;
    }

    @Override
    public IntState bitOr(InstanceState instanceState) throws EvaluationException {
        this.assertIntOrNull(instanceState);
        return IntState.UNKNOWN_VALUE;
    }

    @Override
    public IntState bitXor(InstanceState instanceState) throws EvaluationException {
        this.assertIntOrNull(instanceState);
        return IntState.UNKNOWN_VALUE;
    }

    @Override
    public StringState concatenate(InstanceState instanceState) throws EvaluationException {
        this.assertString(instanceState);
        return StringState.UNKNOWN_VALUE;
    }

    @Override
    public BoolState convertToBool() throws EvaluationException {
        return BoolState.UNKNOWN_VALUE;
    }

    @Override
    public StringState convertToString() throws EvaluationException {
        return StringState.UNKNOWN_VALUE;
    }

    @Override
    public NumState divide(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return this.unknownNum(instanceState);
    }

    @Override
    public BoolState equalEqual(InstanceState instanceState) throws EvaluationException {
        this.assertBoolNumStringOrNull(instanceState);
        return BoolState.UNKNOWN_VALUE;
    }

    @Override
    public String getTypeName() {
        return "dynamic";
    }

    @Override
    public BoolState greaterThan(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return BoolState.UNKNOWN_VALUE;
    }

    @Override
    public BoolState greaterThanOrEqual(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return BoolState.UNKNOWN_VALUE;
    }

    @Override
    public IntState integerDivide(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return IntState.UNKNOWN_VALUE;
    }

    @Override
    public boolean isBool() {
        return true;
    }

    @Override
    public boolean isBoolNumStringOrNull() {
        return true;
    }

    @Override
    public BoolState lessThan(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return BoolState.UNKNOWN_VALUE;
    }

    @Override
    public BoolState lessThanOrEqual(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return BoolState.UNKNOWN_VALUE;
    }

    @Override
    public BoolState logicalAnd(InstanceState instanceState) throws EvaluationException {
        this.assertBool(instanceState);
        return BoolState.UNKNOWN_VALUE;
    }

    @Override
    public BoolState logicalNot() throws EvaluationException {
        return BoolState.UNKNOWN_VALUE;
    }

    @Override
    public BoolState logicalOr(InstanceState instanceState) throws EvaluationException {
        this.assertBool(instanceState);
        return instanceState.convertToBool();
    }

    @Override
    public NumState minus(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return this.unknownNum(instanceState);
    }

    @Override
    public NumState negated() throws EvaluationException {
        return NumState.UNKNOWN_VALUE;
    }

    @Override
    public NumState remainder(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return this.unknownNum(instanceState);
    }

    @Override
    public IntState shiftLeft(InstanceState instanceState) throws EvaluationException {
        this.assertIntOrNull(instanceState);
        return IntState.UNKNOWN_VALUE;
    }

    @Override
    public IntState shiftRight(InstanceState instanceState) throws EvaluationException {
        this.assertIntOrNull(instanceState);
        return IntState.UNKNOWN_VALUE;
    }

    @Override
    public NumState times(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        return this.unknownNum(instanceState);
    }

    private NumState unknownNum(InstanceState instanceState) {
        if (instanceState instanceof IntState) {
            return IntState.UNKNOWN_VALUE;
        }
        if (instanceState instanceof DoubleState) {
            return DoubleState.UNKNOWN_VALUE;
        }
        return NumState.UNKNOWN_VALUE;
    }
}

