/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.object;

import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DynamicState;
import com.google.dart.engine.internal.object.EvaluationException;
import com.google.dart.engine.internal.object.InstanceState;
import com.google.dart.engine.internal.object.IntState;
import com.google.dart.engine.internal.object.NumState;
import com.google.dart.engine.internal.object.StringState;
import com.google.dart.engine.utilities.general.ObjectUtilities;
import java.math.BigInteger;

public class DoubleState
extends NumState {
    private Double value;
    public static final DoubleState UNKNOWN_VALUE = new DoubleState(null);

    public DoubleState(Double d) {
        this.value = d;
    }

    @Override
    public NumState add(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return UNKNOWN_VALUE;
            }
            return new DoubleState(this.value + bigInteger.doubleValue());
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return UNKNOWN_VALUE;
            }
            return new DoubleState(this.value + d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public StringState convertToString() {
        if (this.value == null) {
            return StringState.UNKNOWN_VALUE;
        }
        return new StringState(Double.toString(this.value));
    }

    @Override
    public NumState divide(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return UNKNOWN_VALUE;
            }
            return new DoubleState(this.value / bigInteger.doubleValue());
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return UNKNOWN_VALUE;
            }
            return new DoubleState(this.value / d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public BoolState equalEqual(InstanceState instanceState) throws EvaluationException {
        this.assertBoolNumStringOrNull(instanceState);
        if (this.value == null) {
            return BoolState.UNKNOWN_VALUE;
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value.doubleValue() == d.doubleValue());
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value.equals(bigInteger.doubleValue()));
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return BoolState.UNKNOWN_VALUE;
        }
        return BoolState.FALSE_STATE;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof DoubleState && ObjectUtilities.equals(this.value, ((DoubleState)object).value);
    }

    @Override
    public String getTypeName() {
        return "double";
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public BoolState greaterThan(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            return BoolState.UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value > bigInteger.doubleValue());
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value > d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return BoolState.UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public BoolState greaterThanOrEqual(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            return BoolState.UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value >= bigInteger.doubleValue());
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value >= d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return BoolState.UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public boolean hasExactValue() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    @Override
    public IntState integerDivide(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            return IntState.UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return IntState.UNKNOWN_VALUE;
            }
            double d = this.value / bigInteger.doubleValue();
            return new IntState(BigInteger.valueOf((long)d));
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return IntState.UNKNOWN_VALUE;
            }
            double d2 = this.value / d;
            return new IntState(BigInteger.valueOf((long)d2));
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return IntState.UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public boolean isBoolNumStringOrNull() {
        return true;
    }

    @Override
    public BoolState lessThan(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            return BoolState.UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value < bigInteger.doubleValue());
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value < d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return BoolState.UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public BoolState lessThanOrEqual(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            return BoolState.UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value <= bigInteger.doubleValue());
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return BoolState.UNKNOWN_VALUE;
            }
            return BoolState.from(this.value <= d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return BoolState.UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public NumState minus(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return UNKNOWN_VALUE;
            }
            return new DoubleState(this.value - bigInteger.doubleValue());
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return UNKNOWN_VALUE;
            }
            return new DoubleState(this.value - d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public NumState negated() throws EvaluationException {
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        return new DoubleState(-this.value.doubleValue());
    }

    @Override
    public NumState remainder(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return UNKNOWN_VALUE;
            }
            return new DoubleState(this.value % bigInteger.doubleValue());
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return UNKNOWN_VALUE;
            }
            return new DoubleState(this.value % d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public NumState times(InstanceState instanceState) throws EvaluationException {
        this.assertNumOrNull(instanceState);
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof IntState) {
            BigInteger bigInteger = ((IntState)instanceState).getValue();
            if (bigInteger == null) {
                return UNKNOWN_VALUE;
            }
            return new DoubleState(this.value * bigInteger.doubleValue());
        }
        if (instanceState instanceof DoubleState) {
            Double d = ((DoubleState)instanceState).getValue();
            if (d == null) {
                return UNKNOWN_VALUE;
            }
            return new DoubleState(this.value * d);
        }
        if (instanceState instanceof DynamicState || instanceState instanceof NumState) {
            return UNKNOWN_VALUE;
        }
        throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
    }

    @Override
    public String toString() {
        return this.value == null ? "-unknown-" : Double.toString(this.value);
    }
}

