/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.object;

import com.google.dart.engine.constant.DartObject;
import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DoubleState;
import com.google.dart.engine.internal.object.EvaluationException;
import com.google.dart.engine.internal.object.GenericState;
import com.google.dart.engine.internal.object.InstanceState;
import com.google.dart.engine.internal.object.IntState;
import com.google.dart.engine.internal.object.NullState;
import com.google.dart.engine.internal.object.NumState;
import com.google.dart.engine.internal.object.StringState;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.utilities.general.ObjectUtilities;
import java.math.BigInteger;

public class DartObjectImpl
implements DartObject {
    private InterfaceType type;
    private InstanceState state;

    public DartObjectImpl(InterfaceType interfaceType, InstanceState instanceState) {
        this.type = interfaceType;
        this.state = instanceState;
    }

    public DartObjectImpl add(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        NumState numState = this.state.add(dartObjectImpl.state);
        if (numState instanceof IntState) {
            return new DartObjectImpl(typeProvider.getIntType(), numState);
        }
        if (numState instanceof DoubleState) {
            return new DartObjectImpl(typeProvider.getDoubleType(), numState);
        }
        if (numState instanceof NumState) {
            return new DartObjectImpl(typeProvider.getNumType(), numState);
        }
        throw new IllegalStateException("add returned a " + numState.getClass().getName());
    }

    public DartObjectImpl bitAnd(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        return new DartObjectImpl(typeProvider.getIntType(), this.state.bitAnd(dartObjectImpl.state));
    }

    public DartObjectImpl bitNot(TypeProvider typeProvider) throws EvaluationException {
        return new DartObjectImpl(typeProvider.getIntType(), this.state.bitNot());
    }

    public DartObjectImpl bitOr(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        return new DartObjectImpl(typeProvider.getIntType(), this.state.bitOr(dartObjectImpl.state));
    }

    public DartObjectImpl bitXor(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        return new DartObjectImpl(typeProvider.getIntType(), this.state.bitXor(dartObjectImpl.state));
    }

    public DartObjectImpl concatenate(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        return new DartObjectImpl(typeProvider.getStringType(), this.state.concatenate(dartObjectImpl.state));
    }

    public DartObjectImpl convertToBool(TypeProvider typeProvider) throws EvaluationException {
        InterfaceType interfaceType = typeProvider.getBoolType();
        if (this.type == interfaceType) {
            return this;
        }
        return new DartObjectImpl(interfaceType, this.state.convertToBool());
    }

    public DartObjectImpl divide(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        NumState numState = this.state.divide(dartObjectImpl.state);
        if (numState instanceof IntState) {
            return new DartObjectImpl(typeProvider.getIntType(), numState);
        }
        if (numState instanceof DoubleState) {
            return new DartObjectImpl(typeProvider.getDoubleType(), numState);
        }
        if (numState instanceof NumState) {
            return new DartObjectImpl(typeProvider.getNumType(), numState);
        }
        throw new IllegalStateException("divide returned a " + numState.getClass().getName());
    }

    public DartObjectImpl equalEqual(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        String string;
        if (!(this.type.equals(dartObjectImpl.type) || (string = this.type.getName()).equals("bool") || string.equals("double") || string.equals("int") || string.equals("num") || string.equals("String") || string.equals("Null") || this.type.isDynamic())) {
            throw new EvaluationException(CompileTimeErrorCode.CONST_EVAL_TYPE_BOOL_NUM_STRING);
        }
        return new DartObjectImpl(typeProvider.getBoolType(), this.state.equalEqual(dartObjectImpl.state));
    }

    public boolean equals(Object object) {
        if (!(object instanceof DartObjectImpl)) {
            return false;
        }
        DartObjectImpl dartObjectImpl = (DartObjectImpl)object;
        return this.type.equals(dartObjectImpl.type) && this.state.equals(dartObjectImpl.state);
    }

    @Override
    public Boolean getBoolValue() {
        if (this.state instanceof BoolState) {
            return ((BoolState)this.state).getValue();
        }
        return null;
    }

    @Override
    public Double getDoubleValue() {
        if (this.state instanceof DoubleState) {
            return ((DoubleState)this.state).getValue();
        }
        return null;
    }

    @Override
    public BigInteger getIntValue() {
        if (this.state instanceof IntState) {
            return ((IntState)this.state).getValue();
        }
        return null;
    }

    @Override
    public String getStringValue() {
        if (this.state instanceof StringState) {
            return ((StringState)this.state).getValue();
        }
        return null;
    }

    @Override
    public InterfaceType getType() {
        return this.type;
    }

    @Override
    public Object getValue() {
        return this.state.getValue();
    }

    public DartObjectImpl greaterThan(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        return new DartObjectImpl(typeProvider.getBoolType(), this.state.greaterThan(dartObjectImpl.state));
    }

    public DartObjectImpl greaterThanOrEqual(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        return new DartObjectImpl(typeProvider.getBoolType(), this.state.greaterThanOrEqual(dartObjectImpl.state));
    }

    @Override
    public boolean hasExactValue() {
        return this.state.hasExactValue();
    }

    public int hashCode() {
        return ObjectUtilities.combineHashCodes(this.type.hashCode(), this.state.hashCode());
    }

    public DartObjectImpl integerDivide(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        return new DartObjectImpl(typeProvider.getIntType(), this.state.integerDivide(dartObjectImpl.state));
    }

    public boolean isBool() {
        return this.state.isBool();
    }

    public boolean isBoolNumStringOrNull() {
        return this.state.isBoolNumStringOrNull();
    }

    @Override
    public boolean isFalse() {
        return this.state instanceof BoolState && ((BoolState)this.state).getValue() == Boolean.FALSE;
    }

    @Override
    public boolean isNull() {
        return this.state instanceof NullState;
    }

    @Override
    public boolean isTrue() {
        return this.state instanceof BoolState && ((BoolState)this.state).getValue() == Boolean.TRUE;
    }

    public boolean isUserDefinedObject() {
        return this.state instanceof GenericState;
    }

    public DartObjectImpl lessThan(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        return new DartObjectImpl(typeProvider.getBoolType(), this.state.lessThan(dartObjectImpl.state));
    }

    public DartObjectImpl lessThanOrEqual(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        return new DartObjectImpl(typeProvider.getBoolType(), this.state.lessThanOrEqual(dartObjectImpl.state));
    }

    public DartObjectImpl logicalAnd(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        return new DartObjectImpl(typeProvider.getBoolType(), this.state.logicalAnd(dartObjectImpl.state));
    }

    public DartObjectImpl logicalNot(TypeProvider typeProvider) throws EvaluationException {
        return new DartObjectImpl(typeProvider.getBoolType(), this.state.logicalNot());
    }

    public DartObjectImpl logicalOr(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        return new DartObjectImpl(typeProvider.getBoolType(), this.state.logicalOr(dartObjectImpl.state));
    }

    public DartObjectImpl minus(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        NumState numState = this.state.minus(dartObjectImpl.state);
        if (numState instanceof IntState) {
            return new DartObjectImpl(typeProvider.getIntType(), numState);
        }
        if (numState instanceof DoubleState) {
            return new DartObjectImpl(typeProvider.getDoubleType(), numState);
        }
        if (numState instanceof NumState) {
            return new DartObjectImpl(typeProvider.getNumType(), numState);
        }
        throw new IllegalStateException("minus returned a " + numState.getClass().getName());
    }

    public DartObjectImpl negated(TypeProvider typeProvider) throws EvaluationException {
        NumState numState = this.state.negated();
        if (numState instanceof IntState) {
            return new DartObjectImpl(typeProvider.getIntType(), numState);
        }
        if (numState instanceof DoubleState) {
            return new DartObjectImpl(typeProvider.getDoubleType(), numState);
        }
        if (numState instanceof NumState) {
            return new DartObjectImpl(typeProvider.getNumType(), numState);
        }
        throw new IllegalStateException("negated returned a " + numState.getClass().getName());
    }

    public DartObjectImpl notEqual(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        String string;
        if (!(this.type.equals(dartObjectImpl.type) || (string = this.type.getName()).equals("bool") || string.equals("double") || string.equals("int") || string.equals("num") || string.equals("String"))) {
            return new DartObjectImpl(typeProvider.getBoolType(), BoolState.TRUE_STATE);
        }
        return new DartObjectImpl(typeProvider.getBoolType(), this.state.equalEqual(dartObjectImpl.state).logicalNot());
    }

    public DartObjectImpl performToString(TypeProvider typeProvider) throws EvaluationException {
        InterfaceType interfaceType = typeProvider.getStringType();
        if (this.type == interfaceType) {
            return this;
        }
        return new DartObjectImpl(interfaceType, this.state.convertToString());
    }

    public DartObjectImpl remainder(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        NumState numState = this.state.remainder(dartObjectImpl.state);
        if (numState instanceof IntState) {
            return new DartObjectImpl(typeProvider.getIntType(), numState);
        }
        if (numState instanceof DoubleState) {
            return new DartObjectImpl(typeProvider.getDoubleType(), numState);
        }
        if (numState instanceof NumState) {
            return new DartObjectImpl(typeProvider.getNumType(), numState);
        }
        throw new IllegalStateException("remainder returned a " + numState.getClass().getName());
    }

    public DartObjectImpl shiftLeft(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        return new DartObjectImpl(typeProvider.getIntType(), this.state.shiftLeft(dartObjectImpl.state));
    }

    public DartObjectImpl shiftRight(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        return new DartObjectImpl(typeProvider.getIntType(), this.state.shiftRight(dartObjectImpl.state));
    }

    public DartObjectImpl times(TypeProvider typeProvider, DartObjectImpl dartObjectImpl) throws EvaluationException {
        NumState numState = this.state.times(dartObjectImpl.state);
        if (numState instanceof IntState) {
            return new DartObjectImpl(typeProvider.getIntType(), numState);
        }
        if (numState instanceof DoubleState) {
            return new DartObjectImpl(typeProvider.getDoubleType(), numState);
        }
        if (numState instanceof NumState) {
            return new DartObjectImpl(typeProvider.getNumType(), numState);
        }
        throw new IllegalStateException("times returned a " + numState.getClass().getName());
    }

    public String toString() {
        return this.type.getDisplayName() + " (" + this.state.toString() + ")";
    }
}

