/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.object;

import com.google.dart.engine.internal.object.DynamicState;
import com.google.dart.engine.internal.object.EvaluationException;
import com.google.dart.engine.internal.object.InstanceState;
import com.google.dart.engine.internal.object.StringState;

public class BoolState
extends InstanceState {
    private Boolean value;
    public static final BoolState FALSE_STATE = new BoolState(Boolean.FALSE);
    public static final BoolState TRUE_STATE = new BoolState(Boolean.TRUE);
    public static final BoolState UNKNOWN_VALUE = new BoolState(null);

    public static BoolState from(boolean bl) {
        return bl ? TRUE_STATE : FALSE_STATE;
    }

    private BoolState(Boolean bl) {
        this.value = bl;
    }

    @Override
    public BoolState convertToBool() {
        return this;
    }

    @Override
    public StringState convertToString() {
        if (this.value == null) {
            return StringState.UNKNOWN_VALUE;
        }
        return new StringState(this.value != false ? "true" : "false");
    }

    @Override
    public BoolState equalEqual(InstanceState instanceState) throws EvaluationException {
        this.assertBoolNumStringOrNull(instanceState);
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        if (instanceState instanceof BoolState) {
            Boolean bl = ((BoolState)instanceState).getValue();
            if (bl == null) {
                return UNKNOWN_VALUE;
            }
            return BoolState.from(this.value == bl);
        }
        if (instanceState instanceof DynamicState) {
            return UNKNOWN_VALUE;
        }
        return FALSE_STATE;
    }

    public boolean equals(Object object) {
        return object instanceof BoolState && this.value == ((BoolState)object).value;
    }

    @Override
    public String getTypeName() {
        return "bool";
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public boolean hasExactValue() {
        return true;
    }

    public int hashCode() {
        return this.value == null ? 0 : (this.value != false ? 2 : 3);
    }

    @Override
    public boolean isBool() {
        return true;
    }

    @Override
    public boolean isBoolNumStringOrNull() {
        return true;
    }

    @Override
    public BoolState logicalAnd(InstanceState instanceState) throws EvaluationException {
        this.assertBool(instanceState);
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        return this.value != false ? instanceState.convertToBool() : FALSE_STATE;
    }

    @Override
    public BoolState logicalNot() {
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        return this.value != false ? FALSE_STATE : TRUE_STATE;
    }

    @Override
    public BoolState logicalOr(InstanceState instanceState) throws EvaluationException {
        this.assertBool(instanceState);
        if (this.value == null) {
            return UNKNOWN_VALUE;
        }
        return this.value != false ? TRUE_STATE : instanceState.convertToBool();
    }

    public String toString() {
        return this.value == null ? "-unknown-" : (this.value != false ? "true" : "false");
    }
}

