/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.index.operation;

import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.index.IndexStore;
import com.google.dart.engine.internal.index.operation.IndexOperation;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.SourceContainer;

public class RemoveSourcesOperation
implements IndexOperation {
    private IndexStore indexStore;
    private final AnalysisContext context;
    private SourceContainer container;

    public RemoveSourcesOperation(IndexStore indexStore, AnalysisContext analysisContext, SourceContainer sourceContainer) {
        this.indexStore = indexStore;
        this.context = analysisContext;
        this.container = sourceContainer;
    }

    public SourceContainer getContainer() {
        return this.container;
    }

    @Override
    public boolean isQuery() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performOperation() {
        IndexStore indexStore = this.indexStore;
        synchronized (indexStore) {
            this.indexStore.removeSources(this.context, this.container);
        }
    }

    @Override
    public boolean removeWhenSourceRemoved(Source source) {
        return false;
    }

    public String toString() {
        return "RemoveSources(" + this.container + ")";
    }
}

