/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.index.operation;

import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.index.IndexStore;
import com.google.dart.engine.internal.index.operation.IndexOperation;
import com.google.dart.engine.source.Source;

public class RemoveSourceOperation
implements IndexOperation {
    private IndexStore indexStore;
    private final AnalysisContext context;
    private final Source source;

    public RemoveSourceOperation(IndexStore indexStore, AnalysisContext analysisContext, Source source) {
        this.indexStore = indexStore;
        this.context = analysisContext;
        this.source = source;
    }

    public Source getSource() {
        return this.source;
    }

    @Override
    public boolean isQuery() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performOperation() {
        IndexStore indexStore = this.indexStore;
        synchronized (indexStore) {
            this.indexStore.removeSource(this.context, this.source);
        }
    }

    @Override
    public boolean removeWhenSourceRemoved(Source source) {
        return false;
    }

    public String toString() {
        return "RemoveSource(" + this.source.getFullName() + ")";
    }
}

