/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.index.operation;

import com.google.common.annotations.VisibleForTesting;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.index.IndexStore;
import com.google.dart.engine.internal.index.operation.IndexOperation;
import com.google.dart.engine.source.Source;

public class RemoveContextOperation
implements IndexOperation {
    private IndexStore indexStore;
    private final AnalysisContext context;

    public RemoveContextOperation(IndexStore indexStore, AnalysisContext analysisContext) {
        this.indexStore = indexStore;
        this.context = analysisContext;
    }

    @VisibleForTesting
    public AnalysisContext getContext() {
        return this.context;
    }

    @Override
    public boolean isQuery() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performOperation() {
        IndexStore indexStore = this.indexStore;
        synchronized (indexStore) {
            this.indexStore.removeContext(this.context);
        }
    }

    @Override
    public boolean removeWhenSourceRemoved(Source source) {
        return false;
    }

    public String toString() {
        return "RemoveContext(" + this.context + ")";
    }
}

