/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.index.operation;

import com.google.common.collect.Lists;
import com.google.dart.engine.internal.index.operation.IndexOperation;
import com.google.dart.engine.internal.index.operation.RemoveSourceOperation;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.translation.DartOmit;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

@DartOmit
public class OperationQueue {
    private final LinkedList<IndexOperation> nonQueryOperations = Lists.newLinkedList();
    private final LinkedList<IndexOperation> queryOperations = Lists.newLinkedList();
    private boolean processQueries = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexOperation dequeue(long l) throws InterruptedException {
        LinkedList<IndexOperation> linkedList = this.nonQueryOperations;
        synchronized (linkedList) {
            if (this.nonQueryOperations.isEmpty() && (!this.processQueries || this.queryOperations.isEmpty())) {
                if (l <= 0L) {
                    return null;
                }
                this.waitForOperationAvailable(l);
            }
            if (!this.nonQueryOperations.isEmpty()) {
                return this.nonQueryOperations.removeFirst();
            }
            if (this.processQueries && !this.queryOperations.isEmpty()) {
                return this.queryOperations.removeFirst();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(IndexOperation indexOperation) {
        LinkedList<IndexOperation> linkedList = this.nonQueryOperations;
        synchronized (linkedList) {
            if (indexOperation instanceof RemoveSourceOperation) {
                Source source = ((RemoveSourceOperation)indexOperation).getSource();
                this.removeForSource(source, this.nonQueryOperations);
                this.removeForSource(source, this.queryOperations);
            }
            if (indexOperation.isQuery()) {
                this.queryOperations.add(indexOperation);
            } else {
                this.nonQueryOperations.add(indexOperation);
            }
            this.notifyOperationAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IndexOperation> getOperations() {
        ArrayList<IndexOperation> arrayList = Lists.newArrayList();
        LinkedList<IndexOperation> linkedList = this.nonQueryOperations;
        synchronized (linkedList) {
            arrayList.addAll(this.nonQueryOperations);
            arrayList.addAll(this.queryOperations);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessQueries(boolean bl) {
        LinkedList<IndexOperation> linkedList = this.nonQueryOperations;
        synchronized (linkedList) {
            if (this.processQueries != bl) {
                this.processQueries = bl;
                if (bl && !this.queryOperations.isEmpty()) {
                    this.notifyOperationAvailable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList<IndexOperation> linkedList = this.nonQueryOperations;
        synchronized (linkedList) {
            return this.nonQueryOperations.size() + this.queryOperations.size();
        }
    }

    private void notifyOperationAvailable() {
        this.nonQueryOperations.notifyAll();
    }

    private void removeForSource(Source source, LinkedList<IndexOperation> linkedList) {
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            IndexOperation indexOperation = (IndexOperation)listIterator.next();
            if (!indexOperation.removeWhenSourceRemoved(source)) continue;
            listIterator.remove();
        }
    }

    private void waitForOperationAvailable(long l) throws InterruptedException {
        this.nonQueryOperations.wait(l);
    }
}

