/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.index.operation;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.internal.index.operation.IndexOperation;
import com.google.dart.engine.internal.index.operation.IndexUnitOperation;
import com.google.dart.engine.internal.index.operation.OperationQueue;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.translation.DartOmit;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

@DartOmit
public class OperationProcessor {
    private OperationQueue queue;
    private ProcessorState state = ProcessorState.READY;
    private static long WAIT_DURATION = 100L;

    public OperationProcessor(OperationQueue operationQueue) {
        this.queue = operationQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block19: {
            Object object = this;
            synchronized (object) {
                if (this.state != ProcessorState.READY) {
                    throw new IllegalStateException("Operation processors can only be run one time");
                }
                this.state = ProcessorState.RUNNING;
            }
            block16: while (true) {
                while (this.isRunning()) {
                    object = null;
                    try {
                        object = this.queue.dequeue(WAIT_DURATION);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (object == null) continue;
                    try {
                        object.performOperation();
                        continue block16;
                    }
                    catch (Throwable throwable) {
                        AnalysisEngine.getInstance().getLogger().logError("Exception in indexing operation: " + object, throwable);
                    }
                }
                break block19;
                {
                    continue block16;
                    break;
                }
                break;
            }
            finally {
                object = this;
                synchronized (object) {
                    this.state = ProcessorState.STOPPED;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source[] stop(boolean bl) {
        OperationProcessor operationProcessor = this;
        synchronized (operationProcessor) {
            if (this.state == ProcessorState.READY) {
                this.state = ProcessorState.STOPPED;
                return this.getUnanalyzedSources();
            }
            if (this.state == ProcessorState.STOPPED) {
                return this.getUnanalyzedSources();
            }
            if (this.state == ProcessorState.RUNNING) {
                this.state = ProcessorState.STOP_REQESTED;
            }
        }
        while (bl) {
            operationProcessor = this;
            synchronized (operationProcessor) {
                if (this.state == ProcessorState.STOPPED) {
                    return this.getUnanalyzedSources();
                }
            }
            this.waitOneMs();
        }
        return this.getUnanalyzedSources();
    }

    public boolean waitForRunning() {
        while (this.state == ProcessorState.READY) {
            this.threadYield();
        }
        return this.state == ProcessorState.RUNNING;
    }

    private Source[] getUnanalyzedSources() {
        HashSet<Source> hashSet = Sets.newHashSet();
        for (IndexOperation indexOperation : this.queue.getOperations()) {
            if (!(indexOperation instanceof IndexUnitOperation)) continue;
            Source source = ((IndexUnitOperation)indexOperation).getSource();
            hashSet.add(source);
        }
        return hashSet.toArray(new Source[hashSet.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunning() {
        OperationProcessor operationProcessor = this;
        synchronized (operationProcessor) {
            return this.state == ProcessorState.RUNNING;
        }
    }

    private void threadYield() {
        Thread.yield();
    }

    private void waitOneMs() {
        Uninterruptibles.sleepUninterruptibly(1L, TimeUnit.MILLISECONDS);
    }

    private static enum ProcessorState {
        READY,
        RUNNING,
        STOP_REQESTED,
        STOPPED;

    }
}

