/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.index.operation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.index.IndexStore;
import com.google.dart.engine.internal.html.angular.AngularDartIndexContributor;
import com.google.dart.engine.internal.index.IndexContributor;
import com.google.dart.engine.internal.index.operation.IndexOperation;
import com.google.dart.engine.source.Source;

public class IndexUnitOperation
implements IndexOperation {
    private final IndexStore indexStore;
    private final AnalysisContext context;
    private final CompilationUnit unit;
    private final CompilationUnitElement unitElement;
    private final Source source;

    public IndexUnitOperation(IndexStore indexStore, AnalysisContext analysisContext, CompilationUnit compilationUnit) {
        this.indexStore = indexStore;
        this.context = analysisContext;
        this.unit = compilationUnit;
        this.unitElement = compilationUnit.getElement();
        this.source = this.unitElement.getSource();
    }

    public Source getSource() {
        return this.source;
    }

    @VisibleForTesting
    public CompilationUnit getUnit() {
        return this.unit;
    }

    @Override
    public boolean isQuery() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performOperation() {
        IndexStore indexStore = this.indexStore;
        synchronized (indexStore) {
            try {
                boolean bl = this.indexStore.aboutToIndexDart(this.context, this.unitElement);
                if (!bl) {
                    return;
                }
                this.unit.accept(new IndexContributor(this.indexStore));
                this.unit.accept(new AngularDartIndexContributor(this.indexStore));
            }
            catch (Throwable throwable) {
                AnalysisEngine.getInstance().getLogger().logError("Could not index " + this.unit.getElement().getLocation(), throwable);
            }
        }
    }

    @Override
    public boolean removeWhenSourceRemoved(Source source) {
        return Objects.equal(this.source, source);
    }

    public String toString() {
        return "IndexUnitOperation(" + this.source.getFullName() + ")";
    }
}

