/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.index.operation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.element.HtmlElement;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.index.IndexStore;
import com.google.dart.engine.internal.html.angular.AngularHtmlIndexContributor;
import com.google.dart.engine.internal.index.operation.IndexOperation;
import com.google.dart.engine.source.Source;

public class IndexHtmlUnitOperation
implements IndexOperation {
    private final IndexStore indexStore;
    private final AnalysisContext context;
    private final HtmlUnit unit;
    private final HtmlElement htmlElement;
    private final Source source;

    public IndexHtmlUnitOperation(IndexStore indexStore, AnalysisContext analysisContext, HtmlUnit htmlUnit) {
        this.indexStore = indexStore;
        this.context = analysisContext;
        this.unit = htmlUnit;
        this.htmlElement = htmlUnit.getElement();
        this.source = this.htmlElement.getSource();
    }

    public Source getSource() {
        return this.source;
    }

    @VisibleForTesting
    public HtmlUnit getUnit() {
        return this.unit;
    }

    @Override
    public boolean isQuery() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performOperation() {
        IndexStore indexStore = this.indexStore;
        synchronized (indexStore) {
            try {
                boolean bl = this.indexStore.aboutToIndexHtml(this.context, this.htmlElement);
                if (!bl) {
                    return;
                }
                AngularHtmlIndexContributor angularHtmlIndexContributor = new AngularHtmlIndexContributor(this.indexStore);
                this.unit.accept(angularHtmlIndexContributor);
            }
            catch (Throwable throwable) {
                AnalysisEngine.getInstance().getLogger().logError("Could not index " + this.unit.getElement().getLocation(), throwable);
            }
        }
    }

    @Override
    public boolean removeWhenSourceRemoved(Source source) {
        return Objects.equal(this.source, source);
    }

    public String toString() {
        return "IndexHtmlUnitOperation(" + this.source.getFullName() + ")";
    }
}

