/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.index.operation;

import com.google.common.annotations.VisibleForTesting;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.index.IndexStore;
import com.google.dart.engine.index.Location;
import com.google.dart.engine.index.Relationship;
import com.google.dart.engine.index.RelationshipCallback;
import com.google.dart.engine.internal.index.operation.IndexOperation;
import com.google.dart.engine.source.Source;

public class GetRelationshipsOperation
implements IndexOperation {
    private final IndexStore indexStore;
    private final Element element;
    private final Relationship relationship;
    private RelationshipCallback callback;

    public GetRelationshipsOperation(IndexStore indexStore, Element element, Relationship relationship, RelationshipCallback relationshipCallback) {
        this.indexStore = indexStore;
        this.element = element;
        this.relationship = relationship;
        this.callback = relationshipCallback;
    }

    @VisibleForTesting
    public RelationshipCallback getCallback() {
        return this.callback;
    }

    @VisibleForTesting
    public Element getElement() {
        return this.element;
    }

    @VisibleForTesting
    public Relationship getRelationship() {
        return this.relationship;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performOperation() {
        Location[] locationArray;
        IndexStore indexStore = this.indexStore;
        synchronized (indexStore) {
            locationArray = this.indexStore.getRelationships(this.element, this.relationship);
        }
        this.callback.hasRelationships(this.element, this.relationship, locationArray);
    }

    @Override
    public boolean removeWhenSourceRemoved(Source source) {
        return false;
    }

    public String toString() {
        return "GetRelationships(" + this.element + ", " + this.relationship + ")";
    }
}

