/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.index;

import com.google.common.collect.Lists;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.index.Location;
import com.google.dart.engine.internal.index.MemoryIndexStoreImpl;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

class MemoryIndexWriter {
    static int FILE_VERSION_NUMBER = 1;
    private final MemoryIndexStoreImpl impl;
    private final AnalysisContext context;
    private final DataOutputStream dos;

    MemoryIndexWriter(MemoryIndexStoreImpl memoryIndexStoreImpl, AnalysisContext analysisContext, OutputStream outputStream) {
        this.impl = memoryIndexStoreImpl;
        this.context = analysisContext;
        this.dos = new DataOutputStream(outputStream);
    }

    public void write() throws IOException {
        Object object;
        this.dos.writeInt(FILE_VERSION_NUMBER);
        ArrayList<MemoryIndexStoreImpl.ElementRelationKey> arrayList = Lists.newArrayList();
        for (MemoryIndexStoreImpl.ElementRelationKey elementRelationKey : this.impl.keyToLocations.keySet()) {
            object = elementRelationKey.element;
            if (!this.isElementOfContext((Element)object)) continue;
            arrayList.add(elementRelationKey);
        }
        this.dos.writeInt(arrayList.size());
        for (MemoryIndexStoreImpl.ElementRelationKey elementRelationKey : arrayList) {
            this.writeElementLocation(elementRelationKey.element);
            this.dos.writeUTF(elementRelationKey.relationship.getIdentifier());
            object = Lists.newArrayList();
            Set<Location> set = this.impl.keyToLocations.get(elementRelationKey);
            for (Location location : set) {
                object.add(location);
            }
            this.dos.writeInt(object.size());
            Iterator<Location> iterator = object.iterator();
            while (iterator.hasNext()) {
                Location location;
                location = iterator.next();
                this.writeElementLocation(location.getElement());
                this.dos.writeInt(location.getOffset());
                this.dos.writeInt(location.getLength());
            }
        }
    }

    private boolean isElementOfContext(Element element) {
        return element.getContext() == this.context;
    }

    private void writeElementLocation(Element element) throws IOException {
        this.dos.writeUTF(element.getLocation().getEncoding());
    }
}

