/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.HtmlElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.index.Location;
import com.google.dart.engine.index.MemoryIndexStore;
import com.google.dart.engine.index.Relationship;
import com.google.dart.engine.internal.context.InstrumentedAnalysisContextImpl;
import com.google.dart.engine.internal.element.member.Member;
import com.google.dart.engine.internal.index.MemoryIndexReader;
import com.google.dart.engine.internal.index.MemoryIndexWriter;
import com.google.dart.engine.internal.index.NameElementImpl;
import com.google.dart.engine.internal.index.UniverseElementImpl;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.SourceContainer;
import com.google.dart.engine.utilities.translation.DartExpressionBody;
import com.google.dart.engine.utilities.translation.DartOmit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MemoryIndexStoreImpl
implements MemoryIndexStore {
    private final Map<ElementRelationKey, ElementRelationKey> canonicalKeys = Maps.newHashMap();
    final Map<ElementRelationKey, Set<Location>> keyToLocations = Maps.newHashMap();
    final Map<AnalysisContext, Map<Source2, Set<ElementRelationKey>>> contextToSourceToKeys = Maps.newHashMap();
    final Map<AnalysisContext, Map<Source2, List<Location>>> contextToSourceToLocations = Maps.newHashMap();
    final Map<AnalysisContext, Map<Source, Set<Source>>> contextToLibraryToUnits = Maps.newHashMap();
    final Map<AnalysisContext, Map<Source, Set<Source>>> contextToUnitToLibraries = Maps.newHashMap();
    private int sourceCount;
    private int keyCount;
    private int locationCount;

    public static AnalysisContext unwrapContext(AnalysisContext analysisContext) {
        if (analysisContext instanceof InstrumentedAnalysisContextImpl) {
            analysisContext = ((InstrumentedAnalysisContextImpl)analysisContext).getBasis();
        }
        return analysisContext;
    }

    private static Source getLibrarySourceOrNull(Element element) {
        LibraryElement libraryElement = element.getLibrary();
        if (libraryElement == null) {
            return null;
        }
        if (libraryElement.isAngularHtml()) {
            return null;
        }
        return libraryElement.getSource();
    }

    @Override
    public boolean aboutToIndexDart(AnalysisContext analysisContext, CompilationUnitElement compilationUnitElement) {
        Object object;
        Object object2;
        if ((analysisContext = MemoryIndexStoreImpl.unwrapContext(analysisContext)).isDisposed()) {
            return false;
        }
        if (compilationUnitElement == null) {
            return false;
        }
        LibraryElement libraryElement = compilationUnitElement.getLibrary();
        if (libraryElement == null) {
            return false;
        }
        CompilationUnitElement compilationUnitElement2 = libraryElement.getDefiningCompilationUnit();
        if (compilationUnitElement2 == null) {
            return false;
        }
        Source source = compilationUnitElement2.getSource();
        Source source2 = compilationUnitElement.getSource();
        if (((Object)source2).equals(source)) {
            Set set;
            object2 = Sets.newHashSet();
            for (CompilationUnitElement compilationUnitElement3 : libraryElement.getParts()) {
                object2.add(compilationUnitElement3.getSource());
            }
            object = this.contextToLibraryToUnits.get(analysisContext);
            if (object == null) {
                object = Maps.newHashMap();
                this.contextToLibraryToUnits.put(analysisContext, (Map<Source, Set<Source>>)object);
            }
            if ((set = (Set)object.get(source)) != null) {
                Sets.SetView<Source> setView = Sets.difference(set, object2);
                for (Source source3 : setView) {
                    this.removeLocations(analysisContext, source, source3);
                }
            }
            object.put(source, object2);
        }
        this.recordUnitInLibrary(analysisContext, source, source2);
        this.removeLocations(analysisContext, source, source2);
        object2 = this.contextToSourceToKeys.get(analysisContext);
        if (object2 != null) {
            boolean bl;
            object = new Source2(source, source2);
            boolean bl2 = bl = object2.remove(object) != null;
            if (bl) {
                --this.sourceCount;
            }
        }
        return true;
    }

    @Override
    public boolean aboutToIndexHtml(AnalysisContext analysisContext, HtmlElement htmlElement) {
        if ((analysisContext = MemoryIndexStoreImpl.unwrapContext(analysisContext)).isDisposed()) {
            return false;
        }
        Source source = htmlElement.getSource();
        this.removeLocations(analysisContext, null, source);
        Map<Source2, Set<ElementRelationKey>> map = this.contextToSourceToKeys.get(analysisContext);
        if (map != null) {
            boolean bl;
            Source2 source2 = new Source2(null, source);
            boolean bl2 = bl = map.remove(source2) != null;
            if (bl) {
                --this.sourceCount;
            }
        }
        this.recordUnitInLibrary(analysisContext, null, source);
        return true;
    }

    @Override
    public Location[] getRelationships(Element element, Relationship relationship) {
        ElementRelationKey elementRelationKey = new ElementRelationKey(element, relationship);
        Set<Location> set = this.keyToLocations.get(elementRelationKey);
        if (set != null) {
            return set.toArray(new Location[set.size()]);
        }
        return Location.EMPTY_ARRAY;
    }

    @Override
    public String getStatistics() {
        return this.locationCount + " relationships in " + this.keyCount + " keys in " + this.sourceCount + " sources";
    }

    @VisibleForTesting
    public int internalGetKeyCount() {
        return this.keyToLocations.size();
    }

    @VisibleForTesting
    public int internalGetLocationCount() {
        int n = 0;
        for (Set<Location> set : this.keyToLocations.values()) {
            n += set.size();
        }
        return n;
    }

    @VisibleForTesting
    public int internalGetLocationCountForContext(AnalysisContext analysisContext) {
        analysisContext = MemoryIndexStoreImpl.unwrapContext(analysisContext);
        int n = 0;
        for (Set<Location> set : this.keyToLocations.values()) {
            for (Location location : set) {
                if (location.getElement().getContext() != analysisContext) continue;
                ++n;
            }
        }
        return n;
    }

    @VisibleForTesting
    public int internalGetSourceKeyCount(AnalysisContext analysisContext) {
        int n = 0;
        Map<Source2, Set<ElementRelationKey>> map = this.contextToSourceToKeys.get(analysisContext);
        if (map != null) {
            for (Set<ElementRelationKey> set : map.values()) {
                n += set.size();
            }
        }
        return n;
    }

    @Override
    @DartOmit
    public void readIndex(AnalysisContext analysisContext, InputStream inputStream) throws IOException {
        analysisContext = MemoryIndexStoreImpl.unwrapContext(analysisContext);
        new MemoryIndexReader(this, analysisContext, inputStream).read();
    }

    @Override
    public void recordRelationship(Element element, Relationship relationship, Location location) {
        Collection<ElementRelationKey> collection;
        if (element == null || location == null) {
            return;
        }
        location = location.newClone();
        if (element instanceof Member) {
            element = ((Member)element).getBaseElement();
        }
        AnalysisContext analysisContext = element.getContext();
        AnalysisContext analysisContext2 = location.getElement().getContext();
        Source source = element.getSource();
        Source source2 = location.getElement().getSource();
        Source source3 = MemoryIndexStoreImpl.getLibrarySourceOrNull(element);
        Source source4 = MemoryIndexStoreImpl.getLibrarySourceOrNull(location.getElement());
        if (analysisContext2 == null) {
            return;
        }
        if (source2 == null) {
            return;
        }
        if (analysisContext == null && !(element instanceof NameElementImpl) && !(element instanceof UniverseElementImpl)) {
            return;
        }
        if (source == null && !(element instanceof NameElementImpl) && !(element instanceof UniverseElementImpl)) {
            return;
        }
        if (analysisContext != null && analysisContext.isDisposed()) {
            return;
        }
        if (analysisContext2.isDisposed()) {
            return;
        }
        ElementRelationKey elementRelationKey = this.getCanonicalKey(element, relationship);
        Set<Location> set = this.keyToLocations.remove(elementRelationKey);
        if (set == null) {
            set = this.createLocationIdentitySet();
        } else {
            --this.keyCount;
        }
        this.keyToLocations.put(elementRelationKey, set);
        ++this.keyCount;
        set.add(location);
        ++this.locationCount;
        location.internalKey = elementRelationKey;
        set = new Source2(source3, source);
        Source2 source22 = new Source2(source4, source2);
        Map<Source2, Collection<Object>> map = this.contextToSourceToKeys.get(analysisContext);
        if (map == null) {
            map = Maps.newHashMap();
            this.contextToSourceToKeys.put(analysisContext, map);
        }
        if ((collection = map.get(set)) == null) {
            collection = Sets.newHashSet();
            map.put((Source2)((Object)set), collection);
            ++this.sourceCount;
        }
        collection.remove(elementRelationKey);
        collection.add(elementRelationKey);
        map = this.contextToSourceToLocations.get(analysisContext2);
        if (map == null) {
            map = Maps.newHashMap();
            this.contextToSourceToLocations.put(analysisContext2, map);
        }
        if ((collection = (List)map.get(source22)) == null) {
            collection = Lists.newArrayList();
            map.put(source22, collection);
        }
        collection.add((ElementRelationKey)((Object)location));
    }

    @Override
    public void removeContext(AnalysisContext analysisContext) {
        if ((analysisContext = MemoryIndexStoreImpl.unwrapContext(analysisContext)) == null) {
            return;
        }
        this.removeSources(analysisContext, null);
        this.contextToSourceToKeys.remove(analysisContext);
        this.contextToSourceToLocations.remove(analysisContext);
        this.contextToLibraryToUnits.remove(analysisContext);
        this.contextToUnitToLibraries.remove(analysisContext);
    }

    @Override
    public void removeSource(AnalysisContext analysisContext, Source source) {
        Set<Source> set;
        if ((analysisContext = MemoryIndexStoreImpl.unwrapContext(analysisContext)) == null) {
            return;
        }
        Map<Source, Set<Source>> map = this.contextToUnitToLibraries.get(analysisContext);
        if (map != null && (set = map.remove(source)) != null) {
            for (Source source2 : set) {
                Set<ElementRelationKey> set2;
                Source2 source22 = new Source2(source2, source);
                this.removeLocations(analysisContext, source2, source);
                Map<Source2, Set<ElementRelationKey>> map2 = this.contextToSourceToKeys.get(analysisContext);
                if (map2 == null || (set2 = map2.remove(source22)) == null) continue;
                for (ElementRelationKey elementRelationKey : set2) {
                    this.canonicalKeys.remove(elementRelationKey);
                    Set<Location> set3 = this.keyToLocations.remove(elementRelationKey);
                    if (set3 == null) continue;
                    --this.keyCount;
                    this.locationCount -= set3.size();
                }
                --this.sourceCount;
            }
        }
    }

    @Override
    public void removeSources(AnalysisContext analysisContext, SourceContainer sourceContainer) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if ((analysisContext = MemoryIndexStoreImpl.unwrapContext(analysisContext)) == null) {
            return;
        }
        Map<Source2, Set<ElementRelationKey>> map = this.contextToSourceToKeys.get(analysisContext);
        if (map != null) {
            object4 = Lists.newArrayList(map.keySet());
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (Source2)object3.next();
                object = ((Source2)object2).unitSource;
                if (sourceContainer != null && !sourceContainer.contains((Source)object)) continue;
                this.removeSource(analysisContext, (Source)object);
            }
        }
        if ((object4 = this.contextToSourceToLocations.get(analysisContext)) != null) {
            object3 = Lists.newArrayList(object4.keySet());
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Source2)object2.next();
                Source source = ((Source2)object).unitSource;
                if (sourceContainer != null && !sourceContainer.contains(source)) continue;
                this.removeSource(analysisContext, source);
            }
        }
    }

    @Override
    @DartOmit
    public void writeIndex(AnalysisContext analysisContext, OutputStream outputStream) throws IOException {
        analysisContext = MemoryIndexStoreImpl.unwrapContext(analysisContext);
        new MemoryIndexWriter(this, analysisContext, outputStream).write();
    }

    @DartExpressionBody(value="new Set<Location>.identity()")
    private Set<Location> createLocationIdentitySet() {
        return Sets.newSetFromMap(new IdentityHashMap(4));
    }

    private ElementRelationKey getCanonicalKey(Element element, Relationship relationship) {
        ElementRelationKey elementRelationKey = new ElementRelationKey(element, relationship);
        ElementRelationKey elementRelationKey2 = this.canonicalKeys.get(elementRelationKey);
        if (elementRelationKey2 == null) {
            elementRelationKey2 = elementRelationKey;
            this.canonicalKeys.put(elementRelationKey, elementRelationKey2);
        }
        return elementRelationKey2;
    }

    private void recordUnitInLibrary(AnalysisContext analysisContext, Source source, Source source2) {
        Set<Source> set;
        Map<Source, Set<Source>> map = this.contextToUnitToLibraries.get(analysisContext);
        if (map == null) {
            map = Maps.newHashMap();
            this.contextToUnitToLibraries.put(analysisContext, map);
        }
        if ((set = map.get(source2)) == null) {
            set = Sets.newHashSet();
            map.put(source2, set);
        }
        set.add(source);
    }

    private void removeLocations(AnalysisContext analysisContext, Source source, Source source2) {
        List<Location> list;
        Source2 source22 = new Source2(source, source2);
        Map<Source2, List<Location>> map = this.contextToSourceToLocations.get(analysisContext);
        if (map != null && (list = map.remove(source22)) != null) {
            for (Location location : list) {
                ElementRelationKey elementRelationKey = (ElementRelationKey)location.internalKey;
                Set<Location> set = this.keyToLocations.get(elementRelationKey);
                if (set == null) continue;
                set.remove(location);
                --this.locationCount;
                if (!set.isEmpty()) continue;
                this.canonicalKeys.remove(elementRelationKey);
                this.keyToLocations.remove(elementRelationKey);
                --this.keyCount;
            }
        }
    }

    static class Source2 {
        final Source librarySource;
        final Source unitSource;

        public Source2(Source source, Source source2) {
            this.librarySource = source;
            this.unitSource = source2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Source2)) {
                return false;
            }
            Source2 source2 = (Source2)object;
            return Objects.equal(source2.librarySource, this.librarySource) && Objects.equal(source2.unitSource, this.unitSource);
        }

        public int hashCode() {
            return Objects.hashCode(this.librarySource, this.unitSource);
        }

        public String toString() {
            return this.librarySource + " " + this.unitSource;
        }
    }

    static class ElementRelationKey {
        final Element element;
        final Relationship relationship;

        public ElementRelationKey(Element element, Relationship relationship) {
            this.element = element;
            this.relationship = relationship;
        }

        public boolean equals(Object object) {
            ElementRelationKey elementRelationKey = (ElementRelationKey)object;
            Element element = elementRelationKey.element;
            return elementRelationKey.relationship == this.relationship && element.getNameOffset() == this.element.getNameOffset() && element.getKind() == this.element.getKind() && Objects.equal(element.getDisplayName(), this.element.getDisplayName()) && Objects.equal(element.getSource(), this.element.getSource());
        }

        public int hashCode() {
            return Objects.hashCode(new Object[]{this.element.getSource(), this.element.getNameOffset(), this.element.getKind(), this.element.getDisplayName(), this.relationship});
        }

        public String toString() {
            return this.element + " " + this.relationship;
        }
    }
}

