/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.index;

import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.index.Location;
import com.google.dart.engine.index.Relationship;
import com.google.dart.engine.internal.element.ElementLocationImpl;
import com.google.dart.engine.internal.index.MemoryIndexStoreImpl;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;

class MemoryIndexReader {
    static int FILE_VERSION_NUMBER = 1;
    private final MemoryIndexStoreImpl impl;
    private final AnalysisContext context;
    private final DataInputStream dis;

    MemoryIndexReader(MemoryIndexStoreImpl memoryIndexStoreImpl, AnalysisContext analysisContext, InputStream inputStream) {
        this.impl = memoryIndexStoreImpl;
        this.context = analysisContext;
        this.dis = new DataInputStream(inputStream);
    }

    public void read() throws IOException {
        int n = this.dis.readInt();
        if (n != FILE_VERSION_NUMBER) {
            throw new IOException(MessageFormat.format("Incompatible file version, expected: {0} found: {1}", FILE_VERSION_NUMBER, n));
        }
        n = this.dis.readInt();
        for (int i = 0; i < n; ++i) {
            Element element = this.readElement();
            Relationship relationship = this.readRelationship();
            int n2 = this.dis.readInt();
            for (int j = 0; j < n2; ++j) {
                Location location = this.readLocation();
                this.impl.recordRelationship(element, relationship, location);
            }
        }
    }

    private Element readElement() throws IOException {
        String string = this.dis.readUTF();
        ElementLocationImpl elementLocationImpl = new ElementLocationImpl(string);
        return this.context.getElement(elementLocationImpl);
    }

    private Location readLocation() throws IOException {
        Element element = this.readElement();
        int n = this.dis.readInt();
        int n2 = this.dis.readInt();
        return new Location(element, n, n2);
    }

    private Relationship readRelationship() throws IOException {
        String string = this.dis.readUTF();
        return Relationship.getRelationship(string);
    }
}

