/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.index;

import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.index.Index;
import com.google.dart.engine.index.IndexStore;
import com.google.dart.engine.index.Relationship;
import com.google.dart.engine.index.RelationshipCallback;
import com.google.dart.engine.internal.index.operation.GetRelationshipsOperation;
import com.google.dart.engine.internal.index.operation.IndexHtmlUnitOperation;
import com.google.dart.engine.internal.index.operation.IndexUnitOperation;
import com.google.dart.engine.internal.index.operation.OperationProcessor;
import com.google.dart.engine.internal.index.operation.OperationQueue;
import com.google.dart.engine.internal.index.operation.RemoveContextOperation;
import com.google.dart.engine.internal.index.operation.RemoveSourceOperation;
import com.google.dart.engine.internal.index.operation.RemoveSourcesOperation;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.SourceContainer;
import com.google.dart.engine.utilities.translation.DartOmit;

@DartOmit
public class IndexImpl
implements Index {
    private final IndexStore store;
    private final OperationQueue queue;
    private final OperationProcessor processor;

    public IndexImpl(IndexStore indexStore, OperationQueue operationQueue, OperationProcessor operationProcessor) {
        this.store = indexStore;
        this.queue = operationQueue;
        this.processor = operationProcessor;
    }

    @Override
    public void getRelationships(Element element, Relationship relationship, RelationshipCallback relationshipCallback) {
        this.queue.enqueue(new GetRelationshipsOperation(this.store, element, relationship, relationshipCallback));
    }

    @Override
    public String getStatistics() {
        return this.store.getStatistics();
    }

    @Override
    public void indexHtmlUnit(AnalysisContext analysisContext, HtmlUnit htmlUnit) {
        if (htmlUnit == null) {
            return;
        }
        if (htmlUnit.getElement() == null) {
            return;
        }
        if (htmlUnit.getElement().getAngularCompilationUnit() == null) {
            return;
        }
        this.queue.enqueue(new IndexHtmlUnitOperation(this.store, analysisContext, htmlUnit));
    }

    @Override
    public void indexUnit(AnalysisContext analysisContext, CompilationUnit compilationUnit) {
        if (compilationUnit == null) {
            return;
        }
        if (compilationUnit.getElement() == null) {
            return;
        }
        this.queue.enqueue(new IndexUnitOperation(this.store, analysisContext, compilationUnit));
    }

    @Override
    public void removeContext(AnalysisContext analysisContext) {
        this.queue.enqueue(new RemoveContextOperation(this.store, analysisContext));
    }

    @Override
    public void removeSource(AnalysisContext analysisContext, Source source) {
        this.queue.enqueue(new RemoveSourceOperation(this.store, analysisContext, source));
    }

    @Override
    public void removeSources(AnalysisContext analysisContext, SourceContainer sourceContainer) {
        this.queue.enqueue(new RemoveSourcesOperation(this.store, analysisContext, sourceContainer));
    }

    @Override
    public void run() {
        this.processor.run();
    }

    @Override
    public void stop() {
        this.processor.stop(false);
    }
}

