/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.dart.engine.ast.AssignmentExpression;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.ClassTypeAlias;
import com.google.dart.engine.ast.Combinator;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.ConstructorFieldInitializer;
import com.google.dart.engine.ast.ConstructorName;
import com.google.dart.engine.ast.ExportDirective;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.ExtendsClause;
import com.google.dart.engine.ast.FormalParameter;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionTypeAlias;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.ImplementsClause;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.IndexExpression;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.MethodInvocation;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.PartDirective;
import com.google.dart.engine.ast.PartOfDirective;
import com.google.dart.engine.ast.PostfixExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.PropertyAccess;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.SuperConstructorInvocation;
import com.google.dart.engine.ast.TopLevelVariableDeclaration;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.ast.TypeParameter;
import com.google.dart.engine.ast.UriBasedDirective;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.VariableDeclarationList;
import com.google.dart.engine.ast.WithClause;
import com.google.dart.engine.ast.visitor.GeneralizingAstVisitor;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.ExportElement;
import com.google.dart.engine.element.FieldElement;
import com.google.dart.engine.element.FieldFormalParameterElement;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.element.FunctionTypeAliasElement;
import com.google.dart.engine.element.ImportElement;
import com.google.dart.engine.element.LabelElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.LocalVariableElement;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.PrefixElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.index.IndexStore;
import com.google.dart.engine.index.Location;
import com.google.dart.engine.index.LocationWithData;
import com.google.dart.engine.index.Relationship;
import com.google.dart.engine.internal.index.IndexConstants;
import com.google.dart.engine.internal.index.NameElementImpl;
import com.google.dart.engine.internal.scope.Namespace;
import com.google.dart.engine.internal.scope.NamespaceBuilder;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.type.Type;
import com.google.dart.engine.utilities.general.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class IndexContributor
extends GeneralizingAstVisitor<Void> {
    private final IndexStore store;
    private LibraryElement libraryElement;
    private final Map<ImportElement, Set<Element>> importElementsMap = Maps.newHashMap();
    private LinkedList<Element> elementStack = Lists.newLinkedList();

    @VisibleForTesting
    public static Location createLocation(Element element) {
        if (element != null) {
            int n = element.getNameOffset();
            int n2 = element.getDisplayName().length();
            return new Location(element, n, n2);
        }
        return null;
    }

    public static ImportElement getImportElement(SimpleIdentifier simpleIdentifier) {
        ImportElementInfo importElementInfo = IndexContributor.getImportElementInfo(simpleIdentifier);
        return importElementInfo != null ? importElementInfo.element : null;
    }

    public static ImportElementInfo getImportElementInfo(SimpleIdentifier simpleIdentifier) {
        Object object;
        ImportElementInfo importElementInfo = new ImportElementInfo();
        AstNode astNode = simpleIdentifier.getParent();
        CompilationUnit compilationUnit = simpleIdentifier.getAncestor(CompilationUnit.class);
        LibraryElement libraryElement = compilationUnit.getElement().getLibrary();
        Element element = null;
        if (astNode instanceof PrefixedIdentifier && ((PrefixedIdentifier)(object = (PrefixedIdentifier)astNode)).getPrefix() == simpleIdentifier) {
            element = ((PrefixedIdentifier)object).getStaticElement();
            importElementInfo.periodEnd = ((PrefixedIdentifier)object).getPeriod().getEnd();
        }
        if (astNode instanceof MethodInvocation && ((MethodInvocation)(object = (MethodInvocation)astNode)).getTarget() == simpleIdentifier) {
            element = ((MethodInvocation)object).getMethodName().getStaticElement();
            importElementInfo.periodEnd = ((MethodInvocation)object).getPeriod().getEnd();
        }
        if (element == null) {
            return null;
        }
        object = simpleIdentifier.getName();
        HashMap<ImportElement, Set<Element>> hashMap = Maps.newHashMap();
        importElementInfo.element = IndexContributor.internalGetImportElement(libraryElement, (String)object, element, hashMap);
        if (importElementInfo.element == null) {
            return null;
        }
        return importElementInfo;
    }

    private static Location getLocationWithExpressionType(Location location, Expression expression) {
        if (expression != null) {
            return new LocationWithData<Type>(location, expression.getBestType());
        }
        return location;
    }

    private static Location getLocationWithInitializerType(SimpleIdentifier simpleIdentifier, Location location) {
        ConstructorFieldInitializer constructorFieldInitializer;
        if (simpleIdentifier.getParent() instanceof ConstructorFieldInitializer && (constructorFieldInitializer = (ConstructorFieldInitializer)simpleIdentifier.getParent()).getFieldName() == simpleIdentifier) {
            location = IndexContributor.getLocationWithExpressionType(location, constructorFieldInitializer.getExpression());
        }
        return location;
    }

    private static Location getLocationWithTypeAssignedToField(SimpleIdentifier simpleIdentifier, Element element, Location location) {
        Expression expression;
        if (!(element instanceof PropertyAccessorElement)) {
            return location;
        }
        PropertyAccessorElement propertyAccessorElement = (PropertyAccessorElement)element;
        if (!propertyAccessorElement.isSetter()) {
            return location;
        }
        if (!propertyAccessorElement.isSynthetic()) {
            return location;
        }
        Expression expression2 = simpleIdentifier;
        AstNode astNode = expression2.getParent();
        if (astNode instanceof PropertyAccess && ((PropertyAccess)(expression = (PropertyAccess)astNode)).getPropertyName() == expression2) {
            expression2 = expression;
            astNode = expression.getParent();
        }
        if (astNode instanceof PrefixedIdentifier && ((PrefixedIdentifier)(expression = (PrefixedIdentifier)astNode)).getIdentifier() == expression2) {
            expression2 = expression;
            astNode = expression.getParent();
        }
        if (astNode instanceof AssignmentExpression) {
            expression2 = (AssignmentExpression)astNode;
            expression = ((AssignmentExpression)expression2).getRightHandSide();
            location = IndexContributor.getLocationWithExpressionType(location, expression);
        }
        return location;
    }

    private static ImportElement internalGetImportElement(LibraryElement libraryElement, String string, Element element, Map<ImportElement, Set<Element>> map) {
        if (element == null) {
            return null;
        }
        if (!(element.getEnclosingElement() instanceof CompilationUnitElement)) {
            return null;
        }
        LibraryElement libraryElement2 = element.getLibrary();
        ArrayList<ImportElement> arrayList = null;
        for (ImportElement object : libraryElement.getImports()) {
            if (!Objects.equal(object.getImportedLibrary(), libraryElement2)) continue;
            PrefixElement prefixElement = object.getPrefix();
            if (string != null ? prefixElement == null || !string.equals(prefixElement.getName()) : prefixElement != null) continue;
            if (object.getCombinators().length == 0) {
                return object;
            }
            if (arrayList == null) {
                arrayList = Lists.newArrayList();
            }
            arrayList.add(object);
        }
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (ImportElement)arrayList.get(0);
        }
        for (ImportElement importElement : arrayList) {
            if (map.containsKey(importElement)) continue;
            Namespace namespace = new NamespaceBuilder().createImportNamespaceForDirective(importElement);
            HashSet<Element> hashSet = Sets.newHashSet(namespace.getDefinedNames().values());
            map.put(importElement, hashSet);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!((Set)entry.getValue()).contains(element)) continue;
            return (ImportElement)entry.getKey();
        }
        return null;
    }

    private static boolean isIdentifierInImportCombinator(SimpleIdentifier simpleIdentifier) {
        AstNode astNode = simpleIdentifier.getParent();
        return astNode instanceof Combinator;
    }

    private static boolean isIdentifierInPrefixedIdentifier(SimpleIdentifier simpleIdentifier) {
        AstNode astNode = simpleIdentifier.getParent();
        return astNode instanceof PrefixedIdentifier && ((PrefixedIdentifier)astNode).getIdentifier() == simpleIdentifier;
    }

    private static boolean isQualified(SimpleIdentifier simpleIdentifier) {
        AstNode astNode = simpleIdentifier.getParent();
        if (astNode instanceof PrefixedIdentifier) {
            return ((PrefixedIdentifier)astNode).getIdentifier() == simpleIdentifier;
        }
        if (astNode instanceof PropertyAccess) {
            return ((PropertyAccess)astNode).getPropertyName() == simpleIdentifier;
        }
        if (astNode instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)astNode;
            return methodInvocation.getRealTarget() != null && methodInvocation.getMethodName() == simpleIdentifier;
        }
        return false;
    }

    public IndexContributor(IndexStore indexStore) {
        this.store = indexStore;
    }

    public void enterScope(Element element) {
        this.elementStack.addFirst(element);
    }

    @VisibleForTesting
    public Element peekElement() {
        for (Element element : this.elementStack) {
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @Override
    public Void visitAssignmentExpression(AssignmentExpression assignmentExpression) {
        this.recordOperatorReference(assignmentExpression.getOperator(), assignmentExpression.getBestElement());
        return (Void)super.visitAssignmentExpression(assignmentExpression);
    }

    @Override
    public Void visitBinaryExpression(BinaryExpression binaryExpression) {
        this.recordOperatorReference(binaryExpression.getOperator(), binaryExpression.getBestElement());
        return (Void)super.visitBinaryExpression(binaryExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitClassDeclaration(ClassDeclaration classDeclaration) {
        ClassElement classElement = classDeclaration.getElement();
        this.enterScope(classElement);
        try {
            Object object;
            this.recordElementDefinition(classElement, IndexConstants.DEFINES_CLASS);
            Object object2 = classDeclaration.getExtendsClause();
            if (object2 != null) {
                object = ((ExtendsClause)object2).getSuperclass();
                this.recordSuperType((TypeName)object, IndexConstants.IS_EXTENDED_BY);
            } else {
                object = classElement.getSupertype();
                if (object != null) {
                    ClassElement object3 = object.getElement();
                    this.recordRelationship(object3, IndexConstants.IS_EXTENDED_BY, this.createLocationFromOffset(classDeclaration.getName().getOffset(), 0));
                }
            }
            object2 = classDeclaration.getWithClause();
            if (object2 != null) {
                for (TypeName typeName : ((WithClause)object2).getMixinTypes()) {
                    this.recordSuperType(typeName, IndexConstants.IS_MIXED_IN_BY);
                }
            }
            if ((object2 = classDeclaration.getImplementsClause()) != null) {
                for (TypeName typeName : ((ImplementsClause)object2).getInterfaces()) {
                    this.recordSuperType(typeName, IndexConstants.IS_IMPLEMENTED_BY);
                }
            }
            object2 = (Void)super.visitClassDeclaration(classDeclaration);
            return object2;
        }
        finally {
            this.exitScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitClassTypeAlias(ClassTypeAlias classTypeAlias) {
        ClassElement classElement = classTypeAlias.getElement();
        this.enterScope(classElement);
        try {
            this.recordElementDefinition(classElement, IndexConstants.DEFINES_CLASS_ALIAS);
            Object object = classTypeAlias.getSuperclass();
            if (object != null) {
                this.recordSuperType((TypeName)object, IndexConstants.IS_EXTENDED_BY);
            }
            if ((object = classTypeAlias.getWithClause()) != null) {
                for (TypeName typeName : ((WithClause)object).getMixinTypes()) {
                    this.recordSuperType(typeName, IndexConstants.IS_MIXED_IN_BY);
                }
            }
            if ((object = classTypeAlias.getImplementsClause()) != null) {
                for (TypeName typeName : ((ImplementsClause)object).getInterfaces()) {
                    this.recordSuperType(typeName, IndexConstants.IS_IMPLEMENTED_BY);
                }
            }
            object = (Void)super.visitClassTypeAlias(classTypeAlias);
            return object;
        }
        finally {
            this.exitScope();
        }
    }

    @Override
    public Void visitCompilationUnit(CompilationUnit compilationUnit) {
        CompilationUnitElement compilationUnitElement = compilationUnit.getElement();
        if (compilationUnitElement != null) {
            this.elementStack.add(compilationUnitElement);
            this.libraryElement = compilationUnitElement.getEnclosingElement();
            if (this.libraryElement != null) {
                return (Void)super.visitCompilationUnit(compilationUnit);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
        Object object;
        ConstructorElement constructorElement = constructorDeclaration.getElement();
        if (constructorDeclaration.getName() != null) {
            int n = constructorDeclaration.getPeriod().getOffset();
            int n2 = constructorDeclaration.getName().getEnd();
            object = this.createLocationFromOffset(n, n2 - n);
        } else {
            int n = constructorDeclaration.getReturnType().getEnd();
            object = this.createLocationFromOffset(n, 0);
        }
        this.recordRelationship(constructorElement, IndexConstants.IS_DEFINED_BY, (Location)object);
        this.enterScope(constructorElement);
        try {
            object = (Void)super.visitConstructorDeclaration(constructorDeclaration);
            return object;
        }
        finally {
            this.exitScope();
        }
    }

    @Override
    public Void visitConstructorName(ConstructorName constructorName) {
        Location location;
        ConstructorElement constructorElement = constructorName.getStaticElement();
        if (constructorElement != null && constructorElement.isSynthetic() && constructorElement.getRedirectedConstructor() != null) {
            constructorElement = constructorElement.getRedirectedConstructor();
        }
        if (constructorName.getName() != null) {
            int n = constructorName.getPeriod().getOffset();
            int n2 = constructorName.getName().getEnd();
            location = this.createLocationFromOffset(n, n2 - n);
        } else {
            int n = constructorName.getType().getEnd();
            location = this.createLocationFromOffset(n, 0);
        }
        this.recordRelationship(constructorElement, IndexConstants.IS_REFERENCED_BY, location);
        return (Void)super.visitConstructorName(constructorName);
    }

    @Override
    public Void visitExportDirective(ExportDirective exportDirective) {
        ExportElement exportElement = exportDirective.getElement();
        if (exportElement != null) {
            LibraryElement libraryElement = exportElement.getExportedLibrary();
            this.recordLibraryReference(exportDirective, libraryElement);
        }
        return (Void)super.visitExportDirective(exportDirective);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFormalParameter(FormalParameter formalParameter) {
        ParameterElement parameterElement = formalParameter.getElement();
        this.enterScope(parameterElement);
        try {
            Void void_ = (Void)super.visitFormalParameter(formalParameter);
            return void_;
        }
        finally {
            this.exitScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        ExecutableElement executableElement = functionDeclaration.getElement();
        this.recordElementDefinition(executableElement, IndexConstants.DEFINES_FUNCTION);
        this.enterScope(executableElement);
        try {
            Void void_ = (Void)super.visitFunctionDeclaration(functionDeclaration);
            return void_;
        }
        finally {
            this.exitScope();
        }
    }

    @Override
    public Void visitFunctionTypeAlias(FunctionTypeAlias functionTypeAlias) {
        FunctionTypeAliasElement functionTypeAliasElement = functionTypeAlias.getElement();
        this.recordElementDefinition(functionTypeAliasElement, IndexConstants.DEFINES_FUNCTION_TYPE);
        return (Void)super.visitFunctionTypeAlias(functionTypeAlias);
    }

    @Override
    public Void visitImportDirective(ImportDirective importDirective) {
        ImportElement importElement = importDirective.getElement();
        if (importElement != null) {
            LibraryElement libraryElement = importElement.getImportedLibrary();
            this.recordLibraryReference(importDirective, libraryElement);
        }
        return (Void)super.visitImportDirective(importDirective);
    }

    @Override
    public Void visitIndexExpression(IndexExpression indexExpression) {
        MethodElement methodElement = indexExpression.getBestElement();
        if (methodElement instanceof MethodElement) {
            Token token = indexExpression.getLeftBracket();
            Location location = this.createLocationFromToken(token);
            this.recordRelationship(methodElement, IndexConstants.IS_INVOKED_BY_QUALIFIED, location);
        }
        return (Void)super.visitIndexExpression(indexExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        ExecutableElement executableElement = methodDeclaration.getElement();
        this.enterScope(executableElement);
        try {
            Void void_ = (Void)super.visitMethodDeclaration(methodDeclaration);
            return void_;
        }
        finally {
            this.exitScope();
        }
    }

    @Override
    public Void visitMethodInvocation(MethodInvocation methodInvocation) {
        Location location;
        SimpleIdentifier simpleIdentifier = methodInvocation.getMethodName();
        Element element = simpleIdentifier.getBestElement();
        if (element instanceof MethodElement) {
            location = this.createLocationFromNode(simpleIdentifier);
            Relationship relationship = methodInvocation.getTarget() != null ? IndexConstants.IS_INVOKED_BY_QUALIFIED : IndexConstants.IS_INVOKED_BY_UNQUALIFIED;
            this.recordRelationship(element, relationship, location);
        }
        if (element instanceof FunctionElement) {
            location = this.createLocationFromNode(simpleIdentifier);
            this.recordRelationship(element, IndexConstants.IS_INVOKED_BY, location);
        }
        this.recordImportElementReferenceWithoutPrefix(simpleIdentifier);
        return (Void)super.visitMethodInvocation(methodInvocation);
    }

    @Override
    public Void visitPartDirective(PartDirective partDirective) {
        Element element = partDirective.getElement();
        Location location = this.createLocationFromNode(partDirective.getUri());
        this.recordRelationship(element, IndexConstants.IS_REFERENCED_BY, location);
        return (Void)super.visitPartDirective(partDirective);
    }

    @Override
    public Void visitPartOfDirective(PartOfDirective partOfDirective) {
        Location location = this.createLocationFromNode(partOfDirective.getLibraryName());
        this.recordRelationship(partOfDirective.getElement(), IndexConstants.IS_REFERENCED_BY, location);
        return null;
    }

    @Override
    public Void visitPostfixExpression(PostfixExpression postfixExpression) {
        this.recordOperatorReference(postfixExpression.getOperator(), postfixExpression.getBestElement());
        return (Void)super.visitPostfixExpression(postfixExpression);
    }

    @Override
    public Void visitPrefixExpression(PrefixExpression prefixExpression) {
        this.recordOperatorReference(prefixExpression.getOperator(), prefixExpression.getBestElement());
        return (Void)super.visitPrefixExpression(prefixExpression);
    }

    @Override
    public Void visitSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
        NameElementImpl nameElementImpl = new NameElementImpl(simpleIdentifier.getName());
        Location location = this.createLocationFromNode(simpleIdentifier);
        if (simpleIdentifier.inDeclarationContext()) {
            this.recordRelationship(nameElementImpl, IndexConstants.IS_DEFINED_BY, location);
            return null;
        }
        Element element = simpleIdentifier.getBestElement();
        this.recordQualifiedMemberReference(simpleIdentifier, element, nameElementImpl, location);
        if (this.isAlreadyHandledName(simpleIdentifier)) {
            return null;
        }
        if (element instanceof ClassElement || element instanceof FunctionElement || element instanceof FunctionTypeAliasElement || element instanceof LabelElement || element instanceof TypeParameterElement) {
            this.recordRelationship(element, IndexConstants.IS_REFERENCED_BY, location);
        } else if (element instanceof FieldElement) {
            location = IndexContributor.getLocationWithInitializerType(simpleIdentifier, location);
            this.recordRelationship(element, IndexConstants.IS_REFERENCED_BY, location);
        } else if (element instanceof FieldFormalParameterElement) {
            FieldFormalParameterElement fieldFormalParameterElement = (FieldFormalParameterElement)element;
            FieldElement fieldElement = fieldFormalParameterElement.getField();
            this.recordRelationship(fieldElement, IndexConstants.IS_REFERENCED_BY_QUALIFIED, location);
        } else if (element instanceof PrefixElement) {
            this.recordImportElementReferenceWithPrefix(simpleIdentifier);
        } else if (element instanceof PropertyAccessorElement || element instanceof MethodElement) {
            location = IndexContributor.getLocationWithTypeAssignedToField(simpleIdentifier, element, location);
            if (IndexContributor.isQualified(simpleIdentifier)) {
                this.recordRelationship(element, IndexConstants.IS_REFERENCED_BY_QUALIFIED, location);
            } else {
                this.recordRelationship(element, IndexConstants.IS_REFERENCED_BY_UNQUALIFIED, location);
            }
        } else if (element instanceof ParameterElement || element instanceof LocalVariableElement) {
            boolean bl = simpleIdentifier.inGetterContext();
            boolean bl2 = simpleIdentifier.inSetterContext();
            if (bl && bl2) {
                this.recordRelationship(element, IndexConstants.IS_READ_WRITTEN_BY, location);
            } else if (bl) {
                this.recordRelationship(element, IndexConstants.IS_READ_BY, location);
            } else if (bl2) {
                this.recordRelationship(element, IndexConstants.IS_WRITTEN_BY, location);
            } else {
                this.recordRelationship(element, IndexConstants.IS_REFERENCED_BY, location);
            }
        }
        this.recordImportElementReferenceWithoutPrefix(simpleIdentifier);
        return (Void)super.visitSimpleIdentifier(simpleIdentifier);
    }

    @Override
    public Void visitSuperConstructorInvocation(SuperConstructorInvocation superConstructorInvocation) {
        Location location;
        ConstructorElement constructorElement = superConstructorInvocation.getStaticElement();
        if (superConstructorInvocation.getConstructorName() != null) {
            int n = superConstructorInvocation.getPeriod().getOffset();
            int n2 = superConstructorInvocation.getConstructorName().getEnd();
            location = this.createLocationFromOffset(n, n2 - n);
        } else {
            int n = superConstructorInvocation.getKeyword().getEnd();
            location = this.createLocationFromOffset(n, 0);
        }
        this.recordRelationship(constructorElement, IndexConstants.IS_REFERENCED_BY, location);
        return (Void)super.visitSuperConstructorInvocation(superConstructorInvocation);
    }

    @Override
    public Void visitTopLevelVariableDeclaration(TopLevelVariableDeclaration topLevelVariableDeclaration) {
        VariableDeclarationList variableDeclarationList = topLevelVariableDeclaration.getVariables();
        for (VariableDeclaration variableDeclaration : variableDeclarationList.getVariables()) {
            VariableElement variableElement = variableDeclaration.getElement();
            this.recordElementDefinition(variableElement, IndexConstants.DEFINES_VARIABLE);
        }
        return (Void)super.visitTopLevelVariableDeclaration(topLevelVariableDeclaration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitTypeParameter(TypeParameter typeParameter) {
        TypeParameterElement typeParameterElement = typeParameter.getElement();
        this.enterScope(typeParameterElement);
        try {
            Void void_ = (Void)super.visitTypeParameter(typeParameter);
            return void_;
        }
        finally {
            this.exitScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitVariableDeclaration(VariableDeclaration variableDeclaration) {
        VariableElement variableElement = variableDeclaration.getElement();
        Object object = variableDeclaration.getName();
        Location location = this.createLocationFromNode((AstNode)object);
        location = IndexContributor.getLocationWithExpressionType(location, variableDeclaration.getInitializer());
        this.recordRelationship(variableElement, IndexConstants.IS_DEFINED_BY, location);
        this.enterScope(variableElement);
        try {
            object = (Void)super.visitVariableDeclaration(variableDeclaration);
            return object;
        }
        finally {
            this.exitScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitVariableDeclarationList(VariableDeclarationList variableDeclarationList) {
        NodeList<VariableDeclaration> nodeList = variableDeclarationList.getVariables();
        if (nodeList != null) {
            Iterator iterator;
            TypeName typeName = variableDeclarationList.getType();
            if (typeName != null && (iterator = nodeList.iterator()).hasNext()) {
                VariableDeclaration variableDeclaration = (VariableDeclaration)iterator.next();
                this.enterScope(variableDeclaration.getElement());
                try {
                    typeName.accept(this);
                }
                finally {
                    this.exitScope();
                }
            }
            nodeList.accept(this);
        }
        return null;
    }

    protected void recordRelationship(Element element, Relationship relationship, Location location) {
        if (element != null && location != null) {
            this.store.recordRelationship(element, relationship, location);
        }
    }

    private Location createLocationFromNode(AstNode astNode) {
        return this.createLocationFromOffset(astNode.getOffset(), astNode.getLength());
    }

    private Location createLocationFromOffset(int n, int n2) {
        Element element = this.peekElement();
        return new Location(element, n, n2);
    }

    private Location createLocationFromToken(Token token) {
        return this.createLocationFromOffset(token.getOffset(), token.getLength());
    }

    private void exitScope() {
        this.elementStack.removeFirst();
    }

    private boolean isAlreadyHandledName(SimpleIdentifier simpleIdentifier) {
        Element element;
        AstNode astNode = simpleIdentifier.getParent();
        if (astNode instanceof MethodInvocation && ((element = simpleIdentifier.getStaticElement()) instanceof MethodElement || element instanceof FunctionElement)) {
            return ((MethodInvocation)astNode).getMethodName() == simpleIdentifier;
        }
        return false;
    }

    private void recordElementDefinition(Element element, Relationship relationship) {
        Location location = IndexContributor.createLocation(element);
        this.recordRelationship(this.libraryElement, relationship, location);
        this.recordRelationship(IndexConstants.UNIVERSE, relationship, location);
    }

    private void recordImportElementReferenceWithoutPrefix(SimpleIdentifier simpleIdentifier) {
        if (IndexContributor.isIdentifierInImportCombinator(simpleIdentifier)) {
            return;
        }
        if (IndexContributor.isIdentifierInPrefixedIdentifier(simpleIdentifier)) {
            return;
        }
        Element element = simpleIdentifier.getStaticElement();
        ImportElement importElement = IndexContributor.internalGetImportElement(this.libraryElement, null, element, this.importElementsMap);
        if (importElement != null) {
            Location location = this.createLocationFromOffset(simpleIdentifier.getOffset(), 0);
            this.recordRelationship(importElement, IndexConstants.IS_REFERENCED_BY, location);
        }
    }

    private void recordImportElementReferenceWithPrefix(SimpleIdentifier simpleIdentifier) {
        ImportElementInfo importElementInfo = IndexContributor.getImportElementInfo(simpleIdentifier);
        if (importElementInfo != null) {
            int n = simpleIdentifier.getOffset();
            int n2 = importElementInfo.periodEnd - n;
            Location location = this.createLocationFromOffset(n, n2);
            this.recordRelationship(importElementInfo.element, IndexConstants.IS_REFERENCED_BY, location);
        }
    }

    private void recordLibraryReference(UriBasedDirective uriBasedDirective, LibraryElement libraryElement) {
        if (libraryElement != null) {
            Location location = this.createLocationFromNode(uriBasedDirective.getUri());
            this.recordRelationship(libraryElement.getDefiningCompilationUnit(), IndexConstants.IS_REFERENCED_BY, location);
        }
    }

    private void recordOperatorReference(Token token, Element element) {
        Location location = this.createLocationFromToken(token);
        String string = token.getLexeme();
        if (string.equals("++")) {
            string = "+";
        }
        if (string.equals("--")) {
            string = "-";
        }
        if (StringUtilities.endsWithChar(string, 61) && !string.equals("==")) {
            string = string.substring(0, string.length() - 1);
        }
        NameElementImpl nameElementImpl = new NameElementImpl(string);
        Relationship relationship = element != null ? IndexConstants.IS_REFERENCED_BY_QUALIFIED_RESOLVED : IndexConstants.IS_REFERENCED_BY_QUALIFIED_UNRESOLVED;
        this.recordRelationship(nameElementImpl, relationship, location);
        if (element != null) {
            this.recordRelationship(element, IndexConstants.IS_INVOKED_BY_QUALIFIED, location);
        }
    }

    private void recordQualifiedMemberReference(SimpleIdentifier simpleIdentifier, Element element, Element element2, Location location) {
        if (IndexContributor.isQualified(simpleIdentifier)) {
            Relationship relationship = element != null ? IndexConstants.IS_REFERENCED_BY_QUALIFIED_RESOLVED : IndexConstants.IS_REFERENCED_BY_QUALIFIED_UNRESOLVED;
            this.recordRelationship(element2, relationship, location);
        }
    }

    private void recordSuperType(TypeName typeName, Relationship relationship) {
        Identifier identifier;
        if (typeName != null && (identifier = typeName.getName()) != null) {
            Element element = identifier.getStaticElement();
            this.recordRelationship(element, relationship, this.createLocationFromNode(typeName));
        }
    }

    private static class ImportElementInfo {
        ImportElement element;
        int periodEnd;

        private ImportElementInfo() {
        }
    }
}

